/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import com.sap.tc.logging.Location;
import com.sap.tc.logging.PropertiesConfigurator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public final class XmlSystemAccess {
    private static final String STARS_STRING = "*********************************************************************************************";
    private static final String JPF_SOURCE_INFO = "$Id: //tc/aii/630_REL/src/_proxy/java/com/sap/aii/proxy/framework/core/XmlSystemAccess.java#3 $";
    private static final String JPF_SOURCE_TIME = "$DateTime: 2004/04/29 13:08:16 $";
    private static final String JPF_VERSION = "2.0";
    private static final String JPF_SAP_SYSTEM_DIR = "com.sap.systemdir";
    private static final String JPF_DBC_PROPS_FILENAME = "dbconnect.properties";
    private static final String JPF_TECHNICAL_ID_FILENAME = "technicalID.properties";
    private static final String JPF_TECHNICAL_ID_KEY = "SAPTechnicalSystemIdentification";
    private static final String JPF_TECHNICAL_SYSTEM_ID_KEY = "com.sap.aii.proxy.framework.technicalSystemId";
    private static final String JPF_HOSTNAME_KEY = "com.sap.aii.proxy.framework.hostname";
    private static final String JPF_CONNECTION_NAME_KEY = "com.sap.aii.proxy.framework.connection.name";
    private static final String JPF_CONNECTION_NAME = "JPR";
    private static final String JPF_CONNECTION_TIMEOUT_KEY = "com.sap.aii.proxy.framework.connection.timeoutInMSec";
    private static final long JPF_CONNECTION_TIMEOUT = 30000L;
    private static final String JPF_SERVER_DEFAULT_HOST = "localhost";
    private static final String JPF_SERVER_PORT = "1080";
    private static final String JPF_SERVICE_NAME = "/sap/xi/engine?type=entry";
    private static final String JPF_SERVER_URL_KEY = "com.sap.aii.proxy.framework.serverURL";
    private static final String JPF_SERVER_URL = "http://localhost:1080/sap/xi/engine?type=entry";
    private static final String JPF_PROP_FILENAME_KEY = "com.sap.aii.proxy.framework.propertiesFilename";
    private static final String JPF_PROP_FILENAME = "jpf.properties";
    private static final String JPF_REGISTRY_FILENAME_KEY = "com.sap.aii.proxy.framework.registryFilename";
    private static final String JPF_REGISTRY_FILENAME = "jpf.registry";
    private static final String JPF_LOG_PROPS_FILENAME_KEY = "com.sap.aii.proxy.framework.loggingPropertiesFilename";
    private static final String JPF_LOG_PROPS_FILENAME = "logging.properties";
    private static final String JPF_SERVICE_USER_NAME_FOR_LCR_KEY = "com.sap.aii.proxy.framework.lcrUsername";
    private static final String JPF_SERVICE_USER_PASSWORD_FOR_LCR_KEY = "com.sap.aii.proxy.framework.lcrPassword";
    private static final String EXCHANGE_PROFILE_SECTION_NAME_AII_PROXY_FRAMEWORK = "ApplicationSystem.JavaProxyFramework";
    private static final String EXCHANGE_PROFILE_SECTION_NAME_LOGGING = "Logging";
    private static final String EXCHANGE_PROFILE_SECTION_NAME_APPLICATION_SYSTEM = "ApplicationSystem";
    private static final String EXCHANGE_PROFILE_SECTION_NAME_CONNECTIONS = "Connections";
    private static final String EXCHANGE_PROFILE_SERVICE_USER_NAME_KEY = "com.sap.aii.applicationsystem.serviceuser.name";
    private static final String EXCHANGE_PROFILE_SERVICE_USER_PASSWORD_KEY = "com.sap.aii.applicationsystem.serviceuser.pwd";
    private static final String EXCHANGE_PROFILE_SERVICE_USER_LANGUAGE_KEY = "com.sap.aii.applicationsystem.serviceuser.language";
    private static final String EXCHANGE_PROFILE_LCR_HOST_KEY = "com.sap.aii.connect.landscape.name";
    private static final String EXCHANGE_PROFILE_LCR_PORT_KEY = "com.sap.aii.connect.landscape.httpport";
    private static final String EXCHANGE_PROFILE_IS_CLIENT_ID = "com.sap.aii.connect.integrationserver.r3.client";
    private static final String fileSeparator = System.getProperty("file.separator");
    private static final String pathSeparator = System.getProperty("path.separator");
    private static final String workDirectory = System.getProperty("user.dir");
    private static final String homeDirectory = System.getProperty("user.home");
    private static final String javaClassPath = System.getProperty("java.class.path");
    private static ArrayList exchangeProfileContent = null;
    private static String exchangeProfileClient = null;
    private static String exchangeProfileHostname = null;
    private static String exchangeProfileSystemNumber = null;
    private static String exchangeProfileUser = null;
    private static String exchangeProfilePassword = null;
    private static String exchangeProfileLanguage = null;
    private static String exchangeProfileServiceUserName = null;
    private static String exchangeProfileServiceUserPassword = null;
    private static String exchangeProfileServiceUserLanguage = null;
    private static String technicalSystemId = null;
    private static String businessSystemName = null;
    private static String serviceUserNameForLCR = null;
    private static String serviceUserPasswordForLCR = null;
    private static String integrationServerHostAndPort = null;
    private static String integrationServerClientId = null;
    private static String messagingConnectionName = null;
    private static long messagingTimeoutInMSec = 0L;
    private static final Location loc = Location.getLocation((String)(class$com$sap$aii$proxy$framework$core$XmlSystemAccess == null ? (class$com$sap$aii$proxy$framework$core$XmlSystemAccess = XmlSystemAccess.class$("com.sap.aii.proxy.framework.core.XmlSystemAccess")) : class$com$sap$aii$proxy$framework$core$XmlSystemAccess).getName());
    private static String registryFilename = "jpf.registry";
    private static File registryFile = null;
    private static long registryFileLastModified = 0L;
    private static boolean loggingInitialized = false;
    private static File propertiesFile = null;
    private static long propertiesFileLastModified = 0L;
    private static Properties properties = null;
    private static Object lock = new Object();
    private static boolean isJ2EE = false;
    static /* synthetic */ Class class$com$sap$aii$proxy$framework$core$XmlSystemAccess;

    private static final File getFileInWorkDirectory(String filename) {
        String fullName = workDirectory + fileSeparator + filename;
        File file = new File(fullName);
        return file.exists() ? file : null;
    }

    private static final File getFileInClassPath(String filename) {
        String _methodName = "getFileInClassPath(...)";
        StringTokenizer tokenizer = new StringTokenizer(javaClassPath, pathSeparator);
        if (loc.beLogged(100)) {
            loc.logT(100, _methodName, "Searching file {0}", new Object[]{filename});
            System.out.println("Searching file " + filename);
        }
        Hashtable<String, String> dirsChecked = new Hashtable<String, String>();
        while (tokenizer.hasMoreTokens()) {
            String name;
            String pathname = tokenizer.nextToken();
            File file = new File(pathname);
            if (file.isDirectory()) {
                String fullname = pathname + fileSeparator + filename;
                if (loc.beLogged(100)) {
                    loc.logT(100, _methodName, "... in directory {0}", new Object[]{pathname});
                    System.out.println("... in directory " + pathname);
                }
                if (!(file = new File(fullname)).exists()) continue;
                if (loc.beLogged(100)) {
                    loc.logT(100, _methodName, "File {0} found in {1}", new Object[]{filename, pathname});
                    System.out.println("File " + fullname + " found in " + pathname);
                }
                return file;
            }
            String dirName = file.getParent();
            if (!dirsChecked.containsKey(dirName)) {
                dirsChecked.put(dirName, dirName);
                if (loc.beLogged(100)) {
                    loc.logT(100, _methodName, "... in directory {0}", new Object[]{dirName});
                    System.out.println("... in directory " + dirName);
                }
            }
            if ((name = file.getName()).equals(filename)) {
                if (loc.beLogged(100)) {
                    loc.logT(100, _methodName, "File {0} found in {1}", new Object[]{filename, dirName});
                    System.out.println("File " + filename + " found in " + dirName);
                }
                return file;
            }
            String fullname = dirName + fileSeparator + filename;
            file = new File(fullname);
            if (!file.exists()) continue;
            if (loc.beLogged(100)) {
                loc.logT(100, _methodName, "File {0} found in {1}", new Object[]{filename, dirName});
                System.out.println("File " + fullname + " found in " + dirName);
            }
            return file;
        }
        if (loc.beLogged(400)) {
            loc.logT(400, _methodName, "File {0} not found in classpath", new Object[]{filename});
        }
        return null;
    }

    private static final File createFileInWorkDirectory(String filename) {
        File file;
        String _methodName;
        block7: {
            _methodName = "createFileInWorkDirectory(...)";
            String fullName = workDirectory + fileSeparator + filename;
            file = new File(fullName);
            try {
                if (file.createNewFile()) {
                    if (loc.beLogged(300)) {
                        loc.logT(300, _methodName, "File {0} created", new Object[]{fullName});
                    }
                } else if (loc.beLogged(300)) {
                    loc.logT(300, _methodName, "File {0} already exists", new Object[]{fullName});
                }
            }
            catch (IOException e) {
                if (!loc.beLogged(500)) break block7;
                loc.logT(500, _methodName, "Error creating file {0}. Exception: ", new Object[]{fullName, e.getMessage()});
            }
        }
        if (file == null && loc.beLogged(400)) {
            loc.logT(400, _methodName, "Could not create file {0} in work directory", new Object[]{filename});
        }
        return file;
    }

    private static final File createFileInClassPath(String filename) {
        String _methodName = "createFileInClassPath(...)";
        StringTokenizer tokenizer = new StringTokenizer(javaClassPath, pathSeparator);
        File file = null;
        while (tokenizer.hasMoreTokens()) {
            String pathname = tokenizer.nextToken();
            file = new File(pathname);
            if (!file.isDirectory()) continue;
            String fullname = pathname + fileSeparator + filename;
            file = new File(fullname);
            try {
                if (file.createNewFile()) {
                    if (!loc.beLogged(300)) break;
                    loc.logT(300, _methodName, "File {0} created", new Object[]{fullname});
                    break;
                }
                if (!loc.beLogged(300)) break;
                loc.logT(300, _methodName, "File {0} already exists", new Object[]{fullname});
                break;
            }
            catch (IOException e) {
                if (!loc.beLogged(500)) continue;
                loc.logT(500, _methodName, "Error creating file {0}. Exception: ", new Object[]{fullname, e.getMessage()});
            }
        }
        if (file == null && loc.beLogged(400)) {
            loc.logT(400, _methodName, "Could not create file {0} in classpath", new Object[]{filename});
        }
        return file;
    }

    static String getVersion() {
        return JPF_VERSION;
    }

    static final boolean initLogging() {
        if (loggingInitialized) {
            return true;
        }
        String _methodName = "initLogging()";
        boolean newFile = false;
        loggingInitialized = true;
        String loggingPropFilename = XmlSystemAccess.getProperty(JPF_LOG_PROPS_FILENAME_KEY, JPF_LOG_PROPS_FILENAME);
        File loggingPropFile = XmlSystemAccess.getPropertyFile(loggingPropFilename);
        if (loggingPropFile == null) {
            loggingPropFile = XmlSystemAccess.createFileInWorkDirectory(loggingPropFilename);
            Properties props = XmlSystemAccess.loadProfileProperties(EXCHANGE_PROFILE_SECTION_NAME_LOGGING);
            if (loggingPropFile != null && props != null) {
                try {
                    loggingPropFile.createNewFile();
                    FileWriter fw = new FileWriter(loggingPropFile);
                    fw.write("#Created by Java Proxy Framework\n");
                    fw.write("#" + new Date().toString() + "\n");
                    fw.write("#");
                    PrintWriter pw = new PrintWriter(fw);
                    props.list(pw);
                    pw.close();
                    fw.close();
                    newFile = true;
                }
                catch (IOException e) {
                    loggingInitialized = false;
                }
            }
        }
        if (loggingPropFile != null && loggingPropFile.exists()) {
            XmlSystemAccess.checkLoggingDirectories(loggingPropFile);
            PropertiesConfigurator propertiesConfigurator = new PropertiesConfigurator(loggingPropFile);
            propertiesConfigurator.configure();
            if (loc.beLogged(300)) {
                loc.logT(300, _methodName, "Java Proxy Framework");
                loc.logT(300, _methodName, "Source info {0} {1}", new Object[]{JPF_SOURCE_INFO, JPF_SOURCE_TIME});
                loc.logT(300, _methodName, "Initialized logging, properties loaded from file {0}", new Object[]{loggingPropFile.getPath()});
                if (newFile) {
                    loc.logT(300, _methodName, "Fresh properties file created");
                }
            }
        }
        return loggingInitialized;
    }

    private static void checkLoggingDirectories(File loggingPropFile) {
        if (loggingPropFile == null) {
            return;
        }
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(loggingPropFile));
            Enumeration enumeration = ((Hashtable)properties).keys();
            while (enumeration.hasMoreElements()) {
                String filename;
                File file;
                File parent;
                String key = (String)enumeration.nextElement();
                if (!key.startsWith("log") || key.indexOf(".pattern") <= 0 || (parent = (file = new File(filename = properties.getProperty(key))).getParentFile()) == null || parent.exists()) continue;
                parent.mkdirs();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static synchronized Properties getProperties() {
        if (properties == null || XmlSystemAccess.isPropertiesModified()) {
            properties = XmlSystemAccess.loadProperties();
            technicalSystemId = null;
            businessSystemName = null;
            serviceUserNameForLCR = null;
            serviceUserPasswordForLCR = null;
            integrationServerHostAndPort = null;
            integrationServerClientId = null;
            messagingConnectionName = null;
            messagingTimeoutInMSec = 0L;
        }
        return properties;
    }

    static String getProperty(String key) {
        return XmlSystemAccess.getProperty(key, null);
    }

    static String getProperty(String key, String defaultValue) {
        if (key == null) {
            return null;
        }
        String _methodName = "getProperty(...)";
        String prop = System.getProperty(key);
        if (prop != null) {
            return prop;
        }
        properties = XmlSystemAccess.getProperties();
        if (properties == null) {
            return defaultValue;
        }
        if (defaultValue == null) {
            return properties.getProperty(key);
        }
        return properties.getProperty(key, defaultValue);
    }

    private static Properties loadProperties() {
        String pathname;
        String jpfPropFilename;
        Properties jpfProps;
        Properties props = XmlSystemAccess.loadProfileProperties(EXCHANGE_PROFILE_SECTION_NAME_APPLICATION_SYSTEM);
        if (props == null) {
            props = new Properties();
        }
        if ((jpfProps = XmlSystemAccess.loadProfileProperties(EXCHANGE_PROFILE_SECTION_NAME_AII_PROXY_FRAMEWORK)) != null) {
            ((Hashtable)props).putAll(jpfProps);
        }
        if ((propertiesFile = XmlSystemAccess.getPropertyFile(jpfPropFilename = System.getProperty(JPF_PROP_FILENAME_KEY, JPF_PROP_FILENAME))) == null && (pathname = System.getProperty(JPF_SAP_SYSTEM_DIR)) != null) {
            jpfPropFilename = pathname + fileSeparator + jpfPropFilename;
            propertiesFile = XmlSystemAccess.getPropertyFile(jpfPropFilename);
        }
        propertiesFileLastModified = propertiesFile == null ? 0L : propertiesFile.lastModified();
        jpfProps = XmlSystemAccess.loadPropertiesFromFile(jpfPropFilename);
        if (jpfProps != null && !((Hashtable)jpfProps).isEmpty()) {
            ((Hashtable)props).putAll(jpfProps);
        }
        return props;
    }

    static synchronized Properties loadProfileProperties(String sectionName) {
        String _methodName = "loadProfileProperties()";
        if (exchangeProfileContent == null && exchangeProfileContent == null) {
            exchangeProfileContent = new ArrayList();
        }
        Properties props = null;
        if (exchangeProfileContent != null && !exchangeProfileContent.isEmpty()) {
            Iterator iterator = ((AbstractList)exchangeProfileContent).iterator();
            while (iterator.hasNext()) {
                String[] entry = (String[])iterator.next();
                if (!entry[0].equals(sectionName) || entry[1].length() <= 0) continue;
                if (props == null) {
                    props = new Properties();
                }
                ((Hashtable)props).put(entry[1], entry[2]);
            }
        }
        return props;
    }

    private static Properties loadPropertiesFromFile(String filename) {
        String _methodName = "loadPropertiesFromFile(...)";
        File propertyFile = XmlSystemAccess.getPropertyFile(filename);
        if (propertyFile == null) {
            if (loc.beLogged(400)) {
                loc.logT(400, _methodName, "Could not find property file {0}", new Object[]{filename});
            }
            return null;
        }
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(propertyFile));
            return properties;
        }
        catch (IOException e) {
            if (loc.beLogged(500)) {
                loc.logT(500, _methodName, "Error reading property file {0}", new Object[]{propertyFile.getPath()});
            }
            return null;
        }
    }

    private static File getPropertyFile(String filename) {
        if (filename == null || filename.length() == 0) {
            return null;
        }
        File propertyFile = null;
        if (filename.indexOf(fileSeparator) >= 0) {
            propertyFile = new File(filename);
            if (!propertyFile.exists()) {
                propertyFile = null;
            }
        } else {
            propertyFile = XmlSystemAccess.getFileInWorkDirectory(filename);
        }
        return propertyFile;
    }

    static final String getMessagingConnectionName() {
        if (messagingConnectionName != null && !XmlSystemAccess.isPropertiesModified()) {
            return messagingConnectionName;
        }
        String _methodName = "getMessagingConnectionName()";
        messagingConnectionName = XmlSystemAccess.getProperty(JPF_CONNECTION_NAME_KEY);
        if (messagingConnectionName != null) {
            if (loc.beLogged(300)) {
                loc.logT(300, _methodName, "Messaging connection name {0} found in properties", new Object[]{messagingConnectionName});
            }
        } else {
            messagingConnectionName = JPF_CONNECTION_NAME;
            if (loc.beLogged(300)) {
                loc.logT(300, _methodName, "Using default messaging connection name {0}", new Object[]{messagingConnectionName});
            }
        }
        return messagingConnectionName;
    }

    static final long getMessagingTimeout() {
        if (messagingTimeoutInMSec != 0L && !XmlSystemAccess.isPropertiesModified()) {
            return messagingTimeoutInMSec;
        }
        String _methodName = "getMessagingTimeout()";
        String timeout = XmlSystemAccess.getProperty(JPF_CONNECTION_TIMEOUT_KEY);
        long l = messagingTimeoutInMSec = timeout == null ? 0L : Long.parseLong(timeout);
        if (messagingTimeoutInMSec != 0L) {
            if (loc.beLogged(300)) {
                loc.logT(300, _methodName, "Messaging connection timeout {0} found in properties", new Object[]{Long.toString(messagingTimeoutInMSec)});
            }
        } else {
            messagingTimeoutInMSec = 30000L;
            if (loc.beLogged(300)) {
                loc.logT(300, _methodName, "Using default messaging connection timeout {0}", new Object[]{Long.toString(messagingTimeoutInMSec)});
            }
        }
        return messagingTimeoutInMSec;
    }

    static String getTechnicalSystemId() {
        if (technicalSystemId != null && !XmlSystemAccess.isPropertiesModified()) {
            return technicalSystemId;
        }
        String _methodName = "getTechnicalSystemId()";
        String technicalId = XmlSystemAccess.getProperty(JPF_TECHNICAL_SYSTEM_ID_KEY);
        String hostname = XmlSystemAccess.getProperty(JPF_HOSTNAME_KEY);
        if (technicalId != null && technicalId.length() > 0 && hostname != null && hostname.length() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(technicalId);
            buffer.append(".System.");
            buffer.append(hostname);
            technicalSystemId = new String(buffer);
            if (loc.beLogged(100)) {
                loc.logT(100, _methodName, "Technical System Id {0} retrieved from properties", new Object[]{technicalSystemId});
            }
            return technicalSystemId;
        }
        String filename = JPF_TECHNICAL_ID_FILENAME;
        Properties props = XmlSystemAccess.loadPropertiesFromFile(filename);
        if (props == null) {
            String pathname = System.getProperty(JPF_SAP_SYSTEM_DIR);
            if (pathname != null) {
                filename = pathname + fileSeparator + filename;
                props = XmlSystemAccess.loadPropertiesFromFile(filename);
            }
            if (props == null) {
                return null;
            }
        }
        technicalSystemId = props.getProperty(JPF_TECHNICAL_ID_KEY);
        if (loc.beLogged(100)) {
            loc.logT(100, _methodName, "Technical System Id {0} retrieved from file {1}", new Object[]{technicalSystemId, filename});
        }
        return technicalSystemId;
    }

    static String getLandscapeDirectoryHostAndPort() {
        String portnumber;
        String hostname;
        String _methodName = "getLandscapeDirectoryHostAndPort()";
        Properties props = XmlSystemAccess.loadProfileProperties(EXCHANGE_PROFILE_SECTION_NAME_CONNECTIONS);
        if (exchangeProfileClient == null || exchangeProfileUser == null || exchangeProfilePassword == null || exchangeProfileLanguage == null || exchangeProfileHostname == null || exchangeProfileSystemNumber == null) {
            if (loc.beLogged(400)) {
                Object[] objectArray = new Object[6];
                objectArray[0] = exchangeProfileClient == null ? "<null>" : exchangeProfileClient;
                Object object = objectArray[1] = exchangeProfileUser == null ? "<null>" : exchangeProfileUser;
                objectArray[2] = exchangeProfilePassword == null ? "<null>" : (exchangeProfilePassword.length() <= STARS_STRING.length() ? STARS_STRING.substring(0, exchangeProfilePassword.length()) : "***");
                objectArray[3] = exchangeProfileLanguage == null ? "<null>" : exchangeProfileLanguage;
                objectArray[4] = exchangeProfileHostname == null ? "<null>" : exchangeProfileHostname;
                objectArray[5] = exchangeProfileSystemNumber == null ? "<null>" : exchangeProfileSystemNumber;
                loc.logT(400, _methodName, "Exchange Profile could not be loaded via client {0}, user {1}, password {2}, language {3} on host {4}, system {5}", objectArray);
            }
        } else if (loc.beLogged(100)) {
            Object[] objectArray = new Object[6];
            objectArray[0] = exchangeProfileClient == null ? "<null>" : exchangeProfileClient;
            Object object = objectArray[1] = exchangeProfileUser == null ? "<null>" : exchangeProfileUser;
            objectArray[2] = exchangeProfilePassword == null ? "<null>" : (exchangeProfilePassword.length() <= STARS_STRING.length() ? STARS_STRING.substring(0, exchangeProfilePassword.length()) : "***");
            objectArray[3] = exchangeProfileLanguage == null ? "<null>" : exchangeProfileLanguage;
            objectArray[4] = exchangeProfileHostname == null ? "<null>" : exchangeProfileHostname;
            objectArray[5] = exchangeProfileSystemNumber == null ? "<null>" : exchangeProfileSystemNumber;
            loc.logT(100, _methodName, "Exchange Profile was loaded via client {0}, user {1}, password {2}, language {3} on host {4}, system {5}", objectArray);
        }
        String string = hostname = props == null ? null : props.getProperty(EXCHANGE_PROFILE_LCR_HOST_KEY);
        if (hostname == null) {
            if (loc.beLogged(400)) {
                loc.logT(400, _methodName, "No Exchange Profile entry found for Landscape Directory host", null);
            }
            return null;
        }
        String string2 = portnumber = props == null ? null : props.getProperty(EXCHANGE_PROFILE_LCR_PORT_KEY);
        if (portnumber == null) {
            if (loc.beLogged(400)) {
                loc.logT(400, _methodName, "No Exchange Profile entry found for Landscape Directory port", null);
            }
            return null;
        }
        String hostAndPort = new String(hostname + ":" + portnumber);
        if (loc.beLogged(100)) {
            loc.logT(100, _methodName, "LCR host and port {0} retrieved from Exchange Profile", new Object[]{hostAndPort});
        }
        return hostAndPort;
    }

    static final synchronized String getServiceUserName() {
        if (exchangeProfileServiceUserName == null) {
            exchangeProfileServiceUserName = XmlSystemAccess.getProperty(EXCHANGE_PROFILE_SERVICE_USER_NAME_KEY);
        }
        return exchangeProfileServiceUserName;
    }

    static final synchronized String getServiceUserPassword() {
        if (exchangeProfileServiceUserPassword == null) {
            exchangeProfileServiceUserPassword = XmlSystemAccess.getProperty(EXCHANGE_PROFILE_SERVICE_USER_PASSWORD_KEY);
        }
        return exchangeProfileServiceUserPassword;
    }

    static final synchronized String getServiceUserLanguage() {
        if (exchangeProfileServiceUserLanguage == null) {
            exchangeProfileServiceUserLanguage = XmlSystemAccess.getProperty(EXCHANGE_PROFILE_SERVICE_USER_LANGUAGE_KEY);
        }
        return exchangeProfileServiceUserLanguage;
    }

    static final synchronized String getServiceUserNameForLCR() {
        if (serviceUserNameForLCR == null && (serviceUserNameForLCR = XmlSystemAccess.getProperty(JPF_SERVICE_USER_NAME_FOR_LCR_KEY)) == null) {
            serviceUserNameForLCR = XmlSystemAccess.getServiceUserName();
        }
        return serviceUserNameForLCR;
    }

    static final synchronized String getServiceUserPasswordForLCR() {
        if (serviceUserPasswordForLCR == null && (serviceUserPasswordForLCR = XmlSystemAccess.getProperty(JPF_SERVICE_USER_PASSWORD_FOR_LCR_KEY)) == null) {
            serviceUserPasswordForLCR = XmlSystemAccess.getServiceUserPassword();
        }
        return serviceUserPasswordForLCR;
    }

    static synchronized File getRegistryFile() {
        if (registryFile == null && (registryFile = XmlSystemAccess.getFileInWorkDirectory(registryFilename)) == null) {
            registryFile = XmlSystemAccess.createFileInWorkDirectory(registryFilename);
        }
        registryFileLastModified = registryFile == null ? 0L : registryFile.lastModified();
        return registryFile;
    }

    static final boolean isJ2EE() {
        return isJ2EE;
    }

    public static final void setJ2EE() {
        isJ2EE = true;
    }

    static final Properties getRegistry() {
        Properties registry;
        block6: {
            String _methodName = "getRegistry(...)";
            registry = null;
            if (registry == null) {
                File registryFile = XmlSystemAccess.getRegistryFile();
                if (registryFile == null) {
                    if (loc.beLogged(500)) {
                        loc.logT(500, _methodName, "No registry file specified");
                    }
                    return null;
                }
                if (loc.beLogged(100)) {
                    loc.logT(100, _methodName, "Reloading registry file {0}", new Object[]{registryFile.getPath()});
                }
                registry = new Properties();
                try {
                    registry.load(new FileInputStream(registryFile));
                }
                catch (IOException e) {
                    if (!loc.beLogged(500)) break block6;
                    loc.logT(500, _methodName, "Registry file {0} not found", new Object[]{registryFile.getPath()});
                }
            }
        }
        return registry;
    }

    static final boolean isRegistryModified() {
        if (registryFile == null) {
            return false;
        }
        return registryFile.lastModified() > registryFileLastModified;
    }

    static final boolean isPropertiesModified() {
        if (propertiesFile == null) {
            return false;
        }
        return propertiesFile.lastModified() > propertiesFileLastModified;
    }

    static String checkURL(String url) {
        int index = url.indexOf(":");
        if (index <= 0) {
            return JPF_SERVER_URL;
        }
        StringBuffer buffer = new StringBuffer(url.substring(0, index + 1));
        url = url.substring(index + 1);
        buffer.append("//");
        if (url.startsWith("//")) {
            url = url.substring(2);
        }
        if ((index = url.indexOf(":")) < 0) {
            index = url.indexOf("/");
            if (index < 0) {
                buffer.append(url);
                buffer.append(":");
                buffer.append(JPF_SERVER_PORT);
                buffer.append(JPF_SERVICE_NAME);
                return new String(buffer);
            }
            if (index == 0) {
                buffer.append(JPF_SERVER_DEFAULT_HOST);
            } else {
                buffer.append(url.substring(0, index));
            }
            buffer.append(":");
            buffer.append(JPF_SERVER_PORT);
            url = url.substring(index + 1);
            if (url.length() <= 1) {
                buffer.append(JPF_SERVICE_NAME);
                return new String(buffer);
            }
            buffer.append(url);
            return new String(buffer);
        }
        if (index == 0) {
            buffer.append(JPF_SERVER_DEFAULT_HOST);
        }
        buffer.append(url.substring(0, index + 1));
        if (url.length() <= index + 1) {
            buffer.append(JPF_SERVER_PORT);
            buffer.append(JPF_SERVICE_NAME);
            return new String(buffer);
        }
        if ((index = (url = url.substring(index + 1)).indexOf("/")) < 0) {
            buffer.append(url);
            buffer.append(JPF_SERVICE_NAME);
            return new String(buffer);
        }
        if (index == 0) {
            buffer.append(JPF_SERVER_PORT);
        }
        buffer.append(url.substring(0, index + 1));
        if (url.length() < index + 1) {
            buffer.append(JPF_SERVICE_NAME);
            return new String(buffer);
        }
        if ((url = url.substring(index + 1)).length() == 0) {
            buffer.append(JPF_SERVICE_NAME.substring(1));
            return new String(buffer);
        }
        buffer.append(url);
        return new String(buffer);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

