/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import com.sap.aii.proxy.framework.core.XmlAnyAttribute;
import java.util.Hashtable;

public class XmlRenderer {
    private static final String COMMENT_BEGIN = "<!-- ";
    private static final String COMMENT_END = " -->";
    private static final String ELEMENT_BEGIN = "<";
    private static final String ELEMENT_END_BEGIN = "</";
    private static final String ELEMENT_CLOSE = ">";
    private static final String ELEMENT_END = "/>";
    private static final String EQUALS_BEGIN = "=\"";
    private static final String EQUALS_END = "\"";
    private static final String INSTRUCTION_BEGIN = "<?";
    private static final String INSTRUCTION_END = "?>";
    private static final String NAME_SEPARATOR = ":";
    private static final String XML_NAMESPACE_PREFIX = "xmlns";
    private static final String XML_VERSION_NAME = "xml version";
    private static final String XML_VERSION = "1.0";
    private static final String XML_ENCODING_NAME = "encoding";
    private static final String XML_ENCODING_8 = "UTF-8";
    private static final String XML_STANDALONE_NO = "standalone=\"no\"";
    private static final String SPACE = " ";

    private XmlRenderer() {
    }

    public static String getXmlString(String string) {
        return XmlRenderer.encodeEntityRefs(string);
    }

    public static String getXmlVersionTag() {
        return new String("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
    }

    public static String getEmptyTag(String tagName) {
        if (tagName == null || tagName.length() == 0) {
            return null;
        }
        return new String(ELEMENT_BEGIN + tagName + ELEMENT_END);
    }

    public static String getEmptyTag(String prefix, String tagName) {
        if (tagName == null || tagName.length() == 0) {
            return null;
        }
        return new String(ELEMENT_BEGIN + XmlRenderer.getQName(prefix, tagName) + ELEMENT_END);
    }

    public static String getEmptyTag(String tagName, XmlAnyAttribute[] attributes, Hashtable prefixes) {
        if (tagName == null || tagName.length() == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(ELEMENT_BEGIN + tagName);
        buffer.append(XmlRenderer.getAttributes(attributes, prefixes));
        buffer.append(ELEMENT_END);
        return new String(buffer);
    }

    public static String getCommentTag(String comment) {
        return new String(COMMENT_BEGIN + XmlRenderer.encodeEntityRefs(comment) + COMMENT_END);
    }

    public static String getStartTag(String tagName) {
        if (tagName == null || tagName.length() == 0) {
            return null;
        }
        return new String(ELEMENT_BEGIN + XmlRenderer.encodeEntityRefs(tagName) + ELEMENT_CLOSE);
    }

    public static String getStartTag(String prefix, String tagName) {
        if (tagName == null || tagName.length() == 0) {
            return null;
        }
        return new String(ELEMENT_BEGIN + XmlRenderer.getQName(prefix, tagName) + ELEMENT_CLOSE);
    }

    public static String getStartTag(String prefix, String tagName, String namespace) {
        if (tagName == null || tagName.length() == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(ELEMENT_BEGIN);
        buffer.append(XmlRenderer.getQName(prefix, tagName));
        buffer.append(XmlRenderer.getNamespace(prefix, namespace));
        buffer.append(ELEMENT_CLOSE);
        return new String(buffer);
    }

    public static String getStartTag(String prefix, String tagName, String namespace, XmlAnyAttribute[] attributes, Hashtable prefixes) {
        if (tagName == null || tagName.length() == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(ELEMENT_BEGIN);
        buffer.append(XmlRenderer.getQName(prefix, tagName));
        buffer.append(XmlRenderer.getNamespace(prefix, namespace));
        buffer.append(XmlRenderer.getAttributes(attributes, prefixes));
        buffer.append(ELEMENT_CLOSE);
        return new String(buffer);
    }

    public static String getEndTag(String tagName) {
        if (tagName == null || tagName.length() == 0) {
            return null;
        }
        return new String(ELEMENT_END_BEGIN + XmlRenderer.encodeEntityRefs(tagName) + ELEMENT_CLOSE);
    }

    public static String getEndTag(String prefix, String tagName) {
        if (tagName == null || tagName.length() == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(ELEMENT_END_BEGIN);
        buffer.append(XmlRenderer.getQName(prefix, tagName));
        buffer.append(ELEMENT_CLOSE);
        return new String(buffer);
    }

    public static String getXMLDeclaration(Float version, boolean standalone) {
        StringBuffer buffer = new StringBuffer("<?xml version=\"");
        buffer.append(version);
        buffer.append(EQUALS_END);
        if (!standalone) {
            buffer.append(" standalone=\"no\"");
        }
        buffer.append(INSTRUCTION_END);
        return new String(buffer);
    }

    public static String getXMLProcessingInstruction(String name, XmlAnyAttribute[] attributes, Hashtable prefixes) {
        StringBuffer buffer = new StringBuffer(INSTRUCTION_BEGIN);
        buffer.append(name);
        buffer.append(XmlRenderer.getAttributes(attributes, prefixes));
        buffer.append(INSTRUCTION_END);
        return new String(buffer);
    }

    static String encodeEntityRefs(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int offset = 0;
        int length = string.length();
        String substitute = null;
        int i = 0;
        while (i < length) {
            switch (string.charAt(i)) {
                case '&': {
                    substitute = "&amp;";
                    break;
                }
                case '<': {
                    substitute = "&lt;";
                    break;
                }
                case '>': {
                    substitute = "&gt;";
                    break;
                }
                case '\"': {
                    substitute = "&quot;";
                    break;
                }
                case '\'': {
                    substitute = "&apos;";
                }
            }
            if (substitute != null) {
                if (offset < i) {
                    buffer.append(string.substring(offset, i));
                }
                offset = i + 1;
                buffer.append(substitute);
                substitute = null;
            }
            ++i;
        }
        if (offset == 0) {
            return string;
        }
        if (offset < length) {
            buffer.append(string.substring(offset));
        }
        return new String(buffer);
    }

    private static String getQName(String prefix, String name) {
        StringBuffer buffer = new StringBuffer();
        if (prefix != null && prefix.length() > 0) {
            buffer.append(XmlRenderer.encodeEntityRefs(prefix));
            buffer.append(NAME_SEPARATOR);
        }
        buffer.append(XmlRenderer.encodeEntityRefs(name));
        return new String(buffer);
    }

    private static String getNamespace(String prefix, String namespace) {
        StringBuffer buffer = new StringBuffer();
        if (namespace != null) {
            buffer.append(SPACE);
            buffer.append(XML_NAMESPACE_PREFIX);
            if (prefix != null && prefix.length() > 0) {
                buffer.append(NAME_SEPARATOR);
                buffer.append(XmlRenderer.encodeEntityRefs(prefix));
            }
            buffer.append(EQUALS_BEGIN);
            buffer.append(XmlRenderer.encodeEntityRefs(namespace));
            buffer.append(EQUALS_END);
        }
        return new String(buffer);
    }

    protected static String getAttributes(XmlAnyAttribute[] attributes, Hashtable prefixes) {
        StringBuffer buffer = new StringBuffer();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.length) {
                if (attributes[i] != null) {
                    buffer.append(SPACE);
                    String prefix = attributes[i].getPrefix();
                    if (prefix != null && prefix.length() > 0) {
                        if (prefixes != null) {
                            String namespace = (String)prefixes.get(prefix);
                            if (namespace == null) {
                                namespace = attributes[i].getNamespace();
                            }
                            buffer.append(XmlRenderer.getNamespace(prefix, namespace));
                            buffer.append(SPACE);
                        }
                        buffer.append(XmlRenderer.encodeEntityRefs(prefix));
                        buffer.append(NAME_SEPARATOR);
                    }
                    buffer.append(XmlRenderer.encodeEntityRefs(attributes[i].getName()));
                    buffer.append(EQUALS_BEGIN);
                    buffer.append(XmlRenderer.encodeEntityRefs(attributes[i].getValue()));
                    buffer.append(EQUALS_END);
                }
                ++i;
            }
        }
        return new String(buffer);
    }
}

