/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import com.sap.aii.proxy.framework.core.AbstractList;
import com.sap.aii.proxy.framework.core.AbstractType;
import com.sap.aii.proxy.framework.core.BaseType;
import com.sap.aii.proxy.framework.core.BaseTypeData;
import com.sap.aii.proxy.framework.core.BaseTypeDescriptor;
import com.sap.aii.proxy.framework.core.DataAccessException;
import com.sap.aii.proxy.framework.core.EnumerationType;
import com.sap.aii.proxy.framework.core.XmlBaseTypeData;
import com.sap.aii.proxy.framework.core.XmlParser;
import com.sap.aii.proxy.framework.core.XmlProxyRuntimeException;
import com.sap.aii.proxy.framework.core.XmlUtils;
import com.sap.aii.proxy.framework.core.XsdlAttributeProperties;
import com.sap.aii.proxy.framework.core.XsdlElementProperties;
import com.sap.aii.proxy.framework.core.XsdlProperties;
import com.sap.tc.logging.Location;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

public final class XmlContentHandlerImpl
implements ContentHandler {
    private static final Location loc = Location.getLocation((String)(class$com$sap$aii$proxy$framework$core$XmlContentHandlerImpl == null ? (class$com$sap$aii$proxy$framework$core$XmlContentHandlerImpl = XmlContentHandlerImpl.class$("com.sap.aii.proxy.framework.core.XmlContentHandlerImpl")) : class$com$sap$aii$proxy$framework$core$XmlContentHandlerImpl).getName());
    private BaseType baseType = null;
    private Stack elementStack = new Stack();
    private Object currentElement = null;
    private StringBuffer currentValue = new StringBuffer();
    private int level = 0;
    static /* synthetic */ Class class$com$sap$aii$proxy$framework$core$XmlContentHandlerImpl;

    public XmlContentHandlerImpl(BaseType baseType) {
        this.baseType = baseType;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() {
        if (loc.beLogged(100)) {
            loc.logT(100, "startDocument()", "Starting document");
        }
    }

    public void endDocument() {
        if (loc.beLogged(100)) {
            loc.logT(100, "endDocument()", "Ending document");
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
        if (loc.beLogged(100)) {
            loc.logT(100, "startPrefixMapping()", "for prefix {0}", new Object[]{prefix});
        }
    }

    public void endPrefixMapping(String prefix) {
        if (loc.beLogged(100)) {
            loc.logT(100, "endPrefixMapping()", "for prefix {0}", new Object[]{prefix});
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.currentValue.append(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(ch, start, length);
        if (loc.beLogged(100)) {
            loc.logT(100, "ignorableWhitespace(...)", "with buffer {0}", new Object[]{buffer.toString()});
        }
    }

    public void processingInstruction(String target, String data) {
        if (loc.beLogged(100)) {
            loc.logT(100, "processingInstruction(...)", "with target {0} and data {1}", new Object[]{target, data});
        }
    }

    public void skippedEntity(String name) {
        if (loc.beLogged(100)) {
            loc.logT(100, "skippedEntity(...)", "with name {0}", new Object[]{name});
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        String _methodName = "startElement(...)";
        this.currentValue = new StringBuffer();
        if (loc.beLogged(100)) {
            loc.logT(100, _methodName, "with localName {0}", new Object[]{localName});
        }
        Object currentElement = null;
        if (this.elementStack.isEmpty()) {
            this.currentElement = this.baseType;
            currentElement = ((AbstractType)this.baseType).baseTypeDescriptor.getXsdlType() == 5 ? this.checkInitialValue((AbstractType)this.baseType, 0) : this.currentElement;
        } else {
            currentElement = this.currentElement = this.getElement(localName);
        }
        if (atts.getLength() != 0) {
            this.setAttributes((BaseType)currentElement, atts);
        }
        this.elementStack.push(currentElement);
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        String _methodName = "endElement(...)";
        if (loc.beLogged(100)) {
            loc.logT(100, _methodName, "with localName {0}", new Object[]{localName});
        }
        String valueString = XmlParser.decodeEntityRefs(this.currentValue);
        this.currentElement = this.elementStack.pop();
        if (this.elementStack.isEmpty()) {
            if (((AbstractType)this.baseType).baseTypeDescriptor.getXsdlType() == 5) {
                BaseTypeDescriptor descriptor = (BaseTypeDescriptor)((Object)((AbstractType)this.baseType).descriptor());
                XsdlElementProperties props = descriptor.getElementProperties(0);
                Class javaClass = props.getJavaClass();
                if (XmlUtils.isJavaType(javaClass) || XmlUtils.isEnumerationType(javaClass)) {
                    this.setElementValue((AbstractType)this.baseType, localName, (Object)valueString);
                } else {
                    BaseTypeData dataSet = (BaseTypeData)((Object)this.baseType.dataSet());
                    Object subtype = dataSet.getElementValue(0);
                    int xsdlType = XmlContentHandlerImpl.getXsdlType(((AbstractType)subtype).baseTypeDescriptor);
                    switch (xsdlType) {
                        case 1: {
                            this.setElementValue((AbstractType)subtype, 0, (Object)valueString);
                        }
                    }
                }
            } else {
                int xsdlType = XmlContentHandlerImpl.getXsdlType(((AbstractType)this.baseType).baseTypeDescriptor);
                switch (xsdlType) {
                    case 1: {
                        this.setElementValue((AbstractType)this.baseType, 0, (Object)valueString);
                    }
                }
            }
        } else if (this.currentElement == null || XmlUtils.isJavaType(this.currentElement) || XmlUtils.isEnumerationType(this.currentElement)) {
            this.setValue(localName, valueString);
        } else if (this.currentElement instanceof BaseType) {
            int xsdlType = XmlContentHandlerImpl.getXsdlType(((AbstractType)this.currentElement).baseTypeDescriptor);
            switch (xsdlType) {
                case 1: {
                    this.setElementValue((AbstractType)this.currentElement, 0, (Object)valueString);
                    break;
                }
                case 3: {
                    this.setValue(localName, valueString);
                    break;
                }
                case 2: {
                    this.setValue(localName, this.currentElement);
                    break;
                }
                case 4: {
                    this.setValue(localName, this.currentElement, valueString);
                    break;
                }
                case 5: {
                    this.setElementValue((AbstractType)this.currentElement, localName, (Object)valueString);
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    if (loc.beLogged(400)) {
                        loc.logT(400, _methodName, "Unknown XSDL type {0}", new Object[]{Integer.toString(xsdlType)});
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (this.currentElement instanceof AbstractList && !((AbstractList)this.currentElement).isRfcList()) {
            this.addValue(localName, valueString);
        }
        this.checkMandatoryElements(this.currentElement);
        this.currentValue = new StringBuffer();
    }

    private Object getElement(String elementName) {
        String _methodName = "getElement(...)";
        if (this.elementStack.isEmpty()) {
            if (loc.beLogged(500)) {
                loc.logT(500, _methodName, "elementStack is empty");
            }
            throw new XmlProxyRuntimeException("elementStack is empty");
        }
        Object result = null;
        Object currentElement = this.elementStack.peek();
        if (currentElement instanceof BaseType) {
            AbstractType baseType = (AbstractType)currentElement;
            BaseTypeDescriptor descriptor = (BaseTypeDescriptor)((Object)baseType.descriptor());
            if (elementName != null) {
                int index = descriptor.getElementIndex(elementName);
                if (index < 0) {
                    result = this.getSubelement(elementName, baseType);
                } else {
                    BaseTypeData baseTypeData = (BaseTypeData)((Object)baseType.dataSet());
                    result = baseTypeData.getElementValue(index);
                    if (result == null || baseTypeData.isElementDefaulted(index) || baseTypeData.isElementFixed(index)) {
                        result = this.checkInitialValue(baseType, index);
                    }
                    if (result instanceof AbstractList && !((AbstractList)result).isRfcList()) {
                        result = this.createRecord((AbstractList)result);
                    }
                }
            }
        } else if (currentElement instanceof AbstractList && ((AbstractList)currentElement).isRfcList()) {
            result = this.createRecord((AbstractList)currentElement);
        }
        return result;
    }

    private Object createRecord(AbstractList table) {
        String _methodName = "createRecord(...)";
        if (table == null) {
            return null;
        }
        AbstractList record = table;
        String itemType = table.getItemType();
        if (!XmlUtils.isJavaType(itemType) && !XmlUtils.isEnumerationType(itemType)) {
            Class<?> javaClass = null;
            try {
                ClassLoader classLoader = table.getClass().getClassLoader();
                javaClass = Class.forName(itemType, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                if (loc.beLogged(500)) {
                    loc.logT(500, _methodName, "ClassNotFoundException for name {0}: {1}", new Object[]{itemType, e.getMessage()});
                }
                throw new XmlProxyRuntimeException("ClassNotFoundException for name " + itemType, (Throwable)e);
            }
            try {
                record = javaClass.newInstance();
            }
            catch (InstantiationException e) {
                if (loc.beLogged(500)) {
                    loc.logT(500, _methodName, "InstantiationException for class {0}: {1}", new Object[]{itemType, e.getMessage()});
                }
                throw new XmlProxyRuntimeException("InstantiationException for class " + itemType, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                if (loc.beLogged(500)) {
                    loc.logT(500, _methodName, "IllegalAccessException for class {0}: {1}", new Object[]{itemType, e.getMessage()});
                }
                throw new XmlProxyRuntimeException("IllegalAccessException for class " + itemType, (Throwable)e);
            }
            table.add(record);
        }
        return record;
    }

    private Object checkInitialValue(AbstractType baseType, int index) {
        String _methodName = "checkInitialValue(...)";
        Object result = null;
        BaseTypeData baseTypeData = (BaseTypeData)((Object)baseType.dataSet());
        BaseTypeDescriptor descriptor = (BaseTypeDescriptor)((Object)baseType.descriptor());
        XsdlElementProperties props = descriptor.getElementProperties(index);
        Class javaClass = props.getJavaClass();
        Object element = baseTypeData.getElementValue(index);
        if (!XmlUtils.isJavaType(javaClass) && !XmlUtils.isEnumerationType(javaClass)) {
            try {
                result = javaClass.newInstance();
            }
            catch (InstantiationException e) {
                if (loc.beLogged(500)) {
                    loc.logT(500, _methodName, "InstantiationException for class {0}: {1}", new Object[]{javaClass.getName(), e.getMessage()});
                }
                throw new XmlProxyRuntimeException("InstantiationException for class " + javaClass.getName(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                if (loc.beLogged(500)) {
                    loc.logT(500, _methodName, "IllegalAccessException for class {0}: {1}", new Object[]{javaClass.getName(), e.getMessage()});
                }
                throw new XmlProxyRuntimeException("IllegalAccessException for class " + javaClass.getName(), (Throwable)e);
            }
            if (!baseTypeData.isElementFixed(index)) {
                baseTypeData.setElementValue(index, (Object)result);
            }
        }
        return result;
    }

    private Object getSubelement(String elementName, AbstractType baseType) {
        if (baseType == null) {
            return null;
        }
        String _methodName = "getSubelement(String, AbstractType)";
        Object result = null;
        BaseTypeDescriptor descriptor = (BaseTypeDescriptor)((Object)baseType.descriptor());
        int i = 0;
        while (i < descriptor.getElementCount()) {
            XsdlElementProperties props = descriptor.getElementProperties(i);
            Class javaClass = props.getJavaClass();
            BaseTypeData dataSet = (BaseTypeData)((Object)baseType.dataSet());
            Object subtype = dataSet.getElementValue(i);
            BaseTypeDescriptor subdescriptor = null;
            try {
                int index;
                if (subtype == null && !XmlUtils.isJavaType(javaClass) && !XmlUtils.isEnumerationType(javaClass)) {
                    subtype = javaClass.newInstance();
                    dataSet.setElementValue(i, subtype);
                }
                if (subtype instanceof AbstractList) {
                    int index2;
                    AbstractList table = (AbstractList)subtype;
                    String itemType = table.getItemType();
                    BaseTypeDescriptor itemDescriptor = props.getDescriptor();
                    if (itemDescriptor != null && (index2 = itemDescriptor.getElementIndex(elementName)) >= 0) {
                        Object itemObject = null;
                        AbstractList list = table;
                        Object value = null;
                        int j = 0;
                        while (j < list.size()) {
                            itemObject = list.get(j);
                            if (itemObject instanceof AbstractType) {
                                dataSet = (BaseTypeData)((Object)((AbstractType)itemObject).dataSet());
                                value = dataSet.getElementValue(index2);
                                if (value == null) {
                                    XsdlElementProperties dataprops = itemDescriptor.getElementProperties(index2);
                                    Class dataJavaClass = dataprops.getJavaClass();
                                    if (XmlUtils.isJavaType(dataJavaClass) || XmlUtils.isEnumerationType(dataJavaClass)) break;
                                    Object dataObject = dataJavaClass.newInstance();
                                    dataSet.setElementValue(index2, dataObject);
                                    return dataObject;
                                }
                            } else if (itemObject instanceof AbstractList) {
                                // empty if block
                            }
                            ++j;
                        }
                        if (value != null || itemObject == null) {
                            if (!XmlUtils.isJavaType(itemType) && !XmlUtils.isEnumerationType(itemType)) {
                                ClassLoader classLoader = table.getClass().getClassLoader();
                                Class<?> classDef = Class.forName(itemType, true, classLoader);
                                itemObject = classDef.newInstance();
                                list.add(itemObject);
                            }
                        } else {
                            result = itemObject;
                        }
                    }
                } else if (subtype instanceof BaseType && (subdescriptor = (BaseTypeDescriptor)((Object)((AbstractType)subtype).descriptor())) != null && (index = subdescriptor.getElementIndex(elementName)) >= 0) {
                    BaseTypeData subdataSet = (BaseTypeData)((Object)((AbstractType)subtype).dataSet());
                    XsdlElementProperties subprops = subdescriptor.getElementProperties(index);
                    Class subJavaClass = subprops.getJavaClass();
                    result = subdataSet.getElementValue(index);
                    if (result != null || XmlUtils.isJavaType(subJavaClass) || XmlUtils.isEnumerationType(subJavaClass)) break;
                    result = subJavaClass.newInstance();
                    subdataSet.setElementValue(index, result);
                    break;
                }
            }
            catch (Exception e) {
                if (loc.beLogged(500)) {
                    loc.logT(500, _methodName, "Error. Exception {0}", new Object[]{e.getMessage()});
                }
                throw new XmlProxyRuntimeException("Error getting subelement", (Throwable)e);
            }
            ++i;
        }
        return result;
    }

    private Object getSubelementParent(String elementName, AbstractType baseType) {
        if (baseType == null) {
            return null;
        }
        String _methodName = "getSubelementParent(...)";
        Object result = null;
        BaseTypeDescriptor descriptor = (BaseTypeDescriptor)((Object)baseType.descriptor());
        int i = 0;
        while (i < descriptor.getElementCount()) {
            XsdlElementProperties props = descriptor.getElementProperties(i);
            Class javaClass = props.getJavaClass();
            BaseTypeData dataSet = (BaseTypeData)((Object)baseType.dataSet());
            Object subtype = dataSet.getElementValue(i);
            try {
                int index;
                BaseTypeDescriptor subdescriptor;
                if (subtype == null && !XmlUtils.isJavaType(javaClass) && !XmlUtils.isEnumerationType(javaClass)) {
                    subtype = javaClass.newInstance();
                    dataSet.setElementValue(i, subtype);
                }
                if (subtype instanceof AbstractList) {
                    int index2;
                    AbstractList table = (AbstractList)subtype;
                    String itemType = table.getItemType();
                    BaseTypeDescriptor itemDescriptor = props.getDescriptor();
                    if (itemDescriptor != null && (index2 = itemDescriptor.getElementIndex(elementName)) >= 0) {
                        Object itemObject = null;
                        AbstractList list = table;
                        Object value = null;
                        int j = 0;
                        while (j < list.size()) {
                            itemObject = list.get(j);
                            if (itemObject instanceof AbstractType) {
                                dataSet = (BaseTypeData)((Object)((AbstractType)itemObject).dataSet());
                                value = dataSet.getElementValue(index2);
                                if (value == null) {
                                    break;
                                }
                            } else if (itemObject instanceof AbstractList) {
                                // empty if block
                            }
                            ++j;
                        }
                        if (value == null && itemObject != null) {
                            result = itemObject;
                        }
                    }
                } else if (subtype instanceof BaseType && (subdescriptor = (BaseTypeDescriptor)((Object)((AbstractType)subtype).descriptor())) != null && (index = subdescriptor.getElementIndex(elementName)) >= 0) {
                    result = subtype;
                    break;
                }
            }
            catch (Exception e) {
                if (loc.beLogged(500)) {
                    loc.logT(500, _methodName, "Error. Exception {0}", new Object[]{e.getMessage()});
                }
                throw new XmlProxyRuntimeException("Error getting subelement parent", (Throwable)e);
            }
            ++i;
        }
        return result;
    }

    private void setAttributes(BaseType element, Attributes atts) {
        String _methodName = "setAttributes(...)";
        int i = 0;
        while (i < atts.getLength()) {
            String attrName = atts.getLocalName(i);
            String attrQName = atts.getQName(i);
            String attrPrefix = attrQName == null || attrQName.equals(attrName) ? null : attrQName.substring(0, attrQName.lastIndexOf(attrName) - 1);
            String attrValueString = XmlParser.decodeEntityRefs(atts.getValue(i));
            String attrURI = atts.getURI(i);
            if (element == null || attrPrefix != null && attrPrefix.equals("xmlns") || attrPrefix == null && attrName.equals("xmlns")) {
                if (loc.beLogged(100)) {
                    loc.logT(100, _methodName, "{0}={1} ignored", new Object[]{attrQName, attrValueString});
                }
            } else if (attrURI == null || attrURI.length() == 0) {
                if (loc.beLogged(100)) {
                    loc.logT(100, _methodName, "{0}={1}", new Object[]{attrQName, attrValueString});
                }
                this.setAttributeValue((AbstractType)element, attrName, attrValueString);
            } else {
                if (loc.beLogged(100)) {
                    loc.logT(100, _methodName, "{0}:{1}={2}", new Object[]{attrURI, attrQName, attrValueString});
                }
                if (!attrURI.equals("http://www.w3.org/2001/XMLSchema-instance") || attrName.equals("nil") || attrName.equals("type")) {
                    // empty if block
                }
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addValue(String elementName, String valueString) {
        String _methodName = "addValue(...)";
        if (this.elementStack.isEmpty()) {
            if (!loc.beLogged(500)) throw new XmlProxyRuntimeException("Element stack is empty");
            loc.logT(500, _methodName, "elementStack is empty");
            throw new XmlProxyRuntimeException("Element stack is empty");
        }
        Object currentElement = this.elementStack.peek();
        if (currentElement instanceof BaseType) {
            AbstractType baseType = (AbstractType)currentElement;
            if (elementName == null) return;
            BaseTypeDescriptor descriptor = (BaseTypeDescriptor)((Object)baseType.descriptor());
            int index = descriptor.getElementIndex(elementName);
            BaseTypeData dataSet = (BaseTypeData)((Object)baseType.dataSet());
            Object table = dataSet.getElementValue(index);
            if (table instanceof AbstractList) {
                String itemType = ((AbstractList)table).getItemType();
                Class<?> javaClass = null;
                try {
                    ClassLoader classLoader = table.getClass().getClassLoader();
                    javaClass = Class.forName(itemType, true, classLoader);
                }
                catch (ClassNotFoundException e) {
                    if (!loc.beLogged(500)) throw new XmlProxyRuntimeException("ClassNotFoundException for name " + itemType, (Throwable)e);
                    loc.logT(500, _methodName, "ClassNotFoundException for name {0}: {1}", new Object[]{itemType, e.getMessage()});
                    throw new XmlProxyRuntimeException("ClassNotFoundException for name " + itemType, (Throwable)e);
                }
                Object value = this.getValueInstance(javaClass, valueString, ((AbstractList)table).properties);
                ((AbstractList)table).add(value);
                if (!loc.beLogged(100)) return;
                XsdlElementProperties props = descriptor.getElementProperties(index);
                String tableType = props.getJavaClass().getName();
                loc.logT(100, _methodName, "{0} {1}={2}", new Object[]{tableType, elementName, itemType});
                return;
            }
            if (!loc.beLogged(500)) throw new XmlProxyRuntimeException("Table is not AbstractList");
            loc.logT(500, _methodName, "table is not AbstractList");
            throw new XmlProxyRuntimeException("Table is not AbstractList");
        }
        if (!loc.beLogged(500)) throw new XmlProxyRuntimeException("Current element ist not BaseType");
        loc.logT(500, _methodName, "currentElement is not BaseType");
        throw new XmlProxyRuntimeException("Current element ist not BaseType");
    }

    private void setValue(String elementName, Object value) {
        String _methodName = "setValue(...)";
        if (this.elementStack.isEmpty()) {
            if (loc.beLogged(500)) {
                loc.logT(500, _methodName, "elementStack is empty");
            }
            throw new XmlProxyRuntimeException("Element stack is empty");
        }
        Object currentElement = this.elementStack.peek();
        if (currentElement instanceof BaseType) {
            AbstractType baseType = (AbstractType)currentElement;
            BaseTypeDescriptor descriptor = (BaseTypeDescriptor)((Object)baseType.descriptor());
            if (elementName != null) {
                int index = descriptor.getElementIndex(elementName);
                if (index < 0) {
                    Object subelement = this.getSubelementParent(elementName, baseType);
                    if (!(subelement instanceof AbstractType)) {
                        return;
                    }
                    baseType = (AbstractType)subelement;
                }
                this.setElementValue(baseType, elementName, value);
            }
        }
    }

    private void setValue(String elementName, Object type, Object value) {
        String _methodName = "setValue(...)";
        if (this.elementStack.isEmpty()) {
            if (loc.beLogged(500)) {
                loc.logT(500, _methodName, "elementStack is empty");
            }
            throw new XmlProxyRuntimeException("Element stack is empty");
        }
        Object currentElement = this.elementStack.peek();
        if (currentElement instanceof BaseType) {
            AbstractType baseType = (AbstractType)currentElement;
            this.setElementValue(baseType, elementName, type);
            this.setElementValue((AbstractType)type, "simpleContent", value);
        }
    }

    private void setElementValue(AbstractType baseType, String elementName, Object value) {
        String _methodName = "setElementValue(...)";
        BaseTypeDescriptor descriptor = (BaseTypeDescriptor)((Object)baseType.descriptor());
        int index = descriptor.getElementIndex(elementName);
        if (index < 0) {
            if (loc.beLogged(500)) {
                loc.logT(500, _methodName, "Element {0} not found", new Object[]{elementName});
            }
            throw new XmlProxyRuntimeException("Element " + elementName + " not found");
        }
        this.setElementValue(baseType, elementName, index, value);
    }

    private void setElementValue(AbstractType baseType, int index, Object value) {
        String _methodName = "setElementValue(...)";
        if (index < 0) {
            if (loc.beLogged(500)) {
                loc.logT(500, _methodName, "No element with index {0}", new Object[]{Integer.toString(index)});
            }
            throw new XmlProxyRuntimeException("No element with index " + Integer.toString(index));
        }
        BaseTypeDescriptor descriptor = (BaseTypeDescriptor)((Object)baseType.descriptor());
        String elementName = descriptor.getElementProperties(index).getJavaName();
        this.setElementValue(baseType, elementName, index, value);
    }

    private void setElementValue(AbstractType baseType, String elementName, int index, Object value) {
        String _methodName = "setElementValue(...)";
        if (index < 0) {
            if (loc.beLogged(500)) {
                loc.logT(500, _methodName, "No element with index {0}", new Object[]{Integer.toString(index)});
            }
            throw new XmlProxyRuntimeException("No element with index " + Integer.toString(index));
        }
        BaseTypeDescriptor descriptor = (BaseTypeDescriptor)((Object)baseType.descriptor());
        BaseTypeData dataSet = (BaseTypeData)((Object)baseType.dataSet());
        XsdlElementProperties properties = descriptor.getElementProperties(index);
        Class javaClass = properties.getJavaClass();
        String valueString = XmlContentHandlerImpl.getValueString(javaClass, value);
        if (dataSet.isElementFixed(index)) {
            if (loc.beLogged(400)) {
                loc.logT(400, _methodName, "Element {0} is fixed. Not set to value {1}", new Object[]{elementName, valueString});
            }
        } else {
            Object valueObject = this.getValueInstance(javaClass, value, properties);
            if (valueObject instanceof AbstractType) {
                if (XmlContentHandlerImpl.getXsdlType(((AbstractType)valueObject).baseTypeDescriptor) == 1) {
                    XsdlElementProperties props = descriptor.getElementProperties(0);
                    XmlBaseTypeData data = (XmlBaseTypeData)((AbstractType)valueObject).dataSet();
                    try {
                        data.setElementValue(0, XmlUtils.valueAsString(value, props));
                    }
                    catch (DataAccessException e) {
                        if (loc.beLogged(500)) {
                            loc.logT(500, _methodName, "Error setting element value. Exception: {0}", new Object[]{e.getMessage()});
                        }
                        throw new XmlProxyRuntimeException("Error setting element value", (Throwable)((Object)e));
                    }
                }
            } else {
                try {
                    if (Class.forName("com.sap.aii.proxy.framework.core.AbstractList").isAssignableFrom(javaClass)) {
                        valueString = "<" + valueObject.getClass().getName() + ">";
                    } else {
                        dataSet.setElementValue(index, valueObject);
                    }
                }
                catch (ClassNotFoundException e) {
                    if (loc.beLogged(500)) {
                        loc.logT(500, _methodName, "Error checking class {0} against AbstractList. Exception: {1}", new Object[]{javaClass.getName(), e.getMessage()});
                    }
                    throw new XmlProxyRuntimeException("Error checking class " + javaClass.getName() + " against AbstractList", (Throwable)e);
                }
                catch (DataAccessException ex) {
                    if (loc.beLogged(500)) {
                        loc.logT(500, _methodName, "Error setting element value. Exception: {0}", new Object[]{ex.getMessage()});
                    }
                    throw new XmlProxyRuntimeException("Error setting element value", (Throwable)((Object)ex));
                }
                if (loc.beLogged(100)) {
                    loc.logT(100, _methodName, "{0} {1}={2}", new Object[]{javaClass.getName(), elementName, valueString});
                }
            }
        }
    }

    private void setAttributeValue(AbstractType baseType, String attributeName, Object value) {
        String valueString;
        if (attributeName == null || attributeName.length() <= 0) {
            return;
        }
        String _methodName = "setAttributeValue(...)";
        BaseTypeDescriptor descriptor = (BaseTypeDescriptor)((Object)baseType.descriptor());
        int index = descriptor.getAttributeIndex(attributeName);
        if (index < 0) {
            if (loc.beLogged(500)) {
                loc.logT(500, _methodName, "Attribute {0} not found", new Object[]{attributeName});
            }
            throw new XmlProxyRuntimeException("Attribute " + attributeName + " not found");
        }
        BaseTypeData dataSet = (BaseTypeData)((Object)baseType.dataSet());
        XsdlAttributeProperties properties = descriptor.getAttributeProperties(index);
        Class javaClass = properties.getJavaClass();
        String string = valueString = value == null ? "<null>" : value.toString();
        if (dataSet.isAttributeFixed(index)) {
            if (loc.beLogged(400)) {
                loc.logT(400, _methodName, "Attribute {0} is fixed. Not set to value {1}", new Object[]{attributeName, valueString});
            }
        } else {
            Object valueObject = this.getValueInstance(javaClass, value, properties);
            if (valueObject instanceof AbstractType) {
                if (XmlContentHandlerImpl.getXsdlType(((AbstractType)valueObject).baseTypeDescriptor) == 1) {
                    XsdlAttributeProperties props = descriptor.getAttributeProperties(0);
                    try {
                        dataSet.setAttributeValue(0, XmlUtils.valueAsString(value, props));
                    }
                    catch (DataAccessException e) {
                        if (loc.beLogged(500)) {
                            loc.logT(500, _methodName, "Error setting attribute value. Exception: {0}", new Object[]{e.getMessage()});
                        }
                        throw new XmlProxyRuntimeException("Error setting attribute value", (Throwable)((Object)e));
                    }
                }
            } else {
                try {
                    dataSet.setAttributeValue(index, valueObject);
                }
                catch (DataAccessException ex) {
                    if (loc.beLogged(500)) {
                        loc.logT(500, _methodName, "Error setting element value. Exception: {0}", new Object[]{ex.getMessage()});
                    }
                    throw new XmlProxyRuntimeException("Error setting element value", (Throwable)((Object)ex));
                }
                if (loc.beLogged(100)) {
                    loc.logT(100, _methodName, "{0} {1}={2}", new Object[]{javaClass.getName(), attributeName, valueString});
                }
            }
        }
    }

    private Object getValueInstance(Class javaClass, Object value, XsdlProperties props) {
        String _methodName = "getValueInstance(...)";
        Object valueObject = null;
        if (XmlUtils.isJavaType(javaClass)) {
            if (value != null && ((String)value).length() > 0) {
                valueObject = XmlUtils.getInstance(javaClass, value.toString(), props);
            }
        } else if (XmlUtils.isEnumerationType(javaClass)) {
            valueObject = this.getEnumerationInstance(javaClass, value);
        } else if (value instanceof String) {
            AbstractType simpleType = null;
            try {
                simpleType = (AbstractType)javaClass.newInstance();
            }
            catch (Exception ex) {
                if (loc.beLogged(500)) {
                    loc.logT(500, _methodName, "Error instantiating class {0}", new Object[]{javaClass.getName()});
                }
                throw new XmlProxyRuntimeException("Error instantiating class " + javaClass.getName(), (Throwable)ex);
            }
            valueObject = simpleType;
        } else {
            valueObject = value;
        }
        return valueObject;
    }

    private static String getValueString(Class javaClass, Object value) {
        String valueString;
        String string = valueString = value == null ? "<null>" : value.toString();
        valueString = XmlUtils.isJavaType(javaClass) && value != null && ((String)value).length() > 0 ? value.toString() : (XmlUtils.isEnumerationType(javaClass) && value != null && ((String)value).length() > 0 ? "<" + javaClass.getName() + "=" + value.toString() + ">" : "<" + javaClass.getName() + ">");
        return valueString;
    }

    private Object getEnumerationInstance(Class javaClass, Object value) {
        String _methodName = "getEnumerationInstance(...)";
        Object valueObject = null;
        Method method = null;
        String methodName = null;
        try {
            methodName = value instanceof String ? "fromString" : "fromValue";
            method = javaClass.getMethod(methodName, value.getClass());
        }
        catch (NoSuchMethodException ex) {
            if (loc.beLogged(500)) {
                loc.logT(500, _methodName, "Method {0}.{1} not found", new Object[]{javaClass.getName(), methodName});
            }
            throw new XmlProxyRuntimeException("Method " + javaClass.getName() + "." + methodName + " not found", (Throwable)ex);
        }
        try {
            valueObject = method.invoke((Object)javaClass, value);
        }
        catch (InvocationTargetException e) {
            Exception te = (Exception)e.getTargetException();
            if (loc.beLogged(500)) {
                loc.logT(500, _methodName, "Error invoking method {0}.{1}: {2}", new Object[]{javaClass.getName(), "fromValue", te.getMessage()});
            }
            throw new XmlProxyRuntimeException("InvocationTargetException when calling method " + javaClass.getName() + ".fromValue: " + te.getMessage(), (Throwable)te);
        }
        catch (IllegalAccessException e) {
            if (loc.beLogged(500)) {
                loc.logT(500, _methodName, "Illegal access to method {0}.{1}: {2}", new Object[]{javaClass.getName(), "fromValue", e.getMessage()});
            }
            throw new XmlProxyRuntimeException("IllegalAccessException when calling method " + javaClass.getName() + ".fromValue: " + e.getMessage(), (Throwable)e);
        }
        return valueObject;
    }

    private final boolean checkMandatoryElements(Object element) {
        if (element == null || XmlUtils.isJavaType(element)) {
            return true;
        }
        String _methodName = "checkMandatoryElements(...)";
        boolean result = true;
        if (element instanceof BaseType) {
            BaseTypeDescriptor descriptor = (BaseTypeDescriptor)((Object)((AbstractType)element).descriptor());
            if (descriptor != null) {
                int count = descriptor.getElementCount();
                int i = 0;
                while (i < count) {
                    Object value;
                    XsdlElementProperties props = descriptor.getElementProperties(i);
                    if (props != null && !props.isOptional() && (value = ((AbstractType)element).baseTypeData().getElementValue(i)) == null) {
                        result = false;
                        String elementName = props.getName();
                        String typeName = descriptor.getWsdlName().getLocalName();
                        Class javaClass = props.getJavaClass();
                        if (XmlUtils.isJavaType(javaClass)) {
                            value = XmlUtils.getInstance(javaClass, null, props);
                            ((AbstractType)element).baseTypeData().setElementValue(i, value);
                            if (loc.beLogged(400)) {
                                String valueString = XmlUtils.valueAsString(value, props);
                                loc.logT(400, _methodName, "Added mandatory element {0} with initial value {1} in BaseType {2}", new Object[]{elementName, valueString, typeName});
                            }
                        } else {
                            if (XmlUtils.isEnumerationType(javaClass)) {
                                if (loc.beLogged(500)) {
                                    loc.logT(500, _methodName, "Mandatory enumeration element {0} not provided for BaseType {1}", new Object[]{elementName, typeName});
                                }
                                throw EnumerationType.createIllegalArgumentException(elementName, "<null>");
                            }
                            try {
                                value = javaClass.newInstance();
                            }
                            catch (Exception ex) {
                                if (loc.beLogged(500)) {
                                    loc.logT(500, _methodName, "Error instantiating class {0}", new Object[]{javaClass.getName()});
                                }
                                throw new XmlProxyRuntimeException("Error instantiating class " + javaClass.getName(), (Throwable)ex);
                            }
                            this.checkMandatoryElements(value);
                        }
                    }
                    ++i;
                }
            }
        } else if (!(element instanceof AbstractList) || !((AbstractList)element).isRfcList()) {
            // empty if block
        }
        return result;
    }

    private static final int getXsdlType(BaseTypeDescriptor descriptor) {
        XsdlElementProperties props;
        String _methodName = "getXsdlType(...)";
        int result = 0;
        if (descriptor != null && (result = descriptor.getXsdlType()) == 2 && descriptor.getElementCount() == 1 && (props = descriptor.getElementProperties(0)) != null && props.getXmlType() == null) {
            Class javaClass = props.getJavaClass();
            try {
                if (javaClass == null || !Class.forName("com.sap.aii.proxy.framework.core.AbstractList").isAssignableFrom(javaClass)) {
                    result = 1;
                }
            }
            catch (ClassNotFoundException e) {
                if (loc.beLogged(500)) {
                    loc.logT(500, _methodName, "Error checking class {0} against AbstractList. Exception: {1}", new Object[]{javaClass.getName(), e.getMessage()});
                }
                throw new XmlProxyRuntimeException("Error checking class " + javaClass.getName() + " against AbstractList", (Throwable)e);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

