/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import java.io.Serializable;

public class QName
implements Serializable {
    private static final long serialVersionUID = 2009092002L;
    private static final String SEPARATOR = ":";
    private static final String EMPTY_STRING = "";
    protected String namespace;
    protected String localName;
    protected String prefix;

    public QName(String localName, String namespaceURI, String prefix) {
        this(localName, namespaceURI);
        this.prefix = prefix;
    }

    public QName(String localName, String namespaceURI) {
        this.localName = localName;
        this.namespace = namespaceURI;
        if (this.namespace == null) {
            this.namespace = EMPTY_STRING;
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.namespace != null) {
            buffer.append(this.namespace);
            buffer.append(SEPARATOR);
        }
        buffer.append(this.localName);
        return buffer.toString();
    }

    public String getResolvedName() {
        return this.toString();
    }

    public String getPrefixedName() {
        StringBuffer buffer = new StringBuffer();
        if (this.prefix != null && !this.prefix.equals(EMPTY_STRING)) {
            buffer.append(this.prefix);
            buffer.append(SEPARATOR);
        }
        buffer.append(this.localName);
        return buffer.toString();
    }

    public static String getLocalName(String prefixedName) {
        int colon = prefixedName.indexOf(SEPARATOR);
        if (colon == -1) {
            return prefixedName;
        }
        return prefixedName.substring(colon + 1);
    }

    public static String getPrefix(String prefixedName) {
        int colon = prefixedName.indexOf(SEPARATOR);
        if (colon == -1) {
            return EMPTY_STRING;
        }
        return prefixedName.substring(0, colon);
    }
}

