/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import com.sap.aii.proxy.framework.core.AbstractProxy;
import com.sap.aii.proxy.framework.core.ApplicationFaultException;
import com.sap.aii.proxy.framework.core.BaseType;
import com.sap.aii.proxy.framework.core.BaseTypeDescriptor;
import com.sap.aii.proxy.framework.core.JcoBaseProxyDescriptor;
import com.sap.aii.proxy.framework.core.JcoMarshaler;
import com.sap.aii.proxy.framework.core.JcoProxyException;
import com.sap.mdi.Currencies;
import com.sap.mdi.Currency;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.ObjectFactoryException;
import com.sap.mw.jco.JCO;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Hashtable;

abstract class JcoProxy
implements Serializable {
    private static final long serialVersionUID = 2009092002L;
    private static ObjectFactory of = null;
    private static Hashtable ofs = new Hashtable();

    JcoProxy() {
    }

    static final BaseType send(AbstractProxy proxy, BaseType requestType, String namespace, String interfaceName, String methodName, BaseType responseType) throws JcoProxyException, ApplicationFaultException {
        int encoding = 0;
        JCO.Client jcoClient = null;
        BaseTypeDescriptor faultMessageDesc = null;
        jcoClient = proxy.messageSpecifier.getJcoClient();
        if (jcoClient == null) {
            throw new JcoProxyException(JcoProxyException.createMsg_NO_JCO_CLIENT());
        }
        if (!jcoClient.isAlive()) {
            throw new JcoProxyException(JcoProxyException.createMsg_JCO_CLIENT_NOT_ALIVE());
        }
        encoding = jcoClient.getAttributes().getPartnerCodepage().indexOf("41") == 0 ? 2 : 1;
        faultMessageDesc = ((JcoBaseProxyDescriptor)proxy.baseProxyDescriptor).getFaultMessageDescriptor(methodName);
        try {
            String abapFunctionName = ((JcoBaseProxyDescriptor)proxy.baseProxyDescriptor).getAbapFunctionName(methodName);
            JCO.Request jcoRequest = JcoMarshaler.marshalRequest(abapFunctionName, requestType, responseType, faultMessageDesc, encoding);
            JCO.Response jcoResponse = jcoClient.execute(jcoRequest);
            responseType = JcoMarshaler.unmarshalRecord(responseType, (JCO.Record)jcoResponse);
        }
        catch (JCO.Exception e) {
            JcoMarshaler.unmarshalException(e, proxy.baseProxyDescriptor, faultMessageDesc);
        }
        return responseType;
    }

    static final BigInteger getCurrencyDecimals(AbstractProxy proxy, String currencyCode) throws JcoProxyException {
        if (proxy == null) {
            throw new IllegalArgumentException("No proxy");
        }
        if (currencyCode == null) {
            throw new JcoProxyException(JcoProxyException.createMsg_NO_CURRENCY_CODE());
        }
        int cdecs = 0;
        if (proxy.messageSpecifier == null) {
            throw new IllegalArgumentException("No proxy.messageSpecifier");
        }
        JCO.Client jcoClient = proxy.messageSpecifier.getJcoClient();
        if (jcoClient == null) {
            throw new JcoProxyException(JcoProxyException.createMsg_NO_JCO_CLIENT());
        }
        if (!jcoClient.isAlive()) {
            throw new JcoProxyException(JcoProxyException.createMsg_JCO_CLIENT_NOT_ALIVE());
        }
        try {
            boolean isNew = false;
            Hashtable hashtable = ofs;
            synchronized (hashtable) {
                of = (ObjectFactory)ofs.get(jcoClient);
                if (of == null) {
                    try {
                        of = new ObjectFactory(jcoClient);
                    }
                    catch (RuntimeException e2) {
                        e2.printStackTrace();
                        throw new JcoProxyException(JcoProxyException.createMsg_OBJECT_FACTORY_ERROR("new ObjectFactory(jcoClient) failed: " + e2.getMessage()));
                    }
                    if (ofs.size() >= 1000) {
                        ofs.clear();
                    }
                    if (of == null) {
                        throw new JcoProxyException(JcoProxyException.createMsg_OBJECT_FACTORY_ERROR("No new ObjectFactory"));
                    }
                    ofs.put(jcoClient, of);
                    isNew = true;
                }
            }
            if (of == null) {
                throw new JcoProxyException(JcoProxyException.createMsg_OBJECT_FACTORY_ERROR("No ObjectFactory instance"));
            }
            Currency currency = null;
            boolean isSupported = false;
            ObjectFactory objectFactory = of;
            synchronized (objectFactory) {
                try {
                    isSupported = of.isSupported("CURRENCY_DIRECT");
                }
                catch (RuntimeException e3) {
                    e3.printStackTrace();
                    throw new JcoProxyException(JcoProxyException.createMsg_OBJECT_FACTORY_ERROR("isSupported(CURRENCY_DIRECT) failed: " + e3.getMessage()));
                }
                if (isSupported) {
                    try {
                        currency = of.getCurrency(currencyCode);
                    }
                    catch (RuntimeException e2) {
                        e2.printStackTrace();
                        throw new JcoProxyException(JcoProxyException.createMsg_OBJECT_FACTORY_ERROR("of.getCurrency(" + currencyCode + ") failed: " + e2.getMessage()));
                    }
                }
                if (currency == null) {
                    ObjectFactory.SapData sapData = null;
                    try {
                        sapData = of.getSapData();
                    }
                    catch (RuntimeException e2) {
                        e2.printStackTrace();
                        throw new JcoProxyException(JcoProxyException.createMsg_OBJECT_FACTORY_ERROR("of.getSapData() failed: " + e2.getMessage()));
                    }
                    if (sapData == null) {
                        throw new JcoProxyException(JcoProxyException.createMsg_OBJECT_FACTORY_ERROR("No SapData instance"));
                    }
                    Currencies currencies = null;
                    try {
                        currencies = sapData.getCurrencies();
                    }
                    catch (RuntimeException e4) {
                        e4.printStackTrace();
                        throw new JcoProxyException(JcoProxyException.createMsg_OBJECT_FACTORY_ERROR("sapData.getCurrencies() failed: " + e4.getMessage()));
                    }
                    if (currencies == null) {
                        throw new JcoProxyException(JcoProxyException.createMsg_OBJECT_FACTORY_ERROR("No Currencies instance"));
                    }
                    try {
                        currency = currencies.getCurrency(currencyCode);
                    }
                    catch (RuntimeException e5) {
                        e5.printStackTrace();
                        throw new JcoProxyException(JcoProxyException.createMsg_OBJECT_FACTORY_ERROR("currencies.getCurrency(" + currencyCode + ") failed: " + e5.getMessage()));
                    }
                }
            }
            if (currency == null) {
                return null;
            }
            try {
                cdecs = currency.getDecimals();
            }
            catch (RuntimeException e2) {
                e2.printStackTrace();
                throw new JcoProxyException(JcoProxyException.createMsg_OBJECT_FACTORY_ERROR("currency.getDecimals() failed: " + e2.getMessage()));
            }
        }
        catch (ObjectFactoryException e) {
            throw new JcoProxyException(JcoProxyException.createMsg_CURRENCY_ERROR(currencyCode, e.getMessage()));
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new JcoProxyException(JcoProxyException.createMsg_CURRENCY_ERROR(currencyCode, "Unexpected runtime exception: " + e1.getMessage()));
        }
        return new BigInteger(String.valueOf(cdecs));
    }
}

