/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import com.sap.aii.proxy.framework.core.AbstractList;
import com.sap.aii.proxy.framework.core.AbstractType;
import com.sap.aii.proxy.framework.core.ApplicationFaultException;
import com.sap.aii.proxy.framework.core.BaseList;
import com.sap.aii.proxy.framework.core.BaseProxyDescriptor;
import com.sap.aii.proxy.framework.core.BaseType;
import com.sap.aii.proxy.framework.core.BaseTypeData;
import com.sap.aii.proxy.framework.core.BaseTypeDescriptor;
import com.sap.aii.proxy.framework.core.DataAccessException;
import com.sap.aii.proxy.framework.core.JcoBaseList;
import com.sap.aii.proxy.framework.core.JcoBaseProxyDescriptor;
import com.sap.aii.proxy.framework.core.JcoBaseTypeData;
import com.sap.aii.proxy.framework.core.JcoBaseTypeDescriptor;
import com.sap.aii.proxy.framework.core.JcoProxyException;
import com.sap.aii.proxy.framework.core.JcoRequest;
import com.sap.aii.proxy.framework.core.JcoTable;
import com.sap.aii.proxy.framework.core.XsdlElementProperties;
import com.sap.aii.proxy.framework.core.XsdlTypeRestrictions;
import com.sap.mw.jco.JCO;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.util.Iterator;
import java.util.Set;

final class JcoMarshaler {
    static final int HIDDEN_PARAMETER = 64;
    static /* synthetic */ Class class$java$lang$String;

    private JcoMarshaler() {
    }

    static Object getElementValueFromJco(JCO.Record record, int i) {
        if (record.getType(i) == 1) {
            java.util.Date date = record.getDate(i);
            return date == null ? null : new Date(date.getTime());
        }
        if (record.getType(i) == 3) {
            return Time.valueOf(record.getString(i));
        }
        if (record.getType(i) == 10 || record.getType(i) == 9) {
            return new Short((short)record.getInt(i));
        }
        return record.getValue(i);
    }

    static JCO.Record newRecord(JcoBaseTypeDescriptor descriptor, int encoding) {
        Object record = null;
        try {
            record = descriptor.getXsdlType() == 5 ? new JCO.ParameterList(descriptor.getJcoMetaData(encoding)) : new JCO.Structure(descriptor.getJcoMetaData(encoding));
        }
        catch (JCO.Exception e) {
            throw new DataAccessException("Failed to create JCo data container for " + descriptor.getJavaClass().toString(), (Throwable)e);
        }
        return record;
    }

    static JCO.Record newRecord(JcoBaseTypeDescriptor descriptor) {
        return JcoMarshaler.newRecord(descriptor, 1);
    }

    static JCO.Table marshalList(XsdlElementProperties properties, AbstractList data, int encoding) {
        JCO.Table jcoTable = null;
        if (data != null) {
            BaseList baseList = data.baseList();
            if (baseList instanceof JcoBaseList) {
                jcoTable = ((JcoBaseList)baseList).marshal(encoding);
            } else {
                JcoBaseTypeDescriptor descriptor = (JcoBaseTypeDescriptor)properties.getDescriptor();
                JcoTable newTable = null;
                if (descriptor != null) {
                    newTable = new JcoTable(descriptor.getJcoMetaData(encoding));
                    newTable.appendRows(data.size());
                    int i = 0;
                    while (i < data.size()) {
                        JCO.Structure jcoRecord = (JCO.Structure)JcoMarshaler.marshalRecord(descriptor, (BaseType)data.get(i), encoding);
                        newTable.copyRawData((JCO.Record)jcoRecord);
                        ++i;
                    }
                } else {
                    newTable = new JcoTable(descriptor.getJcoMetaData(encoding));
                    newTable.appendRows(data.size());
                    int i = 0;
                    while (i < data.size()) {
                        Object el = data.get(i);
                        newTable.setRow(i);
                        if (el != null) {
                            newTable.setValue(el, 0);
                        }
                        ++i;
                    }
                }
                jcoTable = newTable;
            }
        }
        return jcoTable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void marshalRecord(JCO.Record dest, BaseType source, int encoding) {
        BaseTypeData sourceData = ((AbstractType)source).baseTypeData();
        boolean checkMandatoryParams = dest instanceof JCO.Request;
        int i = 0;
        while (i < dest.getFieldCount()) {
            boolean hasElementValue = sourceData.hasElementValue(i);
            if (checkMandatoryParams && (dest.getFlags(i) & 4) == 0 && !hasElementValue) {
                throw new DataAccessException("Mandatory parameter " + dest.getName(i) + " of method " + dest.getName() + " missing");
            }
            int type = dest.getType(i);
            if (type == 1 || type == 3) {
                String value = sourceData.getElementValueAsString(i);
                if (value != null) {
                    dest.setValue(value, i);
                }
            } else if (type == 2) {
                BigDecimal value = sourceData.getElementValueAsBigDecimal(i);
                if (value != null) {
                    dest.setValue((Object)value, i);
                }
            } else if (type == 7) {
                double value = sourceData.getElementValueAsDouble(i);
                if (value != 0.0 || hasElementValue) {
                    dest.setValue(value, i);
                }
            } else if (type == 8 || type == 10 || type == 9) {
                int value = sourceData.getElementValueAsInt(i);
                if (value != 0 || hasElementValue) {
                    dest.setValue(value, i);
                }
            } else if (type == 4 || type == 30) {
                byte[] value = sourceData.getElementValueAsByteArray(i);
                if (value != null) {
                    dest.setValue(value, i);
                }
            } else if (type == 99) {
                Object value = sourceData.getElementValue(i);
                if (value != null) {
                    XsdlElementProperties elProperties = ((AbstractType)source).baseTypeDescriptor.getElementProperties(i);
                    JCO.Table nestedTable = null;
                    if (!(value instanceof AbstractList)) {
                        throw new DataAccessException("Data conversion error, field " + dest.getName(i) + ", complex type " + elProperties.getJavaClass().toString() + ", expected list type");
                    }
                    nestedTable = JcoMarshaler.marshalList(elProperties, (AbstractList)value, encoding);
                    dest.setValue(nestedTable, i);
                }
            } else if (type == 17) {
                Object value = sourceData.getElementValue(i);
                if (value != null) {
                    BaseTypeDescriptor elDescriptor = ((AbstractType)source).baseTypeDescriptor.getElementProperties(i).getDescriptor();
                    if (!(value instanceof BaseType)) throw new DataAccessException("Data conversion error, field " + dest.getName(i) + ", complex type " + elDescriptor.getJavaClass().toString() + ", expected structure type");
                    JCO.Structure nestedStruct = (JCO.Structure)JcoMarshaler.marshalRecord(elDescriptor, (BaseType)value, encoding);
                    dest.setValue(nestedStruct, i);
                }
            } else {
                Object value = sourceData.getElementValue(i);
                if (value != null) {
                    dest.setValue(value, i);
                }
            }
            ++i;
        }
    }

    static JCO.Record marshalRecord(BaseTypeDescriptor descriptor, BaseType data, int encoding) {
        JCO.Record jcoRecord = null;
        if (data != null) {
            BaseTypeData baseTypeData = ((AbstractType)data).baseTypeData();
            if (baseTypeData instanceof JcoBaseTypeData) {
                return ((JcoBaseTypeData)baseTypeData).marshal(encoding);
            }
            jcoRecord = JcoMarshaler.newRecord((JcoBaseTypeDescriptor)descriptor, encoding);
            JcoMarshaler.marshalRecord(jcoRecord, data, encoding);
        }
        return jcoRecord;
    }

    static AbstractList unmarshalList(XsdlElementProperties properties, JCO.Table data) {
        if (data != null) {
            try {
                AbstractList el = (AbstractList)properties.getJavaClass().newInstance();
                el.baseList(new JcoBaseList(el.properties, data));
                return el;
            }
            catch (Exception e) {
                throw new DataAccessException("Failed to instantiate proxy instance " + properties.getJavaClass().toString(), (Throwable)e);
            }
        }
        return null;
    }

    static AbstractType unmarshalRecord(BaseTypeDescriptor descriptor, JCO.Record data) {
        if (data != null) {
            try {
                JcoBaseTypeData baseTypeData = new JcoBaseTypeData(descriptor, data);
                AbstractType el = (AbstractType)descriptor.getJavaClass().newInstance();
                el.baseTypeData(baseTypeData);
                return el;
            }
            catch (IllegalAccessException e) {
                throw new DataAccessException("Failed to instantiate proxy instance " + descriptor.getJavaClass().toString(), (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new DataAccessException("Failed to instantiate proxy instance " + descriptor.getJavaClass().toString(), (Throwable)e);
            }
        }
        return null;
    }

    static AbstractType unmarshalRecord(BaseType responseType, JCO.Record data) {
        if (data != null) {
            BaseTypeDescriptor descriptor = ((AbstractType)responseType).baseTypeDescriptor;
            JcoBaseTypeData baseTypeData = new JcoBaseTypeData(descriptor, data);
            ((AbstractType)responseType).baseTypeData(baseTypeData);
            return (AbstractType)responseType;
        }
        return null;
    }

    static JCO.Request marshalRequest(String functionName, BaseType request, BaseType response, BaseTypeDescriptor faultMessageDesc, int encoding) throws JcoProxyException {
        JCO.AbapException[] abapExceptions;
        JcoRequest jcoRequest = null;
        if (((AbstractType)request).baseTypeDescriptor instanceof JcoBaseTypeDescriptor && ((AbstractType)response).baseTypeDescriptor instanceof JcoBaseTypeDescriptor) {
            abapExceptions = null;
            if (faultMessageDesc != null) {
                try {
                    XsdlTypeRestrictions restrictions;
                    int idx = faultMessageDesc.getElementIndex("Name");
                    if (idx > -1 && (restrictions = faultMessageDesc.getElementProperties(idx).getRestrictions()) != null) {
                        Set exceptions = restrictions.getEnumeration();
                        abapExceptions = new JCO.AbapException[exceptions.size()];
                        Iterator iter = exceptions.iterator();
                        int i = 0;
                        while (iter.hasNext()) {
                            abapExceptions[i++] = new JCO.AbapException((String)iter.next());
                        }
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        } else {
            throw new JcoProxyException("Marshal exception: Invalid metadata for request or response message: " + functionName);
        }
        jcoRequest = new JcoRequest(functionName, ((JcoBaseTypeDescriptor)((AbstractType)request).baseTypeDescriptor).getJcoMetaData(encoding), ((JcoBaseTypeDescriptor)((AbstractType)response).baseTypeDescriptor).getJcoMetaData(encoding), abapExceptions);
        JcoMarshaler.marshalRecord((JCO.Record)jcoRequest, request, encoding);
        return jcoRequest;
    }

    static ApplicationFaultException unmarshalException(JCO.Exception jcoEx, BaseProxyDescriptor proxyDesc, BaseTypeDescriptor faultMessageDesc) throws ApplicationFaultException, JcoProxyException {
        if (jcoEx.getGroup() == 102) {
            throw new JcoProxyException(jcoEx.getMessage() + ", error key: " + jcoEx.getKey(), (Throwable)jcoEx);
        }
        if (jcoEx.getGroup() == 105 || jcoEx.getGroup() == 126 || jcoEx instanceof JCO.AbapException) {
            if (faultMessageDesc != null) {
                ApplicationFaultException appEx = null;
                try {
                    AbstractType appFault = (AbstractType)faultMessageDesc.getJavaClass().newInstance();
                    AbstractType message = (AbstractType)faultMessageDesc.getElementProperties(faultMessageDesc.getElementIndex("Message")).getDescriptor().getJavaClass().newInstance();
                    if (appFault.generationInfo.getVersion().equals("1.0")) {
                        appFault.baseTypeData().setElementValue(faultMessageDesc.getElementIndex("Name"), jcoEx.getKey());
                    } else {
                        Class nameTypeClass = faultMessageDesc.getElementProperties(faultMessageDesc.getElementIndex("Name")).getJavaClass();
                        Method nameTypeMethod = nameTypeClass.getMethod("fromString", class$java$lang$String == null ? (class$java$lang$String = JcoMarshaler.class$("java.lang.String")) : class$java$lang$String);
                        Object nameType = nameTypeMethod.invoke((Object)nameTypeClass, (Object[])new String[]{jcoEx.getKey()});
                        appFault.baseTypeData().setElementValue(faultMessageDesc.getElementIndex("Name"), nameType);
                    }
                    appFault.baseTypeData().setElementValue(faultMessageDesc.getElementIndex("Text"), jcoEx.getLocalizedMessage());
                    appFault.baseTypeData().setElementValue(faultMessageDesc.getElementIndex("Message"), message);
                    String appExClassName = ((JcoBaseProxyDescriptor)proxyDesc).getResultTypeAsString(faultMessageDesc.getWsdlName().getResolvedName());
                    ClassLoader classLoader = ((JcoBaseProxyDescriptor)proxyDesc).getClassLoader();
                    Class<?> appExClass = classLoader == null ? Class.forName(appExClassName) : Class.forName(appExClassName, true, classLoader);
                    appEx = (ApplicationFaultException)((Object)appExClass.newInstance());
                    appEx.fault = appFault;
                    appEx.setRootCause(jcoEx);
                }
                catch (Exception e) {
                    throw new JcoProxyException("Application exception raised in the R/3 system: " + jcoEx.getMessage() + " . Could not create application fault message: " + e.getMessage(), (Throwable)jcoEx);
                }
                throw appEx;
            }
            throw new JcoProxyException("Unknown application exception raised in the R/3 system: " + jcoEx.getMessage(), (Throwable)jcoEx);
        }
        throw new JcoProxyException(jcoEx.getMessage() + ", error key: " + jcoEx.getKey(), (Throwable)jcoEx);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

