/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.framework.core;

import com.sap.aii.proxy.framework.core.AbstractList;
import com.sap.aii.proxy.framework.core.AttributeMetaData;
import com.sap.aii.proxy.framework.core.BaseType;
import com.sap.aii.proxy.framework.core.BaseTypeData;
import com.sap.aii.proxy.framework.core.BaseTypeDataFactory;
import com.sap.aii.proxy.framework.core.BaseTypeDescriptor;
import com.sap.aii.proxy.framework.core.BaseTypeDescriptorFactory;
import com.sap.aii.proxy.framework.core.DataSet;
import com.sap.aii.proxy.framework.core.Descriptor;
import com.sap.aii.proxy.framework.core.ElementMetaData;
import com.sap.aii.proxy.framework.core.EnumerationType;
import com.sap.aii.proxy.framework.core.GenerationInfo;
import com.sap.aii.proxy.framework.core.JcoBaseTypeDescriptor;
import com.sap.aii.proxy.framework.core.JcoBaseTypeMetaData;
import com.sap.aii.proxy.framework.core.XmlAnyAttribute;
import com.sap.aii.proxy.framework.core.XmlBaseTypeDescriptor;
import com.sap.aii.proxy.framework.core.XmlBaseTypeMetaData;
import com.sap.aii.proxy.framework.core.XmlParser;
import com.sap.aii.proxy.framework.core.XmlRenderer;
import com.sap.aii.proxy.framework.core.XmlUtils;
import com.sap.aii.proxy.framework.core.XsdlAttributeProperties;
import com.sap.aii.proxy.framework.core.XsdlElementProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;

public abstract class AbstractType
implements BaseType,
Serializable {
    private static final long serialVersionUID = 2009092002L;
    private static final String DEFAULT_PREFIX = "ns";
    private BaseTypeData baseTypeData = null;
    protected BaseTypeDescriptor baseTypeDescriptor = null;
    protected GenerationInfo generationInfo = null;
    private int connectionType = 0;

    protected AbstractType(BaseTypeDescriptor baseTypeDescriptor, int connectionType) {
        this.baseTypeDescriptor = baseTypeDescriptor;
        this.connectionType = connectionType;
    }

    protected AbstractType(BaseTypeDescriptor baseTypeDescriptor, GenerationInfo generationInfo, int connectionType) {
        this.baseTypeDescriptor = baseTypeDescriptor;
        this.generationInfo = generationInfo;
        this.connectionType = connectionType;
    }

    protected final BaseTypeData baseTypeData() {
        if (this.baseTypeData == null) {
            this.baseTypeData = BaseTypeDataFactory.createNewBaseTypeData(this.baseTypeDescriptor, this.connectionType);
        }
        return this.baseTypeData;
    }

    protected final void baseTypeData(BaseTypeData baseTypeData) {
        this.baseTypeData = baseTypeData;
    }

    protected final BaseTypeMetaData baseTypeMetaData() {
        return BaseTypeMetaDataFactory.createNewBaseTypeMetaData(this.baseTypeDescriptor, this.connectionType);
    }

    public final DataSet dataSet() {
        return (DataSet)((Object)this.baseTypeData());
    }

    public final Descriptor descriptor() {
        return (Descriptor)((Object)this.baseTypeDescriptor);
    }

    public final GenerationInfo generationInfo() {
        return this.generationInfo;
    }

    public final void fromXml(String xmlDocument) {
        if (xmlDocument == null) {
            return;
        }
        if (this.baseTypeData != null) {
            this.baseTypeData(null);
        }
        XmlParser parser = new XmlParser();
        parser.parseDocument(xmlDocument, this);
    }

    public void fromXml(InputStream xmlStream) {
        if (xmlStream == null) {
            return;
        }
        if (this.baseTypeData != null) {
            this.baseTypeData(null);
        }
        XmlParser parser = new XmlParser();
        parser.parseStream(xmlStream, this);
    }

    public final String toXml() {
        return this.toXml(null, null);
    }

    public final String toXml(String tagName) {
        return this.toXml(tagName, null);
    }

    public final String toXml(String tagName, String namespace) {
        Stack namespaces = new Stack();
        Hashtable prefixes = new Hashtable();
        return this.toXml(tagName, namespace, namespaces, prefixes);
    }

    public final void toXml(String tagName, String namespace, OutputStream xmlStream) {
        if (xmlStream == null) {
            return;
        }
        String rendition = this.toXml(tagName, namespace);
        if (rendition == null) {
            return;
        }
        String _methodName = "toXml(...)";
        byte[] byteArray = rendition.getBytes();
        try {
            xmlStream.write(byteArray);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    protected static final BaseTypeDescriptor createNewBaseTypeDescriptor(int xsdlType, String namespace, String localname, int numberOfElements, int numberOfAttributes, Class javaClass, int connectionType, int byteLength1, int byteLength2) {
        return BaseTypeDescriptorFactory.createNewBaseTypeDescriptor(xsdlType, namespace, localname, numberOfElements, numberOfAttributes, javaClass, connectionType, null, byteLength1, byteLength2, -1, null);
    }

    protected static final BaseTypeDescriptor createNewBaseTypeDescriptor(int xsdlType, String namespace, String localname, int numberOfElements, int numberOfAttributes, Class javaClass, int connectionType, int byteLength1, int byteLength2, int byteLength4) {
        return BaseTypeDescriptorFactory.createNewBaseTypeDescriptor(xsdlType, namespace, localname, numberOfElements, numberOfAttributes, javaClass, connectionType, null, byteLength1, byteLength2, byteLength4, null);
    }

    protected static final BaseTypeDescriptor createNewBaseTypeDescriptor(int xsdlType, String namespace, String localname, int numberOfElements, int numberOfAttributes, Class javaClass, int connectionType, String abapName, int byteLength1, int byteLength2, int byteLength4) {
        return BaseTypeDescriptorFactory.createNewBaseTypeDescriptor(xsdlType, namespace, localname, numberOfElements, numberOfAttributes, javaClass, connectionType, abapName, byteLength1, byteLength2, byteLength4, null);
    }

    protected static final BaseTypeDescriptor createNewBaseTypeDescriptor(int xsdlType, String namespace, String localname, int numberOfElements, int numberOfAttributes, Class javaClass, int connectionType, String abapName, int byteLength1, int byteLength2, int byteLength4, String metadataXml) {
        return BaseTypeDescriptorFactory.createNewBaseTypeDescriptor(xsdlType, namespace, localname, numberOfElements, numberOfAttributes, javaClass, connectionType, abapName, byteLength1, byteLength2, byteLength4, metadataXml);
    }

    protected static final void descriptorSetAttributeProperties(BaseTypeDescriptor baseTypeDescriptor, int i, String name, Object defaultValue, Object fixedValue, String form, String xmlType, String namespace, String use, String javaName, Class javaType, AbstractType attribute, String[][] restrictions) {
        BaseTypeDescriptor attributeDescriptor;
        BaseTypeDescriptor baseTypeDescriptor2 = attributeDescriptor = attribute == null ? null : attribute.baseTypeDescriptor;
        if (!(baseTypeDescriptor instanceof XmlBaseTypeDescriptor)) {
            throw new UnsupportedOperationException("Attributes are not supported in JCo interfaces");
        }
        ((XmlBaseTypeDescriptor)baseTypeDescriptor).setAttributeProperties(i, name, defaultValue, fixedValue, form, xmlType, namespace, use, javaName, javaType, attributeDescriptor, restrictions);
    }

    protected static final void descriptorSetElementProperties(BaseTypeDescriptor baseTypeDescriptor, int i, String name, Object defaultValue, Object fixedValue, String form, String xmlType, String namespace, boolean isAbstract, int minOccurs, int maxOccurs, boolean isNillable, String substitutionGroup, String javaName, Class javaType, AbstractType element, String[][] restrictions, int offset1, int offset2, int byteLength1, int byteLength2, int internalType, int flags) {
        BaseTypeDescriptor elementDescriptor;
        BaseTypeDescriptor baseTypeDescriptor2 = elementDescriptor = element == null ? null : element.baseTypeDescriptor;
        if (baseTypeDescriptor instanceof XmlBaseTypeDescriptor) {
            ((XmlBaseTypeDescriptor)baseTypeDescriptor).setElementProperties(i, name, defaultValue, fixedValue, form, xmlType, namespace, isAbstract, minOccurs, maxOccurs, isNillable, substitutionGroup, javaName, javaType, elementDescriptor, restrictions, null);
        } else {
            ((JcoBaseTypeDescriptor)baseTypeDescriptor).setElementProperties(i, name, defaultValue, fixedValue, form, xmlType, namespace, isAbstract, minOccurs, maxOccurs, isNillable, substitutionGroup, javaName, javaType, elementDescriptor, restrictions, null, offset1, offset2, -1, byteLength1, byteLength2, -1, internalType, flags, null);
        }
    }

    protected static final void descriptorSetElementProperties(BaseTypeDescriptor baseTypeDescriptor, int i, String name, Object defaultValue, Object fixedValue, String form, String xmlType, String namespace, boolean isAbstract, int minOccurs, int maxOccurs, boolean isNillable, String substitutionGroup, String javaName, Class javaType, AbstractType element, String[][] restrictions, int offset1, int offset2, int offset4, int byteLength1, int byteLength2, int byteLength4, int internalType, int flags) {
        BaseTypeDescriptor elementDescriptor;
        BaseTypeDescriptor baseTypeDescriptor2 = elementDescriptor = element == null ? null : element.baseTypeDescriptor;
        if (baseTypeDescriptor instanceof XmlBaseTypeDescriptor) {
            ((XmlBaseTypeDescriptor)baseTypeDescriptor).setElementProperties(i, name, defaultValue, fixedValue, form, xmlType, namespace, isAbstract, minOccurs, maxOccurs, isNillable, substitutionGroup, javaName, javaType, elementDescriptor, restrictions, null);
        } else {
            ((JcoBaseTypeDescriptor)baseTypeDescriptor).setElementProperties(i, name, defaultValue, fixedValue, form, xmlType, namespace, isAbstract, minOccurs, maxOccurs, isNillable, substitutionGroup, javaName, javaType, elementDescriptor, restrictions, null, offset1, offset2, -1, byteLength1, byteLength2, -1, internalType, flags, null);
        }
    }

    protected static final void descriptorSetElementProperties(BaseTypeDescriptor baseTypeDescriptor, int i, String name, Object defaultValue, Object fixedValue, String form, String xmlType, String namespace, boolean isAbstract, int minOccurs, int maxOccurs, boolean isNillable, String substitutionGroup, String javaName, Class javaType, AbstractType element, String[][] restrictions, String abapName, int offset1, int offset2, int offset4, int byteLength1, int byteLength2, int byteLength4, int internalType, int flags) {
        BaseTypeDescriptor elementDescriptor;
        BaseTypeDescriptor baseTypeDescriptor2 = elementDescriptor = element == null ? null : element.baseTypeDescriptor;
        if (baseTypeDescriptor instanceof XmlBaseTypeDescriptor) {
            ((XmlBaseTypeDescriptor)baseTypeDescriptor).setElementProperties(i, name, defaultValue, fixedValue, form, xmlType, namespace, isAbstract, minOccurs, maxOccurs, isNillable, substitutionGroup, javaName, javaType, elementDescriptor, restrictions, null);
        } else {
            ((JcoBaseTypeDescriptor)baseTypeDescriptor).setElementProperties(i, name, defaultValue, fixedValue, form, xmlType, namespace, isAbstract, minOccurs, maxOccurs, isNillable, substitutionGroup, javaName, javaType, elementDescriptor, restrictions, abapName, offset1, offset2, offset4, byteLength1, byteLength2, byteLength4, internalType, flags, null);
        }
    }

    protected static final void descriptorSetElementProperties(BaseTypeDescriptor baseTypeDescriptor, int i, String name, Object defaultValue, Object fixedValue, String form, String xmlType, String namespace, boolean isAbstract, int minOccurs, int maxOccurs, boolean isNillable, String substitutionGroup, String javaName, Class javaType, AbstractType element, String[][] restrictions, String abapName, int offset1, int offset2, int offset4, int byteLength1, int byteLength2, int byteLength4, int internalType, int flags, String metadataXml) {
        BaseTypeDescriptor elementDescriptor;
        BaseTypeDescriptor baseTypeDescriptor2 = elementDescriptor = element == null ? null : element.baseTypeDescriptor;
        if (baseTypeDescriptor instanceof XmlBaseTypeDescriptor) {
            ((XmlBaseTypeDescriptor)baseTypeDescriptor).setElementProperties(i, name, defaultValue, fixedValue, form, xmlType, namespace, isAbstract, minOccurs, maxOccurs, isNillable, substitutionGroup, javaName, javaType, elementDescriptor, restrictions, metadataXml);
        } else {
            ((JcoBaseTypeDescriptor)baseTypeDescriptor).setElementProperties(i, name, defaultValue, fixedValue, form, xmlType, namespace, isAbstract, minOccurs, maxOccurs, isNillable, substitutionGroup, javaName, javaType, elementDescriptor, restrictions, abapName, offset1, offset2, offset4, byteLength1, byteLength2, byteLength4, internalType, flags, metadataXml);
        }
    }

    private final PrefixedNamespace prefixedNamespace(String namespace, Stack namespaces, Hashtable prefixes) {
        PrefixedNamespace prefixedNamespace = new PrefixedNamespace();
        if (namespace == null) {
            return prefixedNamespace;
        }
        if (namespaces.empty()) {
            if (!prefixes.isEmpty()) {
                prefixes.clear();
            }
            prefixedNamespace.prefix = DEFAULT_PREFIX;
            prefixedNamespace.namespace = namespace;
            prefixes.put(namespace, prefixedNamespace.prefix);
        } else if (!prefixes.containsKey(namespace)) {
            prefixedNamespace.prefix = DEFAULT_PREFIX + prefixes.size();
            prefixedNamespace.namespace = namespace;
            prefixes.put(namespace, prefixedNamespace.prefix);
        } else {
            prefixedNamespace.prefix = (String)prefixes.get(namespace);
        }
        return prefixedNamespace;
    }

    private final XmlAnyAttribute[] attributes(Stack namespaces, Hashtable prefixes) {
        int count = this.baseTypeDescriptor.getAttributeCount();
        XmlAnyAttribute[] attributes = new XmlAnyAttribute[count];
        int i = 0;
        while (i < count) {
            XsdlAttributeProperties props = this.baseTypeDescriptor.getAttributeProperties(i);
            String name = props.getName();
            Object value = this.baseTypeData == null ? null : this.baseTypeData.getAttributeValue(i);
            String valueString = null;
            if (value != null) {
                if (value instanceof AbstractType) {
                    value = ((AbstractType)value).baseTypeData.getElementValue(0);
                    valueString = XmlUtils.valueAsString(value, props);
                } else {
                    valueString = value instanceof EnumerationType ? XmlUtils.valueAsString(value.toString(), props) : XmlUtils.valueAsString(value, props);
                }
            }
            if (valueString == null && !props.isOptional()) {
                Class javaClass = props.getJavaClass();
                if (XmlUtils.isJavaType(javaClass)) {
                    Object valueObject = XmlUtils.getInstance(javaClass, null, props);
                    valueString = valueObject == null ? null : valueObject.toString();
                } else if (XmlUtils.isEnumerationType(javaClass)) {
                    throw EnumerationType.createIllegalArgumentException(name, "<null>");
                }
            }
            if (valueString != null) {
                String namespace = null;
                PrefixedNamespace prefixedNamespace = this.prefixedNamespace(namespace, namespaces, prefixes);
                attributes[i] = new XmlAnyAttribute(prefixedNamespace.prefix, prefixedNamespace.namespace, name, valueString);
            }
            ++i;
        }
        return attributes;
    }

    private final String toXml(String tagName, String namespace, Stack namespaces, Hashtable prefixes) {
        PrefixedNamespace current = this.prefixedNamespace(namespace, namespaces, prefixes);
        String currentPrefix = current.prefix;
        String currentNamespace = current.namespace;
        XmlAnyAttribute[] attributes = this.attributes(namespaces, prefixes);
        StringBuffer buffer = new StringBuffer();
        int xsdlType = this.baseTypeDescriptor.getXsdlType();
        if (xsdlType == 3 || xsdlType == 5) {
            tagName = null;
        }
        if (this.baseTypeDescriptor.getElementCount() == 0) {
            buffer.append(XmlRenderer.getEmptyTag(tagName, attributes, prefixes));
        } else {
            if (tagName != null) {
                namespaces.push(current);
                buffer.append(XmlRenderer.getStartTag(currentPrefix, tagName, currentNamespace, attributes, prefixes));
            }
            buffer.append(this.renderElements(namespaces, prefixes));
            if (tagName != null) {
                buffer.append(XmlRenderer.getEndTag(currentPrefix, tagName));
                current = (PrefixedNamespace)namespaces.pop();
                if (current != null && current.namespace != null) {
                    prefixes.remove(current.namespace);
                }
            }
        }
        if (namespaces.empty() && !prefixes.isEmpty()) {
            prefixes.clear();
        }
        return new String(buffer);
    }

    private final String renderElements(Stack namespaces, Hashtable prefixes) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.baseTypeDescriptor.getElementCount()) {
            String namespace;
            XsdlElementProperties props = this.baseTypeDescriptor.getElementProperties(i);
            String elementName = props.getName();
            String form = props.getForm();
            String string = namespace = form != null && form.equals("qualified") ? props.getNamespace() : null;
            if (this.baseTypeData != null) {
                Object value = this.baseTypeData.getElementValue(i);
                if (value instanceof AbstractType) {
                    switch (this.baseTypeDescriptor.getXsdlType()) {
                        case 1: {
                            String typeName = props.getJavaClass().getName();
                            typeName = typeName.substring(typeName.lastIndexOf(46) + 1);
                            buffer.append(((AbstractType)value).renderSimpleType(elementName, typeName, namespace, namespaces, prefixes));
                            break;
                        }
                        default: {
                            buffer.append(((AbstractType)value).toXml(elementName, namespace, namespaces, prefixes));
                            break;
                        }
                    }
                } else if (value instanceof AbstractList) {
                    String currentNamespace = namespace != null ? namespace : (form != null && form.equals("qualified") ? (namespaces.empty() ? null : ((PrefixedNamespace)namespaces.peek()).namespace) : null);
                    Iterator iterator = ((AbstractList)value).iterator();
                    if (iterator != null) {
                        boolean isJcoTable = ((AbstractList)value).isRfcList() && iterator.hasNext();
                        XsdlElementProperties recordProps = isJcoTable ? ((AbstractList)value).properties : null;
                        String elementNameSave = elementName;
                        String currentNamespaceSave = currentNamespace;
                        if (isJcoTable) {
                            buffer.append(XmlRenderer.getStartTag(elementName));
                            elementName = "item";
                            currentNamespace = null;
                        }
                        while (iterator.hasNext()) {
                            Object record = iterator.next();
                            if (record instanceof AbstractType) {
                                buffer.append(((AbstractType)record).toXml(elementName, currentNamespace, namespaces, prefixes));
                                continue;
                            }
                            if (record instanceof EnumerationType) {
                                buffer.append(this.renderValue(elementName, namespace, record.toString(), null, namespaces, prefixes));
                                continue;
                            }
                            if (isJcoTable) {
                                buffer.append(this.renderValue(elementName, namespace, record, recordProps, namespaces, prefixes));
                                continue;
                            }
                            buffer.append(this.renderElement(elementName, namespace, record, namespaces, prefixes));
                        }
                        if (isJcoTable) {
                            currentNamespace = currentNamespaceSave;
                            elementName = elementNameSave;
                            buffer.append(XmlRenderer.getEndTag(elementName));
                        }
                    }
                } else if (value instanceof EnumerationType) {
                    buffer.append(this.renderValue(elementName, namespace, value.toString(), null, namespaces, prefixes));
                } else if (elementName != null) {
                    buffer.append(this.renderElement(elementName, namespace, value, namespaces, prefixes));
                } else if (value != null) {
                    buffer.append(XmlRenderer.getXmlString(value.toString()));
                }
            }
            ++i;
        }
        return new String(buffer);
    }

    private final String renderSimpleType(String elementName, String typeName, String namespace, Stack namespaces, Hashtable prefixes) {
        PrefixedNamespace current = this.prefixedNamespace(namespace, namespaces, prefixes);
        String currentPrefix = current.prefix;
        String currentNamespace = current.namespace;
        StringBuffer buffer = new StringBuffer();
        int index = this.baseTypeDescriptor.getElementIndex(typeName);
        XsdlElementProperties props = this.baseTypeDescriptor.getElementProperties(index);
        Object value = this.baseTypeData.getElementValue(index);
        if (value instanceof AbstractType) {
            switch (this.baseTypeDescriptor.getXsdlType()) {
                case 1: {
                    String simpleTypeName = props.getJavaClass().getName();
                    simpleTypeName = simpleTypeName.substring(simpleTypeName.lastIndexOf(46) + 1);
                    buffer.append(((AbstractType)value).renderSimpleType(elementName, simpleTypeName, currentNamespace, namespaces, prefixes));
                    break;
                }
                default: {
                    throw new RuntimeException("Type mismatch when rendering: " + elementName + " is not of simpleType");
                }
            }
        } else if (value instanceof EnumerationType) {
            buffer.append(this.renderValue(elementName, currentNamespace, value.toString(), null, namespaces, prefixes));
        } else if (elementName != null) {
            buffer.append(this.renderElement(elementName, currentNamespace, value, namespaces, prefixes));
        } else if (value != null) {
            buffer.append(XmlRenderer.getXmlString(value.toString()));
        }
        return new String(buffer);
    }

    private final String renderElement(String elementName, String namespace, Object value, Stack namespaces, Hashtable prefixes) {
        int index = this.baseTypeDescriptor.getElementIndex(elementName);
        XsdlElementProperties props = null;
        props = index < 0 ? null : this.baseTypeDescriptor.getElementProperties(index);
        return this.renderValue(elementName, namespace, value, props, namespaces, prefixes);
    }

    private final String renderValue(String elementName, String namespace, Object value, XsdlElementProperties props, Stack namespaces, Hashtable prefixes) {
        PrefixedNamespace current = this.prefixedNamespace(namespace, namespaces, prefixes);
        String currentPrefix = current.prefix;
        String currentNamespace = current.namespace;
        XmlAnyAttribute[] attributes = null;
        StringBuffer buffer = new StringBuffer();
        String valueString = XmlUtils.valueAsString(value, props);
        if (valueString == null && props != null) {
            if (!props.isOptional()) {
                Class javaClass = props.getJavaClass();
                if (XmlUtils.isJavaType(javaClass)) {
                    Object valueObject = XmlUtils.getInstance(javaClass, null, props);
                    valueString = valueObject == null ? null : valueObject.toString();
                } else if (XmlUtils.isEnumerationType(javaClass)) {
                    throw EnumerationType.createIllegalArgumentException(elementName, "<null>");
                }
            } else if (props.isNillable()) {
                attributes = new XmlAnyAttribute[]{new XmlAnyAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "nil", "true")};
                buffer.append(XmlRenderer.getEmptyTag(elementName, attributes, prefixes));
            }
        }
        if (valueString != null) {
            buffer.append(XmlRenderer.getStartTag(currentPrefix, elementName, currentNamespace, attributes, prefixes));
            buffer.append(XmlRenderer.getXmlString(valueString));
            buffer.append(XmlRenderer.getEndTag(currentPrefix, elementName));
        }
        return new String(buffer);
    }

    public static interface BaseTypeMetaData {
        public AttributeMetaData getAttribute(int var1);

        public ElementMetaData getElement(int var1);
    }

    private static final class BaseTypeMetaDataFactory {
        private BaseTypeMetaDataFactory() {
        }

        static BaseTypeMetaData createNewBaseTypeMetaData(BaseTypeDescriptor baseTypeDescriptor, int connectionType) {
            com.sap.aii.proxy.framework.core.BaseTypeMetaData baseTypeMetaData = null;
            switch (connectionType) {
                case 1: {
                    baseTypeMetaData = new JcoBaseTypeMetaData(baseTypeDescriptor);
                    break;
                }
                case 2: {
                    baseTypeMetaData = new XmlBaseTypeMetaData(baseTypeDescriptor);
                    break;
                }
                default: {
                    throw new RuntimeException("Implementation of BaseTypeMetaData missing");
                }
            }
            return baseTypeMetaData;
        }
    }

    private static final class PrefixedNamespace {
        private String prefix = null;
        private String namespace = null;
    }
}

