/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.jdbc.impl;

import com.sap.ip.bi.sdk.dac.connector.IBIRelational;
import com.sap.ip.bi.sdk.dac.connector.impl.BIMDRPersistence;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.relational.MetaStore;
import com.sap.ip.bi.sdk.dac.connector.relational.RelationalMDRConnection;
import com.sap.ip.bi.sdk.dac.connector.relational.RelationalPersistenceMetaData;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.CatalogObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.ColumnObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.GenericSchemaObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.SchemaObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.TableObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.TableType;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.BIStringMatcher;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.ip.bi.sdk.util.impl.ServerRTCounter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class JdbcMDRConnection
extends RelationalMDRConnection
implements RelationalPersistenceMetaData {
    ServerRTCounter serverRTCounter = ServerRTCounter.getInstance();
    private static final boolean tracePrivateMethods = false;
    private static final Location loggingLoc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$JdbcMDRConnection == null ? (class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$JdbcMDRConnection = JdbcMDRConnection.class$("com.sap.ip.bi.sdk.dac.connector.jdbc.impl.JdbcMDRConnection")) : class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$JdbcMDRConnection).getName());
    private static final Category loggingCat = BILoggingSetup.METADATA.getCategory();
    private IBIMonitor monitor = null;
    private MetaStore metaStore = new MetaStore();
    private DatabaseMetaData jdbcMeta = null;
    private List tableTypes = null;
    static final String TABLE_CAT = "TABLE_CAT";
    static final String TABLE_SCHEM = "TABLE_SCHEM";
    static final String TABLE_NAME = "TABLE_NAME";
    static final String TABLE_TYPE = "TABLE_TYPE";
    private static final String REMARKS = "REMARKS";
    private static final String TYPE_CAT = "TYPE_CAT";
    private static final String TYPE_SCHEM = "TYPE_SCHEM";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String SELF_REFERENCING_COL_NAME = "SELF_REFERENCING_COL_NAME";
    private static final String REF_GENERATION = "REF_GENERATION";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String COLUMN_SIZE = "COLUMN_SIZE";
    private static final String BUFFER_LENGTH = "BUFFER_LENGTH";
    private static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    private static final String NUM_PREC_RADIX = "NUM_PREC_RADIX";
    private static final String NULLABLE = "NULLABLE";
    private static final String COLUMN_DEF = "COLUMN_DEF";
    private static final String SQL_DATA_TYPE = "SQL_DATA_TYPE";
    private static final String SQL_DATETIME_SUB = "SQL_DATETIME_SUB";
    private static final String CHAR_OCTET_LENGTH = "CHAR_OCTET_LENGTH";
    private static final String ORDINAL_POSITION = "ORDINAL_POSITION";
    private static final String IS_NULLABLE = "IS_NULLABLE";
    private static final String SCOPE_CATALOG = "SCOPE_CATLOG";
    private static final String SCOPE_SCHEMA = "SCOPE_SCHEMA";
    private static final String SCOPE_TABLE = "SCOPE_TABLE";
    private static final String SOURCE_DATA_TYPE = "SOURCE_DATA_TYPE";
    private static final String ANY = "*";
    private boolean assertCatalogSchemaAssocLoaded = false;
    private boolean assertCatalogsLoaded = false;
    private boolean assertColumnsLoaded = false;
    private boolean assertFindTable = false;
    private boolean assertMetaDataLoaded = false;
    private boolean assertSchemasLoaded = false;
    private boolean assertSchemasLoaded_Catalog = false;
    private boolean assertSchemaTableAssocLoaded = false;
    private boolean assertTableColumnAssocLoaded = false;
    private boolean assertTablesLoaded = false;
    private boolean assertTablesLoaded_Schema = false;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$jdbc$impl$JdbcMDRConnection;

    public JdbcMDRConnection(DatabaseMetaData jdbcMeta) throws BIResourceException {
        this.jdbcMeta = jdbcMeta;
    }

    public JdbcMDRConnection(IBIConnectionInfo connectionInfo, DatabaseMetaData jdbcMeta) throws BIResourceException {
        super(connectionInfo);
        this.jdbcMeta = jdbcMeta;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getTableTypes() throws BIResourceException {
        List list;
        block15: {
            List list2;
            block14: {
                String method = "getTableTypes()";
                loggingLoc.entering("getTableTypes()", new Object[0]);
                try {
                    this.assertMetaDataLoaded();
                    if (this.tableTypes == null) {
                        ArrayList<TableType> types = new ArrayList<TableType>();
                        try {
                            loggingLoc.infoT("getTableTypes");
                            this.serverRTCounter.setTimer();
                            ResultSet res = this.jdbcMeta.getTableTypes();
                            this.serverRTCounter.incrementCounter();
                            while (true) {
                                if (!res.next()) {
                                    this.serverRTCounter.addToTimer(2);
                                    this.tableTypes = Collections.unmodifiableList(types);
                                    list2 = this.tableTypes;
                                    Object var6_7 = null;
                                    break block14;
                                }
                                String type = res.getString(TABLE_TYPE);
                                loggingLoc.infoT("table type: " + type);
                                if (IBIRelational.ALIAS.equals(type)) {
                                    types.add(IBIRelational.ALIAS);
                                    continue;
                                }
                                if (IBIRelational.GLOBAL_TEMPRARY.equals(type)) {
                                    types.add(IBIRelational.GLOBAL_TEMPRARY);
                                    continue;
                                }
                                if (IBIRelational.LOCAL_TEMPORARY.equals(type)) {
                                    types.add(IBIRelational.LOCAL_TEMPORARY);
                                    continue;
                                }
                                if (IBIRelational.SYNONYM.equals(type)) {
                                    types.add(IBIRelational.SYNONYM);
                                    continue;
                                }
                                if (IBIRelational.SYSTEM_TABLE.equals(type)) {
                                    types.add(IBIRelational.SYSTEM_TABLE);
                                    continue;
                                }
                                if (IBIRelational.TABLE.equals(type)) {
                                    types.add(IBIRelational.TABLE);
                                    continue;
                                }
                                if (!IBIRelational.VIEW.equals(type)) {
                                    throw new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.connector.jdbc_2001", new Object[]{type});
                                }
                                types.add(IBIRelational.VIEW);
                            }
                        }
                        catch (SQLException ex) {
                            loggingCat.logThrowableT(500, loggingLoc, ex.toString(), (Throwable)ex);
                            throw new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.connector.jdbc_2000", (Throwable)ex);
                        }
                    }
                    list = this.tableTypes;
                    break block15;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    loggingLoc.exiting();
                    throw throwable;
                }
            }
            loggingLoc.exiting();
            return list2;
        }
        Object var6_8 = null;
        loggingLoc.exiting();
        return list;
    }

    public void assertMetaDataLoaded() throws BIResourceException {
        String method = "assertMetaDataLoaded()";
        loggingLoc.entering("assertMetaDataLoaded()", new Object[0]);
        try {
            if (this.jdbcMeta == null) {
                throw new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.connector.rel_3000");
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void assertCatalogsLoaded() throws BIResourceException {
        String method = "assertCatalogsLoaded()";
        loggingLoc.entering("assertCatalogsLoaded()", new Object[0]);
        try {
            this.assertMetaDataLoaded();
            if (!this.assertCatalogsLoaded) {
                this.assertCatalogsLoaded = true;
                try {
                    loggingLoc.infoT("getTables(Catalog/Schema/TableName/ColumnName): " + this.getFixedCatalog() + "," + this.getFixedSchema() + "," + "%" + null);
                    this.serverRTCounter.setTimer();
                    ResultSet res = this.jdbcMeta.getTables(this.getFixedCatalog(), this.getFixedSchema(), "%", null);
                    this.serverRTCounter.incrementCounter();
                    boolean addCatalog = true;
                    boolean addSchemas = true;
                    while (res.next()) {
                        String schemaName;
                        String catalogName = res.getString(TABLE_CAT);
                        if (this.addCatalog(catalogName)) {
                            loggingLoc.infoT("addCatalog(Catalog): " + catalogName);
                            addCatalog = false;
                        }
                        if (!this.addSchema(catalogName, schemaName = res.getString(TABLE_SCHEM))) continue;
                        loggingLoc.infoT("addSchema(Catalog/Schema): " + catalogName + "," + schemaName);
                        addSchemas = false;
                    }
                    this.serverRTCounter.addToTimer(2);
                    this.addDummyInstances(addCatalog, addSchemas);
                }
                catch (SQLException ex) {
                    loggingCat.logThrowableT(400, loggingLoc, ex.toString(), (Throwable)ex);
                    throw new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.connector.jdbc_2000", (Throwable)ex);
                }
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    private boolean addCatalog(String catalogName) {
        CatalogObject catalog;
        if (catalogName != null && !this.metaStore.containsCatalog(catalog = new CatalogObject(catalogName))) {
            this.metaStore.addCatalog(catalog);
            return true;
        }
        return false;
    }

    private boolean addSchema(String catalogName, String schemaName) {
        SchemaObject schema;
        if (schemaName != null && !this.metaStore.containsSchema(schema = new SchemaObject(catalogName, schemaName))) {
            this.metaStore.addSchema(schema);
            return true;
        }
        return false;
    }

    private boolean addSchema(CatalogObject catalog, String schemaName) {
        SchemaObject schema;
        if (schemaName != null && !this.metaStore.containsSchema(schema = new SchemaObject(catalog, schemaName))) {
            this.metaStore.addSchema(schema);
            return true;
        }
        return false;
    }

    private TableObject addTable(String catalogName, String schemaName, String tableName, String tableType) {
        TableObject table = new TableObject(catalogName, schemaName, tableName, tableType);
        if (!this.metaStore.containsTable(table)) {
            this.metaStore.addTable(table);
        }
        return (TableObject)this.metaStore.getTable().get(table.toString());
    }

    private void addDummyInstances(boolean addCatalog, boolean addSchemas) {
        if (addCatalog) {
            this.addCatalog("");
        }
        if (addSchemas) {
            Iterator i = this.metaStore.getCatalog().keySet().iterator();
            while (i.hasNext()) {
                String catalogName = (String)i.next();
                this.addSchema(catalogName, "");
            }
        }
    }

    public void assertSchemasLoaded() throws BIResourceException {
        String method = "assertSchemasLoaded()";
        loggingLoc.entering("assertSchemasLoaded()", new Object[0]);
        try {
            try {
                this.assertCatalogsLoaded();
            }
            catch (BIResourceException ex) {
                throw new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.connector.jdbc_2000", (Throwable)ex);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void assertSchemasLoaded(CatalogObject catalog) throws BIResourceException {
        String method = "assertSchemasLoaded(CatalogObject)";
        loggingLoc.entering("assertSchemasLoaded(CatalogObject)", new Object[]{catalog});
        try {
            this.assertSchemasLoaded();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void assertTablesLoaded() throws BIResourceException {
        String method = "assertTablesLoaded()";
        loggingLoc.entering("assertTablesLoaded()", new Object[0]);
        try {
            this.assertMetaDataLoaded();
            if (!this.assertTablesLoaded) {
                this.assertTablesLoaded = true;
                try {
                    String fixedSchema;
                    String fixedCatalog = this.getFixedCatalog();
                    if (fixedCatalog == null) {
                        fixedCatalog = this.getCurrentCatalogName();
                    }
                    if ((fixedSchema = this.getFixedSchema()) == null) {
                        fixedSchema = this.getCurrentSchemaName();
                    }
                    loggingLoc.infoT("getTables(Catalog/Schema/TableName/ColumnName): " + fixedCatalog + "," + fixedSchema + "," + "%" + null);
                    this.serverRTCounter.setTimer();
                    ResultSet res = this.jdbcMeta.getTables(fixedCatalog, fixedSchema, "%", null);
                    this.serverRTCounter.addToTimer(2);
                    this.serverRTCounter.incrementCounter();
                    this.assertTablesLoadedInternal(loggingLoc, res);
                }
                catch (SQLException ex) {
                    loggingCat.logThrowableT(400, loggingLoc, ex.toString(), (Throwable)ex);
                    throw new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.connector.jdbc_2000", (Throwable)ex);
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void assertTablesLoaded(SchemaObject schema) throws BIResourceException {
        String method = "assertTablesLoaded(SchemaObject)";
        loggingLoc.entering("assertTablesLoaded(SchemaObject)", new Object[]{schema});
        try {
            this.assertMetaDataLoaded();
            if (this.metaStore.getTable(schema) == null || this.metaStore.getTable(schema).isEmpty()) {
                try {
                    String fixedSchema;
                    String fixedCatalog = this.getFixedCatalog();
                    if (fixedCatalog == null) {
                        fixedCatalog = schema.getCatalogName();
                    }
                    if ((fixedSchema = this.getFixedSchema()) == null) {
                        fixedSchema = schema.getSchemaName();
                    }
                    this.serverRTCounter.setTimer();
                    ResultSet res = this.jdbcMeta.getTables(fixedCatalog, fixedSchema, "%", null);
                    this.serverRTCounter.addToTimer(2);
                    this.serverRTCounter.incrementCounter();
                    this.assertTablesLoadedInternal(loggingLoc, res);
                }
                catch (SQLException ex) {
                    loggingCat.logThrowableT(400, loggingLoc, ex.toString(), (Throwable)ex);
                    throw new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.connector.jdbc_2000", (Throwable)ex);
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public List assertTablesLoadedInternal(Location loggingLoc, ResultSet res) throws SQLException {
        ArrayList<TableObject> tables = new ArrayList<TableObject>();
        boolean addCatalog = true;
        boolean addSchemas = true;
        this.serverRTCounter.setTimer();
        while (res.next()) {
            String catalogName = res.getString(TABLE_CAT);
            String schemaName = res.getString(TABLE_SCHEM);
            String tableName = res.getString(TABLE_NAME);
            String tableType = res.getString(TABLE_TYPE);
            if (this.addCatalog(catalogName)) {
                loggingLoc.infoT("addCatalog(Catalog): " + catalogName);
                addCatalog = false;
            }
            if (this.addSchema(catalogName, schemaName)) {
                loggingLoc.infoT("addSchema(Catalog/Schema): " + catalogName + "," + schemaName);
                addSchemas = false;
            }
            tables.add(this.addTable(catalogName, schemaName, tableName, tableType));
        }
        this.serverRTCounter.addToTimer(2);
        this.addDummyInstances(addCatalog, addSchemas);
        return tables;
    }

    public void assertColumnsLoaded(TableObject table) throws BIResourceException {
        String method = "assertColumnsLoaded(TableObject)";
        loggingLoc.entering("assertColumnsLoaded(TableObject)", new Object[]{table});
        try {
            this.assertTableColumnAssocLoaded((GenericSchemaObject)table);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void assertTableColumnAssocLoaded(GenericSchemaObject obj) throws BIResourceException {
        block15: {
            block14: {
                block13: {
                    block12: {
                        String method = "assertTableColumnAssocLoaded(GenericSchemaObject)";
                        loggingLoc.entering("assertTableColumnAssocLoaded(GenericSchemaObject)", new Object[]{obj});
                        try {
                            String columnNamePattern;
                            String tableName;
                            String schemaName;
                            String catalogName;
                            block17: {
                                block16: {
                                    this.assertCatalogsLoaded();
                                    catalogName = null;
                                    schemaName = null;
                                    tableName = null;
                                    columnNamePattern = "%";
                                    if (obj == null) break block16;
                                    if (obj instanceof ColumnObject) {
                                        TableObject tableObj = this.metaStore.getTable((ColumnObject)obj);
                                        if (!this.metaStore.getColumn(tableObj).isEmpty()) {
                                            Object var11_10 = null;
                                            break block12;
                                        }
                                        catalogName = ((ColumnObject)obj).getCatalogName();
                                        schemaName = ((ColumnObject)obj).getSchemaName();
                                        tableName = ((ColumnObject)obj).getTableName();
                                        columnNamePattern = ((ColumnObject)obj).getColumnName();
                                        break block17;
                                    } else {
                                        if (!(obj instanceof TableObject)) {
                                            throw new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.rel.query_1023", new Object[]{obj.getClass().getName(), obj});
                                        }
                                        if (this.metaStore.getColumn((TableObject)obj) == null) break block13;
                                        if (!this.metaStore.getColumn((TableObject)obj).isEmpty()) {
                                            break block13;
                                        }
                                        catalogName = ((TableObject)obj).getCatalogName();
                                        schemaName = ((TableObject)obj).getSchemaName();
                                        tableName = ((TableObject)obj).getTableName();
                                    }
                                    break block17;
                                }
                                if (!this.metaStore.getColumn().isEmpty()) {
                                    break block14;
                                }
                            }
                            try {
                                boolean pos = false;
                                loggingLoc.infoT("getColumns (Catalog/Schema/TableName/ColumnName): " + catalogName + "," + schemaName + "," + tableName + "," + columnNamePattern);
                                this.serverRTCounter.setTimer();
                                ResultSet res = this.jdbcMeta.getColumns(catalogName, schemaName, tableName, columnNamePattern);
                                this.serverRTCounter.incrementCounter();
                                while (true) {
                                    if (!res.next()) {
                                        this.serverRTCounter.addToTimer(2);
                                        break block15;
                                    }
                                    loggingLoc.infoT("column (cat/schema/name/type): " + res.getString(TABLE_CAT) + "," + res.getString(TABLE_SCHEM) + "," + res.getString(TABLE_NAME) + "," + res.getString(COLUMN_NAME));
                                    ColumnObject column = new ColumnObject(res.getString(TABLE_CAT), res.getString(TABLE_SCHEM), res.getString(TABLE_NAME), res.getString(COLUMN_NAME));
                                    column.setCharOctetLength(res.getInt(CHAR_OCTET_LENGTH));
                                    column.setColumnSize(res.getInt(COLUMN_SIZE));
                                    column.setDataType(res.getShort(DATA_TYPE));
                                    column.setDecimalDigits(res.getInt(DECIMAL_DIGITS));
                                    column.setDescription(res.getString(REMARKS));
                                    column.setNumPrecRadix(res.getInt(NUM_PREC_RADIX));
                                    column.setTypeName(res.getString(TYPE_NAME));
                                    this.metaStore.addColumn(column);
                                }
                            }
                            catch (SQLException ex) {
                                loggingCat.logThrowableT(400, loggingLoc, ex.toString(), (Throwable)ex);
                                throw new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.connector.jdbc_2000", (Throwable)ex);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var11_14 = null;
                            loggingLoc.exiting();
                            throw throwable;
                        }
                    }
                    loggingLoc.exiting();
                    return;
                }
                Object var11_11 = null;
                loggingLoc.exiting();
                return;
            }
            Object var11_12 = null;
            loggingLoc.exiting();
            return;
        }
        Object var11_13 = null;
        loggingLoc.exiting();
    }

    public void assertCatalogSchemaAssocLoaded(GenericSchemaObject obj) throws BIResourceException {
        String method = "assertCatalogSchemaAssocLoaded(GenericSchemaObject)";
        loggingLoc.entering("assertCatalogSchemaAssocLoaded(GenericSchemaObject)", new Object[]{obj});
        try {
            this.assertSchemasLoaded();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void assertSchemaTableAssocLoaded(GenericSchemaObject obj) throws BIResourceException {
        String method = "assertSchemaTableAssocLoaded(GenericSchemaObject)";
        loggingLoc.entering("assertSchemaTableAssocLoaded(GenericSchemaObject)", new Object[]{obj});
        try {
            if (obj instanceof ColumnObject) {
                TableObject table = this.metaStore.getTable((ColumnObject)obj);
                SchemaObject schema = this.metaStore.getSchema(table);
                this.assertTablesLoaded(schema);
            } else if (obj instanceof TableObject) {
                SchemaObject schema = this.metaStore.getSchema((TableObject)obj);
                this.assertTablesLoaded(schema);
            } else if (obj instanceof SchemaObject) {
                this.assertTablesLoaded((SchemaObject)obj);
            } else {
                throw new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.rel.query_1023", new Object[]{obj.getClass().getName(), obj});
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List assertFindTable(String catalog, String schemaPattern, String tableNamePattern, TableType[] type) throws BIResourceException {
        ArrayList<TableObject> arrayList;
        block12: {
            String method = "assertFindTable(String, String, String, TableType[])";
            loggingLoc.entering("assertFindTable(String, String, String, TableType[])", new Object[]{catalog, schemaPattern, tableNamePattern, type});
            try {
                this.assertMetaDataLoaded();
                ArrayList<TableObject> tables = Collections.EMPTY_LIST;
                try {
                    TableObject stored;
                    TableObject table;
                    String fixedSchema;
                    String fixedCatalog;
                    String[] tableType = null;
                    if (type != null) {
                        tableType = new String[type.length];
                        int i = 0;
                        while (i < type.length) {
                            tableType[i] = type[i].toString();
                            ++i;
                        }
                    }
                    if ((fixedCatalog = this.getFixedCatalog()) == null) {
                        fixedCatalog = catalog;
                    }
                    if ((fixedSchema = this.getFixedSchema()) == null) {
                        fixedSchema = schemaPattern;
                    }
                    if (!this.containsWildcard(fixedSchema) && !this.containsWildcard(tableNamePattern) && this.metaStore.containsTable(table = new TableObject(fixedCatalog, fixedSchema, tableNamePattern, TableType.UNKNOWN)) && (stored = (TableObject)this.metaStore.getTable().get(table.toString())) != null) {
                        if (type == null) {
                            tables = new ArrayList<TableObject>();
                            tables.add(stored);
                            arrayList = tables;
                            break block12;
                        }
                        int i = 0;
                        while (i < type.length) {
                            if (type[i] == stored.getType()) {
                                tables = new ArrayList();
                                tables.add(stored);
                                ArrayList<TableObject> arrayList2 = tables;
                                Object var15_17 = null;
                                loggingLoc.exiting();
                                return arrayList2;
                            }
                            ++i;
                        }
                    }
                    this.serverRTCounter.setTimer();
                    ResultSet res = this.jdbcMeta.getTables(fixedCatalog, fixedSchema, tableNamePattern, tableType);
                    this.serverRTCounter.incrementCounter();
                    this.serverRTCounter.addToTimer(2);
                    tables = this.assertTablesLoadedInternal(loggingLoc, res);
                }
                catch (SQLException ex) {
                    loggingCat.logThrowableT(400, loggingLoc, ex.toString(), (Throwable)ex);
                    throw new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.connector.jdbc_2000", (Throwable)ex);
                }
                ArrayList<TableObject> arrayList3 = tables;
                Object var15_19 = null;
                loggingLoc.exiting();
                return arrayList3;
            }
            catch (Throwable throwable) {
                Object var15_20 = null;
                loggingLoc.exiting();
                throw throwable;
            }
        }
        Object var15_18 = null;
        loggingLoc.exiting();
        return arrayList;
    }

    public MetaStore getMetaStore() {
        MetaStore metaStore;
        String method = "getMetaStore()";
        loggingLoc.entering("getMetaStore()", new Object[0]);
        try {
            metaStore = this.metaStore;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return metaStore;
    }

    private boolean containsWildcard(String pattern) {
        return BIStringMatcher.patternHasWildcards((String)pattern, (char[])BIStringMatcher.SQL_WILDCARDS);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

