/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.jdbc;

import com.sap.ip.bi.sdk.dac.connector.IBIRelational;
import com.sap.ip.bi.sdk.dac.connector.IBIRelationalObjectFinder;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcConnection;
import com.sap.ip.bi.sdk.dac.connector.jdbc.impl.Connection;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQuery;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.ResultSet;
import java.util.List;
import javax.jmi.reflect.RefPackage;
import javax.resource.ResourceException;
import org.omg.cwm.resource.relational.Catalog;
import org.omg.cwm.resource.relational.Schema;
import org.omg.cwm.resource.relational.Table;

public class JdbcRelational
implements IBIRelational {
    private static final boolean tracePrivateMethods = false;
    private static final Location loggingLoc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$jdbc$JdbcRelational == null ? (class$com$sap$ip$bi$sdk$dac$connector$jdbc$JdbcRelational = JdbcRelational.class$("com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcRelational")) : class$com$sap$ip$bi$sdk$dac$connector$jdbc$JdbcRelational).getName());
    private static final Category loggingCat = BILoggingSetup.CONNECTION.getCategory();
    private IBIMonitor monitor = null;
    private JdbcConnection m_connection = null;
    private Connection jdbcConn = null;
    private IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$jdbc$JdbcRelational;

    private JdbcRelational() {
    }

    public JdbcRelational(JdbcConnection connection) throws BIResourceException {
        String method = "JdbcRelational(JdbcConnection)";
        try {
            this.m_connection = connection;
            if (this.m_connection == null) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_1101");
            }
            this.jdbcConn = this.m_connection.getConnection();
            try {
                this.connectionInfo = this.jdbcConn != null ? this.jdbcConn.getConnectionInfo() : IBIConnectionInfo.DEFAULT;
            }
            catch (ResourceException ex) {
                this.connectionInfo = IBIConnectionInfo.DEFAULT;
            }
            if (this.jdbcConn == null) {
                BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_4002");
                loggingLoc.throwing("JdbcRelational(JdbcConnection)", (Throwable)rex);
                throw rex;
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            throw throwable;
        }
    }

    public Boolean supports(IBIRelational.Supports feature) throws BIResourceException {
        if (this.jdbcConn != null) {
            return this.jdbcConn.supports(feature);
        }
        return Boolean.FALSE;
    }

    public List getCatalog() throws BIResourceException {
        List list;
        String method = "getCatalog()";
        loggingLoc.entering("getCatalog()");
        try {
            list = this.jdbcConn.getCatalog();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return list;
    }

    public Catalog getCurrentCatalog() throws BIResourceException {
        Catalog catalog;
        String method = "getCurrentCatalog()";
        loggingLoc.entering("getCurrentCatalog()");
        try {
            catalog = this.jdbcConn.getCurrentCatalog();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return catalog;
    }

    public void setCurrentCatalog(Catalog current) throws BIResourceException {
        String method = "setCurrentCatalog(Catalog)";
        loggingLoc.entering("setCurrentCatalog(Catalog)");
        try {
            this.jdbcConn.setCurrentCatalog(current);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public List getSchema() throws BIResourceException {
        List list;
        String method = "getSchema()";
        loggingLoc.entering("getSchema()");
        try {
            list = this.jdbcConn.getSchema();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return list;
    }

    public void setCurrentSchema(Schema schema) throws BIResourceException {
        String method = "setCurrentSchema(Schema)";
        loggingLoc.entering("setCurrentSchema(Schema)");
        try {
            this.jdbcConn.setCurrentSchema(schema);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public Schema getCurrentSchema() throws BIResourceException {
        Schema schema;
        String method = "getCurrentSchema()";
        loggingLoc.entering("getCurrentSchema()");
        try {
            schema = this.jdbcConn.getCurrentSchema();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return schema;
    }

    public List getTable() throws BIResourceException {
        List list;
        String method = "getTable()";
        loggingLoc.entering("getTable()");
        try {
            list = this.jdbcConn.getTable();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return list;
    }

    public List getTableTypes() throws BIResourceException {
        List list;
        String method = "getTableTypes()";
        loggingLoc.entering("getTableTypes()");
        try {
            list = this.jdbcConn.getTableTypes();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return list;
    }

    public IBIRelationalObjectFinder getObjectFinder() throws BIResourceException {
        IBIRelationalObjectFinder iBIRelationalObjectFinder;
        String method = "getObjectFinder()";
        loggingLoc.entering("getObjectFinder()");
        try {
            iBIRelationalObjectFinder = this.jdbcConn.getObjectFinder();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return iBIRelationalObjectFinder;
    }

    public IBIQuery createQuery() throws BIResourceException {
        IBIQuery iBIQuery;
        String method = "createQuery()";
        loggingLoc.entering("createQuery()");
        try {
            iBIQuery = this.jdbcConn.createQuery();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return iBIQuery;
    }

    public RefPackage getRefPackage() throws BIResourceException {
        RefPackage refPackage;
        String method = "getRefPackage()";
        loggingLoc.entering("getRefPackage()");
        try {
            refPackage = this.jdbcConn.getRefPackage();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return refPackage;
    }

    public List getColumn(Table table) throws BIResourceException {
        List list;
        String method = "getColumn(Table)";
        loggingLoc.entering("getColumn(Table)");
        try {
            list = this.jdbcConn.getColumn(table);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return list;
    }

    public ResultSet getResultSet(IBIQuery query) throws BIResourceException {
        ResultSet resultSet;
        String method = "getResultSet(IBIQuery)";
        loggingLoc.entering("getResultSet(IBIQuery)");
        try {
            resultSet = this.jdbcConn.getResultSet(query);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return resultSet;
    }

    public ResultSet getResultSet(Object nativeQuery) throws BIResourceException {
        ResultSet resultSet;
        String method = "getResultSet(Object)";
        loggingLoc.entering("getResultSet(Object)");
        try {
            resultSet = this.jdbcConn.getResultSet(nativeQuery);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return resultSet;
    }

    public Object getNativeRepresentation(IBIQuery query) throws BIResourceException {
        Object object;
        String method = "getNativeRepresentation(IBIQuery)";
        loggingLoc.entering("getNativeRepresentation(IBIQuery)");
        try {
            object = this.jdbcConn.getNativeRepresentation(query);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return object;
    }

    public java.sql.Connection getNativeJDBCConnection() throws BIRuntimeException, BIResourceException {
        String method = "getNativeJDBCConnection";
        if (this.jdbcConn == null) {
            BIResourceException rex = new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_4002");
            loggingLoc.throwing("getNativeJDBCConnection", (Throwable)rex);
            throw rex;
        }
        return this.jdbcConn.getNativeJDBCConnection();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

