/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.jdbc;

import com.sap.ip.bi.sdk.dac.connector.impl.AbstractManagedConnection;
import com.sap.ip.bi.sdk.dac.connector.impl.ConnectorConnection;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionDetails;
import com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcConnection;
import com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcConnectionProperties;
import com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcManagedConnectionFactory;
import com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcManagedConnectionMetaData;
import com.sap.ip.bi.sdk.dac.connector.jdbc.impl.Connection;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.tc.logging.Category;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;

public class JdbcManagedConnection
extends AbstractManagedConnection
implements IBIConnectionDetails {
    private static final Category loggingCat = BILoggingSetup.CONNECTION.getCategory();
    private IBIMonitor monitor = null;
    protected JdbcManagedConnectionFactory m_managedConnectionFactory;
    private JdbcConnectionProperties m_request_info;
    private String user;
    private String passwd;

    protected JdbcManagedConnection(JdbcManagedConnectionFactory managed_connection_factory, Subject subject, JdbcConnectionProperties request_info) throws ResourceException {
        String method = "JdbcManagedConnection(JdbcManagedConnectionFactory, Subject, JdbcConnectionProperties)";
        AbstractManagedConnection.loggingLoc.entering("JdbcManagedConnection(JdbcManagedConnectionFactory, Subject, JdbcConnectionProperties)");
        try {
            this.m_managedConnectionFactory = managed_connection_factory;
            this.m_logWriter = managed_connection_factory.m_logWriter;
            this.m_subject = subject;
            this.m_request_info = request_info;
            try {
                Properties connProps = new Properties(managed_connection_factory.m_properties);
                if (subject != null) {
                    connProps.setProperty(JdbcConnectionProperties.Parameter.USER.name, "");
                    connProps.setProperty(JdbcConnectionProperties.Parameter.PASSWD.name, "");
                } else if (request_info != null && request_info.m_properties != null) {
                    Enumeration e = ((Hashtable)request_info.m_properties).keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        connProps.setProperty(key, request_info.getProperty(key));
                    }
                }
                this.connection = Connection.connect(connProps);
                this.connectionInfo = this.connection.getConnectionInfo();
            }
            catch (Exception ex) {
                loggingCat.logThrowableT(500, AbstractManagedConnection.loggingLoc, ex.toString(), (Throwable)ex);
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_1100", (Throwable)ex);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            AbstractManagedConnection.loggingLoc.exiting();
            throw throwable;
        }
        AbstractManagedConnection.loggingLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean equals(JdbcManagedConnectionFactory managed_connection_factory, Subject subject, JdbcConnectionProperties request_info) throws ResourceException {
        boolean bl;
        block10: {
            boolean bl2;
            block9: {
                boolean bl3;
                block8: {
                    boolean bl4;
                    block7: {
                        boolean bl5;
                        block6: {
                            String method = "equals(JdbcManagedConnectionFactory, Subject, JdbcConnectionProperties)";
                            AbstractManagedConnection.loggingLoc.entering("equals(JdbcManagedConnectionFactory, Subject, JdbcConnectionProperties)");
                            try {
                                if (this.m_subject != null && subject == null || this.m_subject == null && subject != null) {
                                    bl5 = false;
                                    Object var9_6 = null;
                                    break block6;
                                }
                                if (this.m_subject != null && !this.m_subject.equals(subject)) {
                                    bl4 = false;
                                    break block7;
                                }
                                if (managed_connection_factory != null && !this.m_managedConnectionFactory.equals(managed_connection_factory)) {
                                    bl3 = false;
                                    break block8;
                                }
                                if (subject == null && !this.compareProperties(request_info)) {
                                    bl2 = false;
                                    break block9;
                                }
                                bl = true;
                                break block10;
                            }
                            catch (Throwable throwable) {
                                Object var9_11 = null;
                                AbstractManagedConnection.loggingLoc.exiting();
                                throw throwable;
                            }
                        }
                        AbstractManagedConnection.loggingLoc.exiting();
                        return bl5;
                    }
                    Object var9_7 = null;
                    AbstractManagedConnection.loggingLoc.exiting();
                    return bl4;
                }
                Object var9_8 = null;
                AbstractManagedConnection.loggingLoc.exiting();
                return bl3;
            }
            Object var9_9 = null;
            AbstractManagedConnection.loggingLoc.exiting();
            return bl2;
        }
        Object var9_10 = null;
        AbstractManagedConnection.loggingLoc.exiting();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean compareProperties(JdbcConnectionProperties other) throws ResourceException {
        boolean bl;
        block10: {
            boolean bl2;
            block9: {
                String method = "compareProperties(JdbcConnectionProperties)";
                AbstractManagedConnection.loggingLoc.entering("compareProperties(JdbcConnectionProperties)");
                try {
                    JdbcConnectionProperties request_info = null;
                    request_info = other == null ? new JdbcConnectionProperties(this.m_managedConnectionFactory.m_properties) : other;
                    if (request_info.m_properties == null) {
                        request_info.m_properties = this.m_managedConnectionFactory.m_properties;
                    }
                    if (request_info.m_properties == null) {
                        request_info.m_properties = this.m_managedConnectionFactory.m_properties;
                    }
                    if (((Hashtable)this.connection.getProperties()).size() < ((Hashtable)request_info.m_properties).size()) {
                        AbstractManagedConnection.loggingLoc.debugT(loggingCat, "connection.getProperties().size() < request_info.m_properties.size()" + ((Hashtable)this.connection.getProperties()).size() + "  " + ((Hashtable)request_info.m_properties).size());
                        AbstractManagedConnection.loggingLoc.exiting((Object)new Boolean(false));
                        bl2 = false;
                        Object var11_6 = null;
                        break block9;
                    }
                    boolean is_equal = true;
                    Enumeration keys = ((Hashtable)this.connection.getProperties()).keys();
                    while (true) {
                        if (!keys.hasMoreElements() || !is_equal) {
                            AbstractManagedConnection.loggingLoc.debugT(loggingCat, "compareProperties  is_equal " + is_equal);
                            AbstractManagedConnection.loggingLoc.exiting((Object)new Boolean(is_equal));
                            bl = is_equal;
                            break block10;
                        }
                        String key = (String)keys.nextElement();
                        String valueMC = this.connection.getProperty(key);
                        String valueNew = request_info.m_properties.getProperty(key);
                        AbstractManagedConnection.loggingLoc.debugT(loggingCat, "key:" + key + "valueMC:" + valueMC + "valueNew:" + valueNew);
                        if (valueMC != null && valueMC.length() > 0 && (valueNew == null || valueNew.length() == 0)) {
                            is_equal = false;
                            continue;
                        }
                        if ((valueMC == null || valueMC.length() == 0) && valueNew != null && valueNew.length() > 0) {
                            is_equal = false;
                            continue;
                        }
                        if (valueMC == null || valueNew == null || valueMC.equals(valueNew)) continue;
                        is_equal = false;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_8 = null;
                    AbstractManagedConnection.loggingLoc.exiting();
                    throw throwable;
                }
            }
            AbstractManagedConnection.loggingLoc.exiting();
            return bl2;
        }
        Object var11_7 = null;
        AbstractManagedConnection.loggingLoc.exiting();
        return bl;
    }

    protected void unregisterConnection(JdbcConnection connection) {
        String method = "unregisterConnection(JdbcConnection)";
        AbstractManagedConnection.loggingLoc.entering("unregisterConnection(JdbcConnection)");
        try {
            this.m_associated_connections.removeElement((Object)connection);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            AbstractManagedConnection.loggingLoc.exiting();
            throw throwable;
        }
        AbstractManagedConnection.loggingLoc.exiting();
    }

    public void associateConnection(Object connection) throws ResourceException {
        String method = "associateConnection(Object)";
        AbstractManagedConnection.loggingLoc.entering("associateConnection(Object)");
        try {
            if (connection == null) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_1101");
            }
            if (!(connection instanceof JdbcConnection)) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_1007", new Object[]{connection.getClass().toString()});
            }
            this.assertConnection();
            ((JdbcConnection)((Object)connection)).associateConnection((ManagedConnection)this);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            AbstractManagedConnection.loggingLoc.exiting();
            throw throwable;
        }
        AbstractManagedConnection.loggingLoc.exiting();
    }

    public void cleanup() throws ResourceException {
        String method = "cleanup()";
        AbstractManagedConnection.loggingLoc.entering("cleanup()");
        try {
            Vector vector = this.m_associated_connections;
            synchronized (vector) {
                Vector list = (Vector)this.m_associated_connections.clone();
                int num_connections = list.size();
                int i = 0;
                while (i < num_connections) {
                    ((JdbcConnection)((Object)list.elementAt(i))).dissociateManagedConnection();
                    ++i;
                }
                this.m_associated_connections.removeAllElements();
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            AbstractManagedConnection.loggingLoc.exiting();
            throw throwable;
        }
        AbstractManagedConnection.loggingLoc.exiting();
    }

    protected ConnectorConnection getConnection() throws BIResourceException {
        return super.getConnection();
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        JdbcConnection jdbcConnection;
        String method = "getConnection(Subject, ConnectionRequestInfo)";
        AbstractManagedConnection.loggingLoc.entering("getConnection(Subject, ConnectionRequestInfo)");
        try {
            this.assertConnection();
            jdbcConnection = new JdbcConnection(this);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            AbstractManagedConnection.loggingLoc.exiting();
            throw throwable;
        }
        AbstractManagedConnection.loggingLoc.exiting();
        return jdbcConnection;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        JdbcManagedConnectionMetaData jdbcManagedConnectionMetaData;
        String method = "getMetaData()";
        AbstractManagedConnection.loggingLoc.entering("getMetaData()");
        try {
            this.assertConnection();
            jdbcManagedConnectionMetaData = new JdbcManagedConnectionMetaData(this);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            AbstractManagedConnection.loggingLoc.exiting();
            throw throwable;
        }
        AbstractManagedConnection.loggingLoc.exiting();
        return jdbcManagedConnectionMetaData;
    }

    protected void fireConnectionClosedEvent(javax.resource.cci.Connection connection) throws BIResourceException {
        super.fireConnectionClosedEvent(connection);
    }

    protected void fireConnectErrorOccurredEvent(javax.resource.cci.Connection connection) throws BIResourceException {
        super.fireConnectErrorOccurredEvent(connection);
    }

    public JdbcManagedConnectionFactory getManagedConnectionFactory() {
        JdbcManagedConnectionFactory jdbcManagedConnectionFactory;
        String method = "getManagedConnectionFactory()";
        AbstractManagedConnection.loggingLoc.entering("getManagedConnectionFactory()");
        try {
            jdbcManagedConnectionFactory = this.m_managedConnectionFactory;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            AbstractManagedConnection.loggingLoc.exiting();
            throw throwable;
        }
        AbstractManagedConnection.loggingLoc.exiting();
        return jdbcManagedConnectionFactory;
    }
}

