/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.jdbc;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcConnectionManager;
import com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcConnectionSpec;
import com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcManagedConnectionFactory;
import com.sap.ip.bi.sdk.exception.BIConnectionFailedException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sapportals.connector.connection.ConnectionFailedException;
import com.sapportals.connector.connection.IConnection;
import com.sapportals.connector.connection.IConnectionFactory;
import com.sapportals.connector.connection.IConnectionSpec;
import com.sapportals.connector.metadata.IConnectorMetaData;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

class JdbcConnectionFactory
implements IConnectionFactory,
Referenceable {
    private static final boolean tracePrivateMethods = false;
    private static final Location loggingLoc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$jdbc$JdbcConnectionFactory == null ? (class$com$sap$ip$bi$sdk$dac$connector$jdbc$JdbcConnectionFactory = JdbcConnectionFactory.class$("com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcConnectionFactory")) : class$com$sap$ip$bi$sdk$dac$connector$jdbc$JdbcConnectionFactory).getName());
    private static final Category loggingCat = BILoggingSetup.CONNECTION.getCategory();
    private IBIMonitor monitor = null;
    private JdbcManagedConnectionFactory m_managedConnectionFactory;
    private ConnectionManager m_connectionManager;
    private Reference m_reference;
    private int m_timeout;
    private IBIConnectionInfo connectionInfo = IBIConnectionInfo.DEFAULT;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$jdbc$JdbcConnectionFactory;

    public JdbcConnectionFactory(JdbcManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager) {
        this.m_managedConnectionFactory = managedConnectionFactory;
        this.m_connectionManager = connectionManager == null ? new JdbcConnectionManager() : connectionManager;
    }

    public Connection getConnection() throws ResourceException {
        Connection connection;
        String method = "getConnection()";
        loggingLoc.entering("getConnection()");
        try {
            connection = this.getConnection(null);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return connection;
    }

    public Connection getConnection(ConnectionSpec properties) throws ResourceException {
        Connection connection;
        String method = "getConnection(javax.resource.cci.ConnectionSpec)";
        loggingLoc.entering("getConnection(javax.resource.cci.ConnectionSpec)");
        try {
            connection = (Connection)this.m_connectionManager.allocateConnection((ManagedConnectionFactory)this.m_managedConnectionFactory, (ConnectionRequestInfo)properties);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return connection;
    }

    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        ResourceAdapterMetaData resourceAdapterMetaData;
        String method = "getMetaData()";
        loggingLoc.entering("getMetaData()");
        try {
            resourceAdapterMetaData = this.m_managedConnectionFactory.getResourceAdapterMetaData();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return resourceAdapterMetaData;
    }

    public void setReference(Reference reference) {
        String method = "setReference(Reference)";
        loggingLoc.entering("setReference(Reference)");
        try {
            this.m_reference = reference;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public RecordFactory getRecordFactory() throws ResourceException {
        String method = "getRecordFactory()";
        loggingLoc.entering("getRecordFactory()");
        try {
            throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk_1000");
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            loggingLoc.exiting();
            throw throwable;
        }
    }

    public Reference getReference() {
        Reference reference;
        String method = "getReference()";
        loggingLoc.entering("getReference()");
        try {
            reference = this.m_reference;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return reference;
    }

    public IConnectionSpec getConnectionSpec() {
        JdbcConnectionSpec jdbcConnectionSpec;
        String method = "getConnectionSpec()";
        loggingLoc.entering("getConnectionSpec()");
        try {
            jdbcConnectionSpec = new JdbcConnectionSpec();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return jdbcConnectionSpec;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IConnection getConnectionEx(IConnectionSpec connectionSpec) throws ConnectionFailedException {
        IConnection iConnection;
        String method = "getConnectionEx(IConnectionSpec)";
        loggingLoc.entering("getConnectionEx(IConnectionSpec)");
        try {
            try {
                iConnection = (IConnection)this.m_connectionManager.allocateConnection((ManagedConnectionFactory)this.m_managedConnectionFactory, (ConnectionRequestInfo)connectionSpec);
                Object var5_5 = null;
            }
            catch (ResourceException re) {
                throw new BIConnectionFailedException(this.connectionInfo.getLocale(), loggingCat, 500, loggingLoc, "sdk.dac.connector_1100", null, (Throwable)re);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return iConnection;
    }

    public int getConnectionTimeOut() {
        int n;
        String method = "getConnectionTimeOut()";
        loggingLoc.entering("getConnectionTimeOut()");
        try {
            n = this.m_timeout;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return n;
    }

    public IConnectorMetaData getMetaDataEx() {
        String method = "getMetaDataEx()";
        loggingLoc.entering("getMetaDataEx()");
        try {
            throw new BIRuntimeException(this.connectionInfo.getLocale(), "sdk_1002");
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            loggingLoc.exiting();
            throw throwable;
        }
    }

    public void setConnectionTimeOut(int parm1) {
        this.m_timeout = parm1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

