/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.jdbc;

import com.sap.ip.bi.sdk.dac.connector.IBIConnection;
import com.sap.ip.bi.sdk.dac.connector.IBIOlap;
import com.sap.ip.bi.sdk.dac.connector.IBIRelational;
import com.sap.ip.bi.sdk.dac.connector.impl.BIConnection;
import com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcManagedConnection;
import com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcRelational;
import com.sap.ip.bi.sdk.dac.connector.jdbc.impl.Connection;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.spi.ManagedConnection;

class JdbcConnection
extends BIConnection
implements IBIConnection {
    private static final boolean tracePrivateMethods = false;
    private static final Location loggingLoc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$jdbc$JdbcConnection == null ? (class$com$sap$ip$bi$sdk$dac$connector$jdbc$JdbcConnection = JdbcConnection.class$("com.sap.ip.bi.sdk.dac.connector.jdbc.JdbcConnection")) : class$com$sap$ip$bi$sdk$dac$connector$jdbc$JdbcConnection).getName());
    private static final Category loggingCat = BILoggingSetup.CONNECTION.getCategory();
    private IBIMonitor monitor = null;
    private JdbcManagedConnection m_managedConnection;
    private IBIRelational relational = null;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$jdbc$JdbcConnection;

    public JdbcConnection(JdbcManagedConnection managedConnection) throws BIResourceException {
        String method = "JdbcConnection(JdbcManagedConnection)";
        try {
            this.m_managedConnection = managedConnection;
            ((Connection)this.m_managedConnection.getConnection()).setBIConnection(this);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }

    public Boolean supports(IBIConnection.Supports feature) throws BIResourceException {
        if (IBIConnection.Supports.RELATIONAL.equals(feature)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        ConnectionMetaData connectionMetaData;
        String method = "getMetaData()";
        loggingLoc.entering("getMetaData()");
        try {
            connectionMetaData = (ConnectionMetaData)this.m_managedConnection.getMetaData();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return connectionMetaData;
    }

    public void close() throws ResourceException {
        String method = "close()";
        loggingLoc.entering("close()");
        try {
            this.assertConnection();
            if (this.m_managedConnection.getManagedConnectionFactory().m_defaultCM) {
                this.m_managedConnection.destroy();
            } else {
                this.m_managedConnection.fireConnectionClosedEvent((javax.resource.cci.Connection)this);
            }
            this.m_managedConnection = null;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void refresh() throws BIResourceException {
        String method = "refresh()";
        loggingLoc.entering("refresh()");
        try {
            this.assertConnection();
            this.m_managedConnection.fireConnectErrorOccurredEvent((javax.resource.cci.Connection)this);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void associateConnection(ManagedConnection managedConnection) {
        String method = "associateConnection(ManagedConnection)";
        loggingLoc.entering("associateConnection(ManagedConnection)");
        try {
            this.m_managedConnection = (JdbcManagedConnection)managedConnection;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    protected void dissociateManagedConnection() {
        String method = "dissociateManagedConnection()";
        try {
            if (this.m_managedConnection != null) {
                this.m_managedConnection.unregisterConnection(this);
            }
            this.m_managedConnection = null;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    protected void assertConnection() throws BIResourceException {
        String method = "assertConnection()";
        try {
            if (this.m_managedConnection == null) {
                throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector_1101");
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    public IBIOlap getOlap() throws BIResourceException {
        String method = "getOlap()";
        loggingLoc.entering("getOlap()");
        try {
            throw new BIResourceException(this.connectionInfo.getLocale(), "sdk.dac.connector.rel_4000");
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            loggingLoc.exiting();
            throw throwable;
        }
    }

    public IBIRelational getRelational() throws BIResourceException {
        IBIRelational iBIRelational;
        String method = "getRelational()";
        loggingLoc.entering("getRelational()");
        try {
            if (this.relational == null) {
                this.relational = new JdbcRelational(this);
            }
            iBIRelational = this.relational;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return iBIRelational;
    }

    public Connection getConnection() throws BIResourceException {
        Connection connection;
        String method = "getConnection()";
        loggingLoc.entering("getConnection()");
        try {
            this.assertConnection();
            connection = (Connection)this.m_managedConnection.getConnection();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return connection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

