/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mdi.ddtypes;

import com.sap.mdi.ddtypes.DDBuiltInType;
import com.sap.mdi.ddtypes.DDNode;
import com.sap.mdi.ddtypes.DDObject;
import com.sap.mdi.ddtypes.DDTreeContentHandler;
import com.sap.mdi.ddtypes.DDUserDefType;
import java.util.HashMap;

public class DDTreeIterator {
    private HashMap parentChildPairs = new HashMap();
    private DDObject root = null;
    private DDTreeContentHandler treeContentHandler = null;
    private DDObject currentNode = null;
    private int currentDirection = 1;
    private int currentDepth = 0;
    private boolean builtInIsOpen = false;

    public DDTreeIterator(DDObject root) {
        this.root = root;
        this.currentNode = root;
    }

    public DDTreeIterator(DDObject root, DDTreeContentHandler treeContentHandler) {
        this.root = root;
        this.currentNode = root;
        this.treeContentHandler = treeContentHandler;
    }

    /*
     * WARNING - void declaration
     */
    public void navigate() {
        DDObject ddObject;
        this.treeContentHandler.startTree();
        this.treeContentHandler.startNode(this.root, 0);
        while ((ddObject = this.nextByWalk()) != null) {
            void var1_1;
            if (var1_1 instanceof DDBuiltInType) {
                this.treeContentHandler.startNode((DDObject)var1_1, this.currentDepth);
                this.treeContentHandler.endNode((DDObject)var1_1, this.currentDepth);
                continue;
            }
            if (this.currentDirection > 0) {
                this.treeContentHandler.startNode((DDObject)var1_1, this.currentDepth);
                continue;
            }
            this.treeContentHandler.endNode((DDObject)var1_1, this.currentDepth);
        }
        this.treeContentHandler.endTree();
    }

    public void skipSubtree() {
        this.currentDirection = -1;
    }

    public DDObject nextForward() {
        DDObject nextByWalk = null;
        do {
            nextByWalk = this.nextByWalk();
        } while (this.currentDirection < 0 && nextByWalk != null);
        return nextByWalk;
    }

    public DDNode next() {
        Object ddNode = null;
        if (this.builtInIsOpen) {
            this.builtInIsOpen = false;
            return new DDNode(this.currentNode, false, this.currentDepth);
        }
        DDObject ddObject = this.nextByWalk();
        if (ddObject == null) {
            return null;
        }
        if (ddObject instanceof DDBuiltInType) {
            this.builtInIsOpen = true;
        }
        return new DDNode(ddObject, this.currentDirection == 1, this.currentDepth);
    }

    protected DDObject getParentForChild(DDObject child) {
        return (DDObject)this.parentChildPairs.get(child);
    }

    protected void setParentChildPair(DDObject child, DDObject parent) {
        this.parentChildPairs.put(child, parent);
    }

    public DDObject nextByWalk() {
        if (this.currentDirection > 0) {
            DDObject child = this.currentNode.getChild();
            if (child == null) {
                this.currentDirection = -1;
            } else {
                if (child instanceof DDUserDefType) {
                    this.setParentChildPair(child, this.currentNode);
                }
                this.currentNode = child;
                ++this.currentDepth;
            }
        }
        if (this.currentDirection < 0) {
            if (this.currentNode == this.root) {
                return null;
            }
            DDObject next = this.currentNode.getNext();
            if (next == null) {
                this.currentNode = this.currentNode instanceof DDUserDefType ? this.getParentForChild(this.currentNode) : this.currentNode.getParent();
                --this.currentDepth;
            } else {
                this.currentNode = next;
                this.currentDirection = 1;
            }
        }
        return this.currentNode;
    }

    public DDObject nextWithPrint() {
        DDObject next = this.nextForward();
        if (next != null) {
            String spaces = "";
            int i = 1;
            while (i <= this.currentDepth) {
                spaces = spaces + "  ";
                ++i;
            }
            System.out.println(spaces + this.currentDepth + "  " + next);
        }
        return next;
    }

    public int getCurrentDirection() {
        return this.currentDirection;
    }

    public int getCurrentDepth() {
        return this.currentDepth;
    }
}

