/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mdi.ddtypes;

import com.sap.mdi.ddtypes.DDBuiltInType;
import com.sap.mdi.ddtypes.DDDataelement;
import com.sap.mdi.ddtypes.DDFactory;
import com.sap.mdi.ddtypes.DDObject;
import com.sap.mdi.ddtypes.DDReferenceType;
import com.sap.mdi.ddtypes.DDScalarField;
import com.sap.mw.jco.JCO;

public class DDField
extends DDObject {
    private String tabname = " ";
    private String fieldname = " ";
    private int position = 0;
    private int offset = 0;
    private String fieldtext = " ";
    private String lfieldname = " ";
    private String comptype = " ";
    private boolean belongsToAppend = false;
    private String referenceTable = "";
    private String referenceField = "";

    protected DDField(DDFactory factory, JCO.Record x030l, JCO.Record dfies, int position) {
        super(factory);
        this.fieldname = dfies.getString("FIELDNAME");
        this.setName(this.fieldname);
        this.position = position;
        this.offset = dfies.getInt("OFFSET");
        this.fieldtext = dfies.getString("FIELDTEXT");
        if (this.getFactory().tablesParameterFieldExists("DDIF_FIELDINFO_GET", "DFIES_TAB", "LFIELDNAME")) {
            this.lfieldname = dfies.getString("LFIELDNAME");
        }
        this.comptype = this.getFactory().tablesParameterFieldExists("DDIF_FIELDINFO_GET", "DFIES_TAB", "COMPTYPE") ? dfies.getString("COMPTYPE") : "E";
        if (0 == this.comptype.compareToIgnoreCase("S")) {
            this.setChildName(dfies.getString("ROLLNAME"));
        } else if (0 == this.comptype.compareToIgnoreCase("L")) {
            this.setChildName(dfies.getString("ROLLNAME"));
        } else if (0 == this.comptype.compareToIgnoreCase("R")) {
            DDReferenceType referenceType = new DDReferenceType(factory, dfies, dfies.getString("ROLLNAME"));
            this.setChildName(dfies.getString("ROLLNAME"));
            this.setChild(referenceType);
            referenceType.setParent(this);
        } else if (0 == this.comptype.compareToIgnoreCase("E")) {
            DDObject ddObject;
            String name = dfies.getString("ROLLNAME");
            this.referenceTable = dfies.getString("REFTABLE");
            this.referenceField = dfies.getString("REFFIELD");
            this.setChildName(name);
            String langu = dfies.getString("LANGU");
            if (langu == null) {
                langu = factory.getObjectFactory().getUserLogonLanguage();
            }
            if (langu == null) {
                langu = "";
            }
            if (langu.length() == 2) {
                langu = factory.getISOLA(langu);
            }
            if ((ddObject = factory.getSavedUserDefType(name, langu)) == null) {
                DDDataelement dataelement = new DDDataelement(factory, x030l, dfies);
                dataelement.save(langu);
                this.setChild(dataelement);
                if (this instanceof DDScalarField) {
                    dataelement.markAsCompleteSubtree();
                }
            } else {
                this.setChild((DDDataelement)ddObject);
            }
        } else {
            this.referenceTable = dfies.getString("REFTABLE");
            this.referenceField = dfies.getString("REFFIELD");
            DDBuiltInType builtInType = new DDBuiltInType(dfies);
            this.setChild(builtInType);
            builtInType.setParent(this);
        }
    }

    public String getFieldname() {
        return this.fieldname;
    }

    public int getPosition() {
        return this.position;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getTypeName() {
        return this.getChildName();
    }

    public String getTypeKind() {
        if (0 == this.comptype.compareToIgnoreCase("S")) {
            return "Structure";
        }
        if (0 == this.comptype.compareToIgnoreCase("L")) {
            return "Tabletype";
        }
        if (0 == this.comptype.compareToIgnoreCase("R")) {
            return "ReferenceType";
        }
        if (0 == this.comptype.compareToIgnoreCase("E")) {
            return "DDataelement";
        }
        return "BuiltInType";
    }

    public String getReferenceTable() {
        return this.referenceTable;
    }

    public String getReferenceField() {
        return this.referenceField;
    }

    public String getFieldtext() {
        return this.fieldtext;
    }

    public boolean hasReference() {
        return 0 == this.comptype.compareToIgnoreCase("R");
    }

    protected void setBelongsToAppend() {
        this.belongsToAppend = true;
    }

    public boolean belongsToAppend() {
        return this.belongsToAppend;
    }
}

