/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mdi.ddtypes;

import com.sap.mdi.ddtypes.DDType;
import com.sap.mw.jco.JCO;
import java.util.Arrays;
import java.util.HashSet;

public class DDBuiltInType
extends DDType {
    private String datatype = " ";
    private String inttype = " ";
    private int leng = 0;
    private int intlen = 0;
    private int decimals = 0;
    private static final HashSet datatypes = new HashSet<String>(Arrays.asList("ACCP", "CHAR", "CLNT", "CUKY", "CURR", "DATS", "DEC", "FLTP", "INT1", "INT2", "INT4", "LANG", "LCHR", "LRAW", "NUMC", "PREC", "QUAN", "RAW", "RSTR", "SSTR", "STRG", "TIMS", "VARC", "UNIT"));

    public DDBuiltInType(String datatype, int leng, int decimals) {
        super(null);
        this.datatype = datatype;
        this.leng = leng;
        this.decimals = decimals;
    }

    public DDBuiltInType(JCO.Record dfies) {
        super(null);
        this.datatype = dfies.getString("DATATYPE");
        this.inttype = dfies.getString("INTTYPE");
        this.leng = dfies.getInt("LENG");
        this.intlen = dfies.getInt("INTLEN");
        this.decimals = dfies.getInt("DECIMALS");
    }

    public DDBuiltInType(JCO.Record dfies, String type) {
        super(null);
        this.datatype = type;
        this.inttype = dfies.getString("INTTYPE");
        this.leng = dfies.getInt("LENG");
        this.intlen = dfies.getInt("INTLEN");
        this.decimals = dfies.getInt("DECIMALS");
    }

    public String getDatatype() {
        return this.datatype;
    }

    public String getInttype() {
        return this.inttype;
    }

    public int getIntlen() {
        return this.intlen;
    }

    public int getDDLeng() {
        return this.leng;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public static boolean isBuiltIn(String datatype) {
        return datatypes.contains(datatype.toUpperCase());
    }

    public String toString() {
        return this.getClass().getName() + " " + this.datatype + " " + this.leng;
    }
}

