/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mdi;

import com.sap.mdi.SmartCollectionSequentialIterator;
import com.sap.mdi.SmartCollectionSortedIterator;
import com.sap.mdi.StringComparator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

class SmartCollection {
    SortedMap keys = new TreeMap(new StringComparator());
    List items;

    public SmartCollection() {
        this(0);
    }

    public SmartCollection(int initialCapacity) {
        this.items = new ArrayList(initialCapacity);
    }

    public synchronized boolean add(Object item, String key) {
        if (this.keys.containsKey(key)) {
            return false;
        }
        this.items.add(item);
        this.keys.put(key, new Integer(this.items.size() - 1));
        return true;
    }

    public synchronized boolean exists(String key) {
        return this.keys.containsKey(key);
    }

    public synchronized Object getItem(int index) {
        return this.items.get(index);
    }

    public synchronized Object getItem(String key) {
        if (!this.exists(key)) {
            return null;
        }
        return this.items.get((Integer)this.keys.get(key));
    }

    public Iterator getSequentialIterator() {
        return new SmartCollectionSequentialIterator(this);
    }

    public synchronized int getSize() {
        return this.items.size();
    }

    public Iterator getSortedIterator() {
        return new SmartCollectionSortedIterator(this);
    }
}

