/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mdi;

import com.sap.mdi.AKHNode;
import com.sap.mdi.BOException;
import com.sap.mdi.BOKeyField;
import com.sap.mdi.BOMethod;
import com.sap.mdi.BOParameter;
import com.sap.mdi.BOTreeNode;
import com.sap.mdi.BOType;
import com.sap.mdi.BOTypes;
import com.sap.mdi.CheckTableDescriptor;
import com.sap.mdi.CheckTableDescriptors;
import com.sap.mdi.Client;
import com.sap.mdi.Clients;
import com.sap.mdi.CompanyCode;
import com.sap.mdi.CompanyCodes;
import com.sap.mdi.ControllingArea;
import com.sap.mdi.ControllingAreas;
import com.sap.mdi.ConversionExitBadBapiReturnCodeException;
import com.sap.mdi.ConversionExitConnectionException;
import com.sap.mdi.ConversionExitDescriptor;
import com.sap.mdi.ConversionExitDescriptors;
import com.sap.mdi.ConversionExitException;
import com.sap.mdi.ConversionExitFunctionNotFoundException;
import com.sap.mdi.ConversionExitNotSupportedException;
import com.sap.mdi.Copyright;
import com.sap.mdi.Countries;
import com.sap.mdi.Currencies;
import com.sap.mdi.Currency;
import com.sap.mdi.DocuLink;
import com.sap.mdi.DocuLinks;
import com.sap.mdi.Documentation;
import com.sap.mdi.Documentations;
import com.sap.mdi.Feature;
import com.sap.mdi.Features;
import com.sap.mdi.Field;
import com.sap.mdi.FieldTexts;
import com.sap.mdi.FixedValuesDescriptor;
import com.sap.mdi.FixedValuesDescriptors;
import com.sap.mdi.GenericCollection;
import com.sap.mdi.GenericCollectionBadBapiReturnCodeException;
import com.sap.mdi.GenericCollectionConnectionException;
import com.sap.mdi.GenericCollectionException;
import com.sap.mdi.GenericCollectionFunctionNotFoundException;
import com.sap.mdi.GenericCollectionNotSupportedException;
import com.sap.mdi.GenericCollectionNotTwoColumnsException;
import com.sap.mdi.GenericItem;
import com.sap.mdi.HelpvaluesField;
import com.sap.mdi.HelpvaluesFields;
import com.sap.mdi.HelpvaluesInformation;
import com.sap.mdi.IDocMessageType;
import com.sap.mdi.IDocMessageTypes;
import com.sap.mdi.IDocSegment;
import com.sap.mdi.IDocSegmentField;
import com.sap.mdi.IDocSegmentFieldValue;
import com.sap.mdi.IDocSegments;
import com.sap.mdi.IDocType;
import com.sap.mdi.IDocTypeExtension;
import com.sap.mdi.IDocTypeExtensions;
import com.sap.mdi.IDocTypes;
import com.sap.mdi.MatchCode;
import com.sap.mdi.MatchCodeCondition;
import com.sap.mdi.MatchCodeConditions;
import com.sap.mdi.MatchCodes;
import com.sap.mdi.MatchCodesDescriptor;
import com.sap.mdi.MatchCodesDescriptors;
import com.sap.mdi.MetaDataAccessConnectionException;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.MetaDataAccessFunctionNotFoundException;
import com.sap.mdi.MetaDataAccessNotBasedOnDictionaryException;
import com.sap.mdi.ObjectFactoryException;
import com.sap.mdi.POReleaseGroups;
import com.sap.mdi.Plants;
import com.sap.mdi.PurchasingGroups;
import com.sap.mdi.Rfm;
import com.sap.mdi.RfmException;
import com.sap.mdi.RfmExceptions;
import com.sap.mdi.RfmParameter;
import com.sap.mdi.RfmParameters;
import com.sap.mdi.Rfms;
import com.sap.mdi.SalesOrganizations;
import com.sap.mdi.SmartCollection;
import com.sap.mdi.SpecificCollection;
import com.sap.mdi.SpecificItem;
import com.sap.mdi.StaticHelper;
import com.sap.mdi.Structure;
import com.sap.mdi.Structures;
import com.sap.mdi.UnitOfMeasure;
import com.sap.mdi.UnitsOfMeasure;
import com.sap.mdi.UnitsOfMeasureISO;
import com.sap.mdi.ValuationArea;
import com.sap.mdi.ValuationAreas;
import com.sap.mdi.ddtypes.DDDatabaseStructure;
import com.sap.mdi.ddtypes.DDDataelement;
import com.sap.mdi.ddtypes.DDFactory;
import com.sap.mdi.ddtypes.DDFlatStructure;
import com.sap.mdi.ddtypes.DDObject;
import com.sap.mdi.ddtypes.DDStructure;
import com.sap.mdi.ddtypes.DDTabletype;
import com.sap.mw.jco.IMetaData;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public final class ObjectFactory {
    private static Copyright copyright = new Copyright();
    private static final String release = "SAP 2.0.0";
    private JCO.Client mConnection = null;
    private IRepository mRepository = null;
    private Features mSupported = new Features();
    private Rfms mRfms = null;
    private Structures mStructures = null;
    private Documentations mDocumentations = null;
    private String mSapDateFormat = null;
    private String mSapDecimalSymbol = null;
    private String mSapRelease = null;
    private String mUserName = null;
    private String mUserLogonLanguage = null;
    private SmartCollection mGenericCollections;
    private AKHNode akhRoot = null;
    private BOTypes boTypes = null;
    private BOTypes biTypes = null;
    private BOTreeNode boRoot = null;
    private IDocMessageTypes iDocMessageTypes = null;
    private Clients clients = null;
    private CompanyCodes companyCodes = null;
    private ControllingAreas controllingAreas = null;
    private Countries countries = null;
    private Currencies currencies = null;
    private static CheckTableDescriptors mCheckTableDescriptors;
    private static ConversionExitDescriptors mConversionExitDescriptors;
    private static FixedValuesDescriptors mFixedValuesDescriptors;
    private MatchCodes mMatchCodesCustomer = null;
    private static MatchCodesDescriptors mMatchCodesDescriptors;
    private MatchCodes mMatchCodesSupplier = null;
    private SapData mSapData;
    private Plants plants = null;
    private POReleaseGroups poReleaseGroups = null;
    private PurchasingGroups purchasingGroups = null;
    private SalesOrganizations salesOrganizations = null;
    private UnitsOfMeasure unitsOfMeasure = null;
    private UnitsOfMeasureISO unitsOfMeasureISO = null;
    private ValuationAreas valuationAreas = null;
    DDFactory df = null;

    ObjectFactory() {
        this.mSupported.add("AKH", "RS_COMPONENT_VIEW", false, false);
        this.mSupported.add("CURRENCY_DIRECT", "BAPI_CURRENCY_GETDECIMALS", false, false);
        this.mSupported.add("CURRENCY_SAPDATA", "BAPI_HELPVALUES_GET", false, false);
        this.mSupported.add("DOCUMENTATION", "DOCU_HTML_GET", false, false);
        this.mSupported.add("IDOC_MESSAGE_TYPES", "IDOCTYPES_LIST_WITH_MESSAGES", false, false);
        this.mSupported.add("IDOC_TYPES", "IDOCTYPES_LIST_WITH_MESSAGES", false, false);
        this.mSupported.add("RFM_DEVCLASS_COMPONENT_ID", "RFC_FUNCTION_SEARCH_WITHGROUP", false, false);
        this.mSupported.add("RFM_RELEASED", "RFC_FUNCTION_SEARCH_WITHGROUP", false, false);
        this.mSupported.add("UC_LEN_SET", "DDIF_FIELDINFO_GET", false, false);
        this.mSupported.add("RFC_FUNCTION_SEARCH", "RFC_FUNCTION_SEARCH", false, false);
        this.mSupported.add("RFC_FUNCTION_SEARCH_WITHGROUP", "RFC_FUNCTION_SEARCH_WITHGROUP", false, false);
        this.mSupported.add("RFC_GROUP_STRUCTURE2", "RFC_FUNCTION_SEARCH_WITHGROUP", false, false);
    }

    public synchronized boolean commitWork() {
        try {
            JCO.Function function = this.createFunction("BAPI_TRANSACTION_COMMIT");
            this.getConnection().execute(function);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    synchronized boolean existsRfm(Rfms rfms, String name) throws MetaDataAccessException {
        Rfm rfm;
        JCO.Table paramsTab;
        if (rfms.internalCollection.exists(name)) {
            return true;
        }
        JCO.Function function = this.createFunction("RFC_GET_FUNCTION_INTERFACE");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("RFC_GET_FUNCTION_INTERFACE");
        }
        try {
            function.getImportParameterList().setValue(name.toUpperCase(), "FUNCNAME");
            function.getImportParameterList().setValue(this.getUserLogonLanguage(), "LANGUAGE");
            this.getConnection().execute(function);
            paramsTab = function.getTableParameterList().getTable("PARAMS");
            RfmParameters params = new RfmParameters();
            RfmExceptions exceptions = new RfmExceptions();
            int i = 0;
            if (paramsTab.getNumRows() > 0) {
                do {
                    rfms.processOneParameter(paramsTab, params, exceptions);
                    ++i;
                } while (paramsTab.nextRow());
            }
            rfm = new Rfm(name.toUpperCase(), params, exceptions);
            rfm.parent = rfms;
            rfms.add(rfm, rfm.getName());
        }
        catch (JCO.AbapException ex) {
            if (ex.getKey().equalsIgnoreCase("FU_NOT_FOUND")) {
                return false;
            }
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
        if (this.getSapRelease().compareTo("46B") < 0) {
            function = this.createFunction("FUNCTION_IMPORT_INTERFACE");
            if (function == null) {
                throw new MetaDataAccessFunctionNotFoundException("FUNCTION_IMPORT_INTERFACE");
            }
            try {
                function.getImportParameterList().setValue(name.toUpperCase(), "FUNCNAME");
                this.getConnection().execute(function);
                paramsTab = function.getTableParameterList().getTable("TABLES_PARAMETER");
                int count = paramsTab.getNumRows();
                int i = 0;
                while (i < count) {
                    paramsTab.setRow(i);
                    RfmParameter p = rfm.params.getRfmParameter(paramsTab.getString("PARAMETER"));
                    if (p != null) {
                        p.isOptional = paramsTab.getString("OPTIONAL").equals("X");
                    }
                    ++i;
                }
                paramsTab = function.getTableParameterList().getTable("IMPORT_PARAMETER");
                count = paramsTab.getNumRows();
                int i2 = 0;
                while (i2 < count) {
                    paramsTab.setRow(i2);
                    RfmParameter p = rfm.params.getRfmParameter(paramsTab.getString("PARAMETER"));
                    if (p != null) {
                        p.isOptional = paramsTab.getString("OPTIONAL").equals("X");
                    }
                    ++i2;
                }
            }
            catch (JCO.Exception ex) {
                throw new MetaDataAccessConnectionException((Exception)((Object)ex));
            }
            catch (Exception ex) {
                throw new MetaDataAccessException(ex);
            }
        }
        return true;
    }

    public synchronized AKHNode getAKHRoot() throws MetaDataAccessException {
        if (this.akhRoot == null) {
            this.akhRoot = new AKHNode();
            this.akhRoot.init(this);
        }
        return this.akhRoot;
    }

    public synchronized BOTypes getBITypes() throws MetaDataAccessException {
        if (this.biTypes == null) {
            this.biTypes = new BOTypes();
            this.biTypes.init(this, true);
        }
        return this.biTypes;
    }

    public synchronized BOTreeNode getBORTreeRoot() throws MetaDataAccessException {
        if (this.boRoot == null) {
            this.boRoot = new BOTreeNode();
            this.boRoot.init(this);
        }
        return this.boRoot;
    }

    public synchronized BOTypes getBOTypes() throws MetaDataAccessException {
        if (this.boTypes == null) {
            this.boTypes = new BOTypes();
            this.boTypes.init(this);
        }
        return this.boTypes;
    }

    public static String getCopyright() {
        return copyright.toString();
    }

    public synchronized Currency getCurrency(String code) throws GenericCollectionException {
        Currency c = (Currency)this.currencies.getInternalItem(code);
        if (c != null) {
            return c;
        }
        JCO.Function function = this.createFunction("BAPI_CURRENCY_GETDECIMALS");
        if (function == null) {
            return null;
        }
        function.getImportParameterList().setValue(code, "CURRENCY");
        this.getConnection().execute(function);
        JCO.Structure returnStructure = function.getExportParameterList().getStructure("RETURN");
        if (!ObjectFactory.isBapiReturnCodeOkay((JCO.Record)returnStructure)) {
            return null;
        }
        JCO.Structure details = function.getExportParameterList().getStructure("CURRENCY_DECIMALS");
        Currency currency = new Currency();
        currency.setInternalCode(code);
        currency.isoCode = details.getString("CURRENCY_ISO");
        currency.decimals = details.getInt("CURDECIMALS");
        currency.initialized = true;
        this.currencies.add(currency);
        return currency;
    }

    public String getDefaultForScalarImportParameter(String pRfmName, String pParameterName) throws MetaDataAccessException {
        return this.getRfm(pRfmName).getRfmParameters().getRfmParameter(pParameterName).getScalarDefaultValue();
    }

    public Documentation getDocumentation(String id, String name) throws MetaDataAccessException {
        return this.getDocumentations().getDocumentation(id.toUpperCase(), name.toUpperCase());
    }

    public Documentation getDocumentation(String id, String name, String language) throws MetaDataAccessException {
        return this.getDocumentations().getDocumentation(id.toUpperCase(), name.toUpperCase(), language.toUpperCase());
    }

    synchronized Documentations getDocumentations() {
        if (this.mDocumentations == null) {
            this.mDocumentations = new Documentations(this);
        }
        return this.mDocumentations;
    }

    synchronized boolean existsDocumentation(Documentations documentations, String id, String name, String language) throws MetaDataAccessException {
        String key = id + name + language;
        String document = "";
        DocuLinks docuLinks = new DocuLinks();
        if (documentations.internalCollection.exists(key)) {
            return true;
        }
        JCO.Function function = this.createFunction("DOCU_HTML_GET");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("DOCU_HTML_GET");
        }
        try {
            function.getImportParameterList().setValue(id, "IV_ID");
            function.getImportParameterList().setValue(name, "IV_OBJECT");
            function.getImportParameterList().setValue(language, "IV_LANGUAGE");
            function.getImportParameterList().setValue("X", "IV_LINKS");
            this.getConnection().execute(function);
            JCO.Table documentTab = function.getExportParameterList().getTable("EV_HTML_TABLE");
            JCO.Table linksTab = function.getExportParameterList().getTable("EV_HTML_LINKS");
            int numRows = documentTab.getNumRows();
            int[] docLen = new int[numRows];
            if (numRows > 0) {
                int i = 0;
                do {
                    docLen[i] = document.length();
                    ++i;
                    document = document + documentTab.getString("TDLINE") + " ";
                } while (documentTab.nextRow());
            } else {
                return false;
            }
            if (linksTab.getNumRows() > 0) {
                do {
                    int line = linksTab.getInt("LINE");
                    int linkPosition = docLen[line - 1] + linksTab.getInt("POSITION");
                    int linkLength = linksTab.getInt("LENGTH");
                    String linkId = linksTab.getString("ID");
                    String linkName = linksTab.getString("OBJECT");
                    DocuLink docuLink = new DocuLink(linkPosition, linkLength, linkId, linkName);
                    docuLinks.add(docuLink);
                } while (linksTab.nextRow());
            }
            Documentation documentation = new Documentation(id, name, language, document, docuLinks);
            documentations.add(documentation, key.toUpperCase());
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
        return true;
    }

    public synchronized boolean getHasBAPIs(String objType) throws MetaDataAccessException {
        if (this.getSapRelease().compareTo("40B") < 0) {
            String name = this.getObjectNameIfHasBAPIs31(objType);
            return name != null;
        }
        JCO.Function function = this.createFunction("SWO_QUERY_OBJTYPE_INFO");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("SWO_QUERY_OBJTYPE_INFO");
        }
        try {
            function.getImportParameterList().setValue(objType, "OBJTYPE");
            this.getConnection().execute(function);
            JCO.Table verbs = function.getTableParameterList().getTable("VERBS");
            if (verbs.getNumRows() > 0) {
                do {
                    String type;
                    if (!(type = verbs.getString("VERBTYPE")).equals("M") || !verbs.getString("ISAPI").equals("X")) continue;
                    return true;
                } while (verbs.nextRow());
            }
            return false;
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
    }

    public synchronized IDocMessageTypes getIDocMessageTypes() throws MetaDataAccessException {
        if (this.iDocMessageTypes == null) {
            this.iDocMessageTypes = new IDocMessageTypes();
            this.iDocMessageTypes.init(this);
        }
        return this.iDocMessageTypes;
    }

    public synchronized IDocType getIDocType(String name) throws MetaDataAccessException {
        if (this.iDocMessageTypes == null) {
            this.iDocMessageTypes = new IDocMessageTypes();
            this.iDocMessageTypes.init(this);
        }
        IDocType iDocType = null;
        boolean i = false;
        Iterator iterator = this.iDocMessageTypes.getIterator();
        while (iterator.hasNext()) {
            iDocType = ((IDocMessageType)iterator.next()).getIDocTypes().getIDocType(name);
            if (iDocType != null) break;
        }
        return iDocType;
    }

    public String getRelease() {
        return release;
    }

    public synchronized IRepository getRepository() {
        return this.mRepository;
    }

    public Rfm getRfm(String name) throws MetaDataAccessException {
        return this.getRfms().getRfm(name);
    }

    public synchronized Rfms getRfms() {
        if (this.mRfms == null) {
            this.mRfms = new Rfms(this);
        }
        return this.mRfms;
    }

    public synchronized String getSapDateFormat() {
        if (this.mSapDateFormat != null) {
            return this.mSapDateFormat;
        }
        try {
            this.getUserLogonLanguage();
            return this.mSapDateFormat;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public synchronized String getSapDecimalSymbol() {
        if (this.mSapDecimalSymbol != null) {
            return this.mSapDecimalSymbol;
        }
        try {
            this.getUserLogonLanguage();
            return this.mSapDecimalSymbol;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public String getSapRelease() {
        if (this.mSapRelease != null) {
            return this.mSapRelease;
        }
        this.mSapRelease = this.getConnection().getAttributes().getPartnerRelease();
        return this.mSapRelease;
    }

    Structure getStructure(String name) throws MetaDataAccessException {
        return this.getStructures().getStructure(name);
    }

    synchronized Structures getStructures() {
        if (this.mStructures == null) {
            this.mStructures = new Structures(this);
        }
        return this.mStructures;
    }

    synchronized Structure getStructureStructures(Structures structures, String name) throws MetaDataAccessException {
        String upperCaseName = name.toUpperCase();
        Structure s = null;
        JCO.Table dfiesFields = null;
        if (upperCaseName.equals("SY")) {
            upperCaseName = "SYST";
        }
        if (structures.internalCollection.exists(upperCaseName)) {
            return (Structure)structures.internalCollection.getItem(upperCaseName);
        }
        JCO.Function function = this.createFunction("DDIF_FIELDINFO_GET");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("DDIF_FIELDINFO_GET");
        }
        try {
            JCO.ParameterList importParameter = function.getImportParameterList();
            importParameter.setValue(upperCaseName, "TABNAME");
            importParameter.setValue("", "FIELDNAME");
            if (importParameter.hasField("ALL_TYPES")) {
                importParameter.setValue("X", "ALL_TYPES");
            }
            this.getConnection().execute(function);
            dfiesFields = function.getTableParameterList().getTable("DFIES_TAB");
            s = new Structure(upperCaseName, dfiesFields.getNumRows(), structures);
            JCO.Structure struct = function.getExportParameterList().getStructure("X030L_WA");
            s.length = StaticHelper.toInt(struct.getByteArray("TABLEN"));
            s.isTable = struct.getString("TABTYPE").equals("T");
            if (dfiesFields.getNumRows() > 0) {
                int i = 0;
                do {
                    Field f = new Field();
                    f.parent = s.fields;
                    f.index = i;
                    f.checkTable = dfiesFields.getString("CHECKTABLE");
                    f.conversionExit = dfiesFields.getString("CONVEXIT");
                    f.dataElementName = dfiesFields.getString("ROLLNAME");
                    f.dataTypeABAP = dfiesFields.getString("INTTYPE");
                    f.dataTypeDD = dfiesFields.getString("DATATYPE");
                    f.decimals = dfiesFields.getInt("DECIMALS");
                    f.domainName = dfiesFields.getString("DOMNAME");
                    f.hasValueList = dfiesFields.getString("VALEXI").equals("X");
                    f.internalLength = dfiesFields.getInt("INTLEN");
                    f.isKeyField = dfiesFields.getString("KEYFLAG").equals("X");
                    f.isSignedNumber = dfiesFields.getString("SIGN").equals("X");
                    f.length = dfiesFields.getInt("LENG");
                    f.name = dfiesFields.getString("FIELDNAME");
                    f.outputLength = dfiesFields.getInt("OUTPUTLEN");
                    f.offset = dfiesFields.getInt("OFFSET");
                    f.parameterId = dfiesFields.getString("MEMORYID");
                    f.referenceField = dfiesFields.getString("REFFIELD");
                    f.referenceTable = dfiesFields.getString("REFTABLE");
                    f.supportsMixedCase = dfiesFields.getString("LOWERCASE").equals("X");
                    f.writesChangeDocuments = dfiesFields.getString("LOGFLAG").equals("X");
                    f.fieldTexts.columnHeading = dfiesFields.getString("REPTEXT");
                    f.fieldTexts.labelLong = dfiesFields.getString("SCRTEXT_L");
                    f.fieldTexts.labelMedium = dfiesFields.getString("SCRTEXT_M");
                    f.fieldTexts.labelShort = dfiesFields.getString("SCRTEXT_S");
                    f.fieldTexts.description = dfiesFields.getString("FIELDTEXT");
                    try {
                        f.hasSearchHelpSupport = dfiesFields.getString("F4AVAILABL").equals("X");
                    }
                    catch (Exception ex) {
                        f.hasSearchHelpSupport = !f.checkTable.equals("") || f.hasValueList;
                    }
                    s.fields.add(f);
                    ++i;
                } while (dfiesFields.nextRow());
            }
            structures.internalCollection.add(s, s.getName());
        }
        catch (JCO.AbapException ex) {
            if (ex.getKey().equalsIgnoreCase("NOT_FOUND")) {
                return null;
            }
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
        if (this.getSapRelease().compareTo("40B") < 0) {
            function = this.createFunction("RFC_GET_STRUCTURE_DEFINITION");
            if (function == null) {
                throw new MetaDataAccessFunctionNotFoundException("RFC_GET_STRUCTURE_DEFINITION");
            }
            try {
                function.getImportParameterList().setValue(upperCaseName, "TABNAME");
                this.getConnection().execute(function);
                dfiesFields = function.getTableParameterList().getTable("FIELDS");
                int count = dfiesFields.getNumRows();
                int i = 0;
                while (i < count) {
                    dfiesFields.setRow(i);
                    Field f = s.getField(dfiesFields.getString("FIELDNAME"));
                    if (f != null) {
                        f.dataTypeABAP = dfiesFields.getString("EXID");
                    }
                    ++i;
                }
            }
            catch (JCO.Exception ex) {
                throw new MetaDataAccessConnectionException((Exception)((Object)ex));
            }
            catch (Exception ex) {
                throw new MetaDataAccessException(ex);
            }
        }
        return s;
    }

    public synchronized String getUserLogonLanguage() {
        if (this.mUserLogonLanguage != null) {
            return this.mUserLogonLanguage;
        }
        ObjectFactory objectFactory = this;
        synchronized (objectFactory) {
            if (this.mUserLogonLanguage != null) {
                String string = this.mUserLogonLanguage;
                return string;
            }
            this.mUserLogonLanguage = "";
            this.mSapDateFormat = "";
            this.mSapDecimalSymbol = "";
            try {
                JCO.Function function = this.createFunction("RFC_GET_SAP_SYSTEM_PARAMETERS");
                this.getConnection().execute(function);
                this.mUserLogonLanguage = function.getExportParameterList().getString("LANGUAGE");
                this.mSapDateFormat = function.getExportParameterList().getString("DATE_FORMAT");
                this.mSapDecimalSymbol = function.getExportParameterList().getString("DECIMAL_SIGN");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.mUserLogonLanguage == null || this.mUserLogonLanguage.equals("")) {
                String string = this.getConnection().getLanguage();
                return string;
            }
            String string = this.mUserLogonLanguage;
            return string;
        }
    }

    public String getUserName() {
        if (this.mUserName != null) {
            return this.mUserName;
        }
        this.mUserName = this.getConnection().getUser();
        return this.mUserName;
    }

    synchronized void initAsyncBOMethod(BOMethod boMethod) throws MetaDataAccessException {
        JCO.Function function = this.createFunction("ALE_ASYNC_BAPI_TO_IDOC");
        if (function == null) {
            boMethod.asyncIDocType = "";
            boMethod.asyncMessageType = "";
            boMethod.asyncInitialized = true;
            return;
        }
        try {
            function.getImportParameterList().setValue(boMethod.parent.parent.getObjectName(), "OBJECTNAME");
            function.getImportParameterList().setValue(boMethod.name, "METHOD");
            this.getConnection().execute(function);
            JCO.Structure asyncInfo = function.getExportParameterList().getStructure("BAPI_ALE_INTERFACE");
            boMethod.asyncIDocType = asyncInfo.getString("IDOCTYPE");
            boMethod.asyncMessageType = asyncInfo.getString("MESTYPE");
            boMethod.asyncInitialized = true;
        }
        catch (JCO.AbapException ex) {
            if (ex.getKey().equalsIgnoreCase("NO_ALE_INTERFACE") || ex.getKey().equalsIgnoreCase("INTERNAL_ERROR")) {
                boMethod.asyncIDocType = "";
                boMethod.asyncMessageType = "";
                boMethod.asyncInitialized = true;
            }
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
    }

    synchronized void initAKHNodes(AKHNode rootNode) throws MetaDataAccessException {
        SmartCollection keys = new SmartCollection();
        JCO.Function function = this.createFunction("RS_COMPONENT_VIEW");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("RS_COMPONENT_VIEW");
        }
        try {
            function.getImportParameterList().setValue(this.getUserLogonLanguage(), "LANGUAGE");
            this.getConnection().execute(function);
            JCO.Table akhTree = function.getTableParameterList().getTable("NODETAB");
            rootNode.parent = null;
            rootNode.nr = akhTree.getString("ID");
            rootNode.id = akhTree.getString("HIDE");
            rootNode.description = akhTree.getString("TEXT");
            rootNode.name = rootNode.fullname = akhTree.getString("NAME");
            if (akhTree.getString("CHILD").equals("000000")) {
                rootNode.leaf = true;
            }
            keys.add(rootNode, rootNode.nr);
            while (akhTree.nextRow()) {
                AKHNode parent = (AKHNode)keys.getItem(akhTree.getString("PARENT"));
                AKHNode child = new AKHNode();
                child.parent = parent;
                child.nr = akhTree.getString("ID");
                child.id = akhTree.getString("HIDE");
                child.description = akhTree.getString("TEXT");
                child.fullname = akhTree.getString("NAME");
                int pos = child.fullname.lastIndexOf(45);
                child.name = pos > 0 ? child.fullname.substring(pos + 1) : child.fullname;
                child.leaf = akhTree.getString("CHILD").equals("000000");
                keys.add(child, child.nr);
                parent.children.add(child, child.id);
            }
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
    }

    synchronized void initBOTreeNode(BOTreeNode boTreeNode) throws MetaDataAccessException {
        SmartCollection keys = new SmartCollection();
        JCO.Function function = this.createFunction("RPY_BOR_TREE_INIT");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("RPY_BOR_TREE_INIT");
        }
        try {
            JCO.Table objects = function.getTableParameterList().getTable("OBJECT_TYPE_ID_SET");
            BOTypes boTypes = this.getBOTypes();
            int i = 0;
            while (i < boTypes.getSize()) {
                BOType boType = boTypes.getBOType(i);
                objects.appendRow();
                objects.setValue(boType.getObjectType(), "OBJTYPE_ID");
                ++i;
            }
            JCO.Structure struct = function.getImportParameterList().getStructure("FILTER_OBJECT_TYPES");
            function.getImportParameterList().getStructure("FILTER_OBJECT_TYPES").setValue("X", "ALLOBJTYPS");
            function.getImportParameterList().getStructure("FILTER_MISCELLANEOUS").setValue("X", "COMPHIER");
            this.getConnection().execute(function);
            JCO.Table borTree = function.getTableParameterList().getTable("BOR_TREE");
            boTreeNode.parent = null;
            boTreeNode.isBOType = false;
            boTreeNode.boType = null;
            boTreeNode.name = borTree.getString("NAME");
            boTreeNode.description = borTree.getString("SHORT_TEXT");
            keys.add(boTreeNode, borTree.getString("ID"));
            while (borTree.nextRow()) {
                String id = borTree.getString("ID");
                BOTreeNode parent = (BOTreeNode)keys.getItem(borTree.getString("PARENT"));
                BOTreeNode child = new BOTreeNode();
                keys.add(child, id);
                child.parent = parent;
                child.isBOType = borTree.getString("TYPE").equals("0");
                if (child.isBOType) {
                    child.boType = boTypes.getBOTypeByObjectType(borTree.getString("INT_ID"));
                    child.name = borTree.getString("EXT_NAME");
                } else {
                    child.boType = null;
                    child.name = borTree.getString("NAME");
                }
                child.description = borTree.getString("SHORT_TEXT");
                if (child.isBOType) {
                    parent.children.add(child, child.name);
                    continue;
                }
                String paddedId = "ZZZZZZZZ" + StaticHelper.repeat("0", 10 - id.length()) + id;
                parent.children.add(child, paddedId);
            }
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
    }

    synchronized void initBOType(BOType boType) throws MetaDataAccessException {
        if (this.getSapRelease().compareTo("40B") < 0) {
            this.initBOType31(boType);
            return;
        }
        JCO.Function function = this.createFunction("SWO_QUERY_OBJTYPE_INFO");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("SWO_QUERY_OBJTYPE_INFO");
        }
        try {
            BOMethod boMethod;
            BOKeyField boKeyField;
            function.getImportParameterList().setValue(boType.getObjectType(), "OBJTYPE");
            function.getImportParameterList().setValue("X", "TEXT");
            function.getImportParameterList().setValue(this.getUserLogonLanguage(), "LANGUAGE");
            this.getConnection().execute(function);
            boType.initialized = true;
            JCO.Structure baseData = function.getExportParameterList().getStructure("BASEDATA");
            String s = baseData.getString("MODOBJTYPE");
            if (!s.equals(boType.getObjectType())) {
                boType.delegationObjectType = s;
            }
            boType.parentObjectType = baseData.getString("PARENT");
            boType.isReleased = baseData.getString("MODELONLY").equals("R") || baseData.getString("RELEASED").equals("X");
            boType.releaseCreated = baseData.getString("CREA_REL");
            boType.releaseChanged = baseData.getString("CHAN_REL");
            boType.releaseReleased = baseData.getString("REL_REL");
            boType.releaseObsolete = baseData.getString("OBSOLETE");
            JCO.Table verbs = function.getTableParameterList().getTable("VERBS");
            JCO.Table parameters = function.getTableParameterList().getTable("PARAMETERS");
            BOKeyField[] boKeyFieldArray = new BOKeyField[20];
            int keyFields = 0;
            if (verbs.getNumRows() > 0) {
                do {
                    String type;
                    if ((type = verbs.getString("VERBTYPE")).equals("K")) {
                        ++keyFields;
                        boKeyField = new BOKeyField(verbs.getString("EDITELEM"), verbs.getString("SHORTTEXT"), verbs.getString("REFSTRUCT"), verbs.getString("REFFIELD"), verbs.getString("INTATYPE"), verbs.getInt("INTLENGTH"), verbs.getInt("OUTLENGTH"), verbs.getString("LOWERCASE").equals("X"), verbs.getString("CONVEXIT"));
                        int position = verbs.getInt("EDITORDER") - 1;
                        boKeyFieldArray[position] = boKeyField;
                        continue;
                    }
                    if (!type.equals("M") || !verbs.getString("ISAPI").equals("X")) continue;
                    boMethod = new BOMethod(verbs.getString("EDITELEM"), verbs.getString("SHORTTEXT"), verbs.getString("ABAPNAME"), verbs.getString("CLASSVERB").equals("X"));
                    boMethod.parent = boType.boMethods;
                    boMethod.index = boType.boMethods.getSize();
                    boType.boMethods.add(boMethod, boMethod.getName().toUpperCase());
                    boMethod.isFactoryMethod = verbs.getString("FACTORY").equals("X");
                    boMethod.isReleased = verbs.getString("MODELONLY").equals("R");
                    boMethod.releaseCreated = verbs.getString("CREA_REL");
                    boMethod.releaseObsolete = verbs.getString("OBSOLETE");
                    boMethod.usesDialog = verbs.getString("DIALOG").equals("X");
                } while (verbs.nextRow());
            }
            int i = 0;
            while (i < keyFields) {
                boKeyField = boKeyFieldArray[i];
                boKeyField.parent = boType.boKeyFields;
                boKeyField.index = boType.boKeyFields.getSize();
                boType.boKeyFields.add(boKeyField, boKeyField.getName().toUpperCase());
                ++i;
            }
            if (parameters.getNumRows() > 0) {
                do {
                    String type;
                    if ((type = parameters.getString("PARAMTYPE")).equals("R")) {
                        String exception = parameters.getString("FUNCEXCEPT");
                        if (exception.equals("") || (boMethod = boType.getBOMethods().getBOMethod(parameters.getString("VERB"))) == null) continue;
                        BOException boException = new BOException(exception, parameters.getString("SHORTTEXT"), parameters.getString("CREA_REL"), parameters.getString("ARBGB"), parameters.getString("MSGNR"), parameters.getString("ELEMENT"));
                        boException.parent = boMethod.boExceptions;
                        boException.index = boMethod.boExceptions.getSize();
                        boMethod.boExceptions.add(boException, boException.getName().toUpperCase());
                        continue;
                    }
                    if (!type.equals("M") || (boMethod = boType.getBOMethods().getBOMethod(parameters.getString("VERB"))) == null) continue;
                    BOParameter boParameter = !parameters.getString("INTATYPE").equals("u") ? new BOParameter(parameters.getString("EDITELEM"), parameters.getString("SHORTTEXT"), parameters.getString("OBLIGIMP").equals(""), parameters.getString("ELEMTYPE"), parameters.getString("FUNCPNAME"), parameters.getString("REFSTRUCT"), parameters.getString("REFFIELD"), parameters.getString("INTATYPE"), parameters.getInt("INTLENGTH"), parameters.getInt("OUTLENGTH"), parameters.getInt("DECIMALS"), parameters.getString("LOWERCASE").equals("X"), parameters.getString("CONVEXIT"), parameters.getString("CREA_REL")) : new BOParameter(parameters.getString("EDITELEM"), parameters.getString("SHORTTEXT"), parameters.getString("OBLIGIMP").equals(""), parameters.getString("ELEMTYPE"), parameters.getString("FUNCPNAME"), parameters.getString("REFSTRUCT"), parameters.getInt("INTLENGTH"), parameters.getString("TABELEM").equals("X"), parameters.getString("CREA_REL"));
                    boParameter.parent = boMethod.boParameters;
                    boParameter.index = boMethod.boParameters.getSize();
                    boMethod.boParameters.add(boParameter, boParameter.getName().toUpperCase());
                } while (parameters.nextRow());
            }
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
    }

    synchronized void initBOTypes(BOTypes boTypes) throws MetaDataAccessException {
        if (this.getSapRelease().compareTo("40B") < 0) {
            this.initBOTypes31(boTypes);
            return;
        }
        boTypes.bof = this;
        JCO.Function function = this.createFunction("SWO_QUERY_API_OBJTYPES");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("SWO_QUERY_API_OBJTYPES");
        }
        try {
            function.getImportParameterList().setValue("X", "WITH_INTERNAL_API_METHODS");
        }
        catch (Exception ex) {
            // empty catch block
        }
        function.getImportParameterList().setValue("X", "WITH_IMPLEMENTED");
        function.getImportParameterList().setValue("X", "WITH_TEXTS");
        function.getImportParameterList().setValue("X", "WITH_OBJECT_NAMES");
        function.getImportParameterList().setValue(this.getUserLogonLanguage(), "LANGUAGE");
        try {
            this.getConnection().execute(function);
            JCO.Table objTypes = function.getTableParameterList().getTable("OBJTYPES");
            if (objTypes.getNumRows() > 0) {
                do {
                    BOType boType = new BOType(objTypes.getString("OBJNAME"), objTypes.getString("OBJTYPE"), objTypes.getString("SHORTTEXT"));
                    boType.parent = boTypes;
                    boType.index = boTypes.getSize();
                    boTypes.add(boType, boType.getObjectName() + "-" + boType.getObjectType());
                } while (objTypes.nextRow());
            }
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
    }

    synchronized void initBOTypes(BOTypes boTypes, boolean getInterfaces) throws MetaDataAccessException {
        if (!getInterfaces) {
            this.initBOTypes(boTypes);
            return;
        }
        if (this.getSapRelease().compareTo("40B") < 0) {
            return;
        }
        boTypes.bof = this;
        JCO.Function function = this.createFunction("SWO_QUERY_OBJTYPES");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("SWO_QUERY_OBJTYPES");
        }
        try {
            function.getImportParameterList().setValue("X", "WITH_INTERNAL_API_METHODS");
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            function.getImportParameterList().setValue("X", "OBJTYPECLASS_IF");
            function.getImportParameterList().setValue("*", "RELEASED");
            function.getImportParameterList().setValue("X", "WITH_IMPLEMENTED");
            function.getImportParameterList().setValue("X", "WITH_OBSOLETE");
            function.getImportParameterList().setValue(this.getUserLogonLanguage(), "LANGUAGE");
            this.getConnection().execute(function);
            JCO.Table objTypes = function.getTableParameterList().getTable("OBJTYPES");
            if (objTypes.getNumRows() > 0) {
                do {
                    String type;
                    if (!this.getHasBAPIs(type = objTypes.getString("OBJTYPE"))) continue;
                    String name = objTypes.getString("OBJNAME");
                    if (name.equals("")) {
                        name = type;
                    }
                    BOType boType = new BOType(name, type, objTypes.getString("SHORTTEXT"));
                    boType.parent = boTypes;
                    boType.index = boTypes.getSize();
                    boTypes.add(boType, boType.getObjectName() + "-" + boType.getObjectType());
                } while (objTypes.nextRow());
            }
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
    }

    synchronized void initDocumentationBOType(BOType boType) throws MetaDataAccessException {
        if (this.getSapRelease().compareTo("40B") < 0) {
            return;
        }
        JCO.Function function = this.createFunction("SWO_QUERY_OBJTYPE_DOCU");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("SWO_QUERY_OBJTYPE_DOCU");
        }
        try {
            function.getImportParameterList().setValue(boType.getObjectType(), "OBJTYPE");
            function.getImportParameterList().setValue("X", "API_ONLY");
            function.getImportParameterList().setValue("X", "WITH_COMPLETE_DOCUMENTATION");
            function.getImportParameterList().setValue(this.getUserLogonLanguage(), "LANGUAGE");
            this.getConnection().execute(function);
            boType.documentationInitialized = true;
            BOException boException = null;
            BOParameter boParameter = null;
            BOKeyField boKeyField = null;
            BOMethod boMethod = null;
            boolean inOB = false;
            boolean inK = false;
            boolean inM = false;
            boolean inMP = false;
            boolean inMR = false;
            int indexDocArray = 0;
            int lines = 0;
            JCO.Table documentationTab = function.getTableParameterList().getTable("DOCUMENTATION");
            if (documentationTab.getNumRows() > 0) {
                do {
                    if (inOB || inK || inM || inMP || inMR) {
                        if (inOB) {
                            boType.documentation[indexDocArray++] = documentationTab.getString("DOCU_LINE");
                            if (indexDocArray < lines) continue;
                            inOB = false;
                            continue;
                        }
                        if (inK) {
                            if (boKeyField != null) {
                                boKeyField.documentation[indexDocArray] = documentationTab.getString("DOCU_LINE");
                            }
                            if (++indexDocArray < lines) continue;
                            inK = false;
                            continue;
                        }
                        if (inM) {
                            if (boMethod != null) {
                                boMethod.documentation[indexDocArray] = documentationTab.getString("DOCU_LINE");
                            }
                            if (++indexDocArray < lines) continue;
                            inM = false;
                            continue;
                        }
                        if (inMP) {
                            if (boParameter != null) {
                                boParameter.documentation[indexDocArray] = documentationTab.getString("DOCU_LINE");
                            }
                            if (++indexDocArray < lines) continue;
                            inMP = false;
                            continue;
                        }
                        if (!inMR) continue;
                        if (boException != null) {
                            boException.documentation[indexDocArray] = documentationTab.getString("DOCU_LINE");
                        }
                        if (++indexDocArray < lines) continue;
                        inMR = false;
                        continue;
                    }
                    String type = documentationTab.getString("TYPE");
                    lines = Integer.valueOf(documentationTab.getString("LINES"));
                    if (type.equals("OB")) {
                        if (lines <= 0) continue;
                        inOB = true;
                        indexDocArray = 0;
                        boType.documentation = new String[lines];
                        continue;
                    }
                    if (type.equals("K")) {
                        if (lines <= 0) continue;
                        boKeyField = boType.getBOKeyFields().getBOKeyField(documentationTab.getString("DOCU_LINE"));
                        inK = true;
                        indexDocArray = 0;
                        if (boKeyField == null) continue;
                        boKeyField.documentation = new String[lines];
                        continue;
                    }
                    if (type.equals("M")) {
                        boMethod = boType.getBOMethods().getBOMethod(documentationTab.getString("DOCU_LINE"));
                        if (lines <= 0) continue;
                        inM = true;
                        indexDocArray = 0;
                        if (boMethod == null) continue;
                        boMethod.documentation = new String[lines];
                        continue;
                    }
                    if (type.equals("MP")) {
                        if (lines <= 0) continue;
                        boParameter = boMethod != null ? boMethod.getBOParameters().getBOParameter(documentationTab.getString("DOCU_LINE")) : null;
                        inMP = true;
                        indexDocArray = 0;
                        if (boParameter == null) continue;
                        boParameter.documentation = new String[lines];
                        continue;
                    }
                    if (!type.equals("MR") || lines <= 0) continue;
                    boException = boMethod != null ? boMethod.getBOExceptions().getBOException(documentationTab.getString("DOCU_LINE")) : null;
                    inMR = true;
                    indexDocArray = 0;
                    if (boException == null) continue;
                    boException.documentation = new String[lines];
                } while (documentationTab.nextRow());
            }
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
    }

    synchronized void initIDocMessageTypes(IDocMessageTypes iDocMessageTypes) throws MetaDataAccessException {
        JCO.Function function = this.createFunction("IDOCTYPES_LIST_WITH_MESSAGES");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("IDOCTYPES_LIST_WITH_MESSAGES");
        }
        IDocTypeExtensions iDocTypeExtensions = new IDocTypeExtensions();
        IDocTypes iDocTypes = new IDocTypes();
        iDocMessageTypes.bof = this;
        try {
            function.getImportParameterList().setValue("", "PI_RELEASE");
            this.getConnection().execute(function);
            JCO.Table messages = function.getTableParameterList().getTable("PT_MESSAGES");
            JCO.Table types = function.getTableParameterList().getTable("PT_IDOCTYPES");
            JCO.Table extensions = function.getTableParameterList().getTable("PT_EXTTYPES");
            int count = extensions.getNumRows();
            int i = 0;
            while (i < count) {
                extensions.setRow(i);
                IDocTypeExtension iDocTypeExtension = new IDocTypeExtension(extensions.getString("CIMTYP"), extensions.getString("DESCRP"), extensions.getString("RELEASED"), extensions.getString("DEVCLASS"), extensions.getString("IDOCTYP"));
                iDocTypeExtensions.add(iDocTypeExtension, iDocTypeExtension.getName());
                ++i;
            }
            count = types.getNumRows();
            int i2 = 0;
            while (i2 < count) {
                types.setRow(i2);
                IDocType iDocType = new IDocType(types.getString("IDOCTYP"), types.getString("DESCRP"), types.getString("RELEASED"), types.getString("DEVCLASS"), types.getString("GENERATED").equals("X"));
                iDocTypes.add(iDocType, iDocType.getName());
                ++i2;
            }
            count = messages.getNumRows();
            int i3 = 0;
            while (i3 < count) {
                IDocMessageType iDocMessageType;
                messages.setRow(i3);
                String s = messages.getString("MESTYP");
                if (!iDocMessageTypes.exists(s)) {
                    iDocMessageType = new IDocMessageType(s, messages.getString("DESCRP"));
                    iDocMessageType.parent = iDocMessageTypes;
                    iDocMessageType.index = iDocMessageTypes.getSize();
                    iDocMessageTypes.add(iDocMessageType, iDocMessageType.getName());
                } else {
                    iDocMessageType = iDocMessageTypes.getIDocMessageType(s);
                }
                s = messages.getString("IDOCTYP");
                if (iDocTypes.exists(s)) {
                    String t;
                    if (!iDocMessageType.getIDocTypes().exists(s)) {
                        IDocType iDocType = iDocTypes.getIDocType(s).getCopy();
                        iDocType.parent = iDocMessageType.getIDocTypes();
                        iDocType.index = iDocMessageType.getIDocTypes().getSize();
                        iDocMessageType.getIDocTypes().add(iDocType, iDocType.getName());
                    }
                    if (!(t = messages.getString("CIMTYP")).equals("") && iDocTypeExtensions.exists(t)) {
                        IDocType iDocType = iDocMessageType.getIDocTypes().getIDocType(s);
                        IDocTypeExtension iDocTypeExtension = iDocTypeExtensions.getIDocTypeExtension(t).getCopy();
                        iDocTypeExtension.parent = iDocType.getIDocTypeExtensions();
                        iDocTypeExtension.index = iDocType.getIDocTypeExtensions().getSize();
                        iDocType.getIDocTypeExtensions().add(iDocTypeExtension, iDocTypeExtension.getName());
                    }
                }
                ++i3;
            }
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException(ex.toString(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex.toString(), ex);
        }
    }

    synchronized void initRfm(Rfm rfm) throws MetaDataAccessException {
        JCO.Table paramsTab;
        JCO.Function function = this.createFunction("RFC_GET_FUNCTION_INTERFACE");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("RFC_GET_FUNCTION_INTERFACE");
        }
        try {
            function.getImportParameterList().setValue(rfm.getName(), "FUNCNAME");
            function.getImportParameterList().setValue(this.getUserLogonLanguage(), "LANGUAGE");
            this.getConnection().execute(function);
            paramsTab = function.getTableParameterList().getTable("PARAMS");
            RfmParameters params = new RfmParameters();
            params.parent = rfm;
            RfmExceptions exceptions = new RfmExceptions();
            exceptions.parent = rfm;
            if (paramsTab.getNumRows() > 0) {
                int i = 0;
                do {
                    rfm.parent.processOneParameter(paramsTab, params, exceptions);
                    ++i;
                } while (paramsTab.nextRow());
            }
            rfm.params = params;
            rfm.exceptions = exceptions;
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
        if (this.getSapRelease().compareTo("46B") < 0) {
            function = this.createFunction("FUNCTION_IMPORT_INTERFACE");
            if (function == null) {
                throw new MetaDataAccessFunctionNotFoundException("FUNCTION_IMPORT_INTERFACE");
            }
            try {
                function.getImportParameterList().setValue(rfm.getName(), "FUNCNAME");
                this.getConnection().execute(function);
                paramsTab = function.getTableParameterList().getTable("TABLES_PARAMETER");
                int count = paramsTab.getNumRows();
                int i = 0;
                while (i < count) {
                    paramsTab.setRow(i);
                    RfmParameter p = rfm.params.getRfmParameter(paramsTab.getString("PARAMETER"));
                    if (p != null) {
                        p.isOptional = paramsTab.getString("OPTIONAL").equals("X");
                    }
                    ++i;
                }
                paramsTab = function.getTableParameterList().getTable("IMPORT_PARAMETER");
                count = paramsTab.getNumRows();
                int i2 = 0;
                while (i2 < count) {
                    paramsTab.setRow(i2);
                    RfmParameter p = rfm.params.getRfmParameter(paramsTab.getString("PARAMETER"));
                    if (p != null) {
                        p.isOptional = paramsTab.getString("OPTIONAL").equals("X");
                    }
                    ++i2;
                }
            }
            catch (JCO.Exception ex) {
                throw new MetaDataAccessConnectionException((Exception)((Object)ex));
            }
            catch (Exception ex) {
                throw new MetaDataAccessException(ex);
            }
        }
    }

    public synchronized boolean isConnectionValid() {
        try {
            JCO.Function function = this.createFunction("RFCPING");
            this.getConnection().execute(function);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public Features getFeatures() {
        return this.mSupported;
    }

    public synchronized boolean isSupported(String feature) {
        Feature fcheck = null;
        fcheck = (Feature)this.mSupported.features.getItem(feature);
        if (fcheck == null) {
            return false;
        }
        if (fcheck.isInitialized()) {
            return fcheck.isSupported();
        }
        if (feature.equals("UC_LEN_SET")) {
            DDFactory factory = this.getDDFactory();
            fcheck.setInitialized(true);
            fcheck.setSupported(factory.importParameterExists("DDIF_FIELDINFO_GET", "UCLEN"));
            return fcheck.isSupported();
        }
        if (feature.equals("CURRENCY_SAPDATA")) {
            try {
                Currencies c = this.getSapData().getCurrencies();
            }
            catch (GenericCollectionException ex) {
                // empty catch block
            }
            return fcheck.isSupported();
        }
        JCO.Function function = this.createFunction(fcheck.getRfmName());
        if (function == null) {
            fcheck.setInitialized(true);
            fcheck.setSupported(false);
            return false;
        }
        if (feature.equals("AKH") || feature.equals("CURRENCY_DIRECT") || feature.equals("DOCUMENTATION") || feature.equals("IDOC_MESSAGE_TYPES") || feature.equals("IDOC_TYPES") || feature.equals("RFC_FUNCTION_SEARCH")) {
            fcheck.setInitialized(true);
            fcheck.setSupported(true);
            return true;
        }
        if (fcheck.getRfmName().equals("RFC_FUNCTION_SEARCH_WITHGROUP")) {
            function.getImportParameterList().setValue("RFC_FUNCTION_SEARCH_WITHGROUP", "FUNCNAME");
            this.getConnection().execute(function);
            fcheck.setInitialized(true);
            fcheck.setSupported(true);
            JCO.Table functionsTab = function.getTableParameterList().getTable("FUNCTIONS");
            fcheck = (Feature)this.mSupported.features.getItem("RFC_GROUP_STRUCTURE2");
            fcheck.setInitialized(true);
            if (functionsTab.hasField("COMPID")) {
                fcheck.setSupported(true);
            }
            fcheck = (Feature)this.mSupported.features.getItem("RFM_DEVCLASS_COMPONENT_ID");
            fcheck.setInitialized(true);
            if (functionsTab.hasField("COMPID") || functionsTab.hasField("COMPONENT_ID")) {
                fcheck.setSupported(true);
            }
            fcheck = (Feature)this.mSupported.features.getItem("RFM_RELEASED");
            fcheck.setInitialized(true);
            if (functionsTab.hasField("INTREL") || functionsTab.hasField("INTRELEASED")) {
                fcheck.setSupported(true);
            }
        }
        return fcheck.supported;
    }

    void processOneParameterRfms(Object rowObject, RfmParameters params, RfmExceptions exceptions) {
        boolean optional;
        String dataType;
        String paramType;
        JCO.Table row;
        HashSet<String> abaptypes;
        block43: {
            abaptypes = new HashSet<String>(Arrays.asList("C", "N", "D", "T", "X", "I", "P", "F", "STRING", "XSTRING"));
            row = (JCO.Table)rowObject;
            paramType = row.getString("PARAMCLASS");
            dataType = row.getString("EXID");
            if ((paramType.equals("I") || paramType.equals("E") || paramType.equals("C")) && dataType.equals("")) {
                if (row.getString("TABNAME").equals("STRING")) {
                    dataType = "g";
                } else if (row.getString("TABNAME").equals("XSTRING")) {
                    dataType = "y";
                } else if (row.getString("TABNAME").trim().equals("")) {
                    dataType = " ";
                } else {
                    DDFactory df = this.getDDFactory();
                    DDObject ddn = df.getDDObject(row.getString("TABNAME"));
                    if (ddn instanceof DDTabletype) {
                        dataType = "h";
                    } else if (ddn instanceof DDStructure) {
                        dataType = "v";
                        if (ddn instanceof DDDatabaseStructure) {
                            dataType = "u";
                        } else if (ddn instanceof DDFlatStructure) {
                            dataType = "u";
                        } else if (ddn instanceof DDDataelement) {
                            dataType = "E";
                        }
                    }
                }
            }
            optional = false;
            try {
                String s = row.getString("OPTIONAL");
                optional = s.equals("X");
            }
            catch (Exception ex) {
                if (paramType.equals("E")) {
                    optional = true;
                }
                if (!paramType.equals("I") && !paramType.equals("C") || dataType.equals("") || row.getString("DEFAULT").equals("")) break block43;
                optional = true;
            }
        }
        if (paramType.equals("I") || paramType.equals("E") || paramType.equals("C")) {
            if (dataType.equals("h") || dataType.equals("u") || dataType.equals("v")) {
                String paramName = row.getString("PARAMETER");
                if (!params.exists(paramName)) {
                    RfmParameter param = new RfmParameter(paramName, row.getString("PARAMTEXT"), paramType.equals("I"), row.getString("TABNAME"), row.getInt("INTLENGTH"), optional);
                    if (!row.getString("FIELDNAME").equalsIgnoreCase("")) {
                        param.setDdFieldName(row.getString("FIELDNAME"));
                    }
                    param.setIsChanging(paramType);
                    if (dataType.equals("h")) {
                        param.setRealType("h");
                    }
                    params.add(param, param.getName());
                    param.parent = params;
                } else {
                    RfmParameter param = params.getRfmParameter(paramName);
                    if (paramType.equals("I")) {
                        param.isImport = true;
                        param.isOptional = optional;
                    } else if (paramType.equals("E")) {
                        param.isExport = true;
                    } else if (paramType.equals("C")) {
                        param.isImport = true;
                        param.isExport = true;
                    }
                }
            } else {
                String paramName = row.getString("PARAMETER");
                if (!params.exists(paramName)) {
                    RfmParameter param;
                    if (!abaptypes.contains(row.getString("TABNAME").toUpperCase()) && row.getString("FIELDNAME").equals("")) {
                        param = new RfmParameter(paramName, row.getString("PARAMTEXT"), paramType.equals("I"), row.getString("TABNAME"), row.getInt("INTLENGTH"), optional);
                        param.setIsChanging(paramType);
                        param.setRealType("E");
                        param.setDataelementDefaultValue(row.getString("DEFAULT"));
                    } else {
                        param = new RfmParameter(paramName, row.getString("PARAMTEXT"), paramType.equals("I"), !row.getString("FIELDNAME").equals(""), row.getString("TABNAME"), row.getString("FIELDNAME"), optional, dataType, row.getInt("INTLENGTH"), row.getInt("DECIMALS"), row.getString("DEFAULT"));
                        param.setIsChanging(paramType);
                    }
                    params.add(param, param.getName());
                    param.parent = params;
                } else {
                    RfmParameter param = params.getRfmParameter(paramName);
                    if (paramType.equals("I")) {
                        param.isImport = true;
                        param.isOptional = optional;
                        param.defaultDefinition = row.getString("DEFAULT");
                    } else if (paramType.equals("E")) {
                        param.isExport = true;
                    } else if (paramType.equals("E")) {
                        param.isImport = true;
                        param.isExport = true;
                    }
                }
            }
        } else if (paramType.equals("T")) {
            RfmParameter param = new RfmParameter(row.getString("PARAMETER"), row.getString("PARAMTEXT"), row.getString("TABNAME"), row.getInt("INTLENGTH"), optional);
            params.add(param, param.getName());
            param.parent = params;
        } else if (paramType.equals("X")) {
            RfmException exception = new RfmException(row.getString("PARAMETER"), row.getString("PARAMTEXT"));
            exceptions.add(exception, exception.getName());
            exception.parent = exceptions;
        }
    }

    private synchronized void reset() {
        this.mConnection = null;
        this.mRepository = null;
        this.mSapData = new SapData();
        this.clients = new Clients();
        this.companyCodes = new CompanyCodes();
        this.controllingAreas = new ControllingAreas();
        this.countries = new Countries();
        this.currencies = new Currencies();
        this.plants = new Plants();
        this.poReleaseGroups = new POReleaseGroups();
        this.purchasingGroups = new PurchasingGroups();
        this.salesOrganizations = new SalesOrganizations();
        this.unitsOfMeasure = new UnitsOfMeasure();
        this.unitsOfMeasureISO = new UnitsOfMeasureISO();
        this.valuationAreas = new ValuationAreas();
        this.mRfms = null;
        this.mStructures = null;
        this.mSapDateFormat = null;
        this.mSapDecimalSymbol = null;
        this.mSapRelease = null;
        this.mUserName = null;
        this.mUserLogonLanguage = null;
        this.mGenericCollections = new SmartCollection();
        this.boTypes = null;
        this.biTypes = null;
        Object boRoot = null;
        this.iDocMessageTypes = null;
        Object mMatchCodesCustomer = null;
        Object var3_3 = null;
    }

    synchronized void retrieveData2Structure(Structure structure) throws MetaDataAccessException {
        if (!structure.textTable.equals("?")) {
            return;
        }
        JCO.Function function = this.createFunction("TABLE_GET_TEXTTABLE");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("TABLE_GET_TEXTTABLE");
        }
        try {
            function.getImportParameterList().setValue(structure.getName(), "CHECKTABLE");
            this.getConnection().execute(function);
            structure.textTable = function.getExportParameterList().getString("TABNAME");
        }
        catch (JCO.AbapException ex) {
            if (ex.getKey().equalsIgnoreCase("TABLE_NOT_FOUND")) {
                structure.textTable = "";
            }
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
    }

    synchronized void retrieveDataStructure(Structure structure) throws MetaDataAccessException {
        if (!structure.tableClass.equals("?")) {
            return;
        }
        JCO.Function function = this.createFunction("RPY_TABLE_SELECT");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("RPY_TABLE_SELECT");
        }
        try {
            function.getImportParameterList().setValue(structure.getName(), "TABLE_NAME");
            function.getImportParameterList().setValue("A", "ACTIVATION_TYPE");
            function.getImportParameterList().setValue(this.getUserLogonLanguage(), "LANGUAGE");
            this.getConnection().execute(function);
            JCO.Table row = function.getTableParameterList().getTable("TABL_INF_TAB");
            structure.baseTable = row.getString("SQLTAB");
            structure.description = row.getString("SHORTTEXT");
            structure.deliveryClass = row.getString("DELIVERYCL");
            structure.tableClass = row.getString("TABLCLASS");
            structure.bufferingAllowed = !row.getString("BUFFERED").equals("");
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
    }

    public synchronized boolean rollbackWork() {
        try {
            JCO.Function function = this.createFunction("BAPI_TRANSACTION_ROLLBACK");
            this.getConnection().execute(function);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    synchronized Rfms searchRfms(Rfms rfms, String functionName, String groupName) throws MetaDataAccessException {
        JCO.Function function;
        String extrel;
        String intrel;
        String compid;
        Rfms foundRfms = new Rfms(this);
        Rfm rfm = null;
        int ext = 3;
        int released = 0;
        if (this.isSupported("RFC_GROUP_STRUCTURE2")) {
            compid = "COMPID";
            intrel = "INTREL";
            extrel = "EXTREL";
        } else {
            compid = "COMPONENT_ID";
            intrel = "INTRELEASED";
            extrel = "EXTRELEASED";
        }
        if (this.isSupported("RFC_FUNCTION_SEARCH_WITHGROUP")) {
            function = this.createFunction("RFC_FUNCTION_SEARCH_WITHGROUP");
        } else if (this.isSupported("RFC_FUNCTION_SEARCH")) {
            function = this.createFunction("RFC_FUNCTION_SEARCH");
            ext = 1;
        } else {
            throw new MetaDataAccessFunctionNotFoundException("RFC_FUNCTION_SEARCH");
        }
        try {
            if (functionName != null) {
                function.getImportParameterList().setValue(functionName.toUpperCase(), "FUNCNAME");
            } else {
                function.getImportParameterList().setValue("", "FUNCNAME");
            }
            if (groupName != null) {
                function.getImportParameterList().setValue(groupName.toUpperCase(), "GROUPNAME");
            } else {
                function.getImportParameterList().setValue("", "GROUPNAME");
            }
            function.getImportParameterList().setValue(this.getUserLogonLanguage(), "LANGUAGE");
            this.getConnection().execute(function);
            JCO.Table functionsTab = function.getTableParameterList().getTable("FUNCTIONS");
            if (functionsTab.getNumRows() > 0) {
                if (ext > 2 && !functionsTab.hasField(intrel)) {
                    ext = 2;
                }
                do {
                    String fName;
                    if (!rfms.internalCollection.exists(fName = functionsTab.getString("FUNCNAME"))) {
                        switch (ext) {
                            case 3: {
                                if (functionsTab.getString(intrel).equals("X")) {
                                    released = 1;
                                }
                                if (functionsTab.getString(extrel).equals("X")) {
                                    released = 2;
                                }
                                if (functionsTab.getString("OBSOLETE").equals("X")) {
                                    released = 3;
                                }
                                rfm = new Rfm(fName, functionsTab.getString("GROUPNAME"), functionsTab.getString("APPL"), functionsTab.getString("STEXT"), functionsTab.getString("DEVCLASS"), functionsTab.getString(compid), released);
                                break;
                            }
                            case 2: {
                                rfm = new Rfm(fName, functionsTab.getString("GROUPNAME"), functionsTab.getString("APPL"), functionsTab.getString("STEXT"), functionsTab.getString("DEVCLASS"), functionsTab.getString(compid));
                                break;
                            }
                            case 1: {
                                rfm = new Rfm(fName, functionsTab.getString("GROUPNAME"), functionsTab.getString("APPL"), functionsTab.getString("STEXT"));
                            }
                        }
                        if (rfm == null) {
                            throw new MetaDataAccessFunctionNotFoundException("searchRfms");
                        }
                        rfm.parent = rfms;
                        rfms.add(rfm, rfm.getName());
                    } else {
                        rfm = rfms.getRfm(fName);
                        if (!rfm.descriptionInitialized) {
                            rfm.descriptionInitialized = true;
                            rfm.groupName = functionsTab.getString("GROUPNAME");
                            rfm.application = functionsTab.getString("APPL");
                            rfm.description = functionsTab.getString("STEXT");
                            switch (ext) {
                                case 3: {
                                    if (functionsTab.getString(intrel).equals("X")) {
                                        released = 1;
                                    }
                                    if (functionsTab.getString(extrel).equals("X")) {
                                        released = 2;
                                    }
                                    if (functionsTab.getString("OBSOLETE").equals("X")) {
                                        released = 3;
                                    }
                                    rfm.devclass = functionsTab.getString("DEVCLASS");
                                    rfm.componentId = functionsTab.getString(compid);
                                    rfm.released = released;
                                    break;
                                }
                                case 2: {
                                    rfm.devclass = functionsTab.getString("DEVCLASS");
                                    rfm.componentId = functionsTab.getString(compid);
                                }
                            }
                        }
                    }
                    foundRfms.add(rfm, rfm.getName());
                } while (functionsTab.nextRow());
            }
            return foundRfms;
        }
        catch (JCO.AbapException ex) {
            if (ex.getKey().equalsIgnoreCase("NO_FUNCTION_FOUND")) {
                return foundRfms;
            }
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
    }

    public ObjectFactory(JCO.Client connection) throws ObjectFactoryException {
        this.mSupported.add("AKH", "RS_COMPONENT_VIEW", false, false);
        this.mSupported.add("CURRENCY_DIRECT", "BAPI_CURRENCY_GETDECIMALS", false, false);
        this.mSupported.add("CURRENCY_SAPDATA", "BAPI_HELPVALUES_GET", false, false);
        this.mSupported.add("DOCUMENTATION", "DOCU_HTML_GET", false, false);
        this.mSupported.add("IDOC_MESSAGE_TYPES", "IDOCTYPES_LIST_WITH_MESSAGES", false, false);
        this.mSupported.add("IDOC_TYPES", "IDOCTYPES_LIST_WITH_MESSAGES", false, false);
        this.mSupported.add("RFM_DEVCLASS_COMPONENT_ID", "RFC_FUNCTION_SEARCH_WITHGROUP", false, false);
        this.mSupported.add("RFM_RELEASED", "RFC_FUNCTION_SEARCH_WITHGROUP", false, false);
        this.mSupported.add("UC_LEN_SET", "DDIF_FIELDINFO_GET", false, false);
        this.mSupported.add("RFC_FUNCTION_SEARCH", "RFC_FUNCTION_SEARCH", false, false);
        this.mSupported.add("RFC_FUNCTION_SEARCH_WITHGROUP", "RFC_FUNCTION_SEARCH_WITHGROUP", false, false);
        this.mSupported.add("RFC_GROUP_STRUCTURE2", "RFC_FUNCTION_SEARCH_WITHGROUP", false, false);
        this.setConnection(connection);
        IRepository repository = this.getRepository();
        this.df = new DDFactory(connection, repository, this);
    }

    public DDFactory getDDFactory() {
        return this.df;
    }

    public static byte convertAbapTypeToJcoType(char type) {
        switch (type) {
            case 'b': {
                return 10;
            }
            case 'I': {
                return 8;
            }
            case 'P': {
                return 2;
            }
            case 'D': {
                return 1;
            }
            case 'N': {
                return 6;
            }
            case 'T': {
                return 3;
            }
            case 'C': {
                return 0;
            }
            case 'F': {
                return 7;
            }
            case 's': {
                return 9;
            }
            case 'X': {
                return 4;
            }
            case 'g': {
                return 29;
            }
            case 'y': {
                return 30;
            }
            case 'u': {
                return 17;
            }
            case 'h': {
                return 99;
            }
        }
        return -1;
    }

    public static byte convertAbapTypeToJcoType(String type) {
        return ObjectFactory.convertAbapTypeToJcoType(type.charAt(0));
    }

    public static char convertJcoTypeToAbapType(int type) {
        switch (type) {
            case 10: {
                return 'b';
            }
            case 8: {
                return 'I';
            }
            case 2: {
                return 'P';
            }
            case 1: {
                return 'D';
            }
            case 6: {
                return 'N';
            }
            case 3: {
                return 'T';
            }
            case 0: {
                return 'C';
            }
            case 7: {
                return 'F';
            }
            case 9: {
                return 's';
            }
            case 4: {
                return 'X';
            }
            case 29: {
                return 'g';
            }
            case 30: {
                return 'y';
            }
            case 17: {
                return 'u';
            }
            case 99: {
                return 'h';
            }
        }
        return ' ';
    }

    public synchronized JCO.Function createFunction(String name) {
        try {
            return this.getRepository().getFunctionTemplate(name.toUpperCase()).getFunction();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean existsFieldInJcoRecord(String fieldName, JCO.Record record) {
        try {
            record.indexOf(fieldName);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static String getBapiReturnErrorMessage(JCO.Record record) throws ObjectFactoryException {
        try {
            String code = ObjectFactory.existsFieldInJcoRecord("CODE", record) ? record.getString("CODE") : record.getString("ID") + record.getString("NUMBER");
            return record.getString("TYPE") + " " + code + ": " + record.getString("MESSAGE");
        }
        catch (Exception ex) {
            throw new ObjectFactoryException("Not a valid Return record.");
        }
    }

    public static CheckTableDescriptors getCheckTableDescriptors() {
        return mCheckTableDescriptors;
    }

    public JCO.Client getConnection() {
        return this.mConnection;
    }

    public static ConversionExitDescriptors getConversionExitDescriptors() {
        return mConversionExitDescriptors;
    }

    public synchronized String getExternalValue(String exitName, String internalValue, int resultLength) throws ConversionExitException {
        if (!this.isConversionExitSupported(exitName)) {
            throw new ConversionExitNotSupportedException();
        }
        try {
            internalValue = internalValue.trim();
            if (exitName.equalsIgnoreCase("ALPHA")) {
                if (!StaticHelper.containsOnly(internalValue, "0123456789")) {
                    if (internalValue.length() <= resultLength) {
                        return internalValue;
                    }
                    return internalValue.substring(0, resultLength);
                }
                if ((internalValue = StaticHelper.removeLeadingChar(internalValue, '0')).length() == 0) {
                    return "0";
                }
                if (internalValue.length() > resultLength) {
                    return internalValue.substring(internalValue.length() - resultLength);
                }
                return internalValue;
            }
            ConversionExitDescriptor descriptor = mConversionExitDescriptors.getConversionExitDescriptor(exitName);
            JCO.Function function = this.createFunction("BAPI_CONVERSION_INT2EXT");
            if (function == null) {
                throw new ConversionExitFunctionNotFoundException("BAPI_CONVERSION_INT2EXT");
            }
            JCO.Table data = function.getTableParameterList().getTable("DATA");
            JCO.Table returns = function.getTableParameterList().getTable("RETURN");
            data.appendRow();
            data.setValue(descriptor.objectType, "OBJTYPE");
            data.setValue(descriptor.methodName, "METHOD");
            data.setValue(descriptor.parameterName, "PARAMETER");
            data.setValue(descriptor.fieldName, "FIELD");
            data.setValue(1, "ROWNUMBER");
            data.setValue(internalValue, "INT_FORMAT");
            this.getConnection().execute(function);
            if (returns.getNumRows() > 0) {
                throw new ConversionExitBadBapiReturnCodeException(ObjectFactory.getBapiReturnErrorMessage((JCO.Record)returns));
            }
            String s = data.getString("EXT_FORMAT");
            if (s.length() > resultLength) {
                s = s.substring(0, resultLength);
            }
            return s;
        }
        catch (ConversionExitException ex) {
            throw ex;
        }
        catch (JCO.Exception ex) {
            throw new ConversionExitConnectionException(ex.toString(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new ConversionExitException(ex.toString(), ex);
        }
    }

    public static FixedValuesDescriptors getFixedValuesDescriptors() {
        return mFixedValuesDescriptors;
    }

    public synchronized HelpvaluesFields getHelpvaluesFields(String objectType, String objectName, String methodName, String parameterName, String fieldName) throws GenericCollectionException {
        HelpvaluesFields hvfs = new HelpvaluesFields();
        JCO.Function function = this.createFunction("BAPI_HELPVALUES_GET");
        if (function == null) {
            throw new GenericCollectionFunctionNotFoundException("BAPI_HELPVALUES_GET");
        }
        if (objectType != null) {
            function.getImportParameterList().setValue(objectType, "OBJTYPE");
        }
        if (objectName != null) {
            function.getImportParameterList().setValue(objectName, "OBJNAME");
        }
        function.getImportParameterList().setValue(methodName, "METHOD");
        function.getImportParameterList().setValue(parameterName, "PARAMETER");
        if (fieldName != null) {
            function.getImportParameterList().setValue(fieldName, "FIELD");
        }
        function.getImportParameterList().setValue(1, "MAX_OF_ROWS");
        try {
            this.getConnection().execute(function);
            JCO.Structure returnStructure = function.getExportParameterList().getStructure("RETURN");
            if (!returnStructure.getString("TYPE").equals("") && !returnStructure.getString("CODE").equals("HV013")) {
                throw new GenericCollectionBadBapiReturnCodeException(ObjectFactory.getBapiReturnErrorMessage((JCO.Record)returnStructure));
            }
            JCO.Table metadata = function.getTableParameterList().getTable("DESCRIPTION_FOR_HELPVALUES");
            int metadataRowCount = metadata.getNumRows();
            int i = 0;
            while (i < metadataRowCount) {
                metadata.setRow(i);
                FieldTexts fts = new FieldTexts();
                fts.columnHeading = metadata.getString("REPTEXT");
                fts.description = metadata.getString("FIELDTEXT");
                fts.labelLong = metadata.getString("SCRTEXT_L");
                fts.labelMedium = metadata.getString("SCRTEXT_M");
                fts.labelShort = metadata.getString("SCRTEXT_S");
                HelpvaluesField hvf = new HelpvaluesField(metadata.getString("TABNAME"), metadata.getString("FIELDNAME"), metadata.getInt("OFFSET"), metadata.getInt("LENG"), fts);
                hvfs.add(hvf);
                ++i;
            }
        }
        catch (GenericCollectionException ex) {
            throw ex;
        }
        catch (JCO.Exception ex) {
            throw new GenericCollectionConnectionException(ex.toString(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new GenericCollectionException(ex.toString(), ex);
        }
        return hvfs;
    }

    synchronized HelpvaluesFields getHelpvaluesFieldsForMatchCode(String objectType, String objectName, String methodName, String parameterName, String fieldName, String mcName, String mcType) throws GenericCollectionException {
        HelpvaluesFields hvfs = new HelpvaluesFields();
        JCO.Function function = this.createFunction("BAPI_HELPVALUES_GET");
        if (function == null) {
            throw new GenericCollectionFunctionNotFoundException("BAPI_HELPVALUES_GET");
        }
        try {
            if (objectType != null) {
                function.getImportParameterList().setValue(objectType, "OBJTYPE");
            }
            if (objectName != null) {
                function.getImportParameterList().setValue(objectName, "OBJNAME");
            }
            function.getImportParameterList().setValue(methodName, "METHOD");
            function.getImportParameterList().setValue(parameterName, "PARAMETER");
            if (fieldName != null) {
                function.getImportParameterList().setValue(fieldName, "FIELD");
            }
            function.getImportParameterList().setValue(1, "MAX_OF_ROWS");
            JCO.Structure shlp = function.getImportParameterList().getStructure("EXPLICIT_SHLP");
            shlp.setValue(mcName, "SHLPNAME");
            shlp.setValue(mcType, "SHLPTYPE");
            this.getConnection().execute(function);
            JCO.Structure returnStructure = function.getExportParameterList().getStructure("RETURN");
            if (!returnStructure.getString("TYPE").equals("") && !returnStructure.getString("CODE").equals("HV013")) {
                throw new GenericCollectionBadBapiReturnCodeException(ObjectFactory.getBapiReturnErrorMessage((JCO.Record)returnStructure));
            }
            JCO.Table metadata = function.getTableParameterList().getTable("DESCRIPTION_FOR_HELPVALUES");
            int metadataRowCount = metadata.getNumRows();
            int i = 0;
            while (i < metadataRowCount) {
                metadata.setRow(i);
                FieldTexts fts = new FieldTexts();
                fts.columnHeading = metadata.getString("REPTEXT");
                fts.description = metadata.getString("FIELDTEXT");
                fts.labelLong = metadata.getString("SCRTEXT_L");
                fts.labelMedium = metadata.getString("SCRTEXT_M");
                fts.labelShort = metadata.getString("SCRTEXT_S");
                HelpvaluesField hvf = new HelpvaluesField(metadata.getString("TABNAME"), metadata.getString("FIELDNAME"), metadata.getInt("OFFSET"), metadata.getInt("LENG"), fts);
                hvfs.add(hvf);
                ++i;
            }
        }
        catch (GenericCollectionException ex) {
            throw ex;
        }
        catch (JCO.Exception ex) {
            throw new GenericCollectionConnectionException(ex.toString(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new GenericCollectionException(ex.toString(), ex);
        }
        return hvfs;
    }

    public synchronized HelpvaluesInformation getHelpvaluesInformation(String objectType, String objectName, String methodName, String parameterName, String fieldName) throws GenericCollectionException {
        HelpvaluesInformation hvi;
        HelpvaluesFields hvfs = new HelpvaluesFields();
        JCO.Function function = this.createFunction("BAPI_HELPVALUES_GET");
        if (function == null) {
            throw new GenericCollectionFunctionNotFoundException("BAPI_HELPVALUES_GET");
        }
        try {
            if (objectType != null) {
                function.getImportParameterList().setValue(objectType, "OBJTYPE");
            }
            if (objectName != null) {
                function.getImportParameterList().setValue(objectName, "OBJNAME");
            }
            function.getImportParameterList().setValue(methodName, "METHOD");
            function.getImportParameterList().setValue(parameterName, "PARAMETER");
            if (fieldName != null) {
                function.getImportParameterList().setValue(fieldName, "FIELD");
            }
            this.getConnection().execute(function);
            JCO.Structure returnStructure = function.getExportParameterList().getStructure("RETURN");
            if (!returnStructure.getString("TYPE").equals("") && !returnStructure.getString("CODE").equals("HV013")) {
                throw new GenericCollectionBadBapiReturnCodeException(ObjectFactory.getBapiReturnErrorMessage((JCO.Record)returnStructure));
            }
            JCO.Table metadata = function.getTableParameterList().getTable("DESCRIPTION_FOR_HELPVALUES");
            int metadataRowCount = metadata.getNumRows();
            int i = 0;
            while (i < metadataRowCount) {
                metadata.setRow(i);
                FieldTexts fts = new FieldTexts();
                fts.columnHeading = metadata.getString("REPTEXT");
                fts.description = metadata.getString("FIELDTEXT");
                fts.labelLong = metadata.getString("SCRTEXT_L");
                fts.labelMedium = metadata.getString("SCRTEXT_M");
                fts.labelShort = metadata.getString("SCRTEXT_S");
                HelpvaluesField hvf = new HelpvaluesField(metadata.getString("TABNAME"), metadata.getString("FIELDNAME"), metadata.getInt("OFFSET"), metadata.getInt("LENG"), fts);
                hvfs.add(hvf);
                ++i;
            }
            JCO.Table data = function.getTableParameterList().getTable("HELPVALUES");
            int count = data.getNumRows();
            String spaces = StaticHelper.repeat(" ", 255);
            int hvfsGetSize = hvfs.getSize();
            String[][] strings = new String[count][hvfsGetSize];
            int i2 = 0;
            while (i2 < count) {
                data.setRow(i2);
                String s = data.getString(0) + spaces;
                int j = 0;
                while (j < hvfsGetSize) {
                    HelpvaluesField hvf = hvfs.getHelpvaluesField(j);
                    int offset = hvf.getOffset();
                    strings[i2][j] = s.substring(offset, offset + hvf.getLength()).trim();
                    ++j;
                }
                ++i2;
            }
            hvi = new HelpvaluesInformation(hvfs, strings, count);
        }
        catch (GenericCollectionException ex) {
            throw ex;
        }
        catch (JCO.Exception ex) {
            throw new GenericCollectionConnectionException(ex.toString(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new GenericCollectionException(ex.toString(), ex);
        }
        return hvi;
    }

    public synchronized String getInternalValue(String exitName, String externalValue, int resultLength) throws ConversionExitException {
        if (!this.isConversionExitSupported(exitName)) {
            throw new ConversionExitNotSupportedException();
        }
        try {
            externalValue = externalValue.trim();
            if (exitName.equalsIgnoreCase("ALPHA")) {
                if (!StaticHelper.containsOnly(externalValue, "0123456789")) {
                    if ((externalValue = externalValue.toUpperCase()).length() <= resultLength) {
                        return externalValue;
                    }
                    return externalValue.substring(0, resultLength);
                }
                if (externalValue.length() < resultLength) {
                    return StaticHelper.repeat("0", resultLength - externalValue.length()) + externalValue;
                }
                return externalValue.substring(externalValue.length() - resultLength);
            }
            ConversionExitDescriptor descriptor = mConversionExitDescriptors.getConversionExitDescriptor(exitName);
            JCO.Function function = this.createFunction("BAPI_CONVERSION_EXT2INT");
            if (function == null) {
                throw new ConversionExitFunctionNotFoundException("BAPI_CONVERSION_EXT2INT");
            }
            JCO.Table data = function.getTableParameterList().getTable("DATA");
            JCO.Table returns = function.getTableParameterList().getTable("RETURN");
            data.appendRow();
            data.setValue(descriptor.objectType, "OBJTYPE");
            data.setValue(descriptor.methodName, "METHOD");
            data.setValue(descriptor.parameterName, "PARAMETER");
            data.setValue(descriptor.fieldName, "FIELD");
            data.setValue(1, "ROWNUMBER");
            data.setValue(externalValue, "EXT_FORMAT");
            this.getConnection().execute(function);
            if (returns.getNumRows() > 0) {
                throw new ConversionExitBadBapiReturnCodeException(ObjectFactory.getBapiReturnErrorMessage((JCO.Record)returns));
            }
            String s = data.getString("INT_FORMAT");
            if (s.length() == 255) {
                s = s.substring(s.length() - resultLength);
            } else if (s.length() > resultLength) {
                s = s.substring(0, resultLength);
            }
            return s;
        }
        catch (ConversionExitException ex) {
            throw ex;
        }
        catch (JCO.Exception ex) {
            throw new ConversionExitConnectionException(ex.toString(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new ConversionExitException(ex.toString(), ex);
        }
    }

    public static String getJcoTypeDescriptionString(int type) {
        switch (type) {
            case 10: {
                return "1-byte integer (byte)";
            }
            case 8: {
                return "4-byte integer (int)";
            }
            case 2: {
                return "Binary Coded Decimal (BCD)";
            }
            case 1: {
                return "Date";
            }
            case 6: {
                return "Numerical Character";
            }
            case 3: {
                return "Time";
            }
            case 0: {
                return "Character (string)";
            }
            case 7: {
                return "Float (double)";
            }
            case 9: {
                return "2-byte integer (short)";
            }
            case 4: {
                return "Raw data";
            }
            case 29: {
                return "String (variable-length)";
            }
            case 30: {
                return "Raw data (variable-length)";
            }
            case 17: {
                return "Structure";
            }
            case 99: {
                return "Table";
            }
        }
        return "undefined";
    }

    synchronized String[][] getMatchCodeData(String objectType, String objectName, String methodName, String parameterName, String fieldName, String mcName, String mcType, HelpvaluesFields hvfs, MatchCodeConditions conditions) throws GenericCollectionException {
        JCO.Function function = this.createFunction("BAPI_HELPVALUES_GET");
        if (function == null) {
            throw new GenericCollectionFunctionNotFoundException("BAPI_HELPVALUES_GET");
        }
        try {
            if (objectType != null) {
                function.getImportParameterList().setValue(objectType, "OBJTYPE");
            }
            if (objectName != null) {
                function.getImportParameterList().setValue(objectName, "OBJNAME");
            }
            function.getImportParameterList().setValue(methodName, "METHOD");
            function.getImportParameterList().setValue(parameterName, "PARAMETER");
            if (fieldName != null) {
                function.getImportParameterList().setValue(fieldName, "FIELD");
            }
            JCO.Structure shlp = function.getImportParameterList().getStructure("EXPLICIT_SHLP");
            shlp.setValue(mcName, "SHLPNAME");
            shlp.setValue(mcType, "SHLPTYPE");
            JCO.Table conds = function.getTableParameterList().getTable("SELECTION_FOR_HELPVALUES");
            int count = conditions.getSize();
            int i = 0;
            while (i < count) {
                MatchCodeCondition mcc = (MatchCodeCondition)conditions.conditions.elementAt(i);
                conds.appendRow();
                conds.setValue(mcc.field, "SELECT_FLD");
                conds.setValue(mcc.include ? "I" : "E", "SIGN");
                conds.setValue(mcc.operator.getOperator(), "OPTION");
                conds.setValue(mcc.low, "LOW");
                if (mcc.high != null) {
                    conds.setValue(mcc.high, "HIGH");
                }
                ++i;
            }
            this.getConnection().execute(function);
            JCO.Structure returnStructure = function.getExportParameterList().getStructure("RETURN");
            if (!returnStructure.getString("TYPE").equals("") && !returnStructure.getString("CODE").equals("HV013")) {
                throw new GenericCollectionBadBapiReturnCodeException(ObjectFactory.getBapiReturnErrorMessage((JCO.Record)returnStructure));
            }
            JCO.Table data = function.getTableParameterList().getTable("HELPVALUES");
            count = data.getNumRows();
            String spaces = StaticHelper.repeat(" ", 255);
            int hvfsGetSize = hvfs.getSize();
            String[][] strings = new String[count][hvfsGetSize];
            int i2 = 0;
            while (i2 < count) {
                data.setRow(i2);
                String s = data.getString(0) + spaces;
                int j = 0;
                while (j < hvfsGetSize) {
                    HelpvaluesField hvf = hvfs.getHelpvaluesField(j);
                    int offset = hvf.getOffset();
                    strings[i2][j] = s.substring(offset, offset + hvf.getLength()).trim();
                    ++j;
                }
                ++i2;
            }
            return strings;
        }
        catch (GenericCollectionException ex) {
            throw ex;
        }
        catch (JCO.Exception ex) {
            throw new GenericCollectionConnectionException(ex.toString(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new GenericCollectionException(ex.toString(), ex);
        }
    }

    public synchronized MatchCodes getMatchCodes(String objectType, String objectName, String methodName, String parameterName, String fieldName) throws GenericCollectionException {
        if ("46B".compareTo(this.getSapRelease()) > 0) {
            throw new GenericCollectionNotSupportedException("Minimum supported release is 4.6B");
        }
        MatchCodes mcs = new MatchCodes();
        mcs.objectName = objectName;
        mcs.objectType = objectType;
        mcs.methodName = methodName;
        mcs.parameterName = parameterName;
        mcs.fieldName = fieldName;
        mcs.bof = this;
        JCO.Function function = this.createFunction("BAPI_HELPVALUES_GET_SEARCHHELP");
        if (function == null) {
            throw new GenericCollectionFunctionNotFoundException("BAPI_HELPVALUES_GET_SEARCHHELP");
        }
        try {
            if (objectType != null) {
                function.getImportParameterList().setValue(objectType, "OBJTYPE");
            }
            if (objectName != null) {
                function.getImportParameterList().setValue(objectName, "OBJNAME");
            }
            function.getImportParameterList().setValue(methodName, "METHOD");
            function.getImportParameterList().setValue(parameterName, "PARAMETER");
            if (fieldName != null) {
                function.getImportParameterList().setValue(fieldName, "FIELD");
            }
            this.getConnection().execute(function);
            JCO.Structure returnStructure = function.getExportParameterList().getStructure("RETURN");
            if (!returnStructure.getString("TYPE").equals("")) {
                throw new GenericCollectionBadBapiReturnCodeException(ObjectFactory.getBapiReturnErrorMessage((JCO.Record)returnStructure));
            }
            JCO.Table table = function.getTableParameterList().getTable("SHLP_FOR_HELPVALUES_GET");
            int tableRowCount = table.getNumRows();
            int i = 0;
            while (i < tableRowCount) {
                table.setRow(i);
                MatchCode mc = new MatchCode();
                mc.description = table.getString("TITLE");
                mc.name = table.getString("SHLPNAME");
                mc.type = table.getString("SHLPTYPE");
                mc.parent = mcs;
                mcs.add(mc);
                ++i;
            }
        }
        catch (GenericCollectionException ex) {
            throw ex;
        }
        catch (JCO.Exception ex) {
            throw new GenericCollectionConnectionException(ex.toString(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new GenericCollectionException(ex.toString(), ex);
        }
        return mcs;
    }

    public static MatchCodesDescriptors getMatchCodesDescriptors() {
        return mMatchCodesDescriptors;
    }

    public MatchCodes getMatchCodesForCustomer() throws GenericCollectionException {
        if (this.mMatchCodesCustomer == null) {
            this.mMatchCodesCustomer = this.getMatchCodesForDataElement("KUNNR");
        }
        return this.mMatchCodesCustomer;
    }

    public MatchCodes getMatchCodesForDataElement(String dataElement) throws GenericCollectionException {
        MatchCodesDescriptor hvd = ObjectFactory.getMatchCodesDescriptors().getMatchCodesDescriptor(dataElement);
        if (hvd == null) {
            throw new GenericCollectionNotSupportedException("Data element not supported: " + dataElement);
        }
        if (hvd.getMinimumSupportedRelease().compareTo(this.getSapRelease()) > 0) {
            throw new GenericCollectionNotSupportedException();
        }
        return this.getMatchCodes(hvd.objectType, null, hvd.methodName, hvd.parameterName, hvd.fieldName);
    }

    public MatchCodes getMatchCodesForSupplier() throws GenericCollectionException {
        if (this.mMatchCodesSupplier == null) {
            this.mMatchCodesSupplier = this.getMatchCodesForDataElement("LIFNR");
        }
        return this.mMatchCodesSupplier;
    }

    String getObjectNameIfHasBAPIs31(String objType) throws MetaDataAccessException {
        JCO.Function function = this.createFunction("RPY_OBJECTTYPE_READ");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("RPY_OBJECTTYPE_READ");
        }
        try {
            function.getImportParameterList().setValue(objType, "OBJECTTYPE_ID");
            function.getImportParameterList().setValue("R", "CICO_MODE");
            function.getImportParameterList().setValue("X", "WITH_VERBS");
            this.getConnection().execute(function);
            JCO.Table verbs = function.getTableParameterList().getTable("METHODS");
            if (verbs.getNumRows() > 0) {
                do {
                    if (!verbs.getString("ISAPI").equals("X")) continue;
                    return function.getExportParameterList().getStructure("OBJECTTYPE_INFO").getString("EDITELEM");
                } while (verbs.nextRow());
            }
            return null;
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
    }

    public SapData getSapData() {
        return this.mSapData;
    }

    public CheckTableDescriptors getSupportedCheckTableDescriptors() {
        CheckTableDescriptors sctds = new CheckTableDescriptors();
        CheckTableDescriptors ctds = ObjectFactory.getCheckTableDescriptors();
        CheckTableDescriptor ctd = null;
        int count = ctds.getSize();
        int i = 0;
        while (i < count) {
            ctd = ctds.getCheckTableDescriptor(i);
            if (ctd.getMinimumSupportedRelease().compareTo(this.getSapRelease()) <= 0) {
                sctds.add(ctd);
            }
            ++i;
        }
        return sctds;
    }

    public ConversionExitDescriptors getSupportedConversionExitDescriptors() {
        ConversionExitDescriptors sctds = new ConversionExitDescriptors();
        ConversionExitDescriptors ctds = ObjectFactory.getConversionExitDescriptors();
        ConversionExitDescriptor ctd = null;
        int count = ctds.getSize();
        int i = 0;
        while (i < count) {
            ctd = ctds.getConversionExitDescriptor(i);
            if (ctd.getMinimumSupportedRelease().compareTo(this.getSapRelease()) <= 0) {
                sctds.add(ctd);
            }
            ++i;
        }
        return sctds;
    }

    public FixedValuesDescriptors getSupportedFixedValuesDescriptors() {
        FixedValuesDescriptors sctds = new FixedValuesDescriptors();
        FixedValuesDescriptors ctds = ObjectFactory.getFixedValuesDescriptors();
        FixedValuesDescriptor ctd = null;
        int count = ctds.getSize();
        int i = 0;
        while (i < count) {
            ctd = ctds.getFixedValuesDescriptor(i);
            if (ctd.getMinimumSupportedRelease().compareTo(this.getSapRelease()) <= 0) {
                sctds.add(ctd);
            }
            ++i;
        }
        return sctds;
    }

    public MatchCodesDescriptors getSupportedMatchCodesDescriptors() {
        MatchCodesDescriptors sctds = new MatchCodesDescriptors();
        MatchCodesDescriptors ctds = ObjectFactory.getMatchCodesDescriptors();
        MatchCodesDescriptor ctd = null;
        int count = ctds.getSize();
        int i = 0;
        while (i < count) {
            ctd = ctds.getMatchCodesDescriptor(i);
            if (ctd.getMinimumSupportedRelease().compareTo(this.getSapRelease()) <= 0) {
                sctds.add(ctd);
            }
            ++i;
        }
        return sctds;
    }

    void initBOType31(BOType boType) throws MetaDataAccessException {
        JCO.Function function = this.createFunction("SWO_QUERY_BASEDATA");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("SWO_QUERY_BASEDATA");
        }
        try {
            function.getImportParameterList().setValue(this.getUserLogonLanguage(), "LANGUAGE");
            function.getImportParameterList().setValue("X", "TEXT");
            function.getImportParameterList().setValue(boType.getObjectType(), "OBJTYPE");
            this.getConnection().execute(function);
            boType.initialized = true;
            JCO.Structure baseData = function.getExportParameterList().getStructure("BASEDATA");
            String s = baseData.getString("MODOBJTYPE");
            if (!s.equals(boType.getObjectType())) {
                boType.delegationObjectType = s;
            }
            boType.parentObjectType = baseData.getString("PARENT");
            boType.isReleased = baseData.getString("MODELONLY").equals("R") || baseData.getString("RELEASED").equals("X");
            boType.releaseCreated = baseData.getString("CREA_REL");
            boType.releaseChanged = baseData.getString("CHAN_REL");
            boType.releaseReleased = "";
            boType.releaseObsolete = "";
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
        function = this.createFunction("RPY_OBJECTTYPE_READ");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("RPY_OBJECTTYPE_READ");
        }
        try {
            BOMethod boMethod;
            Field f;
            String s;
            Structure struct;
            function.getImportParameterList().setValue(boType.getObjectType(), "OBJECTTYPE_ID");
            function.getImportParameterList().setValue("R", "CICO_MODE");
            function.getImportParameterList().setValue("X", "WITH_VERBS");
            function.getImportParameterList().setValue("X", "WITH_PARAMETERS");
            function.getImportParameterList().setValue("X", "WITH_EXCEPTIONS");
            function.getImportParameterList().setValue("X", "WITH_TEXTS");
            function.getImportParameterList().setValue(this.getUserLogonLanguage(), "LANGUAGE");
            this.getConnection().execute(function);
            JCO.Table keyfields = function.getTableParameterList().getTable("KEYFIELDS");
            JCO.Table methods = function.getTableParameterList().getTable("METHODS");
            JCO.Table parameters = function.getTableParameterList().getTable("METHODPARAMS");
            JCO.Table exceptions = function.getTableParameterList().getTable("METHODEXCEPTIONS");
            if (keyfields.getNumRows() > 0) {
                do {
                    if ((struct = this.getStructure(keyfields.getString("REFSTRUCT"))) == null) {
                        s = boType.getObjectType() + " - " + keyfields.getString("EDITELEM");
                        throw new MetaDataAccessNotBasedOnDictionaryException(s);
                    }
                    f = struct.getField(keyfields.getString("REFFIELD"));
                    if (f == null) {
                        String s2 = boType.getObjectType() + " - " + keyfields.getString("EDITELEM");
                        throw new MetaDataAccessNotBasedOnDictionaryException(s2);
                    }
                    BOKeyField boKeyField = new BOKeyField(keyfields.getString("EDITELEM"), keyfields.getString("SHORTTEXT"), keyfields.getString("REFSTRUCT"), keyfields.getString("REFFIELD"), f.getDataTypeABAP(), f.getInternalLength(), f.getOutputLength(), f.isMixedCaseSupported(), f.getConversionExit());
                    boKeyField.parent = boType.boKeyFields;
                    boKeyField.index = boType.boKeyFields.getSize();
                    boType.boKeyFields.add(boKeyField, boKeyField.getName().toUpperCase());
                } while (keyfields.nextRow());
            }
            if (methods.getNumRows() > 0) {
                do {
                    if (!methods.getString("ISAPI").equals("X")) continue;
                    boMethod = new BOMethod(methods.getString("EDITELEM"), methods.getString("SHORTTEXT"), methods.getString("ABAPNAME"), methods.getString("CLASSVERB").equals("X"));
                    boMethod.parent = boType.boMethods;
                    boMethod.index = boType.boMethods.getSize();
                    boType.boMethods.add(boMethod, boMethod.getName().toUpperCase());
                    boMethod.isReleased = methods.getString("MODELONLY").equals("R");
                    boMethod.releaseCreated = methods.getString("FSTREL");
                    boMethod.releaseObsolete = "";
                    boMethod.usesDialog = methods.getString("DIALOG").equals("X");
                } while (methods.nextRow());
            }
            if (parameters.getNumRows() > 0) {
                do {
                    BOParameter boParameter;
                    if ((boMethod = boType.getBOMethods().getBOMethod(parameters.getString("METHOD"))) == null) continue;
                    if (!parameters.getString("REFFIELD").equals("")) {
                        struct = this.getStructure(parameters.getString("REFSTRUCT"));
                        if (struct == null) {
                            s = boType.getObjectType() + "." + boMethod.getName() + ": " + parameters.getString("EDITELEM");
                            throw new MetaDataAccessNotBasedOnDictionaryException(s);
                        }
                        f = struct.getField(parameters.getString("REFFIELD"));
                        if (f == null) {
                            String s3 = boType.getObjectType() + "." + boMethod.getName() + ": " + parameters.getString("EDITELEM");
                            throw new MetaDataAccessNotBasedOnDictionaryException(s3);
                        }
                        boParameter = new BOParameter(parameters.getString("EDITELEM"), parameters.getString("SHORTTEXT"), parameters.getString("OBLIGIMP").equals(""), parameters.getString("ELEMTYPE"), parameters.getString("FUNCPNAME"), parameters.getString("REFSTRUCT"), parameters.getString("REFFIELD"), f.getDataTypeABAP(), f.getInternalLength(), f.getOutputLength(), f.getDecimals(), f.isMixedCaseSupported(), f.getConversionExit(), parameters.getString("FSTREL"));
                    } else {
                        struct = this.getStructure(parameters.getString("REFSTRUCT"));
                        if (struct == null) {
                            s = boType.getObjectType() + "." + boMethod.getName() + ": " + parameters.getString("EDITELEM");
                            throw new MetaDataAccessNotBasedOnDictionaryException(s);
                        }
                        boParameter = new BOParameter(parameters.getString("EDITELEM"), parameters.getString("SHORTTEXT"), parameters.getString("OBLIGIMP").equals(""), parameters.getString("ELEMTYPE"), parameters.getString("FUNCPNAME"), parameters.getString("REFSTRUCT"), struct.getLength(), parameters.getString("TABELEM").equals("X"), parameters.getString("FSTREL"));
                    }
                    boParameter.parent = boMethod.boParameters;
                    boParameter.index = boMethod.boParameters.getSize();
                    boMethod.boParameters.add(boParameter, boParameter.getName().toUpperCase());
                } while (parameters.nextRow());
            }
            if (exceptions.getNumRows() > 0) {
                do {
                    String exception;
                    if ((exception = exceptions.getString("FUNCEXCEPT")).equals("") || (boMethod = boType.getBOMethods().getBOMethod(exceptions.getString("METHOD"))) == null) continue;
                    BOException boException = new BOException(exception, exceptions.getString("TEXT"), exceptions.getString("FSTREL"), exceptions.getString("ARBGB"), exceptions.getString("MSGNR"), exceptions.getString("EXCEPTION"));
                    boException.parent = boMethod.boExceptions;
                    boException.index = boMethod.boExceptions.getSize();
                    boMethod.boExceptions.add(boException, boException.getName().toUpperCase());
                } while (exceptions.nextRow());
            }
            int i = 0;
            while (i < boType.getBOMethods().getSize()) {
                boMethod = boType.getBOMethods().getBOMethod(i);
                boMethod.isFactoryMethod = this.isFactoryMethod(boMethod);
                ++i;
            }
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
    }

    void initBOTypes31(BOTypes boTypes) throws MetaDataAccessException {
        boTypes.bof = this;
        JCO.Function function = this.createFunction("SWO_QUERY_OBJTYPES");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("SWO_QUERY_OBJTYPES");
        }
        try {
            function.getImportParameterList().setValue("X", "OBJTYPECLASS_SAP");
            function.getImportParameterList().setValue("*", "RELEASED");
            function.getImportParameterList().setValue(this.getUserLogonLanguage(), "LANGUAGE");
            this.getConnection().execute(function);
            JCO.Table objTypes = function.getTableParameterList().getTable("OBJTYPES");
            if (objTypes.getNumRows() > 0) {
                do {
                    String type;
                    String name;
                    if ((name = this.getObjectNameIfHasBAPIs31(type = objTypes.getString("OBJTYPE"))) == null) continue;
                    if (name.equals("")) {
                        name = type;
                    }
                    BOType boType = new BOType(name, type, objTypes.getString("SHORTTEXT"));
                    boType.parent = boTypes;
                    boType.index = boTypes.getSize();
                    boTypes.add(boType, boType.getObjectName() + "-" + boType.getObjectType());
                } while (objTypes.nextRow());
            }
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
    }

    synchronized void initClients(Clients clients) throws GenericCollectionException {
        int codeStart = 0;
        int codeLength = 0;
        int descriptionStart = 0;
        int descriptionLength = 0;
        int otherStart = 0;
        int otherLength = 0;
        FieldTexts codeTexts = new FieldTexts();
        FieldTexts descriptionTexts = new FieldTexts();
        Client client = null;
        if (clients.initialized) {
            return;
        }
        JCO.Function function = this.createFunction("BAPI_HELPVALUES_GET");
        if (function == null) {
            throw new GenericCollectionFunctionNotFoundException("BAPI_HELPVALUES_GET");
        }
        clients.conversionExit = "";
        try {
            function.getImportParameterList().setValue("KNA1", "OBJTYPE");
            function.getImportParameterList().setValue("CheckExistence", "METHOD");
            function.getImportParameterList().setValue("CustomerData", "PARAMETER");
            function.getImportParameterList().setValue("MANDT", "FIELD");
            this.getConnection().execute(function);
            JCO.Structure returnStructure = function.getExportParameterList().getStructure("RETURN");
            if (!ObjectFactory.isBapiReturnCodeOkay((JCO.Record)returnStructure)) {
                throw new GenericCollectionBadBapiReturnCodeException(ObjectFactory.getBapiReturnErrorMessage((JCO.Record)returnStructure));
            }
            JCO.Table metadata = function.getTableParameterList().getTable("DESCRIPTION_FOR_HELPVALUES");
            JCO.Table data = function.getTableParameterList().getTable("HELPVALUES");
            int metadataRowCount = metadata.getNumRows();
            int dataRowCount = data.getNumRows();
            int i = 0;
            while (i < metadataRowCount) {
                metadata.setRow(i);
                if (metadata.getString("FIELDNAME").equals("MANDT")) {
                    codeStart = metadata.getInt("OFFSET");
                    codeLength = metadata.getInt("LENG");
                    codeTexts.columnHeading = metadata.getString("REPTEXT");
                    codeTexts.labelLong = metadata.getString("SCRTEXT_L");
                    codeTexts.labelMedium = metadata.getString("SCRTEXT_M");
                    codeTexts.labelShort = metadata.getString("SCRTEXT_S");
                    codeTexts.description = metadata.getString("FIELDTEXT");
                } else if (metadata.getString("FIELDNAME").equals("MTEXT")) {
                    descriptionStart = metadata.getInt("OFFSET");
                    descriptionLength = metadata.getInt("LENG");
                    descriptionTexts.columnHeading = metadata.getString("REPTEXT");
                    descriptionTexts.labelLong = metadata.getString("SCRTEXT_L");
                    descriptionTexts.labelMedium = metadata.getString("SCRTEXT_M");
                    descriptionTexts.labelShort = metadata.getString("SCRTEXT_S");
                    descriptionTexts.description = metadata.getString("FIELDTEXT");
                } else if (metadata.getString("FIELDNAME").equals("ORT01")) {
                    otherStart = metadata.getInt("OFFSET");
                    otherLength = metadata.getInt("LENG");
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < dataRowCount) {
                data.setRow(i2);
                String s = data.getString(0);
                client = new Client();
                client.setInternalCode(StaticHelper.extractSubstring(s, codeStart, codeLength));
                client.setDescription(StaticHelper.extractSubstring(s, descriptionStart, descriptionLength));
                client.city = StaticHelper.extractSubstring(s, otherStart, otherLength);
                client.setParent(clients);
                clients.add(client);
                ++i2;
            }
            clients.codeTexts = codeTexts;
            clients.descriptionTexts = descriptionTexts;
            clients.codeLength = codeLength;
            clients.descriptionLength = descriptionLength;
            clients.initialized = true;
            clients.isConversionInitialized = false;
        }
        catch (GenericCollectionException ex) {
            throw ex;
        }
        catch (JCO.Exception ex) {
            throw new GenericCollectionConnectionException(ex.toString(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new GenericCollectionException(ex.toString(), ex);
        }
    }

    synchronized void initCompanyCodes(CompanyCodes companyCodes) throws GenericCollectionException {
        if (companyCodes.initialized) {
            return;
        }
        JCO.Function function = this.createFunction("BAPI_COMPANYCODE_GETLIST");
        if (function == null) {
            throw new GenericCollectionFunctionNotFoundException("BAPI_COMPANYCODE_GETLIST");
        }
        try {
            this.getConnection().execute(function);
            JCO.Structure returnStructure = function.getExportParameterList().getStructure("RETURN");
            if (!ObjectFactory.isBapiReturnCodeOkay((JCO.Record)returnStructure)) {
                throw new GenericCollectionBadBapiReturnCodeException(ObjectFactory.getBapiReturnErrorMessage((JCO.Record)returnStructure));
            }
            JCO.Table data = function.getTableParameterList().getTable("COMPANYCODE_LIST");
            int dataRowCount = data.getNumRows();
            int i = 0;
            while (i < dataRowCount) {
                data.setRow(i);
                CompanyCode companyCode = new CompanyCode(data.getString("COMP_CODE"), data.getString("COMP_NAME"), companyCodes);
                companyCodes.add(companyCode);
                ++i;
            }
            companyCodes.codeLength = data.getField("COMP_CODE").getLength();
            companyCodes.descriptionLength = data.getField("COMP_NAME").getLength();
            companyCodes.codeTexts = this.getStructures().getStructure((String)"BAPI0002_1").getField((String)"COMP_CODE").fieldTexts;
            companyCodes.descriptionTexts = this.getStructures().getStructure((String)"BAPI0002_1").getField((String)"COMP_NAME").fieldTexts;
            companyCodes.initialized = true;
        }
        catch (GenericCollectionException ex) {
            throw ex;
        }
        catch (JCO.Exception ex) {
            throw new GenericCollectionConnectionException(ex.toString(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new GenericCollectionException(ex.toString(), ex);
        }
    }

    synchronized void initControllingAreas(ControllingAreas controllingAreas) throws GenericCollectionException {
        if (controllingAreas.initialized) {
            return;
        }
        JCO.Function function = this.createFunction("BAPI_CONTROLLINGAREA_GETLIST");
        if (function == null) {
            throw new GenericCollectionFunctionNotFoundException("BAPI_CONTROLLINGAREA_GETLIST");
        }
        try {
            this.getConnection().execute(function);
            JCO.Structure returnStructure = function.getExportParameterList().getStructure("RETURN");
            if (!ObjectFactory.isBapiReturnCodeOkay((JCO.Record)returnStructure)) {
                throw new GenericCollectionBadBapiReturnCodeException(ObjectFactory.getBapiReturnErrorMessage((JCO.Record)returnStructure));
            }
            JCO.Table data = function.getTableParameterList().getTable("CONTROLLINGAREA_LIST");
            int dataRowCount = data.getNumRows();
            int i = 0;
            while (i < dataRowCount) {
                data.setRow(i);
                ControllingArea controllingArea = new ControllingArea(data.getString("CO_AREA"), data.getString("NAME"), this.companyCodes);
                controllingAreas.add(controllingArea);
                ++i;
            }
            controllingAreas.codeLength = data.getField("CO_AREA").getLength();
            controllingAreas.descriptionLength = data.getField("NAME").getLength();
            controllingAreas.codeTexts = this.getStructures().getStructure((String)"BAPI0004_1").getField((String)"CO_AREA").fieldTexts;
            controllingAreas.descriptionTexts = this.getStructures().getStructure((String)"BAPI0004_1").getField((String)"NAME").fieldTexts;
            controllingAreas.initialized = true;
        }
        catch (GenericCollectionException ex) {
            throw ex;
        }
        catch (JCO.Exception ex) {
            throw new GenericCollectionConnectionException(ex.toString(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new GenericCollectionException(ex.toString(), ex);
        }
    }

    synchronized void initConversionGenericCollection(GenericCollection gc) throws ConversionExitException {
        gc.isConversionInitialized = true;
        if (!this.isConversionExitSupported(gc.conversionExit)) {
            throw new ConversionExitNotSupportedException();
        }
        JCO.Function function = this.createFunction("BAPI_CONVERSION_INT2EXT");
        if (function == null) {
            throw new ConversionExitFunctionNotFoundException("BAPI_CONVERSION_INT2EXT");
        }
        try {
            ConversionExitDescriptor descriptor = ObjectFactory.getConversionExitDescriptors().getConversionExitDescriptor(gc.conversionExit);
            JCO.Table data = function.getTableParameterList().getTable("DATA");
            JCO.Table returns = function.getTableParameterList().getTable("RETURN");
            int size = gc.internalItems.getSize();
            data.appendRows(size);
            int i = 0;
            while (i < size) {
                data.setRow(i);
                data.setValue(descriptor.objectType, "OBJTYPE");
                data.setValue(descriptor.methodName, "METHOD");
                data.setValue(descriptor.parameterName, "PARAMETER");
                data.setValue(descriptor.fieldName, "FIELD");
                data.setValue(i, "ROWNUMBER");
                data.setValue(((GenericItem)gc.internalItems.getItem(i)).getInternalCode(), "INT_FORMAT");
                ++i;
            }
            this.getConnection().execute(function);
            if (returns.getNumRows() > 0) {
                throw new ConversionExitBadBapiReturnCodeException(ObjectFactory.getBapiReturnErrorMessage((JCO.Record)returns));
            }
            int i2 = 0;
            while (i2 < size) {
                data.setRow(i2);
                String s = data.getString("EXT_FORMAT");
                int index = data.getInt("ROWNUMBER");
                GenericItem item = (GenericItem)gc.internalItems.getItem(index);
                item.setExternalCode(s);
                gc.externalItems.add(item, s);
                ++i2;
            }
        }
        catch (ConversionExitException ex) {
            throw ex;
        }
        catch (JCO.Exception ex) {
            throw new ConversionExitConnectionException(ex.toString(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new ConversionExitException(ex.toString(), ex);
        }
    }

    synchronized String initSegments(String iDocTypeName, String iDocTypeExtensionName, IDocSegments iDocSegments) throws MetaDataAccessException {
        String name;
        IDocSegments colDocSegments = new IDocSegments();
        JCO.Function function = this.createFunction("IDOCTYPE_READ_COMPLETE");
        if (function == null) {
            throw new MetaDataAccessFunctionNotFoundException("IDOCTYPE_READ_COMPLETE");
        }
        try {
            IDocSegment parentSegment;
            function.getImportParameterList().setValue(iDocTypeName, "PI_IDOCTYP");
            function.getImportParameterList().setValue(iDocTypeExtensionName, "PI_CIMTYP");
            function.getImportParameterList().setValue("", "PI_RELEASE");
            this.getConnection().execute(function);
            JCO.Table segments = function.getTableParameterList().getTable("PT_SEGMENTS");
            JCO.Table fields = function.getTableParameterList().getTable("PT_FIELDS");
            JCO.Table values = function.getTableParameterList().getTable("PT_FVALUES");
            JCO.Structure header = function.getExportParameterList().getStructure("PE_HEADER");
            name = header.getString("PRETYP");
            int count = segments.getNumRows();
            int i = 0;
            while (i < count) {
                segments.setRow(i);
                String r = segments.getString("NR");
                r = StaticHelper.repeat("0", 4 - r.length()) + r;
                String s = segments.getString("PARPNO");
                s = StaticHelper.repeat("0", 4 - s.length()) + s;
                IDocSegment iDocSegment = new IDocSegment(r, segments.getString("SEGMENTTYP"), segments.getString("SEGMENTDEF"), segments.getString("QUALIFIER").equals("X"), segments.getInt("SEGLEN"), segments.getString("PARSEG"), s, segments.getString("PARFLG").equals("X"), segments.getString("MUSTFL").equals("X"), Long.valueOf(segments.getString("OCCMIN")), Long.valueOf(segments.getString("OCCMAX")), segments.getInt("HLEVEL"), segments.getString("DESCRP"), segments.getString("GRP_MUSTFL").equals("X"), Long.valueOf(segments.getString("GRP_OCCMIN")), Long.valueOf(segments.getString("GRP_OCCMAX")), segments.getString("REFSEGTYP"));
                colDocSegments.add(iDocSegment, iDocSegment.getName());
                if (iDocSegment.getParentNumber().equals("0000")) {
                    iDocSegment.parent = iDocSegments;
                    iDocSegment.index = iDocSegments.getSize();
                    iDocSegments.add(iDocSegment, iDocSegment.getName());
                } else {
                    parentSegment = colDocSegments.getIDocSegment(iDocSegment.getParentSegmentName());
                    iDocSegment.parent = parentSegment.getChildren();
                    iDocSegment.index = parentSegment.getChildren().getSize();
                    parentSegment.getChildren().add(iDocSegment, iDocSegment.getName());
                }
                ++i;
            }
            count = fields.getNumRows();
            int i2 = 0;
            while (i2 < count) {
                fields.setRow(i2);
                IDocSegmentField iDocSegmentField = new IDocSegmentField(fields.getString("FIELDNAME"), fields.getString("DESCRP"), fields.getInt("INTLEN"), fields.getInt("EXTLEN"), fields.getInt("FIELD_POS"), fields.getInt("BYTE_FIRST"), fields.getInt("BYTE_LAST"), fields.getString("ROLLNAME"), fields.getString("DOMNAME"), fields.getString("DATATYPE"), fields.getString("ISOCODE").equals("X"), fields.getString("VALUETAB"));
                IDocSegment parentSegment2 = colDocSegments.getIDocSegment(fields.getString("SEGMENTTYP"));
                iDocSegmentField.parent = parentSegment2.getIDocSegmentFields();
                iDocSegmentField.index = parentSegment2.getIDocSegmentFields().getSize();
                parentSegment2.getIDocSegmentFields().add(iDocSegmentField, iDocSegmentField.getName());
                ++i2;
            }
            count = values.getNumRows();
            int i3 = 0;
            while (i3 < count) {
                values.setRow(i3);
                IDocSegmentFieldValue iDocSegmentFieldValue = new IDocSegmentFieldValue(values.getString("DESCRP"), values.getString("FLDVALUE_L"), values.getString("FLDVALUE_H"));
                try {
                    parentSegment = colDocSegments.getIDocSegment(values.getString("STRNAME"));
                    IDocSegmentField field = parentSegment.getIDocSegmentFields().getIDocSegmentField(values.getString("FIELDNAME"));
                    field.getIDocSegmentFieldValues().add(iDocSegmentFieldValue);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ++i3;
            }
        }
        catch (JCO.AbapException ex) {
            if (ex.getKey().equalsIgnoreCase("SEGMENT_UNKNOWN") || ex.getKey().equalsIgnoreCase("OBJECT_UNKNOWN") || ex.getKey().equalsIgnoreCase("RELATION_NOT_FOUND")) {
                return "";
            }
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (JCO.Exception ex) {
            throw new MetaDataAccessConnectionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new MetaDataAccessException(ex);
        }
        return name;
    }

    synchronized void initUnitsOfMeasure(UnitsOfMeasure unitsOfMeasure) throws GenericCollectionException {
        int internalCodeStart = 0;
        int internalCodeLength = 0;
        int descriptionStart = 0;
        int descriptionLength = 0;
        int externalCodeStart = 0;
        int externalCodeLength = 0;
        int dimensionDescriptionStart = 0;
        int dimensionDescriptionLength = 0;
        FieldTexts codeTexts = new FieldTexts();
        FieldTexts descriptionTexts = new FieldTexts();
        UnitOfMeasure unitOfMeasure = null;
        if (unitsOfMeasure.initialized) {
            return;
        }
        JCO.Function function = this.createFunction("BAPI_HELPVALUES_GET");
        if (function == null) {
            throw new GenericCollectionFunctionNotFoundException("BAPI_HELPVALUES_GET");
        }
        unitsOfMeasure.conversionExit = "CUNIT";
        try {
            function.getImportParameterList().setValue("BUS1001", "OBJTYPE");
            function.getImportParameterList().setValue("GetDetail", "METHOD");
            function.getImportParameterList().setValue("MaterialGeneralData", "PARAMETER");
            function.getImportParameterList().setValue("BASE_UOM", "FIELD");
            this.getConnection().execute(function);
            JCO.Structure returnStructure = function.getExportParameterList().getStructure("RETURN");
            if (!ObjectFactory.isBapiReturnCodeOkay((JCO.Record)returnStructure)) {
                throw new GenericCollectionBadBapiReturnCodeException(ObjectFactory.getBapiReturnErrorMessage((JCO.Record)returnStructure));
            }
            JCO.Table metadata = function.getTableParameterList().getTable("DESCRIPTION_FOR_HELPVALUES");
            JCO.Table data = function.getTableParameterList().getTable("HELPVALUES");
            int metadataRowCount = metadata.getNumRows();
            int dataRowCount = data.getNumRows();
            int i = 0;
            while (i < metadataRowCount) {
                metadata.setRow(i);
                if (metadata.getString("FIELDNAME").equals("MSEHI")) {
                    internalCodeStart = metadata.getInt("OFFSET");
                    internalCodeLength = metadata.getInt("LENG");
                    codeTexts.columnHeading = metadata.getString("REPTEXT");
                    codeTexts.labelLong = metadata.getString("SCRTEXT_L");
                    codeTexts.labelMedium = metadata.getString("SCRTEXT_M");
                    codeTexts.labelShort = metadata.getString("SCRTEXT_S");
                    codeTexts.description = metadata.getString("FIELDTEXT");
                } else if (metadata.getString("FIELDNAME").equals("MSEHL")) {
                    descriptionStart = metadata.getInt("OFFSET");
                    descriptionLength = metadata.getInt("LENG");
                    descriptionTexts.columnHeading = metadata.getString("REPTEXT");
                    descriptionTexts.labelLong = metadata.getString("SCRTEXT_L");
                    descriptionTexts.labelMedium = metadata.getString("SCRTEXT_M");
                    descriptionTexts.labelShort = metadata.getString("SCRTEXT_S");
                    descriptionTexts.description = metadata.getString("FIELDTEXT");
                } else if (metadata.getString("FIELDNAME").equals("TXDIM")) {
                    dimensionDescriptionStart = metadata.getInt("OFFSET");
                    dimensionDescriptionLength = metadata.getInt("LENG");
                } else if (metadata.getString("FIELDNAME").equals("MSEH3")) {
                    externalCodeStart = metadata.getInt("OFFSET");
                    externalCodeLength = metadata.getInt("LENG");
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < dataRowCount) {
                data.setRow(i2);
                String s = data.getString(0);
                unitOfMeasure = new UnitOfMeasure();
                unitOfMeasure.setInternalCode(StaticHelper.extractSubstring(s, internalCodeStart, internalCodeLength));
                unitOfMeasure.setExternalCode(StaticHelper.extractSubstring(s, externalCodeStart, externalCodeLength));
                unitOfMeasure.setDescription(StaticHelper.extractSubstring(s, descriptionStart, descriptionLength));
                unitOfMeasure.setParent(unitsOfMeasure);
                unitsOfMeasure.add(unitOfMeasure);
                ++i2;
            }
            unitsOfMeasure.codeTexts = codeTexts;
            unitsOfMeasure.descriptionTexts = descriptionTexts;
            unitsOfMeasure.codeLength = internalCodeLength;
            unitsOfMeasure.descriptionLength = descriptionLength;
            unitsOfMeasure.initialized = true;
            unitsOfMeasure.isConversionInitialized = true;
        }
        catch (GenericCollectionException ex) {
            throw ex;
        }
        catch (JCO.Exception ex) {
            throw new GenericCollectionConnectionException(ex.toString(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new GenericCollectionException(ex.toString(), ex);
        }
    }

    synchronized void initValuationAreas(ValuationAreas valuationAreas) throws GenericCollectionException {
        int codeStart = 0;
        int codeLength = 0;
        int descriptionStart = 0;
        int descriptionLength = 0;
        int otherStart = 0;
        int otherLength = 0;
        FieldTexts codeTexts = new FieldTexts();
        FieldTexts descriptionTexts = new FieldTexts();
        ValuationArea valuationArea = null;
        if (valuationAreas.initialized) {
            return;
        }
        JCO.Function function = this.createFunction("BAPI_HELPVALUES_GET");
        if (function == null) {
            throw new GenericCollectionFunctionNotFoundException("BAPI_HELPVALUES_GET");
        }
        valuationAreas.conversionExit = "";
        try {
            function.getImportParameterList().setValue("BUS6001", "OBJTYPE");
            function.getImportParameterList().setValue("CheckAccountAssignment", "METHOD");
            function.getImportParameterList().setValue("ChangedCodingblock", "PARAMETER");
            function.getImportParameterList().setValue("VAL_AREA", "FIELD");
            this.getConnection().execute(function);
            JCO.Structure returnStructure = function.getExportParameterList().getStructure("RETURN");
            if (!ObjectFactory.isBapiReturnCodeOkay((JCO.Record)returnStructure)) {
                throw new GenericCollectionBadBapiReturnCodeException(ObjectFactory.getBapiReturnErrorMessage((JCO.Record)returnStructure));
            }
            JCO.Table metadata = function.getTableParameterList().getTable("DESCRIPTION_FOR_HELPVALUES");
            JCO.Table data = function.getTableParameterList().getTable("HELPVALUES");
            int metadataRowCount = metadata.getNumRows();
            int dataRowCount = data.getNumRows();
            int i = 0;
            while (i < metadataRowCount) {
                metadata.setRow(i);
                if (metadata.getString("FIELDNAME").equals("BWKEY")) {
                    codeStart = metadata.getInt("OFFSET");
                    codeLength = metadata.getInt("LENG");
                    codeTexts.columnHeading = metadata.getString("REPTEXT");
                    codeTexts.labelLong = metadata.getString("SCRTEXT_L");
                    codeTexts.labelMedium = metadata.getString("SCRTEXT_M");
                    codeTexts.labelShort = metadata.getString("SCRTEXT_S");
                    codeTexts.description = metadata.getString("FIELDTEXT");
                } else if (metadata.getString("FIELDNAME").equals("BUTXT")) {
                    descriptionStart = metadata.getInt("OFFSET");
                    descriptionLength = metadata.getInt("LENG");
                    descriptionTexts.columnHeading = metadata.getString("REPTEXT");
                    descriptionTexts.labelLong = metadata.getString("SCRTEXT_L");
                    descriptionTexts.labelMedium = metadata.getString("SCRTEXT_M");
                    descriptionTexts.labelShort = metadata.getString("SCRTEXT_S");
                    descriptionTexts.description = metadata.getString("FIELDTEXT");
                } else if (metadata.getString("FIELDNAME").equals("BUKRS")) {
                    otherStart = metadata.getInt("OFFSET");
                    otherLength = metadata.getInt("LENG");
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < dataRowCount) {
                data.setRow(i2);
                String s = data.getString(0);
                valuationArea = new ValuationArea();
                valuationArea.setInternalCode(StaticHelper.extractSubstring(s, codeStart, codeLength));
                valuationArea.setDescription(StaticHelper.extractSubstring(s, descriptionStart, descriptionLength));
                valuationArea.companyCode = StaticHelper.extractSubstring(s, otherStart, otherLength);
                valuationArea.setParent(valuationAreas);
                valuationAreas.add(valuationArea);
                ++i2;
            }
            valuationAreas.codeTexts = codeTexts;
            valuationAreas.descriptionTexts = descriptionTexts;
            valuationAreas.codeLength = codeLength;
            valuationAreas.descriptionLength = descriptionLength;
            valuationAreas.initialized = true;
            valuationAreas.isConversionInitialized = false;
        }
        catch (GenericCollectionException ex) {
            throw ex;
        }
        catch (JCO.Exception ex) {
            throw new GenericCollectionConnectionException(ex.toString(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new GenericCollectionException(ex.toString(), ex);
        }
    }

    public static boolean isBapiReturnCodeOkay(JCO.Record object) {
        try {
            if (object instanceof JCO.Structure) {
                JCO.Structure istructure = (JCO.Structure)object;
                return istructure.getString("TYPE").equals("") || istructure.getString("TYPE").equals("S");
            }
            if (object instanceof JCO.Table) {
                JCO.Table itable = (JCO.Table)object;
                int count = itable.getNumRows();
                if (count == 0) {
                    return true;
                }
                boolean allOkay = true;
                int i = 0;
                while (i < count) {
                    itable.setRow(i);
                    if (!itable.getString("TYPE").equals("") && !itable.getString("TYPE").equals("S")) {
                        allOkay = false;
                        break;
                    }
                    ++i;
                }
                itable.setRow(0);
                return allOkay;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    boolean isClassMethod(BOMethod boMethod) throws MetaDataAccessException {
        BOType boType = boMethod.parent.parent;
        int size = boType.getBOKeyFields().getSize();
        if (size == 0) {
            return true;
        }
        Rfm rfm = boMethod.getRfm();
        int i = 0;
        while (i < size) {
            BOParameter boParameter;
            BOKeyField boKeyField = boType.getBOKeyFields().getBOKeyField(i);
            String keyFieldName = boKeyField.getName();
            if (!rfm.getRfmParameters().exists(keyFieldName)) {
                return true;
            }
            RfmParameter rfmParameter = rfm.getRfmParameter(keyFieldName);
            if (!rfmParameter.isImport() || !rfmParameter.isScalar()) {
                return true;
            }
            if (boMethod.getBOParameters().exists(keyFieldName) && (boParameter = boMethod.getBOParameters().getBOParameter(keyFieldName)).isImport()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isConversionExitSupported(String name) {
        if (!mConversionExitDescriptors.exists(name)) {
            return false;
        }
        ConversionExitDescriptor descriptor = mConversionExitDescriptors.getConversionExitDescriptor(name);
        return this.getSapRelease().compareTo(descriptor.release) >= 0;
    }

    boolean isFactoryMethod(BOMethod boMethod) throws MetaDataAccessException {
        BOType boType = boMethod.parent.parent;
        int size = boType.getBOKeyFields().getSize();
        if (size == 0) {
            return false;
        }
        Rfm rfm = boMethod.getRfm();
        int i = 0;
        while (i < size) {
            BOKeyField boKeyField = boType.getBOKeyFields().getBOKeyField(i);
            String keyFieldName = boKeyField.getName();
            if (!rfm.getRfmParameters().exists(keyFieldName)) {
                return false;
            }
            RfmParameter rfmParameter = rfm.getRfmParameter(keyFieldName);
            if (!rfmParameter.isExport() || !rfmParameter.isScalar()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean isInstanceMethod(BOMethod boMethod) throws MetaDataAccessException {
        return !this.isClassMethod(boMethod);
    }

    public static int moveCorresponding(JCO.Record from, JCO.Record to) {
        int count = 0;
        int fci = from.getFieldCount();
        int fcj = to.getFieldCount();
        int i = 0;
        while (i < fci) {
            IMetaData si = from.getMetaData();
            int j = 0;
            while (j < fcj) {
                IMetaData sj = to.getMetaData();
                if (si.getName(i).equals(sj.getName(j)) && si.getDecimals(i) == sj.getDecimals(j) && si.getLength(i) == sj.getLength(j) && si.getType(i) == sj.getType(j)) {
                    to.setValue(from.getValue(i), j);
                    ++count;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return count;
    }

    synchronized void retrieveCompanyCode(CompanyCode companyCode) throws GenericCollectionException {
        if (companyCode.initialized) {
            return;
        }
        JCO.Function function = this.createFunction("BAPI_COMPANYCODE_GETDETAIL");
        if (function == null) {
            throw new GenericCollectionFunctionNotFoundException("BAPI_COMPANYCODE_GETDETAIL");
        }
        try {
            function.getImportParameterList().setValue(companyCode.getInternalCode(), "COMPANYCODEID");
            this.getConnection().execute(function);
            JCO.Structure returnStructure = function.getExportParameterList().getStructure("RETURN");
            if (!ObjectFactory.isBapiReturnCodeOkay((JCO.Record)returnStructure) && !returnStructure.getString("CODE").equals("FN021")) {
                throw new GenericCollectionBadBapiReturnCodeException(returnStructure.toString());
            }
            JCO.Structure detail = function.getExportParameterList().getStructure("COMPANYCODE_DETAIL");
            companyCode.city = detail.getString("CITY");
            companyCode.countryCode = detail.getString("COUNTRY");
            companyCode.currencyCode = detail.getString("CURRENCY");
            companyCode.languageCode = detail.getString("LANGU");
            companyCode.chartOfAccountsCode = detail.getString("CHRT_ACCTS");
            companyCode.fiscalYearVariantCode = detail.getString("FY_VARIANT");
            companyCode.vatRegistrationNumber = detail.getString("VAT_REG_NO");
            companyCode.company_Code = detail.getString("COMPANY");
            companyCode.addressNumber = detail.getString("ADDR_NO");
            companyCode.countryCodeISO = detail.getString("COUNTRY_ISO");
            companyCode.currencyCodeISO = detail.getString("CURRENCY_ISO");
            companyCode.languageCodeISO = detail.getString("LANGU_ISO");
            companyCode.initialized = true;
        }
        catch (GenericCollectionException ex) {
            throw ex;
        }
        catch (JCO.Exception ex) {
            throw new GenericCollectionConnectionException(ex.toString(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new GenericCollectionException(ex.toString(), ex);
        }
    }

    synchronized void retrieveCompanyCode2(CompanyCode companyCode) throws GenericCollectionException {
        if (!companyCode.controllingArea.equals("?")) {
            return;
        }
        JCO.Function function = this.createFunction("BAPI_CONTROLLINGAREA_FIND");
        if (function == null) {
            throw new GenericCollectionFunctionNotFoundException("BAPI_CONTROLLINGAREA_FIND");
        }
        try {
            function.getImportParameterList().setValue(companyCode.getInternalCode(), "COMPANYCODEID");
            this.getConnection().execute(function);
            JCO.Structure returnStructure = function.getExportParameterList().getStructure("RETURN");
            companyCode.controllingArea = !ObjectFactory.isBapiReturnCodeOkay((JCO.Record)returnStructure) ? "" : function.getExportParameterList().getString("CONTROLLINGAREAID");
        }
        catch (JCO.Exception ex) {
            throw new GenericCollectionConnectionException(ex.toString(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new GenericCollectionException(ex.toString(), ex);
        }
    }

    synchronized void retrieveControllingArea(ControllingArea controllingArea) throws GenericCollectionException {
        if (controllingArea.initialized) {
            return;
        }
        JCO.Function function = this.createFunction("BAPI_CONTROLLINGAREA_GETDETAIL");
        if (function == null) {
            throw new GenericCollectionFunctionNotFoundException("BAPI_CONTROLLINGAREA_GETDETAIL");
        }
        try {
            function.getImportParameterList().setValue(controllingArea.getInternalCode(), "CONTROLLINGAREAID");
            this.getConnection().execute(function);
            JCO.Structure returnStructure = function.getExportParameterList().getStructure("RETURN");
            if (!ObjectFactory.isBapiReturnCodeOkay((JCO.Record)returnStructure)) {
                throw new GenericCollectionBadBapiReturnCodeException(returnStructure.toString());
            }
            JCO.Structure detail = function.getExportParameterList().getStructure("CONTROLLINGAREA_DETAIL");
            controllingArea.currencyCode = detail.getString("CURRENCY");
            controllingArea.chartOfAccountsCode = detail.getString("CHRT_ACCTS");
            controllingArea.fiscalYearVariantCode = detail.getString("FY_VARIANT");
            controllingArea.initialized = true;
        }
        catch (GenericCollectionException ex) {
            throw ex;
        }
        catch (JCO.Exception ex) {
            throw new GenericCollectionConnectionException(ex.toString(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new GenericCollectionException(ex.toString(), ex);
        }
    }

    void retrieveData(String checkTableName, int numberOfItemChildren, String objectName, String methodName, String parameterName, String fieldName, String codeFieldName, String[] descriptionFieldNames, SpecificCollection collection, Class itemClass, Class collectionClass) throws GenericCollectionException {
        this.retrieveData(checkTableName, numberOfItemChildren, objectName, methodName, parameterName, fieldName, codeFieldName, descriptionFieldNames, collection, itemClass, collectionClass, null, null);
    }

    synchronized void retrieveData(String checkTableName, int numberOfItemChildren, String objectName, String methodName, String parameterName, String fieldName, String codeFieldName, String[] descriptionFieldNames, SpecificCollection collection, Class itemClass, Class collectionClass, String[] parentCodeFieldNames, int[] childIndices) throws GenericCollectionException {
        int hierarchyLevels = 0;
        int codeStart = 0;
        int codeLength = 0;
        int descriptionStart = 0;
        int descriptionLength = 0;
        int[] parentCodeStarts = null;
        int[] parentCodeLengths = null;
        String[] parentCodes = null;
        FieldTexts codeTexts = new FieldTexts();
        FieldTexts descriptionTexts = new FieldTexts();
        SpecificItem parentItem = null;
        SpecificCollection parentCollection = null;
        Object child = null;
        Object objectCollectionItem = null;
        JCO.Function function = this.createFunction("BAPI_HELPVALUES_GET");
        if (function == null) {
            throw new GenericCollectionFunctionNotFoundException("BAPI_HELPVALUES_GET");
        }
        try {
            if (parentCodeFieldNames != null && parentCodeFieldNames.length != 0) {
                hierarchyLevels = parentCodeFieldNames.length;
                parentCodeStarts = new int[hierarchyLevels];
                parentCodeLengths = new int[hierarchyLevels];
                parentCodes = new String[hierarchyLevels];
            }
            function.getImportParameterList().setValue(objectName, "OBJNAME");
            function.getImportParameterList().setValue(methodName, "METHOD");
            function.getImportParameterList().setValue(parameterName, "PARAMETER");
            function.getImportParameterList().setValue(fieldName, "FIELD");
            this.getConnection().execute(function);
            JCO.Structure returnStructure = function.getExportParameterList().getStructure("RETURN");
            if (!returnStructure.getString("TYPE").equals("") && !returnStructure.getString("CODE").equals("HV013")) {
                throw new GenericCollectionBadBapiReturnCodeException(ObjectFactory.getBapiReturnErrorMessage((JCO.Record)returnStructure));
            }
            JCO.Table metadata = function.getTableParameterList().getTable("DESCRIPTION_FOR_HELPVALUES");
            JCO.Table data = function.getTableParameterList().getTable("HELPVALUES");
            int count = metadata.getNumRows();
            int i = 0;
            while (i < count) {
                metadata.setRow(i);
                if (metadata.getString("FIELDNAME").equals(codeFieldName)) {
                    codeStart = metadata.getInt("OFFSET");
                    codeLength = metadata.getInt("LENG");
                    codeTexts.columnHeading = metadata.getString("REPTEXT");
                    codeTexts.labelLong = metadata.getString("SCRTEXT_L");
                    codeTexts.labelMedium = metadata.getString("SCRTEXT_M");
                    codeTexts.labelShort = metadata.getString("SCRTEXT_S");
                    codeTexts.description = metadata.getString("FIELDTEXT");
                } else {
                    boolean found = false;
                    int j = 0;
                    while (j < hierarchyLevels) {
                        if (metadata.getString("FIELDNAME").equals(parentCodeFieldNames[j])) {
                            parentCodeStarts[j] = metadata.getInt("OFFSET");
                            parentCodeLengths[j] = metadata.getInt("LENG");
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        int length = descriptionFieldNames.length;
                        int j2 = 0;
                        while (j2 < length) {
                            if (metadata.getString("FIELDNAME").equals(descriptionFieldNames[j2])) {
                                descriptionStart = metadata.getInt("OFFSET");
                                descriptionLength = metadata.getInt("LENG");
                                descriptionTexts.columnHeading = metadata.getString("REPTEXT");
                                descriptionTexts.labelLong = metadata.getString("SCRTEXT_L");
                                descriptionTexts.labelMedium = metadata.getString("SCRTEXT_M");
                                descriptionTexts.labelShort = metadata.getString("SCRTEXT_S");
                                descriptionTexts.description = metadata.getString("FIELDTEXT");
                                break;
                            }
                            ++j2;
                        }
                    }
                }
                ++i;
            }
            count = data.getNumRows();
            int i2 = 0;
            while (i2 < count) {
                data.setRow(i2);
                String s = data.getString(0);
                int j = 0;
                while (j < hierarchyLevels) {
                    parentCodes[j] = StaticHelper.extractSubstring(s, parentCodeStarts[j], parentCodeLengths[j]);
                    ++j;
                }
                parentCollection = collection;
                boolean found = true;
                int j3 = 0;
                while (j3 < hierarchyLevels) {
                    if (parentCollection != null) {
                        parentItem = (SpecificItem)parentCollection.getInternalItem(parentCodes[j3]);
                        if (parentItem == null) {
                            found = false;
                        } else {
                            parentCollection = parentItem.getChild(childIndices[j3]);
                            if (parentCollection == null) {
                                found = false;
                            }
                        }
                    }
                    ++j3;
                }
                if (found) {
                    objectCollectionItem = itemClass.newInstance();
                    ((SpecificItem)objectCollectionItem).setInternalCode(StaticHelper.extractSubstring(s, codeStart, codeLength));
                    ((SpecificItem)objectCollectionItem).setDescription(StaticHelper.extractSubstring(s, descriptionStart, descriptionLength));
                    ((SpecificItem)objectCollectionItem).setParent(parentCollection);
                    parentCollection.add(objectCollectionItem);
                    parentCollection.codeTexts = codeTexts;
                    parentCollection.descriptionTexts = descriptionTexts;
                    parentCollection.numberOfItemChildren = numberOfItemChildren;
                    parentCollection.codeLength = codeLength;
                    parentCollection.descriptionLength = descriptionLength;
                    parentCollection.conversionExit = this.getStructure(checkTableName).getField(codeFieldName).getConversionExit();
                }
                ++i2;
            }
            collection.initialized = true;
        }
        catch (Exception ex) {
            throw new GenericCollectionException(ex.toString());
        }
    }

    void retrieveData(String checkTableName, int numberOfItemChildren, String objectName, String methodName, String parameterName, String fieldName, String codeFieldName, String descriptionFieldName, SpecificCollection collection, Class itemClass, Class collectionClass) throws GenericCollectionException {
        String[] strings = new String[]{descriptionFieldName};
        this.retrieveData(checkTableName, numberOfItemChildren, objectName, methodName, parameterName, fieldName, codeFieldName, strings, collection, itemClass, collectionClass, null, null);
    }

    void retrieveData(String checkTableName, int numberOfItemChildren, String objectName, String methodName, String parameterName, String fieldName, String codeFieldName, String descriptionFieldName, SpecificCollection collection, Class itemClass, Class collectionClass, String[] parentCodeFieldNames, int[] childIndices) throws GenericCollectionException {
        String[] strings = new String[]{descriptionFieldName};
        this.retrieveData(checkTableName, numberOfItemChildren, objectName, methodName, parameterName, fieldName, codeFieldName, strings, collection, itemClass, collectionClass, parentCodeFieldNames, childIndices);
    }

    synchronized void retrieveDataCurrency(Currency currency) throws GenericCollectionException {
        if (currency.initialized) {
            return;
        }
        JCO.Function function = this.createFunction("BAPI_CURRENCY_GETDECIMALS");
        if (function == null) {
            throw new GenericCollectionFunctionNotFoundException("BAPI_CURRENCY_GETDECIMALS");
        }
        try {
            function.getImportParameterList().setValue(currency.getInternalCode(), "CURRENCY");
            this.getConnection().execute(function);
            JCO.Structure returnStructure = function.getExportParameterList().getStructure("RETURN");
            if (!ObjectFactory.isBapiReturnCodeOkay((JCO.Record)returnStructure)) {
                throw new GenericCollectionBadBapiReturnCodeException(ObjectFactory.getBapiReturnErrorMessage((JCO.Record)returnStructure));
            }
            JCO.Structure details = function.getExportParameterList().getStructure("CURRENCY_DECIMALS");
            currency.isoCode = details.getString("CURRENCY_ISO");
            currency.decimals = details.getInt("CURDECIMALS");
            currency.initialized = true;
        }
        catch (GenericCollectionException ex) {
            throw ex;
        }
        catch (JCO.Exception ex) {
            throw new GenericCollectionConnectionException(ex.toString(), (Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new GenericCollectionException(ex.toString(), ex);
        }
    }

    private synchronized void setConnection(JCO.Client connection) throws ObjectFactoryException {
        this.reset();
        if (connection == null) {
            throw new ObjectFactoryException("Connection parameter must not be null.");
        }
        try {
            if (connection.getAttributes().getPartnerRelease().compareTo("31H") < 0) {
                this.mConnection = null;
                throw new ObjectFactoryException("Minimum supported SAP release is 3.1H");
            }
            this.mConnection = connection;
            this.mRepository = new JCO.Repository("ARAsoft", this.mConnection);
        }
        catch (Exception x) {
            throw new ObjectFactoryException(x.toString());
        }
    }

    public void testAllConversionsToExternal() {
        System.out.println("Start of conversion to external test");
        System.out.println("------------------------------------");
        int count = 0;
        int i = 0;
        while (i < mConversionExitDescriptors.getSize()) {
            ConversionExitDescriptor descriptor = mConversionExitDescriptors.getConversionExitDescriptor(i);
            try {
                String s = this.getExternalValue(descriptor.conversionExit, "?Q1", 16);
                ++count;
            }
            catch (ConversionExitConnectionException ex) {
                System.out.println("Conversion to external unsuccessful for exit: " + descriptor.conversionExit + ". Reason: " + ex);
                System.out.println("Exit already marked as dangerous: " + String.valueOf(descriptor.dangerous));
                System.out.println("------------------------------------");
                try {
                    this.getConnection().disconnect();
                    this.getConnection().connect();
                }
                catch (Exception ex1) {}
            }
            catch (ConversionExitNotSupportedException ex) {
                System.out.println("Conversion exit not supported before release: " + descriptor.release);
                System.out.println("------------------------------------");
            }
            catch (ConversionExitException ex) {
                System.out.println("Conversion to external unsuccessful for exit: " + descriptor.conversionExit + ". Reason: " + ex);
                System.out.println("------------------------------------");
            }
            ++i;
        }
        System.out.println("Successful conversions to external: " + String.valueOf(count));
        System.out.println("End of conversion to external test");
        System.out.println("------------------------------------");
    }

    public void testAllConversionsToInternal() {
        System.out.println("Start of conversion to internal test");
        System.out.println("------------------------------------");
        int count = 0;
        int i = 0;
        while (i < mConversionExitDescriptors.getSize()) {
            ConversionExitDescriptor descriptor = mConversionExitDescriptors.getConversionExitDescriptor(i);
            try {
                String s = this.getInternalValue(descriptor.conversionExit, "?Q1", 16);
                ++count;
            }
            catch (ConversionExitConnectionException ex) {
                System.out.println("Conversion to internal unsuccessful for exit: " + descriptor.conversionExit + ". Reason: " + ex);
                System.out.println("Exit already marked as dangerous: " + String.valueOf(descriptor.dangerous));
                System.out.println("------------------------------------");
                try {
                    this.getConnection().disconnect();
                    this.getConnection().connect();
                }
                catch (Exception ex1) {}
            }
            catch (ConversionExitNotSupportedException ex) {
                System.out.println("Conversion exit not supported before release: " + descriptor.release);
                System.out.println("------------------------------------");
            }
            catch (ConversionExitException ex) {
                System.out.println("Conversion to internal unsuccessful for exit: " + descriptor.conversionExit + ". Reason: " + ex);
                System.out.println("------------------------------------");
            }
            ++i;
        }
        System.out.println("Successful conversions to internal: " + String.valueOf(count));
        System.out.println("End of conversion to internal test");
        System.out.println("------------------------------------");
    }

    static {
        mMatchCodesDescriptors = new MatchCodesDescriptors();
        mMatchCodesDescriptors.add("KUNNR", "BUS2032", "CreateFromDat1", "OrderPartners", "PARTN_NUMB", "46B");
        mMatchCodesDescriptors.add("LIFNR", "LFA1", "Find", "ResultTab", "VENDOR_NO", "46B");
        mConversionExitDescriptors = new ConversionExitDescriptors();
        mConversionExitDescriptors.add("ALPHA", "BUS0002", "GetDetail", "CompanycodeAddress", "ADDR_NO", "40B", false);
        mConversionExitDescriptors.add("AOBAR", "BUS2002", "Getdetail", "ERelation", "RELATION_TYPE", "40B", true);
        mConversionExitDescriptors.add("AUART", "BUS2030", "CreateFromData", "OrderHeaderIn", "DOC_TYPE", "40B", false);
        mConversionExitDescriptors.add("BEKNZ", "BUS2072", "GetDetail", "LineItem", "DR_CR_IND", "40B", false);
        mConversionExitDescriptors.add("CUNIT", "BUS6010", "Check", "DocItems", "ACTIVITYUN", "40B", true);
        mConversionExitDescriptors.add("GJAHR", "BUS2012", "GetDetail", "PoItems", "SEASON_YR", "40B", true);
        mConversionExitDescriptors.add("ISOLA", "BUS1003", "GetCharacteristics", "LanguInt", "", "40B", true);
        mConversionExitDescriptors.add("ISTAT", "BUS1057", "GetRequestsAndLeaves", "Requests", "ISTAT_REQ", "40B", false);
        mConversionExitDescriptors.add("KONPR", "BUS2072", "GetDetail", "LineItemStatKeyFig", "WBS_ELEM", "40B", true);
        mConversionExitDescriptors.add("MATN1", "BUS6010", "Check", "DocItems", "MATERIAL", "40B", false);
        mConversionExitDescriptors.add("NUMCV", "BUS6010", "Check", "DocItems", "RECOPERATN", "40B", false);
        mConversionExitDescriptors.add("PARVW", "BUS2030", "CreateFromData", "OrderPartners", "PARTN_ROLE", "40B", false);
        mConversionExitDescriptors.add("PDATE", "APPLICANT", "CreateFromData", "DateOfBirth", "", "40B", true);
        mConversionExitDescriptors.add("POSID", "BUS1057", "ExistenceCheck", "FromPosition", "", "40B", false);
        mConversionExitDescriptors.add("PROJN", "BUS6010", "Check", "DocItems", "REC_WBS_EL", "40B", false);
        mConversionExitDescriptors.add("SCOPE", "BUS2001", "CreateFromData", "ProjectDefinitionStr", "OBJECTCLASS", "40B", true);
        mConversionExitDescriptors.add("AFIMC", "BUS1027", "GetConsUnits", "ConsUnitList", "CONSUNIT", "45B", false);
        mConversionExitDescriptors.add("BFIMC", "BUS1025", "GetItems", "ConsItemList", "CONSITEM", "45B", false);
        mConversionExitDescriptors.add("CFOBR", "BUS2030", "Change", "InquiryItemIn", "CFOP_CODE", "45B", true);
        mConversionExitDescriptors.add("EAN11", "BUS3032", "GetItems", "AssortmentlistPos", "EAN_UPC", "45B", false);
        mConversionExitDescriptors.add("EXCRT", "BUS2032", "ChangeFromData", "ConditionsIn", "CONEXCHRAT", "45B", true);
        mConversionExitDescriptors.add("MEASR", "BUS1057", "SaveEntityReplicas", "Measures", "MEASR_EXT", "45B", false);
        mConversionExitDescriptors.add("OBART", "BUS1057", "SaveValueReplicas", "Values", "OBJECTTYPE", "45B", true);
        mConversionExitDescriptors.add("PARC1", "HRMASTER", "SaveReplicaMultiple", "EmployeeArchivedObjects", "EE_DATA_ARCHIVING_STATUS", "45B", true);
        mConversionExitDescriptors.add("PERKZ", "BUS1001001", "Clone", "ClientData", "PERIOD_IND_EXPIRATION_DATE", "45B", true);
        mConversionExitDescriptors.add("SPDEV", "BUS4003", "Change", "Bapiadprt", "PRINT_DEST", "45B", true);
        mConversionExitDescriptors.add("TIMEA", "BUS2015", "ConfirmDecentral", "HeaderDeadlines", "TIMETYPE", "45B", false);
        mConversionExitDescriptors.add("TPLNR", "BUS2045", "StatInterface", "SampleHeader", "FUNCT_LOC", "45B", true);
        mConversionExitDescriptors.add("ABPSN", "BUS6010", "Check", "DocItems", "REC_WBS_EL", "46B", false);
        mConversionExitDescriptors.add("ABPSP", "BUS6029", "Check", "AccountAssignments", "WBS_ELEM", "46B", true);
        mConversionExitDescriptors.add("AKTPA", "HRMASTER", "SaveReplicaMultiple", "PdObjectStandardProfiles", "ACT_MAINT", "46B", false);
        mConversionExitDescriptors.add("DTYPE", "LIKP", "ConfirmDecentral", "Extension2", "TYPE", "46B", false);
        mConversionExitDescriptors.add("OMEGA", "HRMASTER", "SaveReplicaMultiple", "PdObjectWorkEvaluatResult", "EVALUATION_POINTS", "46B", false);
        mConversionExitDescriptors.add("SGENR", "BUS6010", "Check", "DocItems", "SRE_BUILDING", "46B", false);
        mConversionExitDescriptors.add("SGRNR", "BUS6010", "Check", "DocItems", "SRE_PROPERTY", "46B", false);
        mConversionExitDescriptors.add("SMENR", "BUS6010", "Check", "DocItems", "SRE_RENT_UNIT", "46B", false);
        mConversionExitDescriptors.add("SWENR", "BUS6010", "Check", "DocItems", "SRE_BUS_ENT", "46B", false);
        mConversionExitDescriptors.add("TSTPS", "BEBAC", "ReadMultiple", "FromTimeStamp", "", "46B", true);
        mConversionExitDescriptors.add("USTYP", "USER", "Change", "Logondata", "USTYP", "46B", false);
        mConversionExitDescriptors.add("XUTYP", "USER", "Clone", "Profiles", "BAPITYPE", "46B", false);
        mCheckTableDescriptors = new CheckTableDescriptors();
        mCheckTableDescriptors.add("FM01", "BUS6001", "CheckAccountAssignment", "ChangedCodingblock", "FM_AREA", "40B");
        mCheckTableDescriptors.add("J_1ATODC", "KNA1", "CheckExistence", "CustomerData", "STCDT", "40B");
        mCheckTableDescriptors.add("J_1BATL1", "KNA1", "CheckExistence", "CustomerData", "TXLW1", "40B");
        mCheckTableDescriptors.add("J_1BATL2", "KNA1", "CheckExistence", "CustomerData", "TXLW2", "40B");
        mCheckTableDescriptors.add("J_1BTXSTG", "KNA1", "CheckExistence", "CustomerData", "XSUBT", "40B");
        mCheckTableDescriptors.add("QIMTH", "BUS2045", "StatInterface", "ReportHeader", "METHOD", "40B");
        mCheckTableDescriptors.add("QPSH", "BUS2045", "StatInterface", "CharacteristicHeader", "CC_TYPE", "40B");
        mCheckTableDescriptors.add("T000", "KNA1", "CheckExistence", "CustomerData", "MANDT", "40B");
        mCheckTableDescriptors.add("T001", "BUS0004", "Find", "Companycodeid", "", "40B");
        mCheckTableDescriptors.add("T001K", "BUS6001", "CheckAccountAssignment", "ChangedCodingblock", "VAL_AREA", "40B");
        mCheckTableDescriptors.add("T001W", "BUS6001", "CheckAccountAssignment", "ChangedCodingblock", "PLANT", "40B");
        mCheckTableDescriptors.add("T002", "APPLICANT", "CreateFromData", "LetterLanguage", "", "40B");
        mCheckTableDescriptors.add("T004", "BUS0002", "GetDetail", "CompanycodeDetail", "CHRT_ACCTS", "40B");
        mCheckTableDescriptors.add("T005", "APPLICANT", "CreateFromData", "Country", "", "40B");
        mCheckTableDescriptors.add("T006", "BUS1031", "GetList", "ActivityTypeUnit", "", "40B");
        mCheckTableDescriptors.add("T006I", "BUS1001", "GetDetail", "MaterialGeneralData", "BASE_UOM_ISO", "40B");
        mCheckTableDescriptors.add("T009", "BUS0002", "GetDetail", "CompanycodeDetail", "FY_VARIANT", "40B");
        mCheckTableDescriptors.add("T014", "BUS2030", "CreateFromData", "BillingParty", "C_CTR_AREA", "40B");
        mCheckTableDescriptors.add("T016", "APPLICANT", "CreateFromData", "PreviousEmployment", "INDUSTRY", "40B");
        mCheckTableDescriptors.add("T023", "BUS2030", "CreateFromData", "OrderItemsIn", "MATL_GROUP", "40B");
        mCheckTableDescriptors.add("T024", "BUS2093", "GetDetail", "ReservationItems", "PUR_GROUP", "40B");
        mCheckTableDescriptors.add("T024E", "BUS6015", "GetCatalogs", "ValidCatalogs", "PURCH_ORG", "40B");
        mCheckTableDescriptors.add("T024L", "BUS1001", "GetDetail", "MaterialGeneralData", "LAB_DESIGN", "40B");
        mCheckTableDescriptors.add("T025", "BUS1001001", "Clone", "AddnlClientData", "VAL_CLASS", "40B");
        mCheckTableDescriptors.add("T027A", "BUS2012", "GetDetail", "PoItems", "SHIPPING", "40B");
        mCheckTableDescriptors.add("T069", "BUS3003", "GetList", "InforecordGeneral", "CERT_TYPE", "40B");
        mCheckTableDescriptors.add("T100A", "BUS6010", "Check", "Return", "ID", "40B");
        mCheckTableDescriptors.add("T134", "BUS1001", "GetDetail", "MaterialGeneralData", "MATL_TYPE", "40B");
        mCheckTableDescriptors.add("T137", "BUS1001", "GetDetail", "MaterialGeneralData", "IND_SECTOR", "40B");
        mCheckTableDescriptors.add("T141", "BUS1001001", "Clone", "ClientData", "PUR_STATUS", "40B");
        mCheckTableDescriptors.add("T142", "BUS1001", "GetDetail", "MaterialGeneralData", "STOR_CONDS", "40B");
        mCheckTableDescriptors.add("T143", "BUS1001", "GetDetail", "MaterialGeneralData", "TEMP_CONDS", "40B");
        mCheckTableDescriptors.add("T144", "BUS1001", "GetDetail", "MaterialGeneralData", "CONTAINER", "40B");
        mCheckTableDescriptors.add("T148", "BUS2093", "GetDetail", "ReservationItems", "SPEC_STOCK", "40B");
        mCheckTableDescriptors.add("T149C", "BUS2012", "GetDetail", "PoItems", "VAL_CAT", "40B");
        mCheckTableDescriptors.add("T151", "BUS2030", "CreateFromData", "OrderHeaderIn", "CUST_GROUP", "40B");
        mCheckTableDescriptors.add("T163", "BUS6015", "GetInfo", "ProcurementItem", "ITEM_CAT", "40B");
        mCheckTableDescriptors.add("T163B", "BUS2012", "GetDetail", "PoItemHistory", "HIST_TYPE", "40B");
        mCheckTableDescriptors.add("T163K", "BUS2093", "GetDetail", "ReservationItems", "ACCTASSCAT", "40B");
        mCheckTableDescriptors.add("T163L", "BUS2012", "GetDetail", "PoItems", "CONF_CTRL", "40B");
        mCheckTableDescriptors.add("T167F", "BUS2012", "GetDetail", "PoItemServices", "FORMULA", "40B");
        mCheckTableDescriptors.add("T16FB", "BUS2012", "GetDetail", "PoHeader", "REL_IND", "40B");
        mCheckTableDescriptors.add("T16FG", "BUS2012", "GetDetail", "PoHeader", "REL_GROUP", "40B");
        mCheckTableDescriptors.add("T171", "BUS2030", "CreateFromData", "OrderHeaderIn", "SALES_DIST", "40B");
        mCheckTableDescriptors.add("T176", "BUS2030", "CreateFromData", "OrderHeaderIn", "PO_METHOD", "40B");
        mCheckTableDescriptors.add("T178", "BUS1001001", "Clone", "SalesData", "MAT_PR_GRP", "40B");
        mCheckTableDescriptors.add("T188", "BUS2030", "CreateFromData", "OrderHeaderIn", "PRICE_GRP", "40B");
        mCheckTableDescriptors.add("T189", "BUS2030", "CreateFromData", "OrderHeaderIn", "PRICE_LIST", "40B");
        mCheckTableDescriptors.add("T190S", "BUS1001001", "Clone", "ClientData", "PROD_ALLOC", "40B");
        mCheckTableDescriptors.add("T300", "BUS1001001", "Clone", "StorageTypeData", "WHSE_NO", "40B");
        mCheckTableDescriptors.add("T352B", "EQUI", "GetCatalogProfile", "CatalogProfile", "CAT_PROF", "40B");
        mCheckTableDescriptors.add("T356A", "BUS2078", "GetKeyFigures", "Listofnotifications", "PRIOTYPE", "40B");
        mCheckTableDescriptors.add("T370C", "EQUI", "CreateFromData", "Equilocation", "ABCINDIC", "40B");
        mCheckTableDescriptors.add("T370K", "EQUI", "CreateFromData", "Equimaster", "EQUITYPE", "40B");
        mCheckTableDescriptors.add("T377P", "BUS1001001", "Clone", "PlantData", "SERNO_PROF", "40B");
        mCheckTableDescriptors.add("T418", "BUS2093", "GetDetail", "ReservationItems", "ITEM_CAT", "40B");
        mCheckTableDescriptors.add("T437S", "BUS1001001", "Clone", "PlantData", "REPMANPROF", "40B");
        mCheckTableDescriptors.add("T438A", "BUS1001001", "Clone", "PlantData", "MRP_TYPE", "40B");
        mCheckTableDescriptors.add("T441R", "BUS1001", "Availability", "CheckRule", "", "40B");
        mCheckTableDescriptors.add("T459A", "BUS3027", "Change", "RequirementItemOut", "REQU_TYPE", "40B");
        mCheckTableDescriptors.add("T461P", "BUS1001001", "Clone", "PlantData", "PLAN_STRGP", "40B");
        mCheckTableDescriptors.add("T501", "EMPLOYEET", "GetList", "OrgAssignment", "EGROUP", "40B");
        mCheckTableDescriptors.add("T503K", "EMPLOYEET", "GetList", "OrgAssignment", "ESUBGROUP", "40B");
        mCheckTableDescriptors.add("T522G", "APPLICANT", "CreateFromData", "FirstOfAdressKey", "", "40B");
        mCheckTableDescriptors.add("T538A", "BANKDETAIL", "Change", "Timeunit", "", "40B");
        mCheckTableDescriptors.add("T574A", "APPLICANT", "CreateFromData", "Qualification", "QUALIF", "40B");
        mCheckTableDescriptors.add("T6WP1", "BUS1001001", "Clone", "ClientData", "PROC_RULE", "40B");
        mCheckTableDescriptors.add("T6WP3", "BUS1001001", "Clone", "ClientData", "LABEL_TYPE", "40B");
        mCheckTableDescriptors.add("T6WP4", "BUS1001001", "Clone", "ClientData", "LABEL_FORM", "40B");
        mCheckTableDescriptors.add("T6WSA", "BUS1001001", "Clone", "ClientData", "SEASMATCAT", "40B");
        mCheckTableDescriptors.add("T6WSP", "BUS2012", "GetDetail", "PoItems", "SEASON_TY", "40B");
        mCheckTableDescriptors.add("T750D", "APPLICANT", "CreateFromData", "Medium", "", "40B");
        mCheckTableDescriptors.add("T750G", "APPLICANT", "CreateFromData", "UnsolicitedApplGroup", "", "40B");
        mCheckTableDescriptors.add("T751A", "APPLICANT", "CreateFromData", "VacancyAssignment", "VA_STATUS", "40B");
        mCheckTableDescriptors.add("T778O", "PDOTYPE_PT", "GetBookList", "AttendeeName", "PATYP", "40B");
        mCheckTableDescriptors.add("T778P", "PDOTYPE_PT", "GetBookList", "AttendeeBookList", "PLVAR", "40B");
        mCheckTableDescriptors.add("T778Q", "APPLICANT", "CreateFromData", "Qualification", "PROFIC_4", "40B");
        mCheckTableDescriptors.add("T778S", "PDOTYPE_PT", "GetBookList", "AttendeeBookList", "ISTAT", "40B");
        mCheckTableDescriptors.add("T856", "BUS6001", "CheckAccountAssignment", "ChangedCodingblock", "CS_TRANS_T", "40B");
        mCheckTableDescriptors.add("TAIF5", "BUS1057", "GetLeaves", "ProgLeaves", "SCALE", "40B");
        mCheckTableDescriptors.add("TBDLS", "BUS1010", "GetStatus", "CreditAccountDetail", "LOGICAL_SYS", "40B");
        mCheckTableDescriptors.add("TBRC", "KNA1", "CheckExistence", "CustomerData", "BRAN1", "40B");
        mCheckTableDescriptors.add("TCJ04", "BUS2001", "CreateFromData", "ProjectDefinitionStr", "RESPONSIBLE_NO", "40B");
        mCheckTableDescriptors.add("TCJ1", "BUS2054", "Maintain", "IWbsElementTable", "PROJ_TYPE", "40B");
        mCheckTableDescriptors.add("TCJ41", "BUS2001", "CreateFromData", "ProjectDefinitionStr", "PROJECT_PROFILE", "40B");
        mCheckTableDescriptors.add("TCK01", "BUS2044", "GetExplosion", "ExplosionList", "CSTG_TYPE", "40B");
        mCheckTableDescriptors.add("TCK03", "BUS2044", "GetList", "CostingVariant", "LOW", "40B");
        mCheckTableDescriptors.add("TCK05", "BUS2044", "GetExplosion", "ExplosionList", "VLTN_VRNT", "40B");
        mCheckTableDescriptors.add("TCK22", "BUS2044", "GetExplosion", "ExplosionList", "REF_OBJECT", "40B");
        mCheckTableDescriptors.add("TCKH7", "BUS2044", "GetDetail", "CostComponentGroup", "", "40B");
        mCheckTableDescriptors.add("TCKH8", "BUS2044", "GetDetail", "CostComponentView", "", "40B");
        mCheckTableDescriptors.add("TCN07", "BUS2054", "Maintain", "IWbsElementTable", "PRIORITY", "40B");
        mCheckTableDescriptors.add("TCURC", "PDOTYPE_PT", "GetBookList", "AttendeeBookList", "KWAER", "40B");
        mCheckTableDescriptors.add("TCURV", "BUS2030", "CreateFromData", "SoldToParty", "EXCHG_RATE", "40B");
        mCheckTableDescriptors.add("TCXPS", "BUS2001", "CreateFromData", "ProjectDefinitionStr", "WBS_SCHED_PROFILE", "40B");
        mCheckTableDescriptors.add("TDG41", "BUS1001001", "Clone", "ClientData", "HAZMATPROF", "40B");
        mCheckTableDescriptors.add("TDWA", "BUS1071", "GetLayoutDocuments", "Documents", "DTYPE", "40B");
        mCheckTableDescriptors.add("TDWE", "BUS1071", "GetLayoutDocuments", "CarrierType", "", "40B");
        mCheckTableDescriptors.add("TDWP", "BUS1071", "GetLayoutDocuments", "Documents", "DAPPL", "40B");
        mCheckTableDescriptors.add("TFACD", "KNA1", "CheckExistence", "CustomerData", "KNAZK", "40B");
        mCheckTableDescriptors.add("TFKB", "BUS6001", "CheckAccountAssignment", "ChangedCodingblock", "FUNC_AREA", "40B");
        mCheckTableDescriptors.add("TGSB", "BUS6001", "CheckAccountAssignment", "ChangedCodingblock", "BUS_AREA", "40B");
        mCheckTableDescriptors.add("TGSBK", "BUS0003", "GetDetail", "BusinessareaDetail", "CONS_BA", "40B");
        mCheckTableDescriptors.add("TINC", "BUS2030", "CreateFromData", "OrderHeaderIn", "INCOTERMS1", "40B");
        mCheckTableDescriptors.add("TKA01", "BUS6001", "CheckAccountAssignment", "ChangedCodingblock", "CO_AREA", "40B");
        mCheckTableDescriptors.add("TKUKL", "KNA1", "CheckExistence", "CustomerData", "KUKLA", "40B");
        mCheckTableDescriptors.add("TLGR", "BUS1001001", "Clone", "AddnlClientData", "LOADINGGRP", "40B");
        mCheckTableDescriptors.add("TLOG", "BUS1001001", "Clone", "PlantData", "HANDLG_GRP", "40B");
        mCheckTableDescriptors.add("TMAM", "BUS2012", "GetDetail", "PoItems", "COMMENT", "40B");
        mCheckTableDescriptors.add("TMBW1", "BUS1001001", "Clone", "ClientData", "SUP_SOURCE", "40B");
        mCheckTableDescriptors.add("TMCB", "BUS2012", "GetDetail", "PoHeader", "UPDATE_GRP", "40B");
        mCheckTableDescriptors.add("TMCO", "OIW", "GetCatalog", "InfoObjectDataSource", "INFOOBJECT", "40B");
        mCheckTableDescriptors.add("TMFG", "BUS2012", "GetDetail", "PoItems", "PRDTE_CTRL", "40B");
        mCheckTableDescriptors.add("TMSI1", "BUS2012", "GetDetail", "PoItems", "SI_CAT", "40B");
        mCheckTableDescriptors.add("TMSI2", "BUS2012", "GetDetail", "PoItems", "SUBITM_KEY", "40B");
        mCheckTableDescriptors.add("TMVF", "BUS1001001", "Clone", "PlantData", "AVAILCHECK", "40B");
        mCheckTableDescriptors.add("TMW3T", "BUS6015", "GetCatalogs", "ValidCatalogs", "CATALOG", "40B");
        mCheckTableDescriptors.add("TNLS", "KNA1", "CheckExistence", "CustomerData", "NIELS", "40B");
        mCheckTableDescriptors.add("TNTP", "BUS1001", "GetDetail", "MaterialGeneralData", "EAN_CAT", "40B");
        mCheckTableDescriptors.add("TOAAR", "EMPLOYEET", "GetList", "Archivelink", "ARCHIV_ID", "40B");
        mCheckTableDescriptors.add("TPAR", "BUS2030", "CreateFromData", "OrderPartners", "PARTN_ROLE", "40B");
        mCheckTableDescriptors.add("TPI01", "BUS2001", "CreateFromData", "ProjectDefinitionStr", "INT_PROFILE", "40B");
        mCheckTableDescriptors.add("TPTM", "BUS1001001", "Clone", "SalesData", "ITEM_CAT", "40B");
        mCheckTableDescriptors.add("TQ01B", "BUS1001001", "Clone", "PlantData", "QM_AUTHGRP", "40B");
        mCheckTableDescriptors.add("TQ02", "BUS1001001", "Clone", "PlantData", "QM_RGMTS", "40B");
        mCheckTableDescriptors.add("TQ05", "BUS2012", "GetDetail", "PoItems", "CERT_TYPE", "40B");
        mCheckTableDescriptors.add("TQ08", "BUS2012", "GetDetail", "PoItems", "CTR_KEY_QM", "40B");
        mCheckTableDescriptors.add("TQ17", "BUS204502", "GetResult", "CharResult", "ERR_CLASS", "40B");
        mCheckTableDescriptors.add("TQ30", "BUS2045", "StatInterface", "ReportHeader", "INSPTYPE", "40B");
        mCheckTableDescriptors.add("TQ73", "BUS2045", "StatInterface", "ResultsAdditionalDat", "RES_ORG", "40B");
        mCheckTableDescriptors.add("TQ79", "BUS204503", "GetRequirements", "Requirements", "IDENT_KEY", "40B");
        mCheckTableDescriptors.add("TQ80", "EQUI", "GetCatalogProfile", "CatalogProfile", "NOTIF_TYPE", "40B");
        mCheckTableDescriptors.add("TSAC", "BUS0002", "GetDetail", "CompanycodeAddress", "COMM_TYPE", "40B");
        mCheckTableDescriptors.add("TSAD3", "BUS2012", "CreateFromData", "PoAddress", "TITLE", "40B");
        mCheckTableDescriptors.add("TSAD6", "BUS2012", "CreateFromData", "PoAddress", "ADDRORIGIN", "40B");
        mCheckTableDescriptors.add("TTGR", "BUS1001001", "Clone", "ClientData", "TRANS_GRP", "40B");
        mCheckTableDescriptors.add("TTYP", "BUS6001", "CheckAccountAssignment", "ChangedCodingblock", "OBJ_TYPE", "40B");
        mCheckTableDescriptors.add("TVAK", "BUS2030", "CreateFromData", "OrderHeaderIn", "DOC_TYPE", "40B");
        mCheckTableDescriptors.add("TVAU", "BUS2030", "CreateFromData", "OrderHeaderIn", "ORD_REASON", "40B");
        mCheckTableDescriptors.add("TVBO", "BUS1001001", "Clone", "SalesData", "REBATE_GRP", "40B");
        mCheckTableDescriptors.add("TVBUR", "BUS2030", "CreateFromData", "SoldToParty", "SALES_OFF", "40B");
        mCheckTableDescriptors.add("TVCIN", "VBRK", "CreateFromData", "CcardDataIn", "CC_TYPE", "40B");
        mCheckTableDescriptors.add("TVEGR", "BUS1001001", "Clone", "ClientData", "MAT_GRP_SM", "40B");
        mCheckTableDescriptors.add("TVFM", "BUS1001", "GetBatches", "Batches", "EXPIMPGRP", "40B");
        mCheckTableDescriptors.add("TVFS", "KNA1", "CheckExistence", "CustomerData", "FAKSD", "40B");
        mCheckTableDescriptors.add("TVGF", "KNA1", "CheckExistence", "CustomerData", "GFORM", "40B");
        mCheckTableDescriptors.add("TVK0", "KNA1", "CheckExistence", "CustomerData", "KATR10", "40B");
        mCheckTableDescriptors.add("TVK1", "KNA1", "CheckExistence", "CustomerData", "KATR1", "40B");
        mCheckTableDescriptors.add("TVK2", "KNA1", "CheckExistence", "CustomerData", "KATR2", "40B");
        mCheckTableDescriptors.add("TVK3", "KNA1", "CheckExistence", "CustomerData", "KATR3", "40B");
        mCheckTableDescriptors.add("TVK4", "KNA1", "CheckExistence", "CustomerData", "KATR4", "40B");
        mCheckTableDescriptors.add("TVK5", "KNA1", "CheckExistence", "CustomerData", "KATR5", "40B");
        mCheckTableDescriptors.add("TVK6", "KNA1", "CheckExistence", "CustomerData", "KATR6", "40B");
        mCheckTableDescriptors.add("TVK7", "KNA1", "CheckExistence", "CustomerData", "KATR7", "40B");
        mCheckTableDescriptors.add("TVK8", "KNA1", "CheckExistence", "CustomerData", "KATR8", "40B");
        mCheckTableDescriptors.add("TVK9", "KNA1", "CheckExistence", "CustomerData", "KATR9", "40B");
        mCheckTableDescriptors.add("TVKD", "BUS2030", "CreateFromData", "SoldToParty", "PRC_PROCED", "40B");
        mCheckTableDescriptors.add("TVKGG", "KNA1", "CheckExistence", "CustomerData", "KDKG1", "40B");
        mCheckTableDescriptors.add("TVKGR", "BUS2030", "CreateFromData", "SoldToParty", "SALES_GRP", "40B");
        mCheckTableDescriptors.add("TVKM", "BUS1001001", "Clone", "SalesData", "ACCT_ASSGT", "40B");
        mCheckTableDescriptors.add("TVKO", "KNA1", "CheckExistence", "SalesOrganization", "", "40B");
        mCheckTableDescriptors.add("TVKT", "BUS2030", "CreateFromData", "BillingParty", "ACCNT_ASGN", "40B");
        mCheckTableDescriptors.add("TVLK", "BUS2012", "GetDetail", "PoItems", "DEL_TYP_RT", "40B");
        mCheckTableDescriptors.add("TVLS", "KNA1", "CheckExistence", "CustomerData", "LIFSD", "40B");
        mCheckTableDescriptors.add("TVLV", "KNA1", "CheckExistence", "CustomerData", "ABRVW", "40B");
        mCheckTableDescriptors.add("TVM1", "BUS2030", "CreateFromData", "OrderItemsIn", "PRC_GROUP1", "40B");
        mCheckTableDescriptors.add("TVM2", "BUS2030", "CreateFromData", "OrderItemsIn", "PRC_GROUP2", "40B");
        mCheckTableDescriptors.add("TVM3", "BUS2030", "CreateFromData", "OrderItemsIn", "PRC_GROUP3", "40B");
        mCheckTableDescriptors.add("TVM4", "BUS2030", "CreateFromData", "OrderItemsIn", "PRC_GROUP4", "40B");
        mCheckTableDescriptors.add("TVM5", "BUS2030", "CreateFromData", "OrderItemsIn", "PRC_GROUP5", "40B");
        mCheckTableDescriptors.add("TVMS", "BUS1001001", "Clone", "ClientData", "SAL_STATUS", "40B");
        mCheckTableDescriptors.add("TVPR", "BUS1001001", "Clone", "SalesData", "COMM_GROUP", "40B");
        mCheckTableDescriptors.add("TVPT", "BUS2030", "CreateFromData", "OrderItemsIn", "ITEM_CATEG", "40B");
        mCheckTableDescriptors.add("TVSB", "BUS2030", "CreateFromData", "ShipToParty", "SHIP_COND", "40B");
        mCheckTableDescriptors.add("TVSG", "BUS2030", "CreateFromData", "SoldToParty", "STAT_GROUP", "40B");
        mCheckTableDescriptors.add("TVSM", "BUS1001001", "Clone", "SalesData", "MATL_STATS", "40B");
        mCheckTableDescriptors.add("TVST", "BUS2032", "GetList", "SalesOrders", "SHIP_POINT", "40B");
        mCheckTableDescriptors.add("TVTY", "BUS1001001", "Clone", "ClientData", "SH_MAT_TYP", "40B");
        mCheckTableDescriptors.add("TVV1", "BUS2030", "CreateFromData", "OrderHeaderIn", "CUST_GRP1", "40B");
        mCheckTableDescriptors.add("TVV2", "BUS2030", "CreateFromData", "OrderHeaderIn", "CUST_GRP2", "40B");
        mCheckTableDescriptors.add("TVV3", "BUS2030", "CreateFromData", "OrderHeaderIn", "CUST_GRP3", "40B");
        mCheckTableDescriptors.add("TVV4", "BUS2030", "CreateFromData", "OrderHeaderIn", "CUST_GRP4", "40B");
        mCheckTableDescriptors.add("TVV5", "BUS2030", "CreateFromData", "OrderHeaderIn", "CUST_GRP5", "40B");
        mCheckTableDescriptors.add("TVWA", "BUS2030", "CreateFromData", "ShipToParty", "RECV_HOURS", "40B");
        mCheckTableDescriptors.add("TWBB", "BUS1001001", "Clone", "AddnlClientData", "REPL_LIST", "40B");
        mCheckTableDescriptors.add("TWEK", "KNA1", "CheckExistence", "CustomerData", "ETIKG", "40B");
        mCheckTableDescriptors.add("TWEW", "BUS1001001", "Clone", "ClientData", "EXTMATLGRP", "40B");
        mCheckTableDescriptors.add("TWGV", "BUS1071", "GetDetail", "Detail", "LAYOUT", "40B");
        mCheckTableDescriptors.add("TWLV", "BUS1001001", "Clone", "AddnlClientData", "LI_PROC_ST", "40B");
        mCheckTableDescriptors.add("TWML", "BUS1001001", "Clone", "LayoutModuleAssgmt", "LAYOUT_MOD", "40B");
        mCheckTableDescriptors.add("TWPT", "BUS1001001", "Clone", "ClientData", "PRICE_BAND", "40B");
        mCheckTableDescriptors.add("TWRV", "BUS3003", "GetList", "InforecordGeneral", "BACK_AGREE", "40B");
        mCheckTableDescriptors.add("TWSG", "BUS1001001", "Clone", "PlantData", "SERV_LEV_R", "40B");
        mCheckTableDescriptors.add("TWSP", "BUS1001001", "Clone", "AddnlClientData", "ASSORTPRIO", "40B");
        mCheckTableDescriptors.add("TWSS", "BUS1001001", "Clone", "AddnlClientData", "ASSORT_LEV", "40B");
        mCheckTableDescriptors.add("TWSV", "BUS1001001", "Clone", "AddnlClientData", "SERV_AGRT", "40B");
        mCheckTableDescriptors.add("TWWAG", "BUS1001001", "Clone", "POSData", "SCALES_GRP", "40B");
        mCheckTableDescriptors.add("SCARR", "SFLIGHT", "GetDetail", "FlightData", "AIRLINEID", "610");
        mFixedValuesDescriptors = new FixedValuesDescriptors();
        mFixedValuesDescriptors.add("ABREC", "BUS2089", "CreateFromData", "Status", "ACCOUNT", "40B");
        mFixedValuesDescriptors.add("AD_CHECKST", "BUS2012", "CreateFromData", "PoAddress", "CHCKSTATUS", "40B");
        mFixedValuesDescriptors.add("ALTSL", "BUS1001001", "Clone", "PlantData", "ALT_BOM_ID", "40B");
        mFixedValuesDescriptors.add("ANTRG", "BUS2089", "CreateFromData", "Status", "APPROVED", "40B");
        mFixedValuesDescriptors.add("ANZCA", "BUS2089", "GetOptions", "ExpenseTypes", "ANZCA", "40B");
        mFixedValuesDescriptors.add("AOB_PROVG", "BUS2002", "Getdetail", "ERelation", "DURATION_KEY", "40B");
        mFixedValuesDescriptors.add("ASTAT", "BUS2012", "GetDetail", "PoItems", "STATUS", "40B");
        mFixedValuesDescriptors.add("ATFOR", "BUS1003", "GetCharacteristics", "Characteristics", "DATA_TYPE", "40B");
        mFixedValuesDescriptors.add("ATPKZ", "BUS1001001", "Clone", "PlantData", "REPLACE_PT", "40B");
        mFixedValuesDescriptors.add("ATTYP", "BUS1071", "GetItems", "Items", "MATTYPE", "40B");
        mFixedValuesDescriptors.add("ATXFE", "BUS1003", "GetCharacteristics", "Characteristics", "ENTRY_OBLIGATORY", "40B");
        mFixedValuesDescriptors.add("AUFTYP", "BUS6001", "CheckAccountAssignment", "ChangedCodingblock", "ORDER_CATG", "40B");
        mFixedValuesDescriptors.add("AUREL", "BUS2012", "CreateFromData", "PoItems", "AT_RELEV", "40B");
        mFixedValuesDescriptors.add("AUSWL", "BUS2089", "GetOptions", "ExpenseTypes", "SCDV1", "40B");
        mFixedValuesDescriptors.add("AVAILABILITY", "BUS7002", "Build", "TimeAvailSchedule", "AVAILABILITY", "40B");
        mFixedValuesDescriptors.add("BANST", "BUS2009", "CreateFromData", "RequirementItems", "PROC_STAT", "40B");
        mFixedValuesDescriptors.add("BAPIOPTION", "HELPVALUES", "GetList", "Selection4Helpvalues", "OPTION", "40B");
        mFixedValuesDescriptors.add("BAPISIGN", "BUS1001", "GetList", "MaterialShortDescSel", "SIGN", "40B");
        mFixedValuesDescriptors.add("BAPIUPDATE", "BUS2002", "Maintain", "IActivityUpdate", "NETWORK", "40B");
        mFixedValuesDescriptors.add("BEKNZ", "BUS2072", "GetDetail", "LineItem", "DR_CR_IND", "40B");
        mFixedValuesDescriptors.add("BELAR", "BUS2089", "GetOptions", "ExpenseTypes", "EXP_CATE", "40B");
        mFixedValuesDescriptors.add("BEN_CATEG", "BUS302901", "GetDependents", "ExistingDependents", "PLAN_CATEG", "40B");
        mFixedValuesDescriptors.add("BEN_ENRTYP", "BUS302901", "GetPossDependents", "HealthOffer", "ENROLL_TYP", "40B");
        mFixedValuesDescriptors.add("BEN_RLPTYP", "BUS3029", "CheckSelection", "MiscelSelection", "RLP_TYPE", "40B");
        mFixedValuesDescriptors.add("BESKZ", "BUS1001001", "Clone", "PlantData", "PROC_TYPE", "40B");
        mFixedValuesDescriptors.add("BPUEB", "BUS6015", "GetInfo", "ProcurementItem", "PO_PRICE", "40B");
        mFixedValuesDescriptors.add("BREAK", "BUS7002", "Build", "TimeAvailSchedule", "BREAK", "40B");
        mFixedValuesDescriptors.add("BSAKZ", "BUS2012", "GetDetail", "PoHeader", "CNTRL_IND", "40B");
        mFixedValuesDescriptors.add("BSTAT", "BUS3008", "GetBalancedItems", "LineItems", "DOC_STATUS", "40B");
        mFixedValuesDescriptors.add("BSTYP", "BUS6008", "Check", "PurchaseRequi", "DOC_CAT", "40B");
        mFixedValuesDescriptors.add("CCOMP", "BUS2089", "CreateFromData", "Addinfo", "CCOMP", "40B");
        mFixedValuesDescriptors.add("CDCHNGIND", "BUS2009", "CreateFromData", "RequirementAccountAs", "CHANGE_ID", "40B");
        mFixedValuesDescriptors.add("CHAR1_X", "BUS6001", "CheckAccountAssignment", "ChangedCodingblock", "RES_CLOSED", "40B");
        mFixedValuesDescriptors.add("CHSPLIT", "BUS2093", "GetDetail", "ReservationItems", "BATCHKEY", "40B");
        mFixedValuesDescriptors.add("CK_COSESTI", "BUS2044", "GetList", "CostEstimate", "", "40B");
        mFixedValuesDescriptors.add("CK_CURRENY", "BUS2044", "GetDetail", "CurrencyOrgUnit", "", "40B");
        mFixedValuesDescriptors.add("CK_MAT_BOM", "BUS2044", "GetDetail", "CostEstimateHeader", "MAT_BOM", "40B");
        mFixedValuesDescriptors.add("CK_ML_ABST", "BUS1001001", "Clone", "ValuationData", "ML_SETTLE", "40B");
        mFixedValuesDescriptors.add("CK_STATUS", "BUS2044", "GetDetail", "CostEstimateHeader", "CE_STATUS", "40B");
        mFixedValuesDescriptors.add("CSOUR", "VBRK", "CreateFromData", "CcardDataIn", "DATAORIGIN", "40B");
        mFixedValuesDescriptors.add("CURTP", "BUS6007", "Check", "CurrencyAmount", "CURR_TYPE", "40B");
        mFixedValuesDescriptors.add("DEAR3", "KNA1", "CheckExistence", "CustomerData", "DEAR3", "40B");
        mFixedValuesDescriptors.add("DELKZ", "BUS1001", "Availability", "Wmdvsx", "DELKZ", "40B");
        mFixedValuesDescriptors.add("DISKZ", "BUS1001001", "Clone", "StorageLocationData", "MRP_IND", "40B");
        mFixedValuesDescriptors.add("DTAMS", "BUS6007", "Post", "CustomerCPD", "DME_IND", "40B");
        mFixedValuesDescriptors.add("DUEFL_BKPF", "KNA1", "CheckExistence", "CustomerData", "DUEFL", "40B");
        mFixedValuesDescriptors.add("EBSTYP", "BUS2012", "CreateFromData", "PoHeader", "DOC_CAT", "40B");
        mFixedValuesDescriptors.add("ESOKZ", "BUS3003", "GetList", "InfoType", "", "40B");
        mFixedValuesDescriptors.add("ESTAK", "BUS2012", "GetDetail", "PoHeader", "STATUS", "40B");
        mFixedValuesDescriptors.add("ESTKZ", "BUS2012", "CreateFromData", "PoItemSchedules", "CREATE_IND", "40B");
        mFixedValuesDescriptors.add("ETDRK", "BUS2012", "GetDetail", "PoItems", "PRINT_REL", "40B");
        mFixedValuesDescriptors.add("FABKZ", "BUS1001001", "Clone", "PlantData", "JIT_RELVT", "40B");
        mFixedValuesDescriptors.add("FACTION", "ALEMODEL", "GetInfo", "BapiFilters", "ACTION", "40B");
        mFixedValuesDescriptors.add("FLAG", "BUS2072", "GetDetail", "DocHeader", "REVERSEDOC", "40B");
        mFixedValuesDescriptors.add("FTYPE", "ALEMODEL", "GetInfo", "BapiFilters", "FILTERTYPE", "40B");
        mFixedValuesDescriptors.add("GESCH", "APPLICANT", "CreateFromData", "Gender", "", "40B");
        mFixedValuesDescriptors.add("HKMAT", "BUS6002", "Check", "AccountGl", "ORIG_MAT", "40B");
        mFixedValuesDescriptors.add("INDEU", "BUS7003", "Post", "Confirmations", "UPD_STATUS", "40B");
        mFixedValuesDescriptors.add("INSMK", "BUS2012", "GetDetail", "PoItems", "QUAL_INSP", "40B");
        mFixedValuesDescriptors.add("INTTYPE", "OIW", "GetData", "StructureOfData", "TYPE", "40B");
        mFixedValuesDescriptors.add("J_1BINDUS1", "KNA1", "CheckExistence", "CustomerData", "CFOPC", "40B");
        mFixedValuesDescriptors.add("J_1BINDUS3", "BUS1001001", "Clone", "PlantData", "CFOP_CAT", "40B");
        mFixedValuesDescriptors.add("J_1BMATORG", "BUS1001001", "Clone", "ValuationData", "MAT_ORIGIN", "40B");
        mFixedValuesDescriptors.add("J_1BMATUSE", "BUS1001001", "Clone", "ValuationData", "MATL_USAGE", "40B");
        mFixedValuesDescriptors.add("KOART", "BUS6002", "Check", "AccountGl", "ACCT_TYPE", "40B");
        mFixedValuesDescriptors.add("KREUZ", "BUS2002", "Getdetail", "ENetwork", "NOT_AUTO_SCHEDULE", "40B");
        mFixedValuesDescriptors.add("KSTAZ", "BUS6007", "Check", "AccountGl", "STAT_CON", "40B");
        mFixedValuesDescriptors.add("KWDHT", "BUS1001001", "Clone", "POSData", "NO_REP_KEY", "40B");
        mFixedValuesDescriptors.add("KZAGL", "BUS1001001", "Clone", "PlantData", "PROMSMOOTH", "40B");
        mFixedValuesDescriptors.add("KZAUS", "BUS1001001", "Clone", "PlantData", "DISCONTINU", "40B");
        mFixedValuesDescriptors.add("KZBED", "BUS1001001", "Clone", "PlantData", "GRP_REQMTS", "40B");
        mFixedValuesDescriptors.add("KZBEW", "BUS6002", "Check", "AccountGl", "MVT_IND", "40B");
        mFixedValuesDescriptors.add("KZCUH", "BUS2012", "GetDetail", "PoItems", "CONFIG_ORG", "40B");
        mFixedValuesDescriptors.add("KZECH", "BUS2093", "GetDetail", "ReservationItems", "BATCH_ENTR", "40B");
        mFixedValuesDescriptors.add("KZINI", "BUS1001001", "Clone", "ForecastParameters", "INITIALIZE", "40B");
        mFixedValuesDescriptors.add("KZTLF", "BUS2030", "CreateFromData", "OrderItemsIn", "PART_DLV", "40B");
        mFixedValuesDescriptors.add("KZVBR", "BUS6001", "CheckAccountAssignment", "ChangedCodingblock", "CONSUMPT", "40B");
        mFixedValuesDescriptors.add("LATYP", "BUS1031", "GetList", "ActTypeCategory", "", "40B");
        mFixedValuesDescriptors.add("LAYDOCRCOD", "BUS1071", "GetLayoutDocuments", "Documents", "RCODE", "40B");
        mFixedValuesDescriptors.add("LSTAK", "BUS1001001", "Clone", "SalesData", "ASSORTLIST", "40B");
        mFixedValuesDescriptors.add("LVS_2SKREL", "BUS1001001", "Clone", "WarehouseNumberData", "2STEP_PICK", "40B");
        mFixedValuesDescriptors.add("LVS_VOME", "BUS1001001", "Clone", "WarehouseNumberData", "REF_UNIT", "40B");
        mFixedValuesDescriptors.add("MAABC", "BUS1001001", "Clone", "AddnlClientData", "ABC_ID", "40B");
        mFixedValuesDescriptors.add("MEPRF", "BUS2012", "GetDetail", "PoItems", "PRICE_CTR", "40B");
        mFixedValuesDescriptors.add("MISKZ", "BUS1001001", "Clone", "PlantData", "MIXED_MRP", "40B");
        mFixedValuesDescriptors.add("MODAV", "BUS1001001", "Clone", "ForecastParameters", "MODEL_SP", "40B");
        mFixedValuesDescriptors.add("MODAW", "BUS1001001", "Clone", "ForecastParameters", "MODEL_SI", "40B");
        mFixedValuesDescriptors.add("MSGAR", "BUS2002", "Getdetail", "EMessageTable", "MESSAGE_TYPE", "40B");
        mFixedValuesDescriptors.add("MSGFN", "BUS1001001", "Clone", "AddnlClientData", "FUNCTION", "40B");
        mFixedValuesDescriptors.add("MTXID", "BUS1001001", "Clone", "UnitOfMeasureTexts", "TEXT_ID", "40B");
        mFixedValuesDescriptors.add("NRFHG", "BUS1001001", "Clone", "ClientData", "QUAL_DIK", "40B");
        mFixedValuesDescriptors.add("OBJ_TO_GEN", "BUS6015", "GetInfo", "ProcurementItem", "OBJ_TO_GEN", "40B");
        mFixedValuesDescriptors.add("OPGRA", "BUS1001001", "Clone", "ForecastParameters", "OPTIM_LEV", "40B");
        mFixedValuesDescriptors.add("ORVTP", "BUS6002", "Check", "PurchaseAmount", "ORVALTYPE", "40B");
        mFixedValuesDescriptors.add("P_PRINT", "BUS2089", "GetDetails", "Status", "PRINTED", "40B");
        mFixedValuesDescriptors.add("PERKZ", "BUS1001001", "Clone", "PlantData", "PERIOD_IND", "40B");
        mFixedValuesDescriptors.add("PFREQ", "BUS302901", "GetPossDependents", "HealthOffer", "PERIOD", "40B");
        mFixedValuesDescriptors.add("PKBST", "BUS1075", "GetListForSupplier", "Kanbans", "STATUS", "40B");
        mFixedValuesDescriptors.add("PRATA", "BUS1001001", "Clone", "SalesData", "PROD_ATT_1", "40B");
        mFixedValuesDescriptors.add("PRATK", "BUS2030", "CreateFromData", "ShipToParty", "PROD_ATTR1", "40B");
        mFixedValuesDescriptors.add("PRENC", "BUS1001001", "Clone", "PlantData", "EX_CERT_ID", "40B");
        mFixedValuesDescriptors.add("PRGRS", "BUS2030", "CreateFromData", "OrderHeaderIn", "DATE_TYPE", "40B");
        mFixedValuesDescriptors.add("PRMOD", "BUS1001001", "Clone", "ForecastParameters", "FORE_MODEL", "40B");
        mFixedValuesDescriptors.add("PS_ZUORD", "BUS2001", "CreateFromData", "ProjectDefinitionStr", "NETWORK_ASSIGNMENT", "40B");
        mFixedValuesDescriptors.add("PSPLFRM", "BUS2001", "CreateFromData", "ProjectDefinitionStr", "PLAN_BASIC", "40B");
        mFixedValuesDescriptors.add("PW_APPKZ", "BUS7003", "Post", "Confirmations", "SOURCE_APPL", "40B");
        mFixedValuesDescriptors.add("QATTRIBUT", "BUS2045", "StatInterface", "MethodData", "RES_ATTR", "40B");
        mFixedValuesDescriptors.add("QCHAR_TYPE", "BUS2045", "StatInterface", "CharacteristicHeader", "CHAR_TYPE", "40B");
        mFixedValuesDescriptors.add("QDOKUKZ", "BUS204502", "GetRequirements", "Requirements", "DOCU_REQU", "40B");
        mFixedValuesDescriptors.add("QEEBEWERTG", "BUS204502", "GetResult", "CharResult", "EVALUATION", "40B");
        mFixedValuesDescriptors.add("QEIFANVERF", "BUS204502", "GetRequirements", "Requirements", "SHARE_CALC", "40B");
        mFixedValuesDescriptors.add("QEIFBEWART", "BUS204502", "GetRequirements", "Requirements", "VALN_TYPE", "40B");
        mFixedValuesDescriptors.add("QKZ", "KNA1", "CheckExistence", "CustomerData", "INSPBYDEBI", "40B");
        mFixedValuesDescriptors.add("QKZRAST", "BUS204502", "GetRequirements", "Requirements", "INSP_POINT", "40B");
        mFixedValuesDescriptors.add("QKZUSRAKT", "BUS204503", "GetRequirements", "Requirements", "EQUI_ORD", "40B");
        mFixedValuesDescriptors.add("QKZVERS", "BUS2078", "GetKeyFigures", "Keyfigurestructure", "VERSION", "40B");
        mFixedValuesDescriptors.add("QPPKTTYP", "BUS204503", "GetRequirements", "Requirements", "IP_TYPE", "40B");
        mFixedValuesDescriptors.add("QPUMFKZ", "BUS204502", "GetRequirements", "Requirements", "SCOPE_IND", "40B");
        mFixedValuesDescriptors.add("QRZWANG", "BUS204502", "GetRequirements", "Requirements", "OBLIGATORY", "40B");
        mFixedValuesDescriptors.add("RALDB_OPTI", "BUS2044", "GetList", "CostingStatus", "OPTION", "40B");
        mFixedValuesDescriptors.add("RALDB_SIGN", "BUS2044", "GetList", "CostingStatus", "SIGN", "40B");
        mFixedValuesDescriptors.add("RELEVANZKZ", "BUS1001001", "GetCharacsMerchandiseHierachy", "Characteristics", "RELEVANCY", "40B");
        mFixedValuesDescriptors.add("RESTRIKEND", "BUS2002", "Getdetail", "EActivity", "CONSTRAINT_TYPE_FINISH", "40B");
        mFixedValuesDescriptors.add("RESTRIKSTR", "BUS2002", "Getdetail", "EActivity", "CONSTRAINT_TYPE_START", "40B");
        mFixedValuesDescriptors.add("RETYP", "BUS7003", "Post", "Confirmations", "TEVENTTYPE", "40B");
        mFixedValuesDescriptors.add("RGEKM", "BUS1001001", "Clone", "PlantData", "BACKFLUSH", "40B");
        mFixedValuesDescriptors.add("SBDKZ", "BUS1001001", "Clone", "PlantData", "DEP_REQ_ID", "40B");
        mFixedValuesDescriptors.add("SCOPE", "BUS2002", "Getdetail", "EActivity", "OBJECTCLASS", "40B");
        mFixedValuesDescriptors.add("SCOPE_CV", "BUS2001", "CreateFromData", "ProjectDefinitionStr", "OBJECTCLASS", "40B");
        mFixedValuesDescriptors.add("SELKZ", "BUS2093", "GetItems", "ClosedItems", "", "40B");
        mFixedValuesDescriptors.add("SELTYP", "OIW", "GetCatalog", "InfoObjectDataSource", "SELECTTYPE", "40B");
        mFixedValuesDescriptors.add("SHFLG", "BUS1001001", "Clone", "PlantData", "SAFTY_T_ID", "40B");
        mFixedValuesDescriptors.add("SHKZG", "BUS3008", "GetBalancedItems", "LineItems", "DB_CR_IND", "40B");
        mFixedValuesDescriptors.add("SPINF", "BUS2012", "CreateFromData", "PoItemAddData", "INFO_UPD", "40B");
        mFixedValuesDescriptors.add("SPROF", "BUS1001001", "Clone", "ClientData", "PRPROFVAR", "40B");
        mFixedValuesDescriptors.add("STATUS_CO", "BUS6001", "PreCheckPayrollAccountAssign", "Accountingobjects", "RESULT", "40B");
        mFixedValuesDescriptors.add("STATV", "VBRK", "CancelFromData", "DocumentDataIn", "BILLSTATUS", "40B");
        mFixedValuesDescriptors.add("STKZA", "BUS6007", "Post", "CustomerCPD", "EQUAL_TAX", "40B");
        mFixedValuesDescriptors.add("STKZN", "KNA1", "CheckExistence", "CustomerData", "STKZN", "40B");
        mFixedValuesDescriptors.add("TIMEDATA", "BUS7002", "Build", "TimeAvailSchedule", "TIMEDATATYPE", "40B");
        mFixedValuesDescriptors.add("TWRKZ", "BUS2012", "CreateFromData", "PoItems", "PART_INV", "40B");
        mFixedValuesDescriptors.add("TYPPS", "BUS2044", "GetExplosion", "ExplosionList", "ITEM_CATEGORY", "40B");
        mFixedValuesDescriptors.add("TYPZM", "VBRK", "CreateFromData", "CcardDataIn", "PAYTYPE", "40B");
        mFixedValuesDescriptors.add("UEBDT", "BUS2089", "GetDetails", "Status", "TRAN_DME", "40B");
        mFixedValuesDescriptors.add("UEBLG", "BUS2089", "GetDetails", "Status", "TRAN_PAY", "40B");
        mFixedValuesDescriptors.add("UEBRF", "BUS2089", "GetDetails", "Status", "TRAN_FI", "40B");
        mFixedValuesDescriptors.add("VABME", "BUS3003", "GetList", "InforecordGeneral", "VAR_ORD_UN", "40B");
        mFixedValuesDescriptors.add("VBTYP", "BUS2030", "CreateFromData", "OrderHeaderIn", "SD_DOC_CAT", "40B");
        mFixedValuesDescriptors.add("VERVP", "BUS3027", "GetDetail", "RequirementsOut", "CONS_IND_PLNG", "40B");
        mFixedValuesDescriptors.add("VERVS", "BUS3027", "Change", "RequirementItemOut", "VERS_ACTIV", "40B");
        mFixedValuesDescriptors.add("VGABE", "BUS2012", "GetDetail", "PoItemHistory", "PROCESS_ID", "40B");
        mFixedValuesDescriptors.add("VPRSV", "BUS1001001", "Clone", "ValuationData", "PRICE_CTRL", "40B");
        mFixedValuesDescriptors.add("VRMOD", "BUS1001001", "Clone", "PlantData", "CONSUMMODE", "40B");
        mFixedValuesDescriptors.add("VRTKZ", "BUS2012", "CreateFromData", "PoItems", "DISTRIB", "40B");
        mFixedValuesDescriptors.add("WEVWV", "BUS3008", "GetBalancedItems", "LineItems", "BILL_USAGE", "40B");
        mFixedValuesDescriptors.add("WGBKZ", "BUS3008", "GetBalancedItems", "LineItems", "PRTEST_IND", "40B");
        mFixedValuesDescriptors.add("WORKSCHEDULETYPE", "BUS7002", "Build", "TimeAvailSchedule", "WORKSCHEDULETYPE", "40B");
        mFixedValuesDescriptors.add("X", "ABSENCE", "Approve", "Nocommit", "", "40B");
        mFixedValuesDescriptors.add("XFELD", "BUS6007", "Check", "AccountGl", "CSHDIS_IND", "40B");
        mFixedValuesDescriptors.add("XFLAG", "KNA1", "Search", "PiSearchFlag", "", "40B");
        mFixedValuesDescriptors.add("ZBFIX", "BUS3008", "GetBalancedItems", "LineItems", "FIXEDTERMS", "40B");
    }

    public class SapData {
        private SapData() {
        }

        public GenericCollection getLanguages() throws GenericCollectionException {
            return this.getGenericCollectionForCheckTable("T002");
        }

        public GenericCollection getProcurementTypes() throws GenericCollectionException {
            return this.getGenericCollectionForFixedValues("BESKZ");
        }

        public GenericCollection getMaterialGroups() throws GenericCollectionException {
            return this.getGenericCollectionForCheckTable("T023");
        }

        public synchronized GenericCollection getGenericCollectionForFixedValues(String objectType, String methodName, String parameterName, String fieldName, String domainName) throws GenericCollectionException {
            GenericCollection newCollection;
            domainName = domainName.toUpperCase();
            if (ObjectFactory.this.mGenericCollections.exists("FV" + domainName)) {
                return (GenericCollection)ObjectFactory.this.mGenericCollections.getItem("FV" + domainName);
            }
            JCO.Function function = ObjectFactory.this.createFunction("BAPI_HELPVALUES_GET");
            if (function == null) {
                throw new GenericCollectionFunctionNotFoundException("BAPI_HELPVALUES_GET");
            }
            try {
                function.getImportParameterList().setValue(objectType, "OBJTYPE");
                function.getImportParameterList().setValue(methodName, "METHOD");
                function.getImportParameterList().setValue(parameterName, "PARAMETER");
                if (fieldName != null) {
                    function.getImportParameterList().setValue(fieldName, "FIELD");
                }
                ObjectFactory.this.getConnection().execute(function);
                JCO.Structure returnStructure = function.getExportParameterList().getStructure("RETURN");
                if (!returnStructure.getString("TYPE").equals("")) {
                    throw new GenericCollectionBadBapiReturnCodeException(ObjectFactory.getBapiReturnErrorMessage((JCO.Record)returnStructure));
                }
                JCO.Table metadata = function.getTableParameterList().getTable("DESCRIPTION_FOR_HELPVALUES");
                int metadataRowCount = metadata.getNumRows();
                if (metadataRowCount != 2) {
                    throw new GenericCollectionNotTwoColumnsException();
                }
                int codeTableIndex = -1;
                int i = 0;
                while (i < metadataRowCount) {
                    String fldName;
                    metadata.setRow(i);
                    String tabName = metadata.getString("TABNAME");
                    if (tabName.equals(domainName) && (fldName = metadata.getString("FIELDNAME")).equals("_LOW")) {
                        codeTableIndex = i;
                    }
                    ++i;
                }
                if (codeTableIndex < 0) {
                    throw new GenericCollectionNotSupportedException("Pseudo field _LOW not found in metadata table.");
                }
                int descriptionTableIndex = 1 - codeTableIndex;
                newCollection = new GenericCollection(ObjectFactory.this);
                metadata.setRow(codeTableIndex);
                newCollection.conversionExit = "";
                newCollection.codeLength = metadata.getInt("LENG");
                newCollection.codeTexts.columnHeading = metadata.getString("REPTEXT");
                newCollection.codeTexts.description = metadata.getString("FIELDTEXT");
                newCollection.codeTexts.labelLong = metadata.getString("SCRTEXT_L");
                newCollection.codeTexts.labelMedium = metadata.getString("SCRTEXT_M");
                newCollection.codeTexts.labelShort = metadata.getString("SCRTEXT_S");
                int codeOffset = metadata.getInt("OFFSET");
                metadata.setRow(descriptionTableIndex);
                newCollection.descriptionLength = metadata.getInt("LENG");
                newCollection.descriptionTexts.columnHeading = metadata.getString("REPTEXT");
                newCollection.descriptionTexts.description = metadata.getString("FIELDTEXT");
                newCollection.descriptionTexts.labelLong = metadata.getString("SCRTEXT_L");
                newCollection.descriptionTexts.labelMedium = metadata.getString("SCRTEXT_M");
                newCollection.descriptionTexts.labelShort = metadata.getString("SCRTEXT_S");
                int descriptionOffset = metadata.getInt("OFFSET");
                JCO.Table data = function.getTableParameterList().getTable("HELPVALUES");
                String spaces = StaticHelper.repeat(" ", 255);
                int count = data.getNumRows();
                int i2 = 0;
                while (i2 < count) {
                    data.setRow(i2);
                    String s = data.getString(0) + spaces;
                    String code = s.substring(codeOffset, codeOffset + newCollection.codeLength).trim();
                    String description = s.substring(descriptionOffset, descriptionOffset + newCollection.descriptionLength).trim();
                    GenericItem item = new GenericItem(code, description, newCollection);
                    newCollection.add(item);
                    ++i2;
                }
            }
            catch (GenericCollectionException ex) {
                throw ex;
            }
            catch (JCO.Exception ex) {
                throw new GenericCollectionConnectionException(ex.toString(), (Exception)((Object)ex));
            }
            catch (Exception ex) {
                throw new GenericCollectionException(ex.toString(), ex);
            }
            ObjectFactory.this.mGenericCollections.add(newCollection, "FV" + domainName);
            return newCollection;
        }

        public synchronized Countries getCountries() throws GenericCollectionException {
            if (!((ObjectFactory)ObjectFactory.this).countries.initialized) {
                ObjectFactory.this.countries = new Countries();
                ObjectFactory.this.countries.init(ObjectFactory.this);
            }
            return ObjectFactory.this.countries;
        }

        public synchronized Clients getClients() throws GenericCollectionException {
            if (!ObjectFactory.this.clients.isInitialized()) {
                ObjectFactory.this.clients = new Clients();
                ObjectFactory.this.clients.init(ObjectFactory.this);
            }
            return ObjectFactory.this.clients;
        }

        public synchronized ValuationAreas getValuationAreas() throws GenericCollectionException {
            if (!ObjectFactory.this.valuationAreas.isInitialized()) {
                ObjectFactory.this.valuationAreas = new ValuationAreas();
                ObjectFactory.this.valuationAreas.init(ObjectFactory.this);
            }
            return ObjectFactory.this.valuationAreas;
        }

        public synchronized UnitsOfMeasure getUnitsOfMeasure() throws GenericCollectionException {
            if (!ObjectFactory.this.unitsOfMeasure.isInitialized()) {
                ObjectFactory.this.unitsOfMeasure = new UnitsOfMeasure();
                ObjectFactory.this.unitsOfMeasure.init(ObjectFactory.this);
            }
            return ObjectFactory.this.unitsOfMeasure;
        }

        public synchronized CompanyCodes getCompanyCodes() throws GenericCollectionException {
            if (!ObjectFactory.this.companyCodes.isInitialized()) {
                ObjectFactory.this.companyCodes = new CompanyCodes();
                ObjectFactory.this.companyCodes.init(ObjectFactory.this);
            }
            return ObjectFactory.this.companyCodes;
        }

        public synchronized ControllingAreas getControllingAreas() throws GenericCollectionException {
            if (!ObjectFactory.this.controllingAreas.isInitialized()) {
                ObjectFactory.this.controllingAreas = new ControllingAreas();
                ObjectFactory.this.controllingAreas.init(ObjectFactory.this);
            }
            return ObjectFactory.this.controllingAreas;
        }

        public synchronized Currencies getCurrencies() throws GenericCollectionException {
            if (!ObjectFactory.this.currencies.isInitialized()) {
                ObjectFactory.this.currencies = new Currencies();
                ObjectFactory.this.currencies.init(ObjectFactory.this);
            }
            return ObjectFactory.this.currencies;
        }

        public GenericCollection getParentCollectionForCheckTable(String checkTable) throws GenericCollectionException {
            if ((checkTable = checkTable.toUpperCase()).equals("T001L")) {
                return this.getPlants();
            }
            if (checkTable.equals("T005S")) {
                return this.getCountries();
            }
            if (checkTable.equals("T042Z")) {
                return this.getCountries();
            }
            if (checkTable.equals("T16FC")) {
                return this.getPOReleaseGroups();
            }
            if (checkTable.equals("T16FS")) {
                return this.getPOReleaseGroups();
            }
            if (checkTable.equals("T438M")) {
                return this.getPlants();
            }
            if (checkTable.equals("TVKOV")) {
                return this.getSalesOrganizations();
            }
            if (checkTable.equals("TVTA")) {
                return this.getSalesOrganizations();
            }
            throw new GenericCollectionNotSupportedException();
        }

        /*
         * Unable to fully structure code
         */
        public synchronized GenericCollection getGenericCollectionForCheckTable(String objectType, String methodName, String parameterName, String fieldName, String checkTable) throws GenericCollectionException {
            checkTable = checkTable.toUpperCase();
            if (ObjectFactory.access$100(ObjectFactory.this).exists("CT" + checkTable)) {
                return (GenericCollection)ObjectFactory.access$100(ObjectFactory.this).getItem("CT" + checkTable);
            }
            function = ObjectFactory.this.createFunction("BAPI_HELPVALUES_GET");
            if (function == null) {
                throw new GenericCollectionFunctionNotFoundException("BAPI_HELPVALUES_GET");
            }
            try {
                function.getImportParameterList().setValue(objectType, "OBJTYPE");
                function.getImportParameterList().setValue(methodName, "METHOD");
                function.getImportParameterList().setValue(parameterName, "PARAMETER");
                if (fieldName != null) {
                    function.getImportParameterList().setValue(fieldName, "FIELD");
                }
                ObjectFactory.this.getConnection().execute(function);
                returnStructure = function.getExportParameterList().getStructure("RETURN");
                if (!returnStructure.getString("TYPE").equals("") && !returnStructure.getString("CODE").equals("HV013")) {
                    throw new GenericCollectionBadBapiReturnCodeException("Check table: " + checkTable + "\n" + ObjectFactory.getBapiReturnErrorMessage((JCO.Record)returnStructure));
                }
                metadata = function.getTableParameterList().getTable("DESCRIPTION_FOR_HELPVALUES");
                metadataRowCount = metadata.getNumRows();
                if (metadataRowCount == 3) {
                    foundCLNT = false;
                    i = 0;
                    while (i < metadataRowCount) {
                        metadata.setRow(i);
                        tabName = metadata.getString("TABNAME");
                        fldName = metadata.getString("FIELDNAME");
                        if (tabName.equals(checkTable)) {
                            structure = ObjectFactory.this.getStructure(tabName);
                            if (structure == null) {
                                throw new GenericCollectionNotSupportedException("Table name not found in R/3: " + tabName);
                            }
                            field = structure.getField(fldName);
                            if (field != null && field.getDataTypeDD().equals("CLNT")) {
                                foundCLNT = true;
                                break;
                            }
                        }
                        ++i;
                    }
                    if (!foundCLNT) {
                        throw new GenericCollectionNotTwoColumnsException(checkTable);
                    }
                }
                if (metadataRowCount < 2 || metadataRowCount > 3) {
                    throw new GenericCollectionNotTwoColumnsException(checkTable);
                }
                codeTableIndex = -1;
                descriptionTableIndex = -1;
                i = 0;
                while (i < metadataRowCount) {
                    metadata.setRow(i);
                    tabName = metadata.getString("TABNAME");
                    fldName = metadata.getString("FIELDNAME");
                    if (!tabName.equals(checkTable)) ** GOTO lbl-1000
                    structure = ObjectFactory.this.getStructure(tabName);
                    if (structure == null) {
                        throw new GenericCollectionNotSupportedException("Table name not found in R/3: " + tabName);
                    }
                    field = structure.getField(fldName);
                    if (field != null && field.isKeyField() && !field.getDataTypeDD().equals("CLNT")) {
                        codeTableIndex = i;
                    } else lbl-1000:
                    // 2 sources

                    {
                        if ((structure = ObjectFactory.this.getStructure(tabName)) == null) {
                            throw new GenericCollectionNotSupportedException("Table name not found in R/3: " + tabName);
                        }
                        field = structure.getField(fldName);
                        if (field == null || !field.getDataTypeDD().equals("CLNT")) {
                            descriptionTableIndex = i;
                        }
                    }
                    ++i;
                }
                if (codeTableIndex < 0 || descriptionTableIndex < 0) {
                    throw new GenericCollectionNotSupportedException("Code and/or description column could not be identified.");
                }
                newCollection = new GenericCollection(ObjectFactory.this);
                metadata.setRow(codeTableIndex);
                newCollection.conversionExit = ObjectFactory.this.getStructure(checkTable).getField(metadata.getString("FIELDNAME")).getConversionExit();
                newCollection.codeLength = metadata.getInt("LENG");
                newCollection.codeTexts.columnHeading = metadata.getString("REPTEXT");
                newCollection.codeTexts.description = metadata.getString("FIELDTEXT");
                newCollection.codeTexts.labelLong = metadata.getString("SCRTEXT_L");
                newCollection.codeTexts.labelMedium = metadata.getString("SCRTEXT_M");
                newCollection.codeTexts.labelShort = metadata.getString("SCRTEXT_S");
                codeOffset = metadata.getInt("OFFSET");
                metadata.setRow(descriptionTableIndex);
                newCollection.descriptionLength = metadata.getInt("LENG");
                newCollection.descriptionTexts.columnHeading = metadata.getString("REPTEXT");
                newCollection.descriptionTexts.description = metadata.getString("FIELDTEXT");
                newCollection.descriptionTexts.labelLong = metadata.getString("SCRTEXT_L");
                newCollection.descriptionTexts.labelMedium = metadata.getString("SCRTEXT_M");
                newCollection.descriptionTexts.labelShort = metadata.getString("SCRTEXT_S");
                descriptionOffset = metadata.getInt("OFFSET");
                data = function.getTableParameterList().getTable("HELPVALUES");
                spaces = StaticHelper.repeat(" ", 255);
                count = data.getNumRows();
                i = 0;
                while (i < count) {
                    data.setRow(i);
                    s = data.getString(0) + spaces;
                    code = s.substring(codeOffset, codeOffset + newCollection.codeLength).trim();
                    description = s.substring(descriptionOffset, descriptionOffset + newCollection.descriptionLength).trim();
                    item = new GenericItem(code, description, newCollection);
                    newCollection.add(item);
                    ++i;
                }
            }
            catch (GenericCollectionException ex) {
                throw ex;
            }
            catch (JCO.Exception ex) {
                throw new GenericCollectionConnectionException(ex.toString(), (Exception)ex);
            }
            catch (Exception ex) {
                throw new GenericCollectionException(ex.toString(), ex);
            }
            ObjectFactory.access$100(ObjectFactory.this).add(newCollection, "CT" + checkTable);
            return newCollection;
        }

        public synchronized SalesOrganizations getSalesOrganizations() throws GenericCollectionException {
            if (!((ObjectFactory)ObjectFactory.this).salesOrganizations.initialized) {
                ObjectFactory.this.salesOrganizations = new SalesOrganizations();
                ObjectFactory.this.salesOrganizations.init(ObjectFactory.this);
            }
            return ObjectFactory.this.salesOrganizations;
        }

        public GenericCollection getGenericCollectionForCheckTable(String checkTable) throws GenericCollectionException {
            if ((checkTable = checkTable.toUpperCase()).equals("T000")) {
                return this.getClients();
            }
            if (checkTable.equals("T001")) {
                return this.getCompanyCodes();
            }
            if (checkTable.equals("T001K")) {
                return this.getValuationAreas();
            }
            if (checkTable.equals("T001W")) {
                return this.getPlants();
            }
            if (checkTable.equals("T005")) {
                return this.getCountries();
            }
            if (checkTable.equals("T006")) {
                return this.getUnitsOfMeasure();
            }
            if (checkTable.equals("T006I")) {
                return this.getUnitsOfMeasureISO();
            }
            if (checkTable.equals("T16FG")) {
                return this.getPOReleaseGroups();
            }
            if (checkTable.equals("T024")) {
                return this.getPurchasingGroups();
            }
            if (checkTable.equals("TCURC")) {
                return this.getCurrencies();
            }
            if (checkTable.equals("TKA01")) {
                return this.getControllingAreas();
            }
            if (checkTable.equals("TVKO")) {
                return this.getSalesOrganizations();
            }
            CheckTableDescriptor hvd = ObjectFactory.getCheckTableDescriptors().getCheckTableDescriptor(checkTable);
            if (hvd == null) {
                throw new GenericCollectionNotSupportedException("Table not supported: " + checkTable);
            }
            if (hvd.getMinimumSupportedRelease().compareTo(ObjectFactory.this.getSapRelease()) > 0) {
                throw new GenericCollectionNotSupportedException();
            }
            return this.getGenericCollectionForCheckTable(hvd.objectType, hvd.methodName, hvd.parameterName, hvd.fieldName, hvd.name);
        }

        public GenericCollection getGenericCollectionForFixedValues(String domainName) throws GenericCollectionException {
            FixedValuesDescriptor hvd = ObjectFactory.getFixedValuesDescriptors().getFixedValuesDescriptor(domainName);
            if (hvd == null) {
                throw new GenericCollectionNotSupportedException("Domain not supported: " + domainName);
            }
            if (hvd.getMinimumSupportedRelease().compareTo(ObjectFactory.this.getSapRelease()) > 0) {
                throw new GenericCollectionNotSupportedException();
            }
            return this.getGenericCollectionForFixedValues(hvd.objectType, hvd.methodName, hvd.parameterName, hvd.fieldName, hvd.name);
        }

        public synchronized PurchasingGroups getPurchasingGroups() throws GenericCollectionException {
            if (!((ObjectFactory)ObjectFactory.this).purchasingGroups.initialized) {
                ObjectFactory.this.purchasingGroups = new PurchasingGroups();
                ObjectFactory.this.purchasingGroups.init(ObjectFactory.this);
            }
            return ObjectFactory.this.purchasingGroups;
        }

        public synchronized Plants getPlants() throws GenericCollectionException {
            if (!ObjectFactory.this.plants.isInitialized()) {
                ObjectFactory.this.plants = new Plants();
                ObjectFactory.this.plants.init(ObjectFactory.this);
            }
            return ObjectFactory.this.plants;
        }

        public GenericCollection getFiscalYearVariants() throws GenericCollectionException {
            return this.getGenericCollectionForCheckTable("T009");
        }

        public GenericCollection getPurchasingOrganizations() throws GenericCollectionException {
            return this.getGenericCollectionForCheckTable("T024E");
        }

        public GenericCollection getIndustries() throws GenericCollectionException {
            return this.getGenericCollectionForCheckTable("T016");
        }

        public GenericCollection getSalesDocumentTypes() throws GenericCollectionException {
            return this.getGenericCollectionForCheckTable("TVAK");
        }

        public GenericCollection getCustomerGroups() throws GenericCollectionException {
            return this.getGenericCollectionForCheckTable("T151");
        }

        public synchronized UnitsOfMeasureISO getUnitsOfMeasureISO() throws GenericCollectionException {
            if (!((ObjectFactory)ObjectFactory.this).unitsOfMeasureISO.initialized) {
                ObjectFactory.this.unitsOfMeasureISO = new UnitsOfMeasureISO();
                ObjectFactory.this.unitsOfMeasureISO.init(ObjectFactory.this);
            }
            return ObjectFactory.this.unitsOfMeasureISO;
        }

        public synchronized POReleaseGroups getPOReleaseGroups() throws GenericCollectionException {
            if (!ObjectFactory.this.poReleaseGroups.isInitialized()) {
                ObjectFactory.this.poReleaseGroups = new POReleaseGroups();
                ObjectFactory.this.poReleaseGroups.init(ObjectFactory.this);
            }
            return ObjectFactory.this.poReleaseGroups;
        }

        public GenericCollection getMaterialTypes() throws GenericCollectionException {
            return this.getGenericCollectionForCheckTable("T134");
        }

        public GenericCollection getShippingConditions() throws GenericCollectionException {
            return this.getGenericCollectionForCheckTable("TVSB");
        }

        public GenericCollection[] getAllGenericCollections() throws GenericCollectionException {
            CheckTableDescriptors ctds = ObjectFactory.this.getSupportedCheckTableDescriptors();
            FixedValuesDescriptors fvds = ObjectFactory.this.getSupportedFixedValuesDescriptors();
            int ctCount = ctds.getSize();
            int fvCount = fvds.getSize();
            GenericCollection[] gcs = new GenericCollection[ctCount + fvCount];
            int i = 0;
            while (i < ctCount) {
                gcs[i] = this.getGenericCollectionForCheckTable(ctds.getCheckTableDescriptor(i).getName());
                ++i;
            }
            int count = ctCount + fvCount;
            int i2 = ctCount;
            while (i2 < count) {
                gcs[i2] = this.getGenericCollectionForFixedValues(fvds.getFixedValuesDescriptor(i2 - ctCount).getName());
                ++i2;
            }
            return gcs;
        }

        public SpecificCollection[] getAllSpecificCollections() throws GenericCollectionException {
            SpecificCollection[] ofc = new SpecificCollection[]{this.getClients(), this.getCompanyCodes(), this.getControllingAreas(), this.getCountries(), this.getCurrencies(), this.getPlants(), this.getPOReleaseGroups(), this.getPurchasingGroups(), this.getSalesOrganizations(), this.getUnitsOfMeasure(), this.getUnitsOfMeasureISO(), this.getValuationAreas()};
            return ofc;
        }
    }
}

