/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mdi;

import com.sap.mdi.ConversionExitException;
import com.sap.mdi.GenericCollection;

public class GenericItem {
    String internalCode;
    String externalCode;
    String description;
    GenericCollection parent;

    GenericItem() {
    }

    GenericItem(String code, String description, GenericCollection parent) {
        this.internalCode = code;
        this.description = description;
        this.parent = parent;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExternalCode() throws ConversionExitException {
        if (!this.parent.isConversionUsed()) {
            return this.internalCode;
        }
        if (!this.parent.isConversionInitialized) {
            this.parent.initializeConversion();
        }
        return this.externalCode == null ? this.internalCode : this.externalCode;
    }

    public String getInternalCode() {
        return this.internalCode;
    }

    GenericCollection getParent() {
        return this.parent;
    }

    void setDescription(String description) {
        this.description = description;
    }

    void setExternalCode(String code) {
        this.externalCode = code;
    }

    void setInternalCode(String code) {
        this.internalCode = code;
    }

    void setParent(GenericCollection parent) {
        this.parent = parent;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Internal code: ");
        sb.append(this.getInternalCode());
        sb.append(", External code: ");
        try {
            sb.append(this.getExternalCode());
        }
        catch (Exception ex) {
            sb.append("<Error>");
        }
        sb.append(", Description: ");
        sb.append(this.getDescription());
        return sb.toString();
    }
}

