/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mdi;

import com.sap.mdi.ConversionExitException;
import com.sap.mdi.FieldTexts;
import com.sap.mdi.GenericItem;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.SmartCollection;
import com.sap.mdi.SmartCollectionSortedIterator;
import java.util.Iterator;

public class GenericCollection {
    SmartCollection internalItems = new SmartCollection();
    SmartCollection externalItems = new SmartCollection();
    String conversionExit = "";
    boolean isConversionInitialized = false;
    FieldTexts codeTexts = new FieldTexts();
    FieldTexts descriptionTexts = new FieldTexts();
    int codeLength = 0;
    int descriptionLength = 0;
    ObjectFactory bof;

    GenericCollection() {
        this(null);
    }

    GenericCollection(ObjectFactory bof) {
        this.bof = bof;
    }

    void add(GenericItem item) {
        this.internalItems.add(item, item.getInternalCode());
    }

    public boolean existsExternalCode(String code) throws ConversionExitException {
        if (!this.isConversionUsed()) {
            return this.internalItems.exists(code);
        }
        if (!this.isConversionInitialized) {
            this.initializeConversion();
        }
        return this.externalItems.exists(code);
    }

    public boolean existsInternalCode(String code) {
        return this.internalItems.exists(code);
    }

    public FieldTexts getCodeFieldTexts() {
        return this.codeTexts;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public FieldTexts getDescriptionFieldTexts() {
        return this.descriptionTexts;
    }

    public int getDescriptionLength() {
        return this.descriptionLength;
    }

    public GenericItem getExternalItem(String code) throws ConversionExitException {
        if (!this.isConversionUsed()) {
            return (GenericItem)this.internalItems.getItem(code);
        }
        if (!this.isConversionInitialized) {
            this.initializeConversion();
        }
        return (GenericItem)this.externalItems.getItem(code);
    }

    public Iterator getExternalIterator() throws ConversionExitException {
        if (!this.isConversionUsed()) {
            new SmartCollectionSortedIterator(this.internalItems);
        }
        if (!this.isConversionInitialized) {
            this.initializeConversion();
        }
        return new SmartCollectionSortedIterator(this.externalItems);
    }

    public GenericItem getInternalItem(String code) {
        return (GenericItem)this.internalItems.getItem(code);
    }

    public Iterator getInternalIterator() {
        return new SmartCollectionSortedIterator(this.internalItems);
    }

    public GenericItem getItem(int index) {
        return (GenericItem)this.internalItems.getItem(index);
    }

    public int getSize() {
        return this.internalItems.getSize();
    }

    void initializeConversion() throws ConversionExitException {
        this.bof.initConversionGenericCollection(this);
    }

    public boolean isConversionUsed() {
        return !this.conversionExit.equals("");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int count = this.getSize();
        int i = 0;
        while (i < count) {
            GenericItem item = this.getItem(i);
            sb.append(item.toString());
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }
}

