/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mdi;

import com.sap.mdi.BOException;
import com.sap.mdi.BOExceptions;
import com.sap.mdi.BOMethods;
import com.sap.mdi.BOParameter;
import com.sap.mdi.BOParameters;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.Rfm;

public final class BOMethod {
    int index;
    BOMethods parent;
    BOExceptions boExceptions;
    BOParameters boParameters;
    String name;
    String description;
    String rfmName;
    boolean isClassMethod;
    boolean isFactoryMethod;
    boolean isReleased;
    String releaseCreated;
    String releaseObsolete;
    boolean usesDialog;
    String[] documentation;
    boolean asyncInitialized;
    String asyncMessageType;
    String asyncIDocType;

    BOMethod(String name, String description, String rfmName, boolean isClassMethod) {
        this.name = name;
        this.description = description;
        this.rfmName = rfmName;
        this.isClassMethod = isClassMethod;
        this.boParameters = new BOParameters();
        this.boParameters.parent = this;
        this.boExceptions = new BOExceptions();
        this.boExceptions.parent = this;
    }

    public String getAsyncIDocType() throws MetaDataAccessException {
        if (!this.asyncInitialized) {
            this.initAsync();
        }
        return this.asyncIDocType;
    }

    public String getAsyncMessageType() throws MetaDataAccessException {
        if (!this.asyncInitialized) {
            this.initAsync();
        }
        return this.asyncMessageType;
    }

    public BOExceptions getBOExceptions() throws MetaDataAccessException {
        if (!this.parent.parent.initialized) {
            this.parent.parent.init();
        }
        return this.boExceptions;
    }

    public BOParameters getBOParameters() throws MetaDataAccessException {
        if (!this.parent.parent.initialized) {
            this.parent.parent.init();
        }
        return this.boParameters;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getDocumentation() throws MetaDataAccessException {
        if (!this.parent.parent.documentationInitialized) {
            this.parent.parent.initDocumentation();
        }
        return this.documentation;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getReleaseCreated() throws MetaDataAccessException {
        if (!this.parent.parent.initialized) {
            this.parent.parent.init();
        }
        return this.releaseCreated;
    }

    public String getReleaseObsolete() throws MetaDataAccessException {
        if (!this.parent.parent.initialized) {
            this.parent.parent.init();
        }
        return this.releaseObsolete;
    }

    public Rfm getRfm() throws MetaDataAccessException {
        return this.parent.parent.parent.bof.getRfm(this.getRfmName());
    }

    public String getRfmName() {
        return this.rfmName;
    }

    void initAsync() throws MetaDataAccessException {
        this.parent.parent.parent.bof.initAsyncBOMethod(this);
    }

    public boolean isAsynchronousCallSupported() throws MetaDataAccessException {
        return !this.getAsyncMessageType().equals("");
    }

    public boolean isClassMethod() {
        return this.isClassMethod;
    }

    public boolean isConsistent() {
        try {
            if (this.isClassMethod() != this.isReallyClassMethod() || this.isInstanceMethod() != this.isReallyInstanceMethod() || this.isFactoryMethod() != this.isReallyFactoryMethod()) {
                return false;
            }
            int i = 0;
            while (i < this.getBOParameters().getSize()) {
                BOParameter boParameter = this.getBOParameters().getBOParameter(i);
                if (!boParameter.isConsistent()) {
                    return false;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.getBOExceptions().getSize()) {
                BOException boException = this.getBOExceptions().getBOException(i2);
                if (!boException.isConsistent()) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isFactoryMethod() throws MetaDataAccessException {
        if (!this.parent.parent.initialized) {
            this.parent.parent.init();
        }
        return this.isFactoryMethod;
    }

    public boolean isInstanceMethod() {
        return !this.isClassMethod;
    }

    public boolean isObsolete() throws MetaDataAccessException {
        return !this.getReleaseObsolete().equals("");
    }

    public boolean isReallyClassMethod() throws MetaDataAccessException {
        return this.parent.parent.parent.bof.isClassMethod(this);
    }

    public boolean isReallyFactoryMethod() throws MetaDataAccessException {
        return this.parent.parent.parent.bof.isFactoryMethod(this);
    }

    public boolean isReallyInstanceMethod() throws MetaDataAccessException {
        return this.parent.parent.parent.bof.isInstanceMethod(this);
    }

    public boolean isReleased() throws MetaDataAccessException {
        if (!this.parent.parent.initialized) {
            this.parent.parent.init();
        }
        return this.isReleased;
    }

    public boolean isUsingDialog() throws MetaDataAccessException {
        if (!this.parent.parent.initialized) {
            this.parent.parent.init();
        }
        return this.usesDialog;
    }

    public boolean isUsingExceptions() throws MetaDataAccessException {
        return this.getBOExceptions().getSize() > 0;
    }
}

