/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class ExceptionMessageGenerator {
    protected ExceptionMessageGenerator(String dirName) {
        File dir = new File(dirName);
        this.generate(dir);
    }

    private void generate(File dir) {
        if (!dir.isDirectory()) {
            System.err.println("No such directory:" + dir.getAbsolutePath());
            return;
        }
        String[] dirContent = dir.list();
        int i = 0;
        while (i < dirContent.length) {
            File f = new File(dir, dirContent[i]);
            if (f.isDirectory()) {
                this.generate(f);
            } else if (dirContent[i].endsWith("Message.properties")) {
                String className = dirContent[i].substring(0, dirContent[i].length() - "Message.properties".length()) + "Message";
                String filename = className + ".java";
                System.out.println("Generating:" + filename);
                try {
                    Properties p = new Properties();
                    p.load(new FileInputStream(f));
                    File outputFile = new File(dir, filename);
                    PrintStream pw = new PrintStream(new FileOutputStream(outputFile));
                    pw.println("package " + p.getProperty("package") + ";\n");
                    pw.println("import com.sap.security.core.server.util0.IDMessage;");
                    pw.println("public class " + className + " extends IDMessage {");
                    pw.println("public static final String BUNDLE = " + className + ".class.getName();");
                    pw.println("public static final String PREFIX_IN_BUNDLE = \"" + p.getProperty("prefix") + "\";");
                    pw.println("public static final String PREFIX_IN_OUTPUT = PREFIX_IN_BUNDLE;");
                    Iterator keyIterator = ((Hashtable)p).keySet().iterator();
                    while (keyIterator.hasNext()) {
                        String key = (String)keyIterator.next();
                        if (!key.startsWith("ID")) continue;
                        pw.println("/**");
                        pw.println("* " + p.getProperty(key));
                        pw.println("**/");
                        int index = -1;
                        int bracketCounter = 0;
                        while (p.getProperty(key).indexOf("{", index + 1) != -1) {
                            ++bracketCounter;
                            index = p.getProperty(key).indexOf("{", index + 1);
                        }
                        String ID = key.substring(2, key.indexOf("_"));
                        pw.println("\tpublic static final Msg" + bracketCounter + " " + key + " = new Msg" + bracketCounter + "(\"" + ID + "\",\"" + p.getProperty(key) + "\"," + className + ".class);\n");
                    }
                    pw.println("\tpublic " + className + "(BaseMsg baseMsg, Object[] args) {");
                    pw.println("\t\tsuper(baseMsg, args, BUNDLE, PREFIX_IN_BUNDLE, PREFIX_IN_OUTPUT);");
                    pw.println("\t}");
                    pw.println("}");
                }
                catch (Exception ex) {
                    System.err.println("Error during generation of " + filename + ":" + ex.getMessage());
                }
            }
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        String startDir = ".";
        if (args.length == 0) {
            new ExceptionMessageGenerator(startDir);
        } else {
            int i = 0;
            while (i < args.length) {
                new ExceptionMessageGenerator(args[i]);
                ++i;
            }
        }
    }
}

