/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.ws.wss.xml.transforms;

import com.sap.engine.lib.jaxp.TransformerFactoryImpl;
import com.sap.engine.lib.xml.signature.Data;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.security.core.server.util0.Base64;
import com.sap.security.core.ws.wss.AttachmentData;
import com.sap.security.core.ws.wss.AttachmentList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.mail.MessagingException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XLinkDigestTransform
extends Transformation {
    public static String URI = "http://sap.com/exchange/2003/07/XLinkDigestTransform";
    public static String SAPNS = "http://sap.com/xi/XI/Message/30";
    public static String XLINKNS = "http://www.w3.org/1999/xlink";

    public XLinkDigestTransform(Object[] additionalArgs) {
        super(additionalArgs);
        this.uri = URI;
    }

    public void transform(Data data) throws SignatureException {
        Node topNode = data.getNode();
        Element transformElement = null;
        if (this.additionalArgs.length != 1) {
            throw new SignatureException(((Object)((Object)this)).getClass().getName() + ": No additionalArguments found:" + this.additionalArgs);
        }
        if (!(this.additionalArgs[0] instanceof AttachmentList)) {
            throw new SignatureException(((Object)((Object)this)).getClass().getName() + ": Expected AttachmentList as argument. Found:" + this.additionalArgs[0]);
        }
        AttachmentList attachments = (AttachmentList)this.additionalArgs[0];
        if (!(topNode instanceof Document)) {
            throw new SignatureException(((Object)((Object)this)).getClass().getName() + ": Element expected");
        }
        transformElement = ((Document)topNode).getDocumentElement();
        try {
            this.transform(transformElement, attachments);
            data.setOctets(this.writeNode(transformElement));
        }
        catch (Exception ex) {
            throw new SignatureException(((Object)((Object)this)).getClass().getName() + "Error during transform:" + ex.getClass().getName() + " " + ex.getMessage());
        }
    }

    void transform(Element topElement, AttachmentList mimeAttachments) throws NoSuchAlgorithmException, DOMException, IOException, MessagingException {
        Document doc = topElement.getOwnerDocument();
        NodeList nl = topElement.getElementsByTagNameNS(SAPNS, "Payload");
        int nodeNumber = 0;
        while (nodeNumber < nl.getLength()) {
            Element payloadNode = (Element)nl.item(nodeNumber);
            String href = payloadNode.getAttributeNS(XLINKNS, "href");
            AttachmentData attachmentData = mimeAttachments.getAttachmentData(href);
            if (attachmentData == null) {
                throw new IOException("No attchment " + href + " to sign found");
            }
            byte[] payloadData = attachmentData.getPayload();
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(payloadData);
            byte[] digest = md.digest();
            Element digestElement = doc.createElementNS(SAPNS, "SAP:Digest");
            digestElement.setAttributeNS(SAPNS, "SAP:ContentType", attachmentData.getContentType());
            digestElement.appendChild(doc.createTextNode(Base64.encode((byte[])digest, (int)0)));
            payloadNode.appendChild(digestElement);
            ++nodeNumber;
        }
    }

    private byte[] writeNode(Node node) throws TransformerException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(bos);
        DOMSource source = new DOMSource(node);
        TransformerFactoryImpl tf = new TransformerFactoryImpl();
        Transformer tr = tf.newTransformer();
        tr.setOutputProperty("method", "xml");
        tr.setOutputProperty("omit-xml-declaration", "no");
        tr.setOutputProperty("standalone", "yes");
        tr.setOutputProperty("encoding", "UTF-8");
        tr.setOutputProperty("indent", "no");
        tr.transform(source, streamResult);
        return bos.toByteArray();
    }

    public Transformation defineFrom(GenericElement genericElement, HashMap arg1) throws SignatureException {
        String genericElementURI = genericElement.getAttribute("Algorithm", null, null);
        if (this.uri.equals(genericElementURI)) {
            return this;
        }
        return null;
    }
}

