/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.ws.wss.tokens.securitytoken;

import com.sap.engine.lib.security.BasicPasswordCallbackHandler;
import com.sap.security.core.policy.exceptions.ProcessMessage;
import com.sap.security.core.securitypolicy.assertions.SecurityPolicyConstants;
import com.sap.security.core.server.util0.Base64;
import com.sap.security.core.ws.mapping.ExtendableReferenceableElement;
import com.sap.security.core.ws.wss.tokens.securitytoken.NonceElement;
import com.sap.security.core.ws.wss.tokens.securitytoken.PasswordElement;
import com.sap.security.core.ws.wss.tokens.timestamp.CreatedElement;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import iaik.security.random.SecRandom;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class UsernameToken
extends ExtendableReferenceableElement {
    public static final int NONCE_LENGTH = 12;
    private CreatedElement created = null;
    private String username = null;
    private String type = SecurityPolicyConstants.getInstance("WS Security SAP NW 04 Stack 04").getPasswordTextTypeURI();
    private byte[] nonce = null;
    private String password = null;
    private boolean containsNonce = false;
    private boolean containsCreated = false;
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$ws$wss$tokens$securitytoken$UsernameToken == null ? (class$com$sap$security$core$ws$wss$tokens$securitytoken$UsernameToken = UsernameToken.class$("com.sap.security.core.ws.wss.tokens.securitytoken.UsernameToken")) : class$com$sap$security$core$ws$wss$tokens$securitytoken$UsernameToken));
    final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"WS/Policy");
    static /* synthetic */ Class class$com$sap$security$core$ws$wss$tokens$securitytoken$UsernameToken;

    public UsernameToken() {
    }

    public UsernameToken(String type, String username, String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        this();
        this.setUsername(username);
        this.setType(type);
        if (SecurityPolicyConstants.isPasswordDigestType(type)) {
            this.setContainsCreated(true);
            this.setContainsNonce(true);
            this.setNonce();
            this.password = this.createPasswordDigest(password);
        } else {
            this.password = password;
        }
    }

    public CreatedElement getCreated() {
        if (!this.containsCreated) {
            return null;
        }
        return this.created;
    }

    public void setCreated(CreatedElement created) {
        if (created != null) {
            this.containsCreated = true;
        }
        this.created = created;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public NonceElement getNonce() {
        if (!this.containsNonce) {
            return null;
        }
        if (this.nonce == null && this.containsNonce) {
            this.setNonce();
        }
        if (this.nonce != null) {
            NonceElement nonceElement = new NonceElement();
            nonceElement.setValue(Base64.encode((byte[])this.nonce, (int)0));
            return nonceElement;
        }
        return null;
    }

    private void setNonce() {
        this.nonce = new byte[12];
        SecRandom.getDefault().nextBytes(this.nonce);
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
        if (nonce != null) {
            this.containsNonce = true;
        }
    }

    public void setNonce(NonceElement nonceElement) {
        String method = "setNonce";
        this.nonce = null;
        if (nonceElement.getEncodingType() == null || SecurityPolicyConstants.isBase64BinaryEncoding(nonceElement.getEncodingType())) {
            try {
                this.nonce = Base64.decode((String)nonceElement.getValue());
            }
            catch (ParseException e) {
                ProcessMessage.ID0800_SECURITY_HEADER_ERROR.create((Object)e.getMessage()).log(500, this.CATEGORY, LOCATION, "setNonce");
            }
        }
    }

    public PasswordElement getPassword() {
        if (this.password == null) {
            return null;
        }
        PasswordElement passwordElement = new PasswordElement(this.type, this.password);
        return passwordElement;
    }

    public void setPassword(PasswordElement passwordElement) {
        this.type = passwordElement.getType();
        this.password = passwordElement.getValue();
    }

    private String createPasswordDigest(String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String passwordDigest = null;
        if (this.nonce == null) {
            this.setNonce();
        }
        MessageDigest mdAlg = MessageDigest.getInstance("SHA");
        mdAlg.reset();
        mdAlg.update(this.nonce);
        mdAlg.update(this.getCreated().getUTCDateAsString().getBytes("UTF-8"));
        mdAlg.update(password.getBytes("UTF-8"));
        byte[] digest = mdAlg.digest();
        passwordDigest = Base64.encode((byte[])digest, (int)0);
        return passwordDigest;
    }

    public void doLogin() throws LoginException {
        if (!SecurityPolicyConstants.isPasswordTextType(this.type)) {
            throw new LoginException("Cannot do login with password type " + this.type);
        }
        BasicPasswordCallbackHandler handler = new BasicPasswordCallbackHandler(this.username, this.password);
        LoginContext login = new LoginContext("basic", (CallbackHandler)handler);
        login.login();
    }

    public boolean getContainsCreated() {
        return this.containsCreated;
    }

    public boolean getContainsNonce() {
        return this.containsNonce;
    }

    public void setContainsCreated(boolean b) {
        if (b && !this.containsCreated) {
            this.setCreated(new CreatedElement());
        }
        this.containsCreated = b;
    }

    public void setContainsNonce(boolean b) {
        this.containsNonce = b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

