/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.ws.wss.tokens.securitytoken;

import com.sap.security.core.securitypolicy.assertions.SecurityPolicyConstants;
import com.sap.security.core.server.util0.Base64;
import com.sap.security.core.ws.mapping.ExtendableReferenceableElement;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.text.ParseException;

public class KeyIdentifierElement
extends ExtendableReferenceableElement {
    private String valueType;
    private String encodingType;
    private String value;

    public KeyIdentifierElement() {
        this.valueType = SecurityPolicyConstants.getInstance((String)"WS Security SAP NW 04 Stack 04").WSSE_SUBJECT_KEY_IDENTIFIER_URI;
        this.encodingType = SecurityPolicyConstants.getInstance((String)"WS Security SAP NW 04 Stack 04").WSSE_BASE64_BINARY_URI;
        this.value = null;
    }

    public KeyIdentifierElement(X509Certificate iaikCertificate, String encodingType, String valueType) throws X509ExtensionInitException, CertificateException, ParseException, NoSuchAlgorithmException, CodingException {
        this.valueType = SecurityPolicyConstants.getInstance((String)"WS Security SAP NW 04 Stack 04").WSSE_SUBJECT_KEY_IDENTIFIER_URI;
        this.encodingType = SecurityPolicyConstants.getInstance((String)"WS Security SAP NW 04 Stack 04").WSSE_BASE64_BINARY_URI;
        this.value = null;
        this.setEncodingType(encodingType);
        this.setValueType(valueType);
        V3Extension ext = iaikCertificate.getExtension(new ObjectID("2.5.29.14"));
        if (ext == null) {
            ext = new SubjectKeyIdentifier(iaikCertificate.getPublicKey());
        }
        SubjectKeyIdentifier subjectKeyIdentifierExtension = (SubjectKeyIdentifier)ext;
        byte[] certificateSubjectKeyIdentifierValue = subjectKeyIdentifierExtension.get();
        this.setValue(Base64.encode((byte[])certificateSubjectKeyIdentifierValue, (int)0));
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public String getValue() {
        return this.value;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public boolean equalsSubjectKeyIdentifier(X509Certificate iaikCertificate) throws X509ExtensionInitException, CertificateException, ParseException, NoSuchAlgorithmException, CodingException {
        byte[] certificateSubjectKeyIdentifierValue;
        if (this.value == null) {
            throw new CertificateException("No certificate set in <wsse:KeyIdentfier>");
        }
        if (!SecurityPolicyConstants.isBase64BinaryEncoding(this.encodingType)) {
            throw new CertificateException("Unsupported encoding in <wsse:KeyIdentfier>:" + this.encodingType);
        }
        if (!SecurityPolicyConstants.isX509SubjectKeyIdentifier(this.valueType)) {
            throw new CertificateException("Unsupported value type in <wsse:KeyIdentfier>:" + this.valueType);
        }
        V3Extension ext = iaikCertificate.getExtension(new ObjectID("2.5.29.14"));
        if (ext == null) {
            ext = new SubjectKeyIdentifier(iaikCertificate.getPublicKey());
        }
        SubjectKeyIdentifier subjectKeyIdentifierExtension = (SubjectKeyIdentifier)ext;
        byte[] keyIdentifierSubjectKeyIdentifierValue = Base64.decode((String)this.value);
        if (keyIdentifierSubjectKeyIdentifierValue.length != (certificateSubjectKeyIdentifierValue = subjectKeyIdentifierExtension.get()).length) {
            return false;
        }
        int i = 0;
        while (i < keyIdentifierSubjectKeyIdentifierValue.length) {
            if (keyIdentifierSubjectKeyIdentifierValue[i] != certificateSubjectKeyIdentifierValue[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

