/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.ws.wss;

import com.sap.security.core.policy.PolicyInfoManagerInterface;
import com.sap.security.core.policy.WSPolicy;
import com.sap.security.core.policy.exceptions.ProcessException;
import com.sap.security.core.policy.exceptions.ProcessMessage;
import com.sap.security.core.policy.exceptions.VerifyException;
import com.sap.security.core.policy.exceptions.VerifyMessage;
import com.sap.security.core.securitypolicy.assertions.SecurityPolicyConstants;
import com.sap.security.core.server.util0.Base64;
import com.sap.security.core.server.util0.IDMessage;
import com.sap.security.core.ws.mapping.WSMappingUtil;
import com.sap.security.core.ws.wss.AttachmentData;
import com.sap.security.core.ws.wss.AttachmentList;
import com.sap.security.core.ws.wss.NoSecurityHeaderException;
import com.sap.security.core.ws.wss.WSProcessor;
import com.sap.security.core.ws.wss.WSSecurity;
import com.sap.security.core.ws.wss.WSSecurityContext;
import com.sap.security.core.ws.wss.WSSecurityDocument;
import com.sap.security.core.ws.wss.WSSecurityMessage;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WSSecurityImpl
implements WSSecurity {
    private static int id = 0;
    private PolicyInfoManagerInterface policyInfoManager;
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$ws$wss$WSSecurityImpl == null ? (class$com$sap$security$core$ws$wss$WSSecurityImpl = WSSecurityImpl.class$("com.sap.security.core.ws.wss.WSSecurityImpl")) : class$com$sap$security$core$ws$wss$WSSecurityImpl));
    final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"WS/SecurityProtocol");
    static /* synthetic */ Class class$com$sap$security$core$ws$wss$WSSecurityImpl;
    static /* synthetic */ Class class$com$sap$security$core$ws$wss$WSSecurityDocument;

    public WSSecurityImpl() {
    }

    public WSSecurityImpl(PolicyInfoManagerInterface policyInfoManager) {
        this.policyInfoManager = policyInfoManager;
    }

    public WSSecurityDocument applyPolicy(Document soapDocument, AttachmentList attachments, WSPolicy policy, WSSecurityContext sctx) throws ProcessException {
        WSSecurityDocument wsDocument;
        String method = "applyPolicy";
        try {
            wsDocument = new WSSecurityDocument(soapDocument, attachments, sctx, true);
        }
        catch (NoSecurityHeaderException ex) {
            IDMessage message = ProcessMessage.ID0800_SECURITY_HEADER_ERROR.create((Object)ex.getMessage());
            throw new ProcessException(message, (Throwable)((Object)ex));
        }
        if (this.CATEGORY.bePath()) {
            try {
                ByteArrayOutputStream soapBOS = new ByteArrayOutputStream();
                WSMappingUtil.write(soapDocument, soapBOS);
                WSSecurityMessage.ID0100_APPLY.create((Object)sctx.getMessageID(), (Object)new String(soapBOS.toByteArray())).log(200, this.CATEGORY, LOCATION, method);
                WSSecurityMessage.ID0110_APPLY_BASE64.create((Object)sctx.getMessageID(), (Object)Base64.encode((byte[])soapBOS.toByteArray(), (int)0)).log(200, this.CATEGORY, LOCATION, method);
                if (attachments != null && !attachments.getContentIdSet().isEmpty()) {
                    Set cidSet = attachments.getContentIdSet();
                    Iterator cidIterator = cidSet.iterator();
                    while (cidIterator.hasNext()) {
                        String cid = (String)cidIterator.next();
                        AttachmentData attachmentData = attachments.getAttachmentData(cid);
                        WSSecurityMessage.ID0210_APPLY_ATTACHMENT_DATA.create((Object)sctx.getMessageID(), (Object)cid, (Object)attachmentData.getContentType(), (Object)Base64.encode((byte[])attachmentData.getPayload(), (int)0)).log(200, this.CATEGORY, LOCATION, method);
                    }
                }
            }
            catch (Throwable ex) {
                LOCATION.catching(this.CATEGORY, ex);
            }
        }
        policy.apply(wsDocument, sctx.getMessageID());
        try {
            WSMappingUtil util = SecurityPolicyConstants.getMappingUtilByNamespace(sctx.getConstants().WSSE_URI);
            NodeList headerNL = soapDocument.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
            if (headerNL.getLength() > 1) {
                System.err.println("More than one header element found");
                return wsDocument;
            }
            Element headerElement = null;
            if (headerNL.getLength() == 0) {
                headerElement = soapDocument.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "soap:Header");
                NodeList bodyNL = soapDocument.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
                if (bodyNL.getLength() == 1) {
                    soapDocument.getDocumentElement().insertBefore(headerElement, bodyNL.item(0));
                } else {
                    soapDocument.getDocumentElement().appendChild(headerElement);
                }
            } else {
                headerElement = (Element)headerNL.item(0);
            }
            Iterator headerIterator = wsDocument.getHeaders();
            while (headerIterator.hasNext()) {
                util.marshall(headerIterator.next(), headerElement, (class$com$sap$security$core$ws$wss$WSSecurityDocument == null ? WSSecurityImpl.class$("com.sap.security.core.ws.wss.WSSecurityDocument") : class$com$sap$security$core$ws$wss$WSSecurityDocument).getClassLoader());
            }
        }
        catch (Exception ex) {
            throw new ProcessException(ProcessMessage.ID0010_ERROR_DURING_XML_UNMARSHALL.create((Object)ex.getMessage()), ex);
        }
        Iterator processorIterator = wsDocument.getProcessors();
        while (processorIterator.hasNext()) {
            WSProcessor processor = (WSProcessor)processorIterator.next();
            processor.apply(wsDocument);
        }
        if (this.CATEGORY.bePath()) {
            try {
                ByteArrayOutputStream soapBOS = new ByteArrayOutputStream();
                WSMappingUtil.write(soapDocument, soapBOS);
                WSSecurityMessage.ID0150_APPLY_POST.create((Object)sctx.getMessageID(), (Object)new String(soapBOS.toByteArray())).log(200, this.CATEGORY, LOCATION, method);
                WSSecurityMessage.ID0160_APPLY_BASE64_POST.create((Object)sctx.getMessageID(), (Object)Base64.encode((byte[])soapBOS.toByteArray(), (int)0)).log(200, this.CATEGORY, LOCATION, method);
                if (attachments != null && !attachments.getContentIdSet().isEmpty()) {
                    Set cidSet = attachments.getContentIdSet();
                    Iterator cidIterator = cidSet.iterator();
                    while (cidIterator.hasNext()) {
                        String cid = (String)cidIterator.next();
                        AttachmentData attachmentData = attachments.getAttachmentData(cid);
                        WSSecurityMessage.ID0260_APPLY_ATTACHMENT_DATA_POST.create((Object)sctx.getMessageID(), (Object)cid, (Object)attachmentData.getContentType(), (Object)Base64.encode((byte[])attachmentData.getPayload(), (int)0)).log(200, this.CATEGORY, LOCATION, method);
                    }
                }
            }
            catch (Throwable ex) {
                LOCATION.catching(this.CATEGORY, ex);
            }
        }
        return wsDocument;
    }

    public WSSecurityDocument applyPolicy(Document soapDocument, WSPolicy policy, WSSecurityContext sctx) throws ProcessException {
        return this.applyPolicy(soapDocument, null, policy, sctx);
    }

    public void verifyPolicy(Document soapDocument, AttachmentList attachments, WSPolicy policy, WSSecurityContext sctx) throws VerifyException {
        AttachmentData attachmentData;
        String cid;
        Iterator cidIterator;
        Set cidSet;
        ByteArrayOutputStream soapBOS;
        WSSecurityDocument wsDocument;
        String method = "verifyPolicy";
        try {
            wsDocument = new WSSecurityDocument(soapDocument, attachments, sctx, false);
        }
        catch (NoSecurityHeaderException ex) {
            IDMessage message = VerifyMessage.ID0800_SECURITY_HEADER_ERROR.create((Object)ex.getMessage());
            throw new VerifyException(message, (Throwable)((Object)ex));
        }
        if (this.CATEGORY.bePath()) {
            try {
                soapBOS = new ByteArrayOutputStream();
                WSMappingUtil.write(soapDocument, soapBOS);
                WSSecurityMessage.ID0500_VERIFY.create((Object)sctx.getMessageID(), (Object)new String(soapBOS.toByteArray())).log(200, this.CATEGORY, LOCATION, method);
                WSSecurityMessage.ID0510_VERIFY_BASE64.create((Object)sctx.getMessageID(), (Object)Base64.encode((byte[])soapBOS.toByteArray(), (int)0)).log(200, this.CATEGORY, LOCATION, method);
                if (attachments != null && !attachments.getContentIdSet().isEmpty()) {
                    cidSet = attachments.getContentIdSet();
                    cidIterator = cidSet.iterator();
                    while (cidIterator.hasNext()) {
                        cid = (String)cidIterator.next();
                        attachmentData = attachments.getAttachmentData(cid);
                        WSSecurityMessage.ID0610_VERIFY_ATTACHMENT_DATA.create((Object)sctx.getMessageID(), (Object)cid, (Object)attachmentData.getContentType(), (Object)Base64.encode((byte[])attachmentData.getPayload(), (int)0)).log(200, this.CATEGORY, LOCATION, method);
                    }
                }
            }
            catch (Throwable ex) {
                LOCATION.catching(this.CATEGORY, ex);
            }
        }
        policy.verify(wsDocument, sctx.getMessageID());
        if (this.CATEGORY.bePath()) {
            try {
                soapBOS = new ByteArrayOutputStream();
                WSMappingUtil.write(soapDocument, soapBOS);
                WSSecurityMessage.ID0550_VERIFY_POST.create((Object)sctx.getMessageID(), (Object)new String(soapBOS.toByteArray())).log(200, this.CATEGORY, LOCATION, method);
                WSSecurityMessage.ID0560_VERIFY_BASE64_POST.create((Object)sctx.getMessageID(), (Object)Base64.encode((byte[])soapBOS.toByteArray(), (int)0)).log(200, this.CATEGORY, LOCATION, method);
                if (attachments != null && !attachments.getContentIdSet().isEmpty()) {
                    cidSet = attachments.getContentIdSet();
                    cidIterator = cidSet.iterator();
                    while (cidIterator.hasNext()) {
                        cid = (String)cidIterator.next();
                        attachmentData = attachments.getAttachmentData(cid);
                        WSSecurityMessage.ID0660_VERIFY_ATTACHMENT_DATA_POST.create((Object)sctx.getMessageID(), (Object)cid, (Object)attachmentData.getContentType(), (Object)Base64.encode((byte[])attachmentData.getPayload(), (int)0)).log(200, this.CATEGORY, LOCATION, method);
                    }
                }
            }
            catch (Throwable ex) {
                LOCATION.catching(this.CATEGORY, ex);
            }
        }
    }

    public void verifyPolicy(Document soapDocument, WSPolicy policy, WSSecurityContext sctx) throws VerifyException {
        this.verifyPolicy(soapDocument, null, policy, sctx);
    }

    public PolicyInfoManagerInterface getPolicyInfoManager() {
        return this.policyInfoManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

