/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.ws.wss;

import com.sap.security.core.securitypolicy.assertions.SecurityPolicyConstants;
import com.sap.security.core.server.util0.IDMessage;
import com.sap.security.core.ws.mapping.WSMappingUtil;
import com.sap.security.core.ws.wss.AttachmentList;
import com.sap.security.core.ws.wss.NoSecurityHeaderException;
import com.sap.security.core.ws.wss.NoSecurityHeaderExceptionMessage;
import com.sap.security.core.ws.wss.SecurityHeader;
import com.sap.security.core.ws.wss.WSProcessor;
import com.sap.security.core.ws.wss.WSSSOAPHeader;
import com.sap.security.core.ws.wss.WSSecurityContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WSSecurityDocument {
    Document soapDocument;
    List headerElementList = new ArrayList();
    List processorList = new ArrayList();
    AttachmentList attachments = null;
    WSSecurityContext sctx = null;
    static /* synthetic */ Class class$com$sap$security$core$ws$wss$SecurityHeader;

    public WSSecurityDocument(Document soapDocument, AttachmentList attachments, WSSecurityContext sctx, boolean apply) throws NoSecurityHeaderException {
        this.soapDocument = soapDocument;
        this.attachments = attachments;
        this.sctx = sctx;
        Element securityHeaderElement = this.getSecurityHeaderElement(apply);
        if (securityHeaderElement != null) {
            SecurityPolicyConstants constants = SecurityPolicyConstants.getConstantsByNamespace(securityHeaderElement.getNamespaceURI());
            sctx.setConstants(constants);
            try {
                WSMappingUtil util2 = SecurityPolicyConstants.getMappingUtilByNamespace(securityHeaderElement.getNamespaceURI());
                Object obj = util2.unmarshall(securityHeaderElement, (class$com$sap$security$core$ws$wss$SecurityHeader == null ? (class$com$sap$security$core$ws$wss$SecurityHeader = WSSecurityDocument.class$("com.sap.security.core.ws.wss.SecurityHeader")) : class$com$sap$security$core$ws$wss$SecurityHeader).getClassLoader());
                SecurityHeader securityHeader = (SecurityHeader)obj;
                this.addSecurityHeader(securityHeader);
            }
            catch (Exception ex) {
                IDMessage message = NoSecurityHeaderExceptionMessage.ID0500_PARSING_ERROR.create((Object)ex.getClass().getName(), (Object)ex.getMessage(), (Object)securityHeaderElement);
                throw new NoSecurityHeaderException(message, ex);
            }
        }
    }

    public void addHeader(WSSSOAPHeader soapHeader) {
        this.headerElementList.add(soapHeader);
    }

    public void addSecurityHeader(SecurityHeader securityHeader) {
        this.headerElementList.add(securityHeader);
    }

    public SecurityHeader getSecurityHeaderByRole(String role) throws NoSecurityHeaderException {
        Iterator headerIterator = this.headerElementList.iterator();
        while (headerIterator.hasNext()) {
            Object o = headerIterator.next();
            if (!(o instanceof SecurityHeader) || !role.equals(((SecurityHeader)o).getRole())) continue;
            return (SecurityHeader)o;
        }
        throw new NoSecurityHeaderException(NoSecurityHeaderExceptionMessage.ID0100_NO_SECURITY_HEADER.create((Object)role), null);
    }

    public boolean hasSecurityHeader(String role) {
        Iterator headerIterator = this.headerElementList.iterator();
        while (headerIterator.hasNext()) {
            Object o = headerIterator.next();
            if (!(o instanceof SecurityHeader) || !role.equals(((SecurityHeader)o).getRole())) continue;
            return true;
        }
        return false;
    }

    public Iterator getHeaders() {
        return this.headerElementList.iterator();
    }

    public void addProcessor(WSProcessor processor) {
        this.processorList.add(processor);
    }

    public Iterator getProcessors() {
        return this.processorList.iterator();
    }

    public Document getSoapDocument() {
        return this.soapDocument;
    }

    public Element getSecurityHeaderElement() {
        return this.getSecurityHeaderElement(false);
    }

    private Element getSecurityHeaderElement(boolean removeSecurityHeader) {
        NodeList nl = this.soapDocument.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
        if (nl.getLength() == 0) {
            return null;
        }
        Element element = (Element)nl.item(0);
        NodeList headerNodeList = element.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
        if (headerNodeList.getLength() == 0) {
            return null;
        }
        Element headerElement = (Element)headerNodeList.item(0);
        Iterator wsseNamespaceInterator = SecurityPolicyConstants.getWSSENamespaces().iterator();
        NodeList securityHeaderNodeList = null;
        while (wsseNamespaceInterator.hasNext()) {
            NodeList tmpSecurityHeaderNodeList;
            String wsseNamespace = (String)wsseNamespaceInterator.next();
            if (securityHeaderNodeList != null || (tmpSecurityHeaderNodeList = headerElement.getElementsByTagNameNS(wsseNamespace, "Security")).getLength() == 0) continue;
            securityHeaderNodeList = tmpSecurityHeaderNodeList;
        }
        if (securityHeaderNodeList == null) {
            return null;
        }
        Element securityHeaderElement = (Element)securityHeaderNodeList.item(0);
        if (removeSecurityHeader) {
            headerElement.removeChild(securityHeaderElement);
        }
        return securityHeaderElement;
    }

    public AttachmentList getAttachments() {
        return this.attachments;
    }

    public WSSecurityContext getSecurityContext() {
        return this.sctx;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

