/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.ws.wss;

import com.sap.security.core.ws.dsig.SignatureElement;
import com.sap.security.core.ws.mapping.ExtendableReferenceableElement;
import com.sap.security.core.ws.wss.WSSSOAPHeader;
import com.sap.security.core.ws.wss.tokens.securitytoken.BinarySecurityToken;
import com.sap.security.core.ws.wss.tokens.securitytoken.UsernameToken;
import com.sap.security.core.ws.wss.tokens.timestamp.Timestamp;
import com.sap.security.core.ws.xenc.EncryptedKeyElement;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SecurityHeader
extends ExtendableReferenceableElement
implements WSSSOAPHeader {
    public static String TYPE = "Security";
    private String role = "soap:finalActor";
    private UsernameToken usernameToken;
    private List binarySecurityTokensList = new ArrayList();
    private List anyElementList = new ArrayList();
    private String mustUnderstand = "1";
    private List encryptedKeyElementList = new ArrayList();
    private List timestampList = new ArrayList();
    List signatureElementList = new ArrayList();
    private static int guidID = 0;

    public String getRole() {
        return this.role;
    }

    public UsernameToken getUsernameToken() {
        return this.usernameToken;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setUsernameToken(UsernameToken usernameToken) {
        this.usernameToken = usernameToken;
    }

    public String getType() {
        return TYPE;
    }

    public Iterator getBinarySecurityTokens() {
        return this.binarySecurityTokensList.iterator();
    }

    public BinarySecurityToken getBinarySecurityTokenbyID(String id) {
        Iterator tokenIterator = this.binarySecurityTokensList.iterator();
        while (tokenIterator.hasNext()) {
            BinarySecurityToken token = (BinarySecurityToken)tokenIterator.next();
            if (!id.equals(token.getId())) continue;
            return token;
        }
        return null;
    }

    public void addBinarySecurityToken(BinarySecurityToken binarySecurityToken) throws NoSuchAlgorithmException {
        if (this.getBinarySecurityTokenID(binarySecurityToken) == null) {
            this.binarySecurityTokensList.add(binarySecurityToken);
        }
    }

    public String getBinarySecurityTokenID(BinarySecurityToken binarySecurityToken) throws NoSuchAlgorithmException {
        Iterator tokenIterator = this.binarySecurityTokensList.iterator();
        while (tokenIterator.hasNext()) {
            BinarySecurityToken token = (BinarySecurityToken)tokenIterator.next();
            if (!token.getFingerprint().equals(binarySecurityToken.getFingerprint())) continue;
            return token.getId();
        }
        return null;
    }

    public Iterator getSignatures() {
        return this.signatureElementList.iterator();
    }

    public void addSignature(SignatureElement signatureElement) {
        this.signatureElementList.add(signatureElement);
    }

    public String getGUID() {
        return "sap-" + guidID++;
    }

    public void addAnyElment(Object any) {
        this.anyElementList.add(any);
    }

    public Iterator getAnyElements() {
        return null;
    }

    public String getMustUnderstand() {
        return this.mustUnderstand;
    }

    public void setMustUnderstand(String string) {
        this.mustUnderstand = string;
    }

    public void addEncryptedKey(EncryptedKeyElement encryptedKey) {
        this.encryptedKeyElementList.add(encryptedKey);
    }

    public Iterator getEncryptedKeys() {
        return this.encryptedKeyElementList.iterator();
    }

    public void addTimestamp(Timestamp timestamp) {
        this.timestampList.add(timestamp);
    }

    public Iterator getTimestamps() {
        return this.timestampList.iterator();
    }
}

