/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.ws.wss;

import com.sap.security.core.ws.wss.AttachmentData;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class AttachmentList {
    private HashMap attachmentHashMap = new HashMap();

    public AttachmentList() {
    }

    public AttachmentList(MimeMultipart soapAttachments) throws IOException, MessagingException {
        int i = 0;
        while (i < soapAttachments.getCount()) {
            MimeBodyPart bp = (MimeBodyPart)soapAttachments.getBodyPart(i);
            String cid = bp.getContentID();
            if (cid != null) {
                if (!cid.startsWith("cid:")) {
                    cid = "cid:" + cid;
                }
                byte[] payloadData = new byte[bp.getSize()];
                bp.getInputStream().read(payloadData);
                AttachmentData data = new AttachmentData(bp.getContentType(), payloadData);
                this.setAttachmentData(cid, data);
            }
            ++i;
        }
    }

    public void setAttachmentData(String cid, AttachmentData attachmentData) {
        this.attachmentHashMap.put(cid, attachmentData);
    }

    public AttachmentData getAttachmentData(String cid) {
        return (AttachmentData)this.attachmentHashMap.get(cid);
    }

    public Set getContentIdSet() {
        return this.attachmentHashMap.keySet();
    }
}

