/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.securitypolicy.assertions.cert;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.keystore.KeystoreManager;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.interfaces.security.SecuritySession;
import com.sap.security.core.securitypolicy.assertions.cert.WSSEKeystoreException;
import com.sap.security.core.securitypolicy.assertions.cert.WSSEKeystoreExceptionMessage;
import com.sap.security.core.server.util0.IDMessage;
import com.sap.security.core.server.util0.LRUHashMap;
import com.sap.tc.logging.Location;
import iaik.asn1.ObjectID;
import iaik.security.ssl.KeyAndCert;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.naming.NamingException;

public class WSSEKeystoreImpl {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$securitypolicy$assertions$cert$WSSEKeystoreImpl == null ? (class$com$sap$security$core$securitypolicy$assertions$cert$WSSEKeystoreImpl = WSSEKeystoreImpl.class$("com.sap.security.core.securitypolicy.assertions.cert.WSSEKeystoreImpl")) : class$com$sap$security$core$securitypolicy$assertions$cert$WSSEKeystoreImpl));
    private ApplicationServiceContext serviceContext = null;
    private LRUHashMap cacheHashmap = new LRUHashMap(25);
    boolean useCache = true;
    final long maxAge = 60000L;
    static final int DOMAIN_CERT_VIEW_ALIAS = 1;
    static final int DOMAIN_KEY_VIEW_ALIAS = 2;
    static final int DOMAIN_CERT_SKI = 3;
    static final int DOMAIN_KEY_SKI = 4;
    static /* synthetic */ Class class$com$sap$security$core$securitypolicy$assertions$cert$WSSEKeystoreImpl;

    public WSSEKeystoreImpl(ApplicationServiceContext applicationServiceContext) {
        this.serviceContext = applicationServiceContext;
    }

    private final void addToCache(int cacheDomain, String name, Object value) {
        String key = this.getPrincipal() + "." + cacheDomain + "." + name;
        if (this.cacheHashmap.containsKey(key)) {
            CacheEntry entry = (CacheEntry)this.cacheHashmap.get((Object)key);
            entry.value = value;
            entry.time = System.currentTimeMillis();
        } else {
            CacheEntry entry = new CacheEntry();
            entry.value = value;
            entry.time = System.currentTimeMillis();
            this.cacheHashmap.put((Object)key, (Object)entry);
        }
    }

    private final Object getFromCache(int cacheDomain, String name, boolean ignoreTimeout) {
        CacheEntry entry = null;
        String key = this.getPrincipal() + "." + cacheDomain + "." + name;
        if (this.cacheHashmap.containsKey(key)) {
            entry = (CacheEntry)this.cacheHashmap.get((Object)key);
            if (ignoreTimeout) {
                return entry.value;
            }
            if (System.currentTimeMillis() - entry.time > 60000L) {
                this.cacheHashmap.remove((Object)key);
                return null;
            }
            return entry.value;
        }
        return null;
    }

    private boolean equalSubjectKeyIdentifier(java.security.cert.X509Certificate certificate, byte[] subjectKeyIdentifierValue) throws CertificateException {
        byte[] certificateSubjectKeyIdentifierValue;
        try {
            certificateSubjectKeyIdentifierValue = this.getSubjectKeyIdentifier((X509Certificate)certificate);
        }
        catch (WSSEKeystoreException e) {
            return false;
        }
        if (certificateSubjectKeyIdentifierValue == null) {
            return false;
        }
        if (subjectKeyIdentifierValue.length != certificateSubjectKeyIdentifierValue.length) {
            return false;
        }
        int j = 0;
        while (j < subjectKeyIdentifierValue.length) {
            if (subjectKeyIdentifierValue[j] != certificateSubjectKeyIdentifierValue[j]) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public java.security.cert.X509Certificate getX509CertificateBySubjectKeyIdentifier(String view, byte[] subjectKeyIdentifierValue) throws WSSEKeystoreException {
        Object cachedData = this.getFromCache(3, view + this.octets2Hex(subjectKeyIdentifierValue), false);
        if (cachedData != null) {
            return (java.security.cert.X509Certificate)cachedData;
        }
        java.security.cert.X509Certificate[] certificates = this.getX509Certificate(view, "*");
        try {
            int i = 0;
            while (i < certificates.length) {
                if (this.equalSubjectKeyIdentifier(certificates[i], subjectKeyIdentifierValue)) {
                    this.addToCache(3, view + this.octets2Hex(subjectKeyIdentifierValue), certificates[i]);
                    return certificates[i];
                }
                ++i;
            }
        }
        catch (Exception ex) {
            IDMessage message = WSSEKeystoreExceptionMessage.ID0400_KEYSTORE_SKI_ERROR.create((Object)view, (Object)this.octets2Hex(subjectKeyIdentifierValue), (Object)ex.getMessage());
            throw new WSSEKeystoreException(message, ex);
        }
        IDMessage message = WSSEKeystoreExceptionMessage.ID0300_KEYSTORE_SKI.create((Object)view, (Object)this.octets2Hex(subjectKeyIdentifierValue));
        throw new WSSEKeystoreException(message, null);
    }

    public KeyAndCert getPrivateKeyBySubjectKeyIdentifier(String view, byte[] subjectKeyIdentifierValue) throws WSSEKeystoreException {
        Object cachedData = this.getFromCache(4, view + this.octets2Hex(subjectKeyIdentifierValue), false);
        if (cachedData != null) {
            return (KeyAndCert)cachedData;
        }
        KeyAndCert keyAndCert = null;
        try {
            keyAndCert = (KeyAndCert)AccessController.doPrivileged(new GetKeyBySubjectKeyIdentifierAction(view, subjectKeyIdentifierValue));
        }
        catch (Exception ex) {
            IDMessage message = WSSEKeystoreExceptionMessage.ID0400_KEYSTORE_SKI_ERROR.create((Object)view, (Object)this.octets2Hex(subjectKeyIdentifierValue), (Object)ex.getMessage());
            throw new WSSEKeystoreException(message, ex);
        }
        if (keyAndCert == null) {
            IDMessage message = WSSEKeystoreExceptionMessage.ID0300_KEYSTORE_SKI.create((Object)view, (Object)this.octets2Hex(subjectKeyIdentifierValue));
            throw new WSSEKeystoreException(message, null);
        }
        this.addToCache(4, view + this.octets2Hex(subjectKeyIdentifierValue), keyAndCert);
        return keyAndCert;
    }

    public java.security.cert.X509Certificate getX509CertificateBySubjectName(String view, String subjectName) throws WSSEKeystoreException {
        java.security.cert.X509Certificate[] certificates = this.getX509Certificate(view, "*");
        int i = 0;
        while (i < certificates.length) {
            if (certificates[i].getSubjectDN().getName().equals(subjectName)) {
                return certificates[i];
            }
            ++i;
        }
        IDMessage message = WSSEKeystoreExceptionMessage.ID0200_KEYSTORE_NO_SUCH_SUBJECT.create((Object)subjectName, (Object)view);
        throw new WSSEKeystoreException(message, null);
    }

    public java.security.cert.X509Certificate[] getX509Certificate(String view, String alias) throws WSSEKeystoreException {
        try {
            Object cachedData = this.getFromCache(1, view + alias, false);
            if (cachedData != null) {
                return (java.security.cert.X509Certificate[])cachedData;
            }
            GetCertPrivilegedAction action = new GetCertPrivilegedAction(view, alias);
            java.security.cert.X509Certificate[] x509Certificates = (java.security.cert.X509Certificate[])AccessController.doPrivileged(action);
            this.addToCache(1, view + alias, x509Certificates);
            return x509Certificates;
        }
        catch (Exception ex) {
            IDMessage message = WSSEKeystoreExceptionMessage.ID0100_KEYSTORE_ACCESS_FAILED.create((Object)ex.getMessage());
            throw new WSSEKeystoreException(message, ex);
        }
    }

    public KeyAndCert getPrivateKey(String view, String alias) throws WSSEKeystoreException {
        try {
            Object cachedData = this.getFromCache(2, view + alias, false);
            if (cachedData != null) {
                return (KeyAndCert)cachedData;
            }
            GetKeyAndCertPrivilegedAction action = new GetKeyAndCertPrivilegedAction(view, alias);
            KeyAndCert keyAndCert = (KeyAndCert)AccessController.doPrivileged(action);
            this.addToCache(2, view + alias, keyAndCert);
            return keyAndCert;
        }
        catch (Exception ex) {
            IDMessage message = WSSEKeystoreExceptionMessage.ID0100_KEYSTORE_ACCESS_FAILED.create((Object)ex.getMessage());
            throw new WSSEKeystoreException(message, ex);
        }
    }

    private String getPrincipal() {
        Principal principal = null;
        try {
            if (this.serviceContext != null && this.serviceContext.getCoreContext().getThreadSystem() != null && this.serviceContext.getCoreContext().getThreadSystem().getThreadContext() != null) {
                ThreadContext threadContext = this.serviceContext.getCoreContext().getThreadSystem().getThreadContext();
                SecurityContextObject securityContext = (SecurityContextObject)threadContext.getContextObject("security");
                SecuritySession session = securityContext.getSession();
                principal = session.getPrincipal();
            }
        }
        catch (Exception ex) {
            LOCATION.catching((Throwable)ex);
        }
        if (principal == null) {
            return "UnknownUser";
        }
        return principal.getName();
    }

    public KeyAndCert getPrivateKeyByIssuerSerial(String view, String issuer, BigInteger serialNumber) throws WSSEKeystoreException {
        IDMessage message = WSSEKeystoreExceptionMessage.ID0500_KEYSTORE_ISSUER_SERIAL_ERROR.create();
        throw new WSSEKeystoreException(message, null);
    }

    public java.security.cert.X509Certificate getX509CertificateByIssuerSerial(String view, String issuer, BigInteger serialNumber) throws WSSEKeystoreException {
        IDMessage message = WSSEKeystoreExceptionMessage.ID0500_KEYSTORE_ISSUER_SERIAL_ERROR.create();
        throw new WSSEKeystoreException(message, null);
    }

    private byte[] getSubjectKeyIdentifier(X509Certificate cert) throws WSSEKeystoreException {
        X509Certificate iaikCertificate = cert;
        V3Extension ext = null;
        try {
            ext = iaikCertificate.getExtension(new ObjectID("2.5.29.14"));
        }
        catch (X509ExtensionInitException exc) {
            IDMessage message = WSSEKeystoreExceptionMessage.ID0320_SKI_ERROR.create((Object)cert.getSubjectDN(), (Object)exc.getMessage());
            throw new WSSEKeystoreException(message, exc);
        }
        if (ext == null) {
            IDMessage message = WSSEKeystoreExceptionMessage.ID0310_NO_SKI.create((Object)cert.getSubjectDN());
            throw new WSSEKeystoreException(message, null);
        }
        SubjectKeyIdentifier subjectKeyIdentifierExtension = (SubjectKeyIdentifier)ext;
        byte[] certificateSubjectKeyIdentifierValue = subjectKeyIdentifierExtension.get();
        return certificateSubjectKeyIdentifierValue;
    }

    private String octets2Hex(byte[] octets) {
        StringBuffer hexBuffer = new StringBuffer();
        int index = 0;
        while (index < octets.length) {
            int octetAsInt = octets[index] & 0xFF;
            hexBuffer.append(Integer.toHexString(octetAsInt).toUpperCase());
            if (index != octets.length - 1) {
                hexBuffer.append(":");
            }
            ++index;
        }
        return hexBuffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CacheEntry {
        Object value;
        long time;

        CacheEntry() {
        }
    }

    private class GetKeyBySubjectKeyIdentifierAction
    implements PrivilegedExceptionAction {
        private String view;
        private byte[] subjectKeyIdentifier;

        GetKeyBySubjectKeyIdentifierAction(String view, byte[] subjectKeyIdentifier) {
            this.view = view;
            this.subjectKeyIdentifier = subjectKeyIdentifier;
        }

        public Object run() throws Exception {
            KeystoreManager km = null;
            if (WSSEKeystoreImpl.this.serviceContext != null) {
                km = (KeystoreManager)WSSEKeystoreImpl.this.serviceContext.getContainerContext().getObjectRegistry().getServiceInterface("keystore");
            }
            if (km == null) {
                throw new NamingException("Could not find keystore");
            }
            KeyStore keystore = km.getKeystore(this.view);
            Enumeration<String> aliasEnumeration = keystore.aliases();
            while (aliasEnumeration.hasMoreElements()) {
                Certificate certificate;
                String alias = aliasEnumeration.nextElement();
                if (!keystore.isKeyEntry(alias) || !((certificate = keystore.getCertificate(alias)) instanceof java.security.cert.X509Certificate) || !WSSEKeystoreImpl.this.equalSubjectKeyIdentifier((java.security.cert.X509Certificate)certificate, this.subjectKeyIdentifier)) continue;
                Certificate[] certChain = keystore.getCertificateChain(alias);
                java.security.cert.X509Certificate[] x509CertChain = new java.security.cert.X509Certificate[certChain.length];
                System.arraycopy(certChain, 0, x509CertChain, 0, certChain.length);
                KeyAndCert keyAndCert = new KeyAndCert(x509CertChain, (PrivateKey)keystore.getKey(alias, new char[0]));
                return keyAndCert;
            }
            return null;
        }
    }

    private class GetCertPrivilegedAction
    implements PrivilegedExceptionAction {
        String view;
        String alias;

        GetCertPrivilegedAction(String view, String alias) {
            this.view = view;
            this.alias = alias;
        }

        public Object run() throws Exception {
            KeystoreManager km = null;
            if (WSSEKeystoreImpl.this.serviceContext != null) {
                km = (KeystoreManager)WSSEKeystoreImpl.this.serviceContext.getContainerContext().getObjectRegistry().getServiceInterface("keystore");
            }
            if (km == null) {
                throw new NamingException("Could not find keystore");
            }
            KeyStore keystore = km.getKeystore(this.view);
            if (this.alias == null) {
                ArrayList<Certificate> certificateList = new ArrayList<Certificate>();
                Enumeration<String> aliasEnumeration = keystore.aliases();
                while (aliasEnumeration.hasMoreElements()) {
                    String thisAlias = aliasEnumeration.nextElement();
                    if (!keystore.isCertificateEntry(thisAlias)) continue;
                    certificateList.add(keystore.getCertificate(thisAlias));
                }
                return certificateList.toArray(new java.security.cert.X509Certificate[0]);
            }
            if ("*".equals(this.alias)) {
                ArrayList<Certificate> certificateList = new ArrayList<Certificate>();
                Enumeration<String> aliasEnumeration = keystore.aliases();
                while (aliasEnumeration.hasMoreElements()) {
                    String thisAlias = aliasEnumeration.nextElement();
                    if (!keystore.isCertificateEntry(thisAlias)) continue;
                    certificateList.add(keystore.getCertificate(thisAlias));
                }
                return certificateList.toArray(new java.security.cert.X509Certificate[0]);
            }
            if (!keystore.containsAlias(this.alias)) {
                throw new CertificateException("No such alias:" + this.alias);
            }
            Certificate[] certificateChain = keystore.getCertificateChain(this.alias);
            Certificate[] certificates = null;
            certificates = certificateChain != null ? certificateChain : new Certificate[]{keystore.getCertificate(this.alias)};
            java.security.cert.X509Certificate[] x509Certificates = new java.security.cert.X509Certificate[certificates.length];
            System.arraycopy(certificates, 0, x509Certificates, 0, certificates.length);
            return x509Certificates;
        }
    }

    private class GetKeyAndCertPrivilegedAction
    implements PrivilegedExceptionAction {
        String view;
        String alias;

        GetKeyAndCertPrivilegedAction(String view, String alias) {
            this.view = view;
            this.alias = alias;
        }

        public Object run() throws Exception {
            KeystoreManager km = null;
            if (WSSEKeystoreImpl.this.serviceContext != null) {
                km = (KeystoreManager)WSSEKeystoreImpl.this.serviceContext.getContainerContext().getObjectRegistry().getServiceInterface("keystore");
            }
            if (km == null) {
                throw new NamingException("Could not find keystore");
            }
            KeyStore keystore = km.getKeystore(this.view);
            Certificate[] certificates = keystore.getCertificateChain(this.alias);
            java.security.cert.X509Certificate[] x509Certificates = new java.security.cert.X509Certificate[certificates.length];
            System.arraycopy(certificates, 0, x509Certificates, 0, certificates.length);
            PrivateKey pk = (PrivateKey)keystore.getKey(this.alias, null);
            return new KeyAndCert(x509Certificates, pk);
        }
    }
}

