/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.securitypolicy.assertions.cert;

import com.sap.security.core.securitypolicy.assertions.cert.KeyAndCertException;
import com.sap.security.core.securitypolicy.assertions.cert.KeyAndCertMessage;
import com.sap.security.core.securitypolicy.assertions.cert.KeyElement;
import com.sap.security.core.ws.wss.WSSecurityContext;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.security.ssl.KeyAndCert;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class P12KeyElement
implements KeyElement {
    static final String TYPE = "P12KeyElement";
    private String file = "";
    private String password = "";

    public String getElementType() {
        return TYPE;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public KeyAndCert getKeyAndCert(WSSecurityContext sctx) throws KeyAndCertException {
        try {
            PKCS12 pkcs12 = new PKCS12((InputStream)new FileInputStream(this.file));
            pkcs12.decrypt(this.password.toCharArray());
            PrivateKey pk = pkcs12.getKeyBag().getPrivateKey();
            iaik.x509.X509Certificate[] certificates = CertificateBag.getCertificates((CertificateBag[])pkcs12.getCertificateBags());
            KeyAndCert keyAndCert = new KeyAndCert((X509Certificate[])certificates, pk);
            return keyAndCert;
        }
        catch (Throwable ex) {
            throw new KeyAndCertException(KeyAndCertMessage.ID0110_ERROR_FILE_READING_KEY_AND_CERT.create((Object)this.file, (Object)ex.getClass().getName(), (Object)ex.getMessage()), ex);
        }
    }
}

