/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.securitypolicy.assertions.cert;

import com.sap.engine.interfaces.keystore.KeystoreManager;
import com.sap.security.core.securitypolicy.assertions.cert.CertException;
import com.sap.security.core.securitypolicy.assertions.cert.CertMessage;
import com.sap.security.core.securitypolicy.assertions.cert.CertificateElement;
import com.sap.security.core.securitypolicy.assertions.cert.WSSEKeystoreException;
import com.sap.security.core.ws.wss.WSSecurityContext;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.naming.InitialContext;

public class KeystoreCertificateElement
implements CertificateElement {
    public static final String TYPE = "KeystoreKeyElement";
    private String view = "";
    private String alias = "";

    public String getElementType() {
        return TYPE;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getView() {
        return this.view;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setView(String view) {
        this.view = view;
    }

    public X509Certificate[] getCertificates(WSSecurityContext sctx) throws CertException {
        if (sctx.getWSSEKeystore() != null) {
            try {
                return sctx.getWSSEKeystore().getX509Certificate(this.view, this.alias);
            }
            catch (WSSEKeystoreException ex) {
                throw new CertException(CertMessage.ID0100_ERROR_KEYSTORE_READING_CERT.create((Object)this.view, (Object)((Object)((Object)ex)).getClass().getName(), (Object)ex.getMessage()), (Throwable)((Object)ex));
            }
        }
        Object res = AccessController.doPrivileged(new GetCertPrivilegedAction(sctx));
        if (res instanceof X509Certificate[]) {
            return (X509Certificate[])res;
        }
        Throwable ex = (Throwable)res;
        throw new CertException(CertMessage.ID0100_ERROR_KEYSTORE_READING_CERT.create((Object)this.view, (Object)ex.getClass().getName(), (Object)ex.getMessage()), ex);
    }

    private class GetCertPrivilegedAction
    implements PrivilegedAction {
        WSSecurityContext sctx;

        GetCertPrivilegedAction(WSSecurityContext sctx) {
            this.sctx = sctx;
        }

        public Object run() {
            try {
                KeystoreManager km = null;
                if (this.sctx.getApplicationServiceContext() != null) {
                    km = (KeystoreManager)this.sctx.getApplicationServiceContext().getContainerContext().getObjectRegistry().getServiceInterface("keystore");
                }
                if (km == null) {
                    InitialContext ctx = new InitialContext();
                    km = (KeystoreManager)ctx.lookup("keystore");
                }
                KeyStore keystore = km.getKeystore(KeystoreCertificateElement.this.view);
                if ("*".equals(KeystoreCertificateElement.this.alias)) {
                    ArrayList<Certificate> certificateList = new ArrayList<Certificate>();
                    Enumeration<String> aliasEnumeration = keystore.aliases();
                    while (aliasEnumeration.hasMoreElements()) {
                        String thisAlias = aliasEnumeration.nextElement();
                        if (!keystore.isCertificateEntry(thisAlias)) continue;
                        certificateList.add(keystore.getCertificate(thisAlias));
                    }
                    return certificateList.toArray(new X509Certificate[0]);
                }
                if (!keystore.containsAlias(KeystoreCertificateElement.this.alias)) {
                    throw new CertificateException("No such alias:" + KeystoreCertificateElement.this.alias);
                }
                Certificate[] certificateChain = keystore.getCertificateChain(KeystoreCertificateElement.this.alias);
                Certificate[] certificates = null;
                certificates = certificateChain != null ? certificateChain : new Certificate[]{keystore.getCertificate(KeystoreCertificateElement.this.alias)};
                X509Certificate[] x509Certificates = new X509Certificate[certificates.length];
                System.arraycopy(certificates, 0, x509Certificates, 0, certificates.length);
                return x509Certificates;
            }
            catch (Throwable ex) {
                return ex;
            }
        }
    }
}

