/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.securitypolicy.assertions;

import com.sap.security.core.policy.exceptions.VerifyMessage;
import com.sap.security.core.securitypolicy.assertions.ClaimsElement;
import com.sap.security.core.securitypolicy.assertions.TrustedCAListElement;
import com.sap.security.core.securitypolicy.assertions.cert.CertException;
import com.sap.security.core.securitypolicy.assertions.cert.CertificateElement;
import com.sap.security.core.securitypolicy.assertions.cert.KeyAndCertException;
import com.sap.security.core.securitypolicy.assertions.cert.KeyElement;
import com.sap.security.core.server.ssf.SsfPabBasicImpl;
import com.sap.security.core.ws.mapping.ExtendableElement;
import com.sap.security.core.ws.wss.WSSecurityContext;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import iaik.security.ssl.KeyAndCert;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class SecurityTokenElement
extends ExtendableElement {
    private String preference;
    private String tokenType;
    private String tokenIssuer;
    private ClaimsElement claims;
    private KeyElement keyReference;
    private CertificateElement certificateElement;
    private TrustedCAListElement trustedCAList;
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$securitypolicy$assertions$IntegrityAssertion == null ? (class$com$sap$security$core$securitypolicy$assertions$IntegrityAssertion = SecurityTokenElement.class$("com.sap.security.core.securitypolicy.assertions.IntegrityAssertion")) : class$com$sap$security$core$securitypolicy$assertions$IntegrityAssertion));
    final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"WS/Policy");
    static /* synthetic */ Class class$com$sap$security$core$securitypolicy$assertions$IntegrityAssertion;

    public String getPreference() {
        return this.preference;
    }

    public void setPreference(String preference) {
        this.preference = preference;
    }

    public ClaimsElement getClaims() {
        return this.claims;
    }

    public String getTokenIssuer() {
        return this.tokenIssuer;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void addClaims(ClaimsElement claims) {
        this.claims = claims;
    }

    public void setTokenIssuer(String tokenIssuer) {
        this.tokenIssuer = tokenIssuer;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public KeyElement getKeyReference() {
        return this.keyReference;
    }

    public void setKeyReference(KeyElement element) {
        this.keyReference = element;
    }

    public KeyAndCert getKeyAndCert(WSSecurityContext sctx) throws CertificateException, KeyAndCertException {
        if (!"wsse:X509v3".equals(this.getTokenType())) {
            throw new CertificateException("No X.509v3 certificate found in SecurityToken");
        }
        if (this.keyReference == null) {
            throw new CertificateException("No Key/Certificate set");
        }
        return this.keyReference.getKeyAndCert(sctx);
    }

    public TrustedCAListElement getTrustedCAList() {
        return this.trustedCAList;
    }

    public void setTrustedCAList(TrustedCAListElement element) {
        this.trustedCAList = element;
    }

    public boolean isCertificateTrusted(WSSecurityContext sctx, X509Certificate certificate, String pid) throws CertException {
        if (this.getTrustedCAList() == null) {
            return false;
        }
        SsfPabBasicImpl signaturePab = new SsfPabBasicImpl(this.getTrustedCAList().getCertificates(sctx));
        boolean trusted = signaturePab.isTrusted(certificate);
        if (!trusted) {
            VerifyMessage.ID0241_DSIG_CERT_NOT_TRUSTED_INFO.create((Object)certificate.getIssuerDN(), (Object)certificate.getSubjectDN()).log(300, this.CATEGORY, LOCATION, pid);
            return false;
        }
        String certificaterIssuerDN = certificate.getIssuerDN().getName();
        String certificaterSubjectDN = certificate.getSubjectDN().getName();
        String subjectName = null;
        String issuerName = this.getTokenIssuer();
        if (this.getClaims() != null) {
            subjectName = this.getClaims().getSubjectName().getValue();
        }
        if (issuerName != null && !issuerName.trim().equals(certificaterIssuerDN)) {
            VerifyMessage.ID0242_DSIG_ISSUER_DOES_NOT_MATCH_INFO.create((Object)certificate.getIssuerDN(), (Object)certificate.getSubjectDN(), (Object)issuerName).log(300, this.CATEGORY, LOCATION, pid);
            return false;
        }
        if (subjectName != null && issuerName == null) {
            VerifyMessage.ID0243_DSIG_SUBJECT_AND_ISSUER_DO_NOT_MATCH_INFO.create((Object)certificate.getIssuerDN(), (Object)certificate.getSubjectDN(), (Object)issuerName, (Object)subjectName).log(300, this.CATEGORY, LOCATION, pid);
            return false;
        }
        if (!(subjectName == null || subjectName.trim().equals(certificaterSubjectDN) && issuerName.trim().equals(certificaterIssuerDN))) {
            VerifyMessage.ID0243_DSIG_SUBJECT_AND_ISSUER_DO_NOT_MATCH_INFO.create((Object)certificate.getIssuerDN(), (Object)certificate.getSubjectDN(), (Object)issuerName, (Object)subjectName).log(300, this.CATEGORY, LOCATION, pid);
            return false;
        }
        VerifyMessage.ID0244_DSIG_CERT_TRUSTED_INFO.create((Object)certificate.getIssuerDN(), (Object)certificate.getSubjectDN()).log(300, this.CATEGORY, LOCATION, pid);
        return true;
    }

    public X509Certificate[] getCertificate(WSSecurityContext sctx) throws CertException {
        if (this.getCertificateReference() == null) {
            return new X509Certificate[0];
        }
        return this.getCertificateReference().getCertificates(sctx);
    }

    public CertificateElement getCertificateReference() {
        return this.certificateElement;
    }

    public void setCertificateReference(CertificateElement element) {
        this.certificateElement = element;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

