/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.securitypolicy.assertions;

import com.sap.security.api.ssf.ISsfProfile;
import com.sap.security.core.policy.exceptions.ProcessException;
import com.sap.security.core.policy.exceptions.ProcessMessage;
import com.sap.security.core.securitypolicy.assertions.SecurityPolicyConstants;
import com.sap.security.core.server.ssf.SsfDataXML;
import com.sap.security.core.server.ssf.SsfPabBasicImpl;
import com.sap.security.core.server.ssf.SsfProfileBasicImpl;
import com.sap.security.core.server.ssf.SsfRefXMLInfo;
import com.sap.security.core.server.ssf.SsfRefXMLList;
import com.sap.security.core.ws.wss.WSProcessor;
import com.sap.security.core.ws.wss.WSSecurityDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DSIGProcessor
implements WSProcessor {
    SsfRefXMLList refList = new SsfRefXMLList();
    SsfProfileBasicImpl ssfProfile = null;
    SsfPabBasicImpl ssfPabProfile = null;
    private String role = "soap:finalActor";
    private String certificateReferenceID = null;
    private String certificateReferenceType = null;

    public DSIGProcessor(SsfProfileBasicImpl ssfProfile, SecurityPolicyConstants constants) {
        this.refList.setIdAttribute("Id", constants.WSU_URI);
        this.ssfProfile = ssfProfile;
    }

    public void addReference(SsfRefXMLInfo reference) {
        this.refList.add(reference);
    }

    public void apply(WSSecurityDocument securityDocument) throws ProcessException {
        try {
            Document soapDocument = securityDocument.getSoapDocument();
            SecurityPolicyConstants constants = securityDocument.getSecurityContext().getConstants();
            Element securityHeaderElement = securityDocument.getSecurityHeaderElement();
            SsfDataXML ssfDataXML = new SsfDataXML(soapDocument.getDocumentElement());
            Element signatureReplacementElement = soapDocument.createElement("signature");
            NodeList childNodeList = securityHeaderElement.getChildNodes();
            int selectedIndex = -1;
            int i = childNodeList.getLength() - 1;
            while (i >= 0) {
                if (1 == childNodeList.item(i).getNodeType()) {
                    Element currentElement = (Element)childNodeList.item(i);
                    if (!("Signature".equals(currentElement.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(currentElement.getNamespaceURI()) || "EncryptedData".equals(currentElement.getLocalName()) && SecurityPolicyConstants.XENC_URI.equals(currentElement.getNamespaceURI()) || "EncryptedKey".equals(currentElement.getLocalName()) && SecurityPolicyConstants.XENC_URI.equals(currentElement.getNamespaceURI()))) {
                        if (selectedIndex == -1) {
                            selectedIndex = i;
                        }
                    } else {
                        selectedIndex = -1;
                    }
                }
                --i;
            }
            if (selectedIndex < childNodeList.getLength() - 1) {
                securityHeaderElement.insertBefore(signatureReplacementElement, childNodeList.item(selectedIndex + 1));
            } else {
                securityHeaderElement.appendChild(signatureReplacementElement);
            }
            ssfDataXML.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            boolean result = ssfDataXML.sign(signatureReplacementElement, this.refList, (ISsfProfile)this.ssfProfile, 0, false, false);
            if (result) {
                Element keyInfo = (Element)securityHeaderElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo").item(0);
                Element secTokenRef = soapDocument.createElementNS(constants.WSSE_URI, "wsse:SecurityTokenReference");
                keyInfo.appendChild(secTokenRef);
                Element x509TokenRef = soapDocument.createElementNS(constants.WSSE_URI, "wsse:Reference");
                x509TokenRef.setAttribute("URI", "#" + this.getCertificateReferenceID());
                x509TokenRef.setAttribute("ValueType", this.certificateReferenceType);
                secTokenRef.appendChild(x509TokenRef);
            }
            if (!result) {
                throw new ProcessException(ProcessMessage.ID0110_XML_DSIG_ERROR.create(), null);
            }
        }
        catch (Throwable ex) {
            ProcessException pe = new ProcessException(ProcessMessage.ID0100_XML_DSIG_APPLY_ERROR.create((Object)ex.getClass().getName(), (Object)ex.getMessage()), ex);
            throw pe;
        }
    }

    public String getCertificateReferenceID() {
        return this.certificateReferenceID;
    }

    public void setCertificateReferenceID(String certificateReferenceID) {
        this.certificateReferenceID = certificateReferenceID;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String string) {
        this.role = string;
    }

    public void setCertificateReferenceType(String string) {
        this.certificateReferenceType = string;
    }
}

