/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.securitypolicy.assertions;

import com.sap.engine.lib.security.Base64;
import com.sap.engine.lib.xml.signature.encryption.EncryptedKey;
import com.sap.engine.lib.xml.signature.encryption.EncryptedKeyGenerator;
import com.sap.engine.lib.xml.signature.encryption.XMLDecryptor;
import com.sap.security.api.ssf.ISsfProfile;
import com.sap.security.core.policy.assertions.BaseAssertion;
import com.sap.security.core.policy.exceptions.ProcessException;
import com.sap.security.core.policy.exceptions.ProcessMessage;
import com.sap.security.core.policy.exceptions.VerifyException;
import com.sap.security.core.policy.exceptions.VerifyMessage;
import com.sap.security.core.securitypolicy.assertions.AlgorithmElement;
import com.sap.security.core.securitypolicy.assertions.AttachmentEncryptionProcessor;
import com.sap.security.core.securitypolicy.assertions.EncryptionProcessor;
import com.sap.security.core.securitypolicy.assertions.MessagePartsElement;
import com.sap.security.core.securitypolicy.assertions.SecurityPolicyConstants;
import com.sap.security.core.securitypolicy.assertions.SecurityTokenElement;
import com.sap.security.core.securitypolicy.assertions.cert.WSSEKeystoreImpl;
import com.sap.security.core.server.ssf.SsfDataXML;
import com.sap.security.core.server.ssf.SsfProfileBasicImpl;
import com.sap.security.core.server.ssf.SsfRefXMLInfo;
import com.sap.security.core.server.ssf.SsfRefXMLList;
import com.sap.security.core.server.ssf.SsfSigRcpInfo;
import com.sap.security.core.server.ssf.SsfSigRcpList;
import com.sap.security.core.ws.dsig.KeyInfoElement;
import com.sap.security.core.ws.dsig.TransformElement;
import com.sap.security.core.ws.mapping.WSMappingUtil;
import com.sap.security.core.ws.wss.AttachmentData;
import com.sap.security.core.ws.wss.AttachmentList;
import com.sap.security.core.ws.wss.NoSecurityHeaderException;
import com.sap.security.core.ws.wss.SecurityHeader;
import com.sap.security.core.ws.wss.WSSecurityDocument;
import com.sap.security.core.ws.wss.tokens.securitytoken.KeyIdentifierElement;
import com.sap.security.core.ws.wss.tokens.securitytoken.SecurityTokenReference;
import com.sap.security.core.ws.xenc.CipherReferenceElement;
import com.sap.security.core.ws.xenc.DataReferenceElement;
import com.sap.security.core.ws.xenc.EncryptedDataElement;
import com.sap.security.core.ws.xenc.EncryptedKeyElement;
import com.sap.security.core.ws.xenc.ReferenceListElement;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import iaik.security.ssl.KeyAndCert;
import iaik.x509.X509Certificate;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfidentialityAssertion
extends BaseAssertion {
    public static final String TYPE = "ConfidentialityAssertion";
    private String usage;
    private AlgorithmElement algorithm;
    private List messagePartsList = new ArrayList();
    private String role = "soap:finalActor";
    private String encryptionType = "http://www.w3.org/2001/04/xmlenc#Element";
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$securitypolicy$assertions$ConfidentialityAssertion == null ? (class$com$sap$security$core$securitypolicy$assertions$ConfidentialityAssertion = ConfidentialityAssertion.class$("com.sap.security.core.securitypolicy.assertions.ConfidentialityAssertion")) : class$com$sap$security$core$securitypolicy$assertions$ConfidentialityAssertion));
    final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"WS/Policy");
    private SecurityTokenElement encryptionSecurityToken;
    static /* synthetic */ Class class$com$sap$security$core$securitypolicy$assertions$ConfidentialityAssertion;
    static /* synthetic */ Class class$com$sap$security$core$ws$xenc$EncryptedDataElement;

    public String getType() {
        return TYPE;
    }

    public Iterator getMessageParts() {
        return this.messagePartsList.iterator();
    }

    public void addMessageParts(MessagePartsElement messagePart) {
        this.messagePartsList.add(messagePart);
    }

    public AlgorithmElement getAlgorithm() {
        return this.algorithm;
    }

    public SecurityTokenElement getEncryptionSecurityToken() {
        return this.encryptionSecurityToken;
    }

    public void setAlgorithm(AlgorithmElement element) {
        this.algorithm = element;
    }

    public void setEncryptionSecurityToken(SecurityTokenElement element) {
        this.encryptionSecurityToken = element;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String string) {
        this.role = string;
    }

    public void apply(Object o, String pid) throws ProcessException {
        if (o instanceof WSSecurityDocument && o != null) {
            WSSecurityDocument security = (WSSecurityDocument)o;
            SecurityPolicyConstants constants = security.getSecurityContext().getConstants();
            try {
                EncryptionProcessor processor = new EncryptionProcessor();
                AttachmentEncryptionProcessor attachmentProcessor = new AttachmentEncryptionProcessor();
                if (this.getEncryptionSecurityToken() == null) {
                    throw new CertificateException("No SecurityToken set.");
                }
                java.security.cert.X509Certificate[] certificateArray = this.getEncryptionSecurityToken().getCertificate(security.getSecurityContext());
                if (certificateArray.length != 1) {
                    throw new ProcessException(ProcessMessage.ID0610_CONFIDENTIALITY_WRONG_NUMBER_OF_CERTS_ERROR.create((Object)("" + certificateArray.length)), null);
                }
                java.security.cert.X509Certificate certificate = certificateArray[0];
                attachmentProcessor.setCertificate((X509Certificate)certificate);
                SsfSigRcpInfo rcpInfo = new SsfSigRcpInfo(certificate);
                SsfSigRcpList ssfRcpList = new SsfSigRcpList();
                ssfRcpList.add(rcpInfo);
                processor.setSsfSigRcpList(ssfRcpList);
                SsfRefXMLList refList = new SsfRefXMLList();
                refList.setIdAttribute("Id", constants.WSU_URI);
                Iterator messagePartIterator = this.getMessageParts();
                while (messagePartIterator.hasNext()) {
                    MessagePartsElement messagePart = (MessagePartsElement)messagePartIterator.next();
                    if ("http://security.sap.com/ID".equals(messagePart.getDialect())) {
                        SsfRefXMLInfo refInfo = new SsfRefXMLInfo();
                        refInfo.uri = messagePart.getURI();
                        refInfo.contentOnly = "http://www.w3.org/2001/04/xmlenc#Content".equals(this.encryptionType);
                        refList.add(refInfo);
                    }
                    if (!"http://security.sap.com/AttachmentID".equals(messagePart.getDialect())) continue;
                    attachmentProcessor.addToEncryptionList(messagePart.getURI());
                }
                processor.setSsfRefXMLList(refList);
                AlgorithmElement algorithElement = this.getAlgorithm();
                if ("wsse:AlgEncryption".equals(algorithElement.getType())) {
                    processor.setEncryptionAlgorithm(algorithElement.getURI());
                }
                if (refList.size() > 0) {
                    security.addProcessor(processor);
                }
                if (attachmentProcessor.getEncryptionListSize() > 0) {
                    security.addProcessor(attachmentProcessor);
                }
            }
            catch (Exception ex) {
                throw new ProcessException(ProcessMessage.ID0600_CONFIDENTIALITY_APPLY_ERROR.create((Object)ex.getClass().getName(), (Object)ex.getMessage()), ex);
            }
        }
    }

    public void verify(Object o, String pid) throws VerifyException {
        String method = "verify";
        HashMap<String, Element> encryptedDataHashMap = new HashMap<String, Element>();
        HashMap<String, PrivateKey> privateKeyHashmap = new HashMap<String, PrivateKey>();
        HashMap<String, EncryptedKeyElement> encryptedKeyHashmap = new HashMap<String, EncryptedKeyElement>();
        if (o instanceof WSSecurityDocument && o != null) {
            WSSecurityDocument security = (WSSecurityDocument)o;
            SecurityHeader securityHeader = null;
            SecurityPolicyConstants constants = security.getSecurityContext().getConstants();
            try {
                try {
                    securityHeader = security.getSecurityHeaderByRole("soap:finalActor");
                }
                catch (NoSecurityHeaderException ex) {
                    return;
                }
                Document soapDocument = security.getSoapDocument();
                NodeList encryptedDataNodeList = soapDocument.getElementsByTagNameNS(SecurityPolicyConstants.XENC_URI, "EncryptedData");
                int i = 0;
                while (i < encryptedDataNodeList.getLength()) {
                    Element encryptedDataElement = (Element)encryptedDataNodeList.item(i);
                    String idString = encryptedDataElement.getAttribute("Id");
                    if (idString != null) {
                        encryptedDataHashMap.put("#" + idString, encryptedDataElement);
                    }
                    ++i;
                }
                Iterator encryptedKeysIterator = securityHeader.getEncryptedKeys();
                while (encryptedKeysIterator.hasNext()) {
                    int i2;
                    EncryptedKeyElement encryptedKey = (EncryptedKeyElement)encryptedKeysIterator.next();
                    if (encryptedKey == null) continue;
                    PrivateKey pk = null;
                    java.security.cert.X509Certificate[] certificates = null;
                    java.security.cert.X509Certificate usedCertificate = null;
                    KeyInfoElement keyInfo = encryptedKey.getKeyInfo();
                    SecurityTokenReference securityTokenReference = keyInfo.getSecurityTokenReference();
                    if (securityTokenReference == null) {
                        throw new VerifyException(VerifyMessage.ID0110_XENC_NO_SECURITYTOKEN_REFERENCE.create(), null);
                    }
                    KeyIdentifierElement keyIdentifier = securityTokenReference.getKeyIdentifier();
                    if (keyIdentifier == null) {
                        throw new VerifyException(VerifyMessage.ID0120_XENC_NO_KEYIDENTIFIER.create(), null);
                    }
                    if (this.getEncryptionSecurityToken() == null) {
                        if (security.getSecurityContext().getWSSEKeystore() != null) {
                            WSSEKeystoreImpl wsseKeystore = security.getSecurityContext().getWSSEKeystore();
                            KeyAndCert resolvedKeyAndCert = wsseKeystore.getPrivateKeyBySubjectKeyIdentifier("WebServiceSecurity", Base64.decode((byte[])keyIdentifier.getValue().getBytes()));
                            pk = resolvedKeyAndCert.getPrivateKey();
                            certificates = resolvedKeyAndCert.getCertificateChain();
                            usedCertificate = resolvedKeyAndCert.getCertificateChain()[0];
                        }
                    } else {
                        KeyAndCert keyAndCert = this.getEncryptionSecurityToken().getKeyAndCert(security.getSecurityContext());
                        certificates = keyAndCert.getCertificateChain();
                        if (keyIdentifier.equalsSubjectKeyIdentifier((X509Certificate)certificates[0])) {
                            pk = keyAndCert.getPrivateKey();
                            usedCertificate = certificates[0];
                        }
                    }
                    if (pk == null) {
                        throw new VerifyException(VerifyMessage.ID0150_XENC_NO_PRIVATE_KEY.create((Object)keyIdentifier.getValueType(), (Object)keyIdentifier.getEncodingType(), (Object)this.octets2Hex(Base64.decode((byte[])keyIdentifier.getValue().getBytes()))), null);
                    }
                    if (encryptedKey.getId() != null) {
                        privateKeyHashmap.put(encryptedKey.getId(), pk);
                        encryptedKeyHashmap.put(encryptedKey.getId(), encryptedKey);
                    }
                    String symmetricAlgorithm = null;
                    ReferenceListElement referenceList = encryptedKey.getReferenceList();
                    if (referenceList == null) continue;
                    Iterator referenceIterator = referenceList.getDataReferences();
                    while (referenceIterator.hasNext() && symmetricAlgorithm == null) {
                        String referenceURI = ((DataReferenceElement)referenceIterator.next()).getURI();
                        if (!encryptedDataHashMap.containsKey(referenceURI)) continue;
                        Element encrytedDataElement = (Element)encryptedDataHashMap.get(referenceURI);
                        NodeList childNodeList = encrytedDataElement.getChildNodes();
                        i2 = 0;
                        while (i2 < childNodeList.getLength()) {
                            Element element;
                            Node childNode = childNodeList.item(i2);
                            if (childNode instanceof Element && symmetricAlgorithm == null && "EncryptionMethod".equals((element = (Element)childNode).getLocalName())) {
                                symmetricAlgorithm = element.getAttribute("Algorithm");
                            }
                            ++i2;
                        }
                    }
                    if (symmetricAlgorithm != null) {
                        SsfProfileBasicImpl profile = new SsfProfileBasicImpl(pk, certificates);
                        ArrayList encryptedReferencesList = new ArrayList();
                        Key key = SsfDataXML.decryptKey((Element)encryptedKey.getXmlElement(), (ISsfProfile)profile, symmetricAlgorithm, encryptedReferencesList);
                        if (key == null) {
                            throw new VerifyException(VerifyMessage.ID0310_XENC_DECRYPT_ERROR.create((Object)usedCertificate, (Object)encryptedKey.getXmlElement()), null);
                        }
                        i2 = 0;
                        while (i2 < encryptedDataNodeList.getLength()) {
                            boolean result;
                            Element encryptedDataElement = (Element)encryptedDataNodeList.item(i2);
                            String idString = "#" + encryptedDataElement.getAttribute("Id");
                            if (encryptedReferencesList.contains(idString) && !(result = SsfDataXML.decryptData((Element)encryptedDataElement, (Key)key, (String)symmetricAlgorithm))) {
                                throw new VerifyException(VerifyMessage.ID0300_XENC_DECRYPT_ERROR.create((Object)encryptedKey.getReferenceList(), (Object)usedCertificate.getSubjectDN()), null);
                            }
                            ++i2;
                        }
                        continue;
                    }
                    VerifyMessage.ID0160_XENC_NO_SYMMETRIC_ENCRYPTION_ALGORITHM_FOUND.create((Object)encryptedKey.getXmlElement(), (Object)soapDocument).log(500, this.CATEGORY, LOCATION, "verify");
                }
                WSMappingUtil mapping = SecurityPolicyConstants.getMappingUtilByNamespace(constants.WSSE_URI);
                NodeList encryptedDataNL = security.getSecurityHeaderElement().getElementsByTagNameNS(SecurityPolicyConstants.XENC_URI, "EncryptedData");
                HashMap<String, Key> encryptedDataId2Key = new HashMap<String, Key>();
                int i3 = 0;
                while (i3 < encryptedDataNL.getLength()) {
                    Element encryptedDataElement = (Element)encryptedDataNL.item(i3);
                    EncryptedDataElement encryptedData = (EncryptedDataElement)mapping.unmarshall(encryptedDataElement, (class$com$sap$security$core$ws$xenc$EncryptedDataElement == null ? ConfidentialityAssertion.class$("com.sap.security.core.ws.xenc.EncryptedDataElement") : class$com$sap$security$core$ws$xenc$EncryptedDataElement).getClassLoader());
                    if (!constants.WSSE_SWA_ATTACHMENT_CONTENT_ONLY.equals(encryptedData.getType()) || encryptedData.getKeyInfo() == null || encryptedData.getKeyInfo().getRetrievalMethod() == null) break;
                    if ("http://www.w3.org/2001/04/xmlenc#EncryptedKey".equals(encryptedData.getKeyInfo().getRetrievalMethod().getType())) {
                        String referencedKeyID = encryptedData.getKeyInfo().getRetrievalMethod().getURI();
                        EncryptedKeyElement encryptedKey = (EncryptedKeyElement)encryptedKeyHashmap.get(referencedKeyID.substring(1));
                        if (encryptedData == null || encryptedData.getEncryptionMethod() == null) break;
                        String symmetricAlgorithm = encryptedData.getEncryptionMethod().getAlgorithm();
                        if (encryptedDataId2Key.get(referencedKeyID) == null) {
                            String keyAlg = "AES";
                            if ("http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(symmetricAlgorithm)) {
                                keyAlg = "AES";
                            } else if ("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(symmetricAlgorithm)) {
                                keyAlg = "DESede";
                            }
                            EncryptedKeyGenerator ekg = new EncryptedKeyGenerator();
                            EncryptedKey ek = new EncryptedKey(encryptedKey.getXmlElement(), false);
                            PrivateKey privateKey = (PrivateKey)privateKeyHashmap.get(referencedKeyID.substring(1));
                            Key key = ekg.extractKey(ek, (Key)privateKey, keyAlg);
                            encryptedDataId2Key.put(referencedKeyID, key);
                        }
                        Key symmetricKey = (Key)encryptedDataId2Key.get(referencedKeyID);
                        this.decryptEncryptedAttachment(constants, security.getAttachments(), symmetricKey, symmetricAlgorithm, encryptedData);
                    }
                    ++i3;
                }
            }
            catch (Exception ex) {
                if (ex instanceof VerifyException) {
                    throw (VerifyException)((Object)ex);
                }
                throw new VerifyException(ProcessMessage.ID0600_CONFIDENTIALITY_APPLY_ERROR.create((Object)ex.getClass().getName(), (Object)ex.getMessage()), ex);
            }
        }
    }

    public String getEncryptionType() {
        return this.encryptionType;
    }

    public void setEncryptionType(String string) {
        this.encryptionType = string;
    }

    private String octets2Hex(byte[] octets) {
        StringBuffer hexBuffer = new StringBuffer();
        int index = 0;
        while (index < octets.length) {
            int octetAsInt = octets[index] & 0xFF;
            hexBuffer.append(Integer.toHexString(octetAsInt).toUpperCase());
            if (index != octets.length - 1) {
                hexBuffer.append(":");
            }
            ++index;
        }
        return hexBuffer.toString();
    }

    public void decryptEncryptedAttachment(SecurityPolicyConstants constants, AttachmentList attachmentList, Key symmetricKey, String symmetricKeyAlgorithm, EncryptedDataElement encryptedData) throws Exception {
        TransformElement transformation;
        CipherReferenceElement cipherReference;
        if (constants.WSSE_SWA_ATTACHMENT_CONTENT_ONLY.equals(encryptedData.getType()) && encryptedData.getCipherData() != null && encryptedData.getCipherData().getCipherReference() != null && (cipherReference = encryptedData.getCipherData().getCipherReference()).getTransforms() != null && cipherReference.getTransforms().getTransformCount() == 1 && constants.WSSE_SWA_ATTACHMENT_CONTENT_ONLY.equals((transformation = (TransformElement)cipherReference.getTransforms().getTransforms().next()).getAlgorithm())) {
            AttachmentData attachment = attachmentList.getAttachmentData(cipherReference.getURI().substring(1));
            if (attachment == null) {
                throw new Exception("Attachment " + cipherReference.getURI() + " not found");
            }
            if (!"application/octet-stream".equals(attachment.getContentType().toLowerCase())) {
                throw new Exception("Attachment " + cipherReference.getURI() + " has wrong content type:" + attachment.getContentType());
            }
            byte[] encrypedBytes = attachment.getPayload();
            XMLDecryptor dec = new XMLDecryptor();
            dec.setEncryptionKey(symmetricKey);
            byte[] decryptedData = dec.decryptRaw(encrypedBytes, symmetricKeyAlgorithm);
            attachment.setPayload(decryptedData);
            attachment.setContentType(encryptedData.getMimeType());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

