/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.policy.expressions;

import com.sap.security.core.policy.PolicyConstants;
import com.sap.security.core.policy.assertions.BaseAssertion;
import com.sap.security.core.policy.exceptions.AllExpressionMessage;
import com.sap.security.core.policy.exceptions.ProcessException;
import com.sap.security.core.policy.exceptions.VerifyException;
import com.sap.security.core.policy.expressions.BaseExpression;
import com.sap.security.core.ws.mapping.WSMappingUtil;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Iterator;

public class AllExpression
extends BaseExpression {
    public static final String TYPE = "AllExpression";
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$policy$expressions$AllExpression == null ? (class$com$sap$security$core$policy$expressions$AllExpression = AllExpression.class$("com.sap.security.core.policy.expressions.AllExpression")) : class$com$sap$security$core$policy$expressions$AllExpression));
    final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"WS/Policy");
    static /* synthetic */ Class class$com$sap$security$core$policy$expressions$AllExpression;

    public AllExpression() {
        String METHOD = "AllExpression()";
        LOCATION.entering("AllExpression()");
        LOCATION.exiting();
    }

    public void apply(Object o, String pid) throws ProcessException {
        String METHOD = "apply()";
        LOCATION.entering("apply()", new Object[]{o});
        AllExpressionMessage.ID0000_START_APPLY_POLICY.create((Object)this.getType(), (Object)("" + this.expressionList.size()), (Object)("" + this.assertionList.size())).log(200, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
        Iterator expressionIterator = this.expressionList.iterator();
        while (expressionIterator.hasNext()) {
            BaseExpression expression = (BaseExpression)expressionIterator.next();
            try {
                AllExpressionMessage.ID0001_PROCESS_EXPRESSION.create((Object)expression.getType(), (Object)expression.getID()).log(200, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
                if (PolicyConstants.BUSINESS_CATEGORY.beLogged(200)) {
                    AllExpressionMessage.ID0004_EXPRESSION.create((Object)expression.getType(), (Object)expression.getID(), (Object)this.getPolicyObjectAsXML(expression)).log(200, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
                }
                expression.apply(o, pid);
                AllExpressionMessage.ID0002_PROCESS_EXPRESSION_SUCCEEDED.create((Object)expression.getType(), (Object)expression.getID()).log(200, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
            }
            catch (ProcessException ex) {
                AllExpressionMessage.ID0003_PROCESS_EXPRESSION_FAILED.create((Object)expression.getType(), (Object)expression.getID(), (Object)ex.getLocalizedMessage()).log(500, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
            }
        }
        Iterator assertionIterator = this.assertionList.iterator();
        while (assertionIterator.hasNext()) {
            BaseAssertion assertion = (BaseAssertion)assertionIterator.next();
            try {
                AllExpressionMessage.ID0005_PROCESS_ASSERTION.create((Object)assertion.getType(), (Object)assertion.getID()).log(200, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
                if (PolicyConstants.BUSINESS_CATEGORY.beLogged(200)) {
                    AllExpressionMessage.ID0008_ASSERTION.create((Object)assertion.getType(), (Object)assertion.getID(), (Object)this.getPolicyObjectAsXML(assertion)).log(200, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
                }
                assertion.apply(o, pid);
                AllExpressionMessage.ID0006_PROCESS_ASSERTION_SUCCEEDED.create((Object)assertion.getType(), (Object)assertion.getID()).log(200, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
            }
            catch (ProcessException ex) {
                AllExpressionMessage.ID0007_PROCESS_ASSERTION_FAILED.create((Object)assertion.getType(), (Object)assertion.getID(), (Object)ex.getLocalizedMessage()).log(500, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
                throw ex;
            }
        }
        LOCATION.exiting();
    }

    public boolean verify(Object o, String pid) throws VerifyException {
        String METHOD = "verify()";
        LOCATION.entering("verify()", new Object[]{o});
        AllExpressionMessage.ID0000_START_APPLY_POLICY.create((Object)this.getType(), (Object)("" + this.expressionList.size()), (Object)("" + this.assertionList.size())).log(200, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
        Iterator expressionIterator = this.expressionList.iterator();
        while (expressionIterator.hasNext()) {
            BaseExpression expression = (BaseExpression)expressionIterator.next();
            try {
                AllExpressionMessage.ID0101_VERIFY_EXPRESSION.create((Object)expression.getType(), (Object)expression.getID()).log(200, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
                if (PolicyConstants.BUSINESS_CATEGORY.beLogged(200)) {
                    AllExpressionMessage.ID0104_EXPRESSION.create((Object)expression.getType(), (Object)expression.getID(), (Object)this.getPolicyObjectAsXML(expression)).log(200, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
                }
                expression.verify(o, pid);
                AllExpressionMessage.ID0102_VERIFY_EXPRESSION_SUCCEEDED.create((Object)expression.getType(), (Object)expression.getID()).log(200, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
            }
            catch (VerifyException ex) {
                AllExpressionMessage.ID0103_VERIFY_EXPRESSION_FAILED.create((Object)expression.getType(), (Object)expression.getID(), (Object)ex.getLocalizedMessage()).log(200, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
                LOCATION.exiting((Object)ex);
                throw ex;
            }
        }
        Iterator assertionIterator = this.assertionList.iterator();
        while (assertionIterator.hasNext()) {
            BaseAssertion assertion = (BaseAssertion)assertionIterator.next();
            try {
                AllExpressionMessage.ID0005_PROCESS_ASSERTION.create((Object)assertion.getType(), (Object)assertion.getID()).log(200, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
                if (PolicyConstants.BUSINESS_CATEGORY.beLogged(200)) {
                    AllExpressionMessage.ID0008_ASSERTION.create((Object)assertion.getType(), (Object)assertion.getID(), (Object)this.getPolicyObjectAsXML(assertion)).log(200, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
                }
                assertion.verify(o, pid);
                AllExpressionMessage.ID0106_VERIFY_ASSERTION_SUCCEEDED.create((Object)assertion.getType(), (Object)assertion.getID()).log(200, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
            }
            catch (VerifyException ex) {
                AllExpressionMessage.ID0007_PROCESS_ASSERTION_FAILED.create((Object)assertion.getType(), (Object)assertion.getID(), (Object)ex.getLocalizedMessage()).log(200, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
                LOCATION.exiting((Object)ex);
                throw ex;
            }
        }
        LOCATION.exiting();
        return true;
    }

    public String getType() {
        return TYPE;
    }

    private String getPolicyObjectAsXML(Object obj) {
        if (this.CATEGORY.bePath()) {
            try {
                return "" + WSMappingUtil.get(WSMappingUtil.POLICY_MAPPING).marshall(obj, obj.getClass().getClassLoader());
            }
            catch (Exception ex) {
                LOCATION.catching(this.CATEGORY, (Throwable)ex);
                return "(no xml available)";
            }
        }
        return "(no xml available)";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

