/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.policy;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.NoWriteAccessException;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.security.core.policy.WSPolicyConfigurationElement;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class WSPolicyProfileConfigurationData
implements Serializable {
    String policyTemplate = "";
    final String VERSION = "1.0";
    ArrayList templateConfigurationList = new ArrayList();

    public WSPolicyProfileConfigurationData() {
    }

    protected WSPolicyProfileConfigurationData(List templateConfigurationList) {
        this.templateConfigurationList = new ArrayList(templateConfigurationList);
    }

    public WSPolicyProfileConfigurationData(Configuration configuration) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        this.read(configuration);
    }

    public void addPolicyConfiguration(WSPolicyConfigurationElement configurationElement) {
        this.templateConfigurationList.add(configurationElement);
    }

    public List getPolicyConfigurationList() {
        return this.templateConfigurationList;
    }

    public void read(Configuration profileConfiguration) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        String version = (String)profileConfiguration.getConfigEntry("version");
        if (!"1.0".equals(version)) {
            throw new ConfigurationException("Invalid version");
        }
        this.policyTemplate = (String)profileConfiguration.getConfigEntry("template-reference");
        this.templateConfigurationList = new ArrayList(WSPolicyConfigurationElement.getElements(profileConfiguration.getSubConfiguration("Configuration").getPropertySheetInterface().getProperties()));
    }

    public void store(Configuration profileConfiguration) throws ConfigurationLockedException, ConfigurationException, IOException {
        Configuration propertyConfiguration = null;
        if (profileConfiguration.existsSubConfiguration("Configuration")) {
            propertyConfiguration = profileConfiguration.getSubConfiguration("Configuration");
            String version = (String)profileConfiguration.getConfigEntry("version");
            if (!"1.0".equals(version)) {
                throw new ConfigurationException("Invalid version");
            }
        } else {
            propertyConfiguration = profileConfiguration.createSubConfiguration("Configuration", 1);
            profileConfiguration.addConfigEntry("version", (Object)"1.0");
        }
        if (profileConfiguration.existsConfigEntry("template-reference")) {
            profileConfiguration.deleteConfigEntry("template-reference");
            profileConfiguration.addConfigEntry("template-reference", (Object)this.policyTemplate);
        } else {
            profileConfiguration.addConfigEntry("template-reference", (Object)this.policyTemplate);
        }
        this.storeProperties(propertyConfiguration, this.templateConfigurationList);
    }

    private void storeProperties(Configuration configuration, List policyConfigurationList) throws IOException, ConfigurationException, NameAlreadyExistsException, NoWriteAccessException {
        Iterator policyConfigurationIterator = policyConfigurationList.iterator();
        Properties requestProperties = new Properties();
        int counter = 0;
        while (policyConfigurationIterator.hasNext()) {
            WSPolicyConfigurationElement configElement = (WSPolicyConfigurationElement)policyConfigurationIterator.next();
            configElement.getProperties(requestProperties, counter);
            ++counter;
        }
        configuration.getPropertySheetInterface().deleteAllPropertyEntries();
        configuration.getPropertySheetInterface().createPropertyEntries(requestProperties);
        Iterator keyIterator = ((Hashtable)requestProperties).keySet().iterator();
        while (keyIterator.hasNext()) {
            String keyValue;
            String key = (String)keyIterator.next();
            if (!key.endsWith(".type") || !"Password".equals(keyValue = requestProperties.getProperty(key))) continue;
            String valueFieldKey = key.substring(0, key.length() - 5) + ".value";
            PropertyEntry propertyEntry = configuration.getPropertySheetInterface().getPropertyEntry(valueFieldKey);
            propertyEntry.setSecure(true);
        }
    }

    public String getPolicyTemplate() {
        return this.policyTemplate;
    }

    public void setPolicyTemplate(String string) {
        this.policyTemplate = string;
    }
}

