/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.policy;

import com.sap.engine.frame.core.configuration.ChangeEvent;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.security.core.policy.PolicyInfoManagerInterface;
import com.sap.security.core.policy.PolicyInfoManagerMessage;
import com.sap.security.core.policy.WSPolicy;
import com.sap.security.core.policy.WSPolicyConfigurationData;
import com.sap.security.core.policy.WSPolicyConfigurationElement;
import com.sap.security.core.policy.WSPolicyProfileConfigurationData;
import com.sap.security.core.server.xmlbind.exception.XMLBindConfigException;
import com.sap.security.core.server.xmlbind.exception.XMLBindException;
import com.sap.security.core.ws.mapping.WSMappingUtil;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class PolicyInfoManagerImpl
implements PolicyInfoManagerInterface,
ConfigurationChangedListener {
    private static final Location location = Location.getLocation((Class)(class$com$sap$security$core$policy$PolicyInfoManagerImpl == null ? (class$com$sap$security$core$policy$PolicyInfoManagerImpl = PolicyInfoManagerImpl.class$("com.sap.security.core.policy.PolicyInfoManagerImpl")) : class$com$sap$security$core$policy$PolicyInfoManagerImpl));
    private static final Category category = Category.getCategory((Category)Category.SYS_SECURITY, (String)"WS/SecurityProtocol");
    ConfigurationHandler configurationHandler = null;
    boolean cachingEnabled = false;
    HashMap cacheHashmap = null;
    static /* synthetic */ Class class$com$sap$security$core$policy$PolicyInfoManagerImpl;
    static /* synthetic */ Class class$com$sap$security$core$policy$WSPolicy;

    public PolicyInfoManagerImpl(ConfigurationHandler configurationHandler) throws NamingException, ConfigurationException, RemoteException {
        this.configurationHandler = configurationHandler;
    }

    public void setupConfigurationManagerStructures() throws ConfigurationException {
        this.createConfigurationPath("webservices/proxies", false);
        this.createConfigurationPath("webservices/services", false);
        this.createConfigurationPath("webservices/security/wss/policy-templates/outbound", false);
        this.createConfigurationPath("webservices/security/wss/policy-templates/inbound", false);
        this.createConfigurationPath("webservices/security/wss/policy-templates/outbound/Version", true);
        this.createConfigurationPath("webservices/security/wss/policy-templates/inbound/Version", true);
        this.createConfigurationPath("webservices/security/wss/policy-profiles/outbound", false);
        this.createConfigurationPath("webservices/security/wss/policy-profiles/inbound", false);
        this.createConfigurationPath("webservices/proxies/sap.com/DynamicWSProxies", false);
    }

    public void setCachingEnabled(boolean enabled) {
        if (enabled == this.cachingEnabled) {
            return;
        }
        this.cachingEnabled = enabled;
        if (this.cachingEnabled) {
            this.configurationHandler.addConfigurationChangedListener((ConfigurationChangedListener)this, "webservices");
            this.cacheHashmap = new HashMap();
        } else {
            this.configurationHandler.removeConfigurationChangedListener((ConfigurationChangedListener)this, "webservices");
            this.cacheHashmap = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createConfigurationPath(String path, boolean createPropertysheet) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        block17: {
            block16: {
                block14: {
                    Configuration rootConfiguration = null;
                    try {
                        String rootConfigurationName;
                        StringTokenizer st;
                        block15: {
                            st = new StringTokenizer(path, "/");
                            if (!st.hasMoreTokens()) {
                                Object var13_5 = null;
                                break block14;
                            }
                            rootConfigurationName = st.nextToken();
                            String[] rootNames = this.configurationHandler.getAllRootNames();
                            boolean hasrootConfiguration = false;
                            int i = 0;
                            while (true) {
                                if (i >= rootNames.length) {
                                    if (hasrootConfiguration) break;
                                    rootConfiguration = this.configurationHandler.createRootConfiguration(rootConfigurationName);
                                    break block15;
                                }
                                if (rootConfigurationName.equals(rootNames[i])) {
                                    hasrootConfiguration = true;
                                }
                                ++i;
                            }
                            boolean existsConfiguration = true;
                            Configuration currentConfiguration = rootConfiguration = this.configurationHandler.openConfiguration(rootConfigurationName, 0);
                            while (true) {
                                if (!st.hasMoreTokens() || !existsConfiguration) {
                                    if (!existsConfiguration) break;
                                    break block16;
                                }
                                String subConfigurationName = st.nextToken();
                                if (!currentConfiguration.existsSubConfiguration(subConfigurationName)) {
                                    existsConfiguration = false;
                                    continue;
                                }
                                currentConfiguration = currentConfiguration.getSubConfiguration(subConfigurationName);
                            }
                            rootConfiguration.close();
                            rootConfiguration = this.configurationHandler.openConfiguration(rootConfigurationName, 1);
                        }
                        st = new StringTokenizer(path, "/");
                        rootConfigurationName = st.nextToken();
                        Configuration currentConfiguration = rootConfiguration;
                        while (true) {
                            if (!st.hasMoreTokens()) {
                                this.configurationHandler.commit();
                                rootConfiguration.close();
                                break block17;
                            }
                            String subConfigurationName = st.nextToken();
                            if (!currentConfiguration.existsSubConfiguration(subConfigurationName)) {
                                if (!st.hasMoreElements() && createPropertysheet) {
                                    currentConfiguration.createSubConfiguration(subConfigurationName, 1);
                                } else {
                                    currentConfiguration.createSubConfiguration(subConfigurationName);
                                }
                            }
                            currentConfiguration = currentConfiguration.getSubConfiguration(subConfigurationName);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_8 = null;
                        this.configurationHandler.closeAllConfigurations();
                        throw throwable;
                    }
                }
                this.configurationHandler.closeAllConfigurations();
                return;
            }
            Object var13_6 = null;
            this.configurationHandler.closeAllConfigurations();
            return;
        }
        Object var13_7 = null;
        this.configurationHandler.closeAllConfigurations();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storePolicyTemplate(String path, String name, InputStream policyInputStream, int version) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        block8: {
            block7: {
                try {
                    Configuration policyVersionConfiguration = null;
                    Configuration policyConfiguration = this.configurationHandler.openConfiguration(path, 0);
                    policyVersionConfiguration = policyConfiguration.getSubConfiguration("Version");
                    PropertySheet versionPropertySheet = policyVersionConfiguration.getPropertySheetInterface();
                    int storedVersionNumber = -1;
                    Properties versionProperties = versionPropertySheet.getProperties();
                    storedVersionNumber = Integer.parseInt(versionProperties.getProperty(name, "-1"));
                    if (version <= storedVersionNumber) {
                        Object var11_10 = null;
                        break block7;
                    }
                    policyConfiguration.close();
                    policyConfiguration = this.configurationHandler.openConfiguration(path, 1);
                    policyVersionConfiguration = policyConfiguration.getSubConfiguration("Version");
                    versionPropertySheet = policyVersionConfiguration.getPropertySheetInterface();
                    if (policyConfiguration.existsFile(name)) {
                        policyConfiguration.updateFileAsStream(name, policyInputStream);
                    } else {
                        policyConfiguration.addFileAsStream(name, policyInputStream);
                    }
                    if (!((Hashtable)versionProperties).containsKey(name)) {
                        versionPropertySheet.createPropertyEntry(name, (Object)("" + version), "Version of template " + name);
                    } else {
                        versionPropertySheet.getPropertyEntry(name).setValue((Object)("" + version));
                    }
                    this.configurationHandler.commit();
                    policyConfiguration.close();
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    this.configurationHandler.closeAllConfigurations();
                    throw throwable;
                }
            }
            this.configurationHandler.closeAllConfigurations();
            return;
        }
        Object var11_11 = null;
        this.configurationHandler.closeAllConfigurations();
    }

    private Configuration getApplicationConfiguration(String path, String providerApplicationName, int accessMode) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        this.configurationHandler.closeAllConfigurations();
        this.createConfigurationPath(path + "/" + providerApplicationName, false);
        Configuration proxyConfiguration = this.configurationHandler.openConfiguration(path + "/" + providerApplicationName, accessMode);
        return proxyConfiguration;
    }

    public List getApplicationProviders(String path) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        List<Object> list;
        try {
            Configuration proxyConfiguration = this.configurationHandler.openConfiguration(path, 0);
            Object[] dataArray = proxyConfiguration.getAllSubConfigurationNames();
            Arrays.sort(dataArray);
            List<Object> returnList = Arrays.asList(dataArray);
            proxyConfiguration.close();
            list = returnList;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return list;
    }

    public List getApplicationNames(String path, String provider) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        List<Object> list;
        try {
            Configuration applicationConfiguration = this.configurationHandler.openConfiguration(path + "/" + provider, 0);
            Object[] dataArray = applicationConfiguration.getAllSubConfigurationNames();
            Arrays.sort(dataArray);
            List<Object> returnList = Arrays.asList(dataArray);
            applicationConfiguration.close();
            list = returnList;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return list;
    }

    public List getApplicationConfigurations(String path, String provider, String application) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        List<Object> list;
        try {
            Configuration configurationsConfiguration = this.configurationHandler.openConfiguration(path + "/" + provider + "/" + application, 0);
            Object[] dataArray = configurationsConfiguration.getAllSubConfigurationNames();
            Arrays.sort(dataArray);
            List<Object> returnList = Arrays.asList(dataArray);
            configurationsConfiguration.close();
            list = returnList;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return list;
    }

    public List getApplicationOperations(String path, String provider, String application, String configuration) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        List<Object> list;
        try {
            Configuration operationConfiguration = this.configurationHandler.openConfiguration(path + "/" + provider + "/" + application + "/" + configuration, 0);
            Object[] dataArray = operationConfiguration.getAllSubConfigurationNames();
            Arrays.sort(dataArray);
            List<Object> returnList = Arrays.asList(dataArray);
            operationConfiguration.close();
            list = returnList;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return list;
    }

    public List getPolicyTemplateNames(String policyTemplatePath) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        ArrayList arrayList;
        try {
            Configuration policyConfiguration = this.configurationHandler.openConfiguration(policyTemplatePath, 0);
            Set policyNamesSet = policyConfiguration.getAllFileEntries().keySet();
            policyConfiguration.close();
            ArrayList templateNamesList = new ArrayList(policyNamesSet);
            Collections.sort(templateNamesList);
            arrayList = templateNamesList;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return arrayList;
    }

    private WSPolicy getPolicyProfileInstance(String profilePath, String profileName) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException, XMLBindException, ParserConfigurationException, SAXException, IOException {
        WSPolicy wSPolicy;
        try {
            WSPolicy policy;
            WSPolicyProfileConfigurationData configData = this.getPolicyProfileConfiguration(profilePath, profileName);
            String policyName = configData.getPolicyTemplate();
            List configurationDataList = configData.getPolicyConfigurationList();
            String templatePath = null;
            templatePath = "webservices/security/wss/policy-profiles/outbound".equals(profilePath) ? "webservices/security/wss/policy-templates/outbound" : "webservices/security/wss/policy-templates/inbound";
            Configuration policyConfiguration = this.configurationHandler.openConfiguration(templatePath, 0);
            InputStream is = policyConfiguration.getFile(policyName);
            byte[] data = new byte[10240];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int length = 0;
            while ((length = is.read(data)) != -1) {
                if (length == -1) continue;
                bos.write(data, 0, length);
            }
            policyConfiguration.close();
            String template = new String(bos.toByteArray(), "UTF-8");
            Object[] replacementData = new Object[]{"", "", "", "", "", "", "", "", "", ""};
            Iterator configurationDataIterator = configurationDataList.iterator();
            while (configurationDataIterator.hasNext()) {
                WSPolicyConfigurationElement configElement = (WSPolicyConfigurationElement)configurationDataIterator.next();
                int variableNumber = Integer.parseInt(configElement.variable);
                if (variableNumber >= replacementData.length) continue;
                replacementData[variableNumber] = configElement.getValue();
            }
            String policyString = MessageFormat.format(template, replacementData);
            WSMappingUtil util = WSMappingUtil.get(WSMappingUtil.POLICY_MAPPING);
            ByteArrayInputStream policyIS = new ByteArrayInputStream(policyString.getBytes("UTF-8"));
            wSPolicy = policy = (WSPolicy)util.unmarshall(policyIS);
            Object var21_21 = null;
        }
        catch (Throwable throwable) {
            Object var21_22 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return wSPolicy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WSPolicy getProxyRequestPolicy(String applicationName) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException, XMLBindException, ParserConfigurationException, SAXException, IOException {
        WSPolicy wSPolicy;
        String cacheName = "getProxyRequestPolicy:" + applicationName;
        if (this.cachingEnabled && this.cacheHashmap.containsKey(cacheName)) {
            try {
                return (WSPolicy)((WSPolicy)this.cacheHashmap.get(cacheName)).clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new IOException("Could not clone policy: " + ex.getMessage());
            }
        }
        try {
            WSPolicyConfigurationData policyConfigurationData = this.getProxyConfiguration(applicationName);
            WSPolicy policy = this.getPolicyProfileInstance("webservices/security/wss/policy-profiles/outbound", policyConfigurationData.getOutboundPolicyProfile());
            if (this.cachingEnabled) {
                this.cacheHashmap.put(cacheName, policy);
            }
            try {
                wSPolicy = (WSPolicy)policy.clone();
                Object var7_8 = null;
            }
            catch (CloneNotSupportedException ex) {
                throw new IOException("Could not clone policy: " + ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return wSPolicy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WSPolicy getProxyResponsePolicy(String applicationName) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException, XMLBindException, ParserConfigurationException, SAXException, IOException {
        WSPolicy wSPolicy;
        String cacheName = "getProxyResponsePolicy:" + applicationName;
        if (this.cachingEnabled && this.cacheHashmap.containsKey(cacheName)) {
            try {
                return (WSPolicy)((WSPolicy)this.cacheHashmap.get(cacheName)).clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new IOException("Could not clone policy: " + ex.getMessage());
            }
        }
        try {
            WSPolicyConfigurationData policyConfigurationData = this.getProxyConfiguration(applicationName);
            WSPolicy policy = this.getPolicyProfileInstance("webservices/security/wss/policy-profiles/inbound", policyConfigurationData.getInboundPolicyProfile());
            if (this.cachingEnabled) {
                this.cacheHashmap.put(cacheName, policy);
            }
            try {
                wSPolicy = (WSPolicy)policy.clone();
                Object var7_8 = null;
            }
            catch (CloneNotSupportedException ex) {
                throw new IOException("Could not clone policy: " + ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return wSPolicy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WSPolicy getServiceRequestPolicy(String applicationName) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException, XMLBindException, ParserConfigurationException, SAXException, IOException {
        WSPolicy wSPolicy;
        String cacheName = "getServiceRequestPolicy:" + applicationName;
        if (this.cachingEnabled && this.cacheHashmap.containsKey(cacheName)) {
            try {
                return (WSPolicy)((WSPolicy)this.cacheHashmap.get(cacheName)).clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new IOException("Could not clone policy: " + ex.getMessage());
            }
        }
        try {
            WSPolicyConfigurationData policyConfigurationData = this.getServiceConfiguration(applicationName);
            WSPolicy policy = this.getPolicyProfileInstance("webservices/security/wss/policy-profiles/inbound", policyConfigurationData.getInboundPolicyProfile());
            if (this.cachingEnabled) {
                this.cacheHashmap.put(cacheName, policy);
            }
            try {
                wSPolicy = (WSPolicy)policy.clone();
                Object var7_8 = null;
            }
            catch (CloneNotSupportedException ex) {
                throw new IOException("Could not clone policy: " + ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return wSPolicy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WSPolicy getServiceResponsePolicy(String applicationName) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException, XMLBindException, ParserConfigurationException, SAXException, IOException {
        WSPolicy wSPolicy;
        String cacheName = "getServiceResponsePolicy:" + applicationName;
        if (this.cachingEnabled && this.cacheHashmap.containsKey(cacheName)) {
            try {
                return (WSPolicy)((WSPolicy)this.cacheHashmap.get(cacheName)).clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new IOException("Could not clone policy: " + ex.getMessage());
            }
        }
        try {
            WSPolicyConfigurationData policyConfigurationData = this.getServiceConfiguration(applicationName);
            WSPolicy policy = this.getPolicyProfileInstance("webservices/security/wss/policy-profiles/outbound", policyConfigurationData.getOutboundPolicyProfile());
            if (this.cachingEnabled) {
                this.cacheHashmap.put(cacheName, policy);
            }
            try {
                wSPolicy = (WSPolicy)policy.clone();
                Object var7_8 = null;
            }
            catch (CloneNotSupportedException ex) {
                throw new IOException("Could not clone policy: " + ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return wSPolicy;
    }

    private WSPolicy getPolicyTemplate(String path, String policyName) throws ParserConfigurationException, XMLBindException, XMLBindConfigException, NameNotFoundException, ConfigurationLockedException, ConfigurationException, SAXException, IOException {
        WSPolicy wSPolicy;
        try {
            Configuration policyConfiguration = this.configurationHandler.openConfiguration(path, 0);
            InputStream policyInputStream = policyConfiguration.getFile(policyName);
            WSMappingUtil util = WSMappingUtil.get(WSMappingUtil.POLICY_MAPPING);
            WSPolicy policy = (WSPolicy)util.unmarshall(policyInputStream, (class$com$sap$security$core$policy$WSPolicy == null ? (class$com$sap$security$core$policy$WSPolicy = PolicyInfoManagerImpl.class$("com.sap.security.core.policy.WSPolicy")) : class$com$sap$security$core$policy$WSPolicy).getClassLoader());
            policyConfiguration.close();
            wSPolicy = policy;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return wSPolicy;
    }

    private WSPolicyConfigurationData getApplicationConfiguration(String path, String applicationName) throws ConfigurationLockedException, ConfigurationException {
        WSPolicyConfigurationData wSPolicyConfigurationData;
        try {
            Configuration proxyConfiguration = this.getApplicationConfiguration(path, applicationName, 0);
            WSPolicyConfigurationData configurationData = new WSPolicyConfigurationData(proxyConfiguration);
            proxyConfiguration.close();
            wSPolicyConfigurationData = configurationData;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return wSPolicyConfigurationData;
    }

    public WSPolicyConfigurationData getProxyConfiguration(String applicationName) throws ConfigurationLockedException, ConfigurationException {
        WSPolicyConfigurationData wSPolicyConfigurationData;
        String cacheName = "getProxyConfiguration:" + applicationName;
        if (this.cachingEnabled && this.cacheHashmap.containsKey(cacheName)) {
            return (WSPolicyConfigurationData)this.cacheHashmap.get(cacheName);
        }
        try {
            WSPolicyConfigurationData configurationData = this.getApplicationConfiguration("webservices/proxies", applicationName);
            if (this.cachingEnabled) {
                this.cacheHashmap.put(cacheName, configurationData);
            }
            wSPolicyConfigurationData = configurationData;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return wSPolicyConfigurationData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WSPolicyConfigurationData getServiceConfiguration(String applicationName) throws ConfigurationLockedException, ConfigurationException {
        WSPolicyConfigurationData wSPolicyConfigurationData;
        String cacheName = "getServiceConfiguration:" + applicationName;
        if (this.cachingEnabled && this.cacheHashmap.containsKey(cacheName)) {
            return (WSPolicyConfigurationData)this.cacheHashmap.get(cacheName);
        }
        try {
            try {
                WSPolicyConfigurationData configurationData = this.getApplicationConfiguration("webservices/services", applicationName);
                if (this.cachingEnabled) {
                    this.cacheHashmap.put(cacheName, configurationData);
                }
                wSPolicyConfigurationData = configurationData;
                Object var11_7 = null;
            }
            catch (ConfigurationException e) {
                WSPolicyConfigurationData configurationData;
                StringTokenizer st = new StringTokenizer(applicationName, "/");
                String pathLong = "webservices/services/" + st.nextToken() + "/" + st.nextToken();
                String newConfig = st.nextToken();
                if (new StringTokenizer(newConfig, "*").countTokens() != 2) throw e;
                String oldConfig = newConfig.substring(newConfig.indexOf("*") + 1);
                if (!this.configurationHandler.openConfiguration(pathLong, 0).existsSubConfiguration(oldConfig)) {
                    throw e;
                }
                this.configurationHandler.closeAllConfigurations();
                this.renameConfigurationEntry(pathLong, oldConfig, newConfig);
                WSPolicyConfigurationData wSPolicyConfigurationData2 = configurationData = this.getApplicationConfiguration("webservices/services", applicationName);
                Object var11_8 = null;
                this.configurationHandler.closeAllConfigurations();
                return wSPolicyConfigurationData2;
            }
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return wSPolicyConfigurationData;
    }

    public WSPolicyConfigurationData getServiceRedeployConfiguration(String applicationName) throws ConfigurationLockedException, ConfigurationException {
        WSPolicyConfigurationData wSPolicyConfigurationData;
        try {
            wSPolicyConfigurationData = this.getApplicationConfiguration("webservices/deploy/services", applicationName);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return wSPolicyConfigurationData;
    }

    public WSPolicyConfigurationData getProxyRedeployConfiguration(String applicationName) throws ConfigurationLockedException, ConfigurationException {
        WSPolicyConfigurationData wSPolicyConfigurationData;
        try {
            wSPolicyConfigurationData = this.getApplicationConfiguration("webservices/deploy/proxies", applicationName);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return wSPolicyConfigurationData;
    }

    public WSPolicyConfigurationData createPolicyConfiguration(String inboundPolicyProfile, String outboundPolicyProfile) throws ConfigurationLockedException, ConfigurationException, XMLBindException, FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        WSPolicyConfigurationData wSPolicyConfigurationData;
        try {
            WSPolicyConfigurationData configurationData;
            wSPolicyConfigurationData = configurationData = new WSPolicyConfigurationData(inboundPolicyProfile, outboundPolicyProfile);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return wSPolicyConfigurationData;
    }

    private void updateConfiguration(String path, WSPolicyConfigurationData configuration, String applicationName) throws ConfigurationLockedException, ConfigurationException, IOException {
        try {
            Configuration applicationConfiguration = this.getApplicationConfiguration(path, applicationName, 1);
            configuration.store(applicationConfiguration);
            this.configurationHandler.commit();
            applicationConfiguration.close();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
    }

    public void updateProxyConfiguration(WSPolicyConfigurationData configuration, String applicationName) throws ConfigurationLockedException, ConfigurationException, IOException {
        this.updateConfiguration("webservices/proxies", configuration, applicationName);
    }

    public void updateServiceConfiguration(WSPolicyConfigurationData configuration, String applicationName) throws ConfigurationLockedException, ConfigurationException, IOException {
        this.updateConfiguration("webservices/services", configuration, applicationName);
    }

    /*
     * Loose catch block
     */
    private void renameConfigurationEntry(String pathLong, String nameOld, String nameNew) {
        block11: {
            HashMap<String, WSPolicyConfigurationData> cfgData = new HashMap<String, WSPolicyConfigurationData>();
            String application = pathLong.substring(pathLong.lastIndexOf("/") + 1);
            String path = pathLong.substring(0, pathLong.lastIndexOf("/"));
            String provider = path.substring(path.lastIndexOf("/") + 1);
            path = path.substring(0, path.lastIndexOf("/"));
            Iterator operations = this.getApplicationOperations(path, provider, application, nameOld).iterator();
            while (operations.hasNext()) {
                String operation = (String)operations.next();
                String hashKey = nameOld + "/" + operation;
                cfgData.put(hashKey, this.getApplicationConfiguration(pathLong, hashKey));
            }
            Configuration writeCfg = this.getApplicationConfiguration(path, provider + "/" + application, 1);
            Configuration config = !writeCfg.existsSubConfiguration(nameNew) ? writeCfg.createSubConfiguration(nameNew) : writeCfg.getSubConfiguration(nameNew);
            Iterator keys = cfgData.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String cfg = key.substring(key.lastIndexOf("/") + 1);
                Configuration applConfig = config.existsSubConfiguration(cfg) ? config.getSubConfiguration(cfg) : config.createSubConfiguration(cfg);
                ((WSPolicyConfigurationData)cfgData.get(key)).store(applConfig);
            }
            if (writeCfg.existsSubConfiguration(nameOld)) {
                String[] array = new String[]{nameOld};
                writeCfg.deleteSubConfigurations(array);
            }
            PolicyInfoManagerMessage.ID0330_INFO_CONFIGURATION_RENAMED.create((Object)nameOld, (Object)pathLong.substring(pathLong.lastIndexOf("/") + 1), (Object)nameNew).log(400, category, location, "getServiceConfiguration");
            Object var18_19 = null;
            try {
                this.configurationHandler.commit();
                this.configurationHandler.closeAllConfigurations();
            }
            catch (ConfigurationException e2) {
                String method2 = "renameConfigurationEntry";
                PolicyInfoManagerMessage.ID0200_ERROR_ACCESSING_CONFIG_MANAGER.create((Object)method2, (Object)((Object)((Object)e2)).getClass().getName(), (Object)e2.getMessage()).log(500, category, location, method2);
            }
            break block11;
            {
                catch (Exception e) {
                    String method = "renameConfigurationEntry";
                    PolicyInfoManagerMessage.ID0180_ERROR_RENAMING_CONFIG.create((Object)nameOld, (Object)application, (Object)e.getClass().getName(), (Object)e.getMessage()).log(500, category, location, method);
                    Object var18_20 = null;
                    try {
                        this.configurationHandler.commit();
                        this.configurationHandler.closeAllConfigurations();
                    }
                    catch (ConfigurationException e2) {
                        String method2 = "renameConfigurationEntry";
                        PolicyInfoManagerMessage.ID0200_ERROR_ACCESSING_CONFIG_MANAGER.create((Object)method2, (Object)((Object)((Object)e2)).getClass().getName(), (Object)e2.getMessage()).log(500, category, location, method2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var18_21 = null;
                try {
                    this.configurationHandler.commit();
                    this.configurationHandler.closeAllConfigurations();
                }
                catch (ConfigurationException e2) {
                    String method2 = "renameConfigurationEntry";
                    PolicyInfoManagerMessage.ID0200_ERROR_ACCESSING_CONFIG_MANAGER.create((Object)method2, (Object)((Object)((Object)e2)).getClass().getName(), (Object)e2.getMessage()).log(500, category, location, method2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean exitsConfiguration(String path) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        StringTokenizer st = new StringTokenizer(path, "/");
        if (!st.hasMoreTokens()) {
            return false;
        }
        String currentPath = st.nextToken();
        while (true) {
            Object var8_6;
            block7: {
                boolean bl;
                block6: {
                    if (!st.hasMoreTokens()) {
                        return true;
                    }
                    String pathElement = st.nextToken();
                    try {
                        Configuration configurationsConfiguration = this.configurationHandler.openConfiguration(currentPath, 0);
                        if (!configurationsConfiguration.existsSubConfiguration(pathElement)) {
                            bl = false;
                            var8_6 = null;
                            break block6;
                        }
                        currentPath = currentPath + "/" + pathElement;
                        configurationsConfiguration.close();
                        break block7;
                    }
                    catch (Throwable throwable) {
                        var8_6 = null;
                        this.configurationHandler.closeAllConfigurations();
                        throw throwable;
                    }
                }
                this.configurationHandler.closeAllConfigurations();
                return bl;
            }
            var8_6 = null;
            this.configurationHandler.closeAllConfigurations();
        }
    }

    /*
     * Loose catch block
     */
    private void copyApplicationConfiguration(String pathFrom, String pathTo, String provAppName) {
        block12: {
            String configuration;
            HashMap<String, WSPolicyConfigurationData> cfgData = new HashMap<String, WSPolicyConfigurationData>();
            StringTokenizer st = new StringTokenizer(provAppName, "/");
            String provider = st.nextToken();
            String applicationName = st.nextToken();
            Iterator subCfgIterator = this.getApplicationConfigurations(pathFrom, provider, applicationName).iterator();
            while (subCfgIterator.hasNext()) {
                configuration = (String)subCfgIterator.next();
                Iterator subSubCfgIterator = this.getApplicationOperations(pathFrom, provider, applicationName, configuration).iterator();
                while (subSubCfgIterator.hasNext()) {
                    String operation = (String)subSubCfgIterator.next();
                    String appPath = configuration + "/" + operation;
                    cfgData.put(appPath, this.getApplicationConfiguration(pathFrom, provAppName + "/" + appPath));
                }
            }
            Configuration deleteCfg = this.getApplicationConfiguration(pathTo, provider, 1);
            if (deleteCfg.existsSubConfiguration(applicationName)) {
                String[] array = new String[]{applicationName};
                deleteCfg.deleteSubConfigurations(array);
            }
            this.configurationHandler.commit();
            deleteCfg.close();
            Configuration writeCfg = this.getApplicationConfiguration(pathTo, provAppName, 1);
            Iterator keys = cfgData.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                st = new StringTokenizer(key, "/");
                configuration = st.nextToken();
                Configuration config = !writeCfg.existsSubConfiguration(configuration) ? writeCfg.createSubConfiguration(configuration) : writeCfg.getSubConfiguration(configuration);
                Configuration op = config.createSubConfiguration(st.nextToken());
                ((WSPolicyConfigurationData)cfgData.get(key)).store(op);
            }
            Object var19_20 = null;
            try {
                this.configurationHandler.commit();
                this.configurationHandler.closeAllConfigurations();
            }
            catch (ConfigurationException e2) {
                String method2 = "copyApplicationConfiguration";
                PolicyInfoManagerMessage.ID0200_ERROR_ACCESSING_CONFIG_MANAGER.create((Object)method2, (Object)((Object)((Object)e2)).getClass().getName(), (Object)e2.getMessage()).log(500, category, location, method2);
            }
            break block12;
            {
                catch (Exception e) {
                    String method = "copyApplicationConfiguration";
                    PolicyInfoManagerMessage.ID0100_ERROR_WHILE_COPYING_CONFIG.create((Object)provAppName, (Object)e.getClass().getName(), (Object)e.getMessage()).log(500, category, location, method);
                    Object var19_21 = null;
                    try {
                        this.configurationHandler.commit();
                        this.configurationHandler.closeAllConfigurations();
                    }
                    catch (ConfigurationException e2) {
                        String method2 = "copyApplicationConfiguration";
                        PolicyInfoManagerMessage.ID0200_ERROR_ACCESSING_CONFIG_MANAGER.create((Object)method2, (Object)((Object)((Object)e2)).getClass().getName(), (Object)e2.getMessage()).log(500, category, location, method2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var19_22 = null;
                try {
                    this.configurationHandler.commit();
                    this.configurationHandler.closeAllConfigurations();
                }
                catch (ConfigurationException e2) {
                    String method2 = "copyApplicationConfiguration";
                    PolicyInfoManagerMessage.ID0200_ERROR_ACCESSING_CONFIG_MANAGER.create((Object)method2, (Object)((Object)((Object)e2)).getClass().getName(), (Object)e2.getMessage()).log(500, category, location, method2);
                }
                throw throwable;
            }
        }
    }

    private void deleteApplicationConfiguration(String path, String applicationName) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        try {
            Configuration proxyConfiguration = this.getApplicationConfiguration(path, applicationName, 1);
            proxyConfiguration.deleteConfiguration();
            this.configurationHandler.commit();
            proxyConfiguration.close();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
    }

    public void deleteProxyConfiguration(String applicationName) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        if (this.exitsConfiguration("webservices/proxies/" + applicationName)) {
            this.copyApplicationConfiguration("webservices/proxies", "webservices/deploy/proxies", applicationName);
            this.deleteApplicationConfiguration("webservices/proxies", applicationName);
        }
    }

    public void deletePolicyConfiguration(String applicationName) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        if (this.exitsConfiguration("webservices/services/" + applicationName)) {
            this.copyApplicationConfiguration("webservices/services", "webservices/deploy/services", applicationName);
            this.deleteApplicationConfiguration("webservices/services", applicationName);
        }
    }

    public WSPolicyProfileConfigurationData getPolicyProfileConfiguration(String profilePath, String profileName) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        WSPolicyProfileConfigurationData wSPolicyProfileConfigurationData;
        try {
            Configuration templateConfiguration = this.configurationHandler.openConfiguration(profilePath, 0);
            WSPolicyProfileConfigurationData returnData = new WSPolicyProfileConfigurationData(templateConfiguration.getSubConfiguration(profileName));
            templateConfiguration.close();
            wSPolicyProfileConfigurationData = returnData;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return wSPolicyProfileConfigurationData;
    }

    public void updatePolicyProfile(String path, String name, WSPolicyProfileConfigurationData configData) throws ConfigurationLockedException, NameNotFoundException, InconsistentReadException, ConfigurationException, IOException {
        try {
            Configuration templateConfiguration = this.configurationHandler.openConfiguration(path, 1);
            if (!templateConfiguration.existsSubConfiguration(name)) {
                templateConfiguration.createSubConfiguration(name);
            }
            configData.store(templateConfiguration.getSubConfiguration(name));
            this.configurationHandler.commit();
            templateConfiguration.close();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
    }

    public void deletePolicyProfile(String profilePath, String name) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        try {
            Configuration profileConfiguration = this.configurationHandler.openConfiguration(profilePath + "/" + name, 1);
            profileConfiguration.deleteConfiguration();
            this.configurationHandler.commit();
            profileConfiguration.close();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
    }

    public WSPolicyProfileConfigurationData createPolicyProfileConfiguration(String path, String policyTemplate) throws ConfigurationLockedException, ConfigurationException, XMLBindException, FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        WSPolicyProfileConfigurationData wSPolicyProfileConfigurationData;
        try {
            WSPolicy inboundPolicy = this.getPolicyTemplate(path, policyTemplate);
            WSPolicyProfileConfigurationData configurationData = new WSPolicyProfileConfigurationData(inboundPolicy.getConfigurationList());
            configurationData.setPolicyTemplate(policyTemplate);
            wSPolicyProfileConfigurationData = configurationData;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return wSPolicyProfileConfigurationData;
    }

    public List getPolicyProfileNames(String profilePath) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        List<Object> list;
        try {
            Configuration profileConfiguration = this.configurationHandler.openConfiguration(profilePath, 0);
            Object[] resultNamesArray = profileConfiguration.getAllSubConfigurationNames();
            Arrays.sort(resultNamesArray);
            List<Object> profileNameList = Arrays.asList(resultNamesArray);
            profileConfiguration.close();
            list = profileNameList;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.configurationHandler.closeAllConfigurations();
            throw throwable;
        }
        this.configurationHandler.closeAllConfigurations();
        return list;
    }

    public List getPolicyProfileNames(String profilePath, String templateName) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        ArrayList<String> profileList = new ArrayList<String>();
        Iterator profileNameIterator = this.getPolicyProfileNames(profilePath).iterator();
        while (profileNameIterator.hasNext()) {
            String profileName = (String)profileNameIterator.next();
            WSPolicyProfileConfigurationData configData = this.getPolicyProfileConfiguration(profilePath, profileName);
            if (!templateName.equals(configData.getPolicyTemplate())) continue;
            profileList.add(profileName);
        }
        if (!profileList.contains("None")) {
            profileList.add("None");
        }
        return profileList;
    }

    public void closeAllConfigurations() throws ConfigurationException {
        this.configurationHandler.closeAllConfigurations();
    }

    public void configurationChanged(ChangeEvent changeEvent) {
        this.cacheHashmap.clear();
        ChangeEvent[] changeEventArray = changeEvent.getDetailedChangeEvents();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

