/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.client.ws.wdhelper;

import com.sap.engine.interfaces.keystore.KeystoreManager;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientProtocolException;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.HTTPTransportInterface;
import com.sap.security.core.client.ws.DeployableAuthenticationContext;
import com.sap.security.core.client.ws.wdhelper.WSSecurityWDHelperMessage;
import com.sap.security.core.server.destinations.api.DestinationService;
import com.sap.security.core.server.util0.IDMessage;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;

public class WSSecurityWDHelper {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$client$ws$wdhelper$WSSecurityWDHelper == null ? (class$com$sap$security$core$client$ws$wdhelper$WSSecurityWDHelper = WSSecurityWDHelper.class$("com.sap.security.core.client.ws.wdhelper.WSSecurityWDHelper")) : class$com$sap$security$core$client$ws$wdhelper$WSSecurityWDHelper));
    private static final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"WS/SecurityProtocol");
    private DestinationService dstService = null;
    private KeystoreManager keystoreManager = null;
    static /* synthetic */ Class class$com$sap$security$core$client$ws$wdhelper$WSSecurityWDHelper;

    public WSSecurityWDHelper() throws ClientProtocolException {
        String method = "WSSecurityWDHelper";
        LOCATION.entering("WSSecurityWDHelper");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Properties prop = new Properties();
                ((Hashtable)prop).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                InitialContext ctx = new InitialContext(prop);
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.dstService = (DestinationService)ctx.lookup("tc~sec~destinations~service~local");
                this.keystoreManager = (KeystoreManager)ctx.lookup("keystore");
            }
            catch (Exception e) {
                IDMessage message = WSSecurityWDHelperMessage.ID0000_ERROR_INITIALIZING_WDHELPER.create((Object)e.getClass().getName(), (Object)e.getMessage());
                message.log(500, CATEGORY, LOCATION, "WSSecurityWDHelper");
                throw new ClientProtocolException(message.format());
            }
            Object var6_7 = null;
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            Thread.currentThread().setContextClassLoader(cl);
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDestinationUrl(String destinationName) {
        String method = "getDestinationUrl";
        LOCATION.entering("getDestinationUrl");
        String destinationUrl = null;
        try {
            try {
                destinationUrl = this.dstService.getDestination("HTTP", destinationName).getDestinationProperties().getProperty("URL");
            }
            catch (Exception e) {
                WSSecurityWDHelperMessage.ID0100_ERROR_READING_DESTINATION.create((Object)destinationName, (Object)e.getClass().getName(), (Object)e.getMessage()).log(500, CATEGORY, LOCATION, "getDestinationUrl");
                Object var6_5 = null;
                LOCATION.exiting();
                return destinationUrl;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
        return destinationUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeployableAuthenticationContext getDeployableAuthenticationContext(PropertyContext authenticationFeatureContext) {
        String method = "getDeployableAuthenticationContext";
        LOCATION.entering("getDeployableAuthenticationContext");
        DeployableAuthenticationContext deplAuthCtx = null;
        try {
            try {
                if (this.dstService == null) throw new Exception("Either destination service or keystore manager is not available.");
                if (this.keystoreManager == null) {
                    throw new Exception("Either destination service or keystore manager is not available.");
                }
                deplAuthCtx = new DeployableAuthenticationContext(this.dstService, this.keystoreManager, authenticationFeatureContext, true);
            }
            catch (Exception e) {
                WSSecurityWDHelperMessage.ID0200_ERROR_CREATING_AUTH_CONTEXT.create((Object)e.getClass().getName(), (Object)e.getMessage()).log(500, CATEGORY, LOCATION, "getDeployableAuthenticationContext");
                Object var6_5 = null;
                LOCATION.exiting();
                return deplAuthCtx;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
        return deplAuthCtx;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setHTTPEndpoint(String destinationUrl, PropertyContext context) {
        String method = "setHTTPEndpoint";
        LOCATION.entering("setHTTPEndpoint");
        try {
            block4: {
                try {
                    Object transportInterface = context.getProperty("transportInterface");
                    if (transportInterface == null || !(transportInterface instanceof HTTPTransportInterface)) break block4;
                    HTTPTransportInterface http = (HTTPTransportInterface)transportInterface;
                    http.setEndpoint(destinationUrl);
                    WSSecurityWDHelperMessage.ID0300_INFO_URL_CHANGED.create((Object)destinationUrl).log(300, CATEGORY, LOCATION, "setHTTPEndpoint");
                }
                catch (Exception e) {
                    WSSecurityWDHelperMessage.ID0310_ERROR_CHANGING_URL.create((Object)e.getClass().getName(), (Object)e.getMessage()).log(500, CATEGORY, LOCATION, "setHTTPEndpoint");
                    Object var7_8 = null;
                    LOCATION.exiting();
                    return;
                }
            }
            Object var7_7 = null;
            LOCATION.exiting();
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            LOCATION.exiting();
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

