/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.client.ws;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.ServerInternalLocking;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.interfaces.keystore.KeystoreManager;
import com.sap.engine.interfaces.webservices.server.SLDLogicalPort;
import com.sap.engine.interfaces.webservices.server.WebServiceInterface;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.interfaces.webservices.server.deploy.WSWarningException;
import com.sap.engine.interfaces.webservices.server.deploy.wsclient.WSClientBaseContext;
import com.sap.engine.interfaces.webservices.server.deploy.wsclient.WSClientContext;
import com.sap.engine.interfaces.webservices.server.deploy.wsclient.WSClientDeploymentInterface;
import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientProtocolException;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientProtocolStartAppEvent;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.RuntimeInformation;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.FeatureType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LocalFeatures;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.OperationType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.ClientMimeMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.ClientSOAPMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.HTTPTransportInterface;
import com.sap.engine.services.wssec.srt.protocols.OperationNotSupportedException;
import com.sap.engine.services.wssec.srt.protocols.OperationNotSupportedMessage;
import com.sap.security.core.client.ws.DeployableAuthenticationContext;
import com.sap.security.core.client.ws.DeployableSecurityProtocolMessage;
import com.sap.security.core.client.ws.SecurityProtocol;
import com.sap.security.core.policy.PolicyInfoManagerImpl;
import com.sap.security.core.policy.PolicyInfoManagerInterface;
import com.sap.security.core.policy.WSPolicy;
import com.sap.security.core.policy.WSPolicyConfigurationData;
import com.sap.security.core.securitypolicy.assertions.SecurityPolicyConstants;
import com.sap.security.core.server.destinations.api.Destination;
import com.sap.security.core.server.destinations.api.DestinationService;
import com.sap.security.core.server.destinations.api.HTTPDestination;
import com.sap.security.core.server.destinations.service.HTTPDestinationImpl;
import com.sap.security.core.server.util0.IDMessage;
import com.sap.security.core.server.xmlbind.exception.XMLBindException;
import com.sap.security.core.ws.mapping.WSMappingUtil;
import com.sap.security.core.ws.wss.WSSecurity;
import com.sap.security.core.ws.wss.WSSecurityContext;
import com.sap.security.core.ws.wss.WSSecurityDocument;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogRecord;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DeployableSecurityProtocol
extends SecurityProtocol
implements ClientProtocolStartAppEvent,
WSClientDeploymentInterface {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$client$ws$DeployableSecurityProtocol == null ? (class$com$sap$security$core$client$ws$DeployableSecurityProtocol = DeployableSecurityProtocol.class$("com.sap.security.core.client.ws.DeployableSecurityProtocol")) : class$com$sap$security$core$client$ws$DeployableSecurityProtocol));
    private static final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"WS/SecurityProtocol");
    boolean initialized = false;
    private boolean ignoreDefaultDestination = false;
    private PropertyContext ctx;
    private ApplicationServiceContext serviceContext;
    private static WSSecurity wssImpl;
    private static DocumentBuilder documentBuilder;
    private static WSPolicy decryptionPolicy;
    private static final String DECRYPTION_POLICY_RESOUCE = "/policies/inbound/Decrypt_all.xml";
    private String operationName = null;
    private String lockNameSpace = "[ws_security:Depl.Sec.Prot]";
    private String lockDescription = "internal lock set by ws client deployment";
    private LockingContext lockingContext = null;
    private boolean lockingEnabled = true;
    private int lockingTimeout = 30000;
    private boolean invalidateAllSessions = false;
    ServerInternalLocking _serverInternalLocking = null;
    private static WSPolicy emptyPolicy;
    static /* synthetic */ Class class$com$sap$security$core$client$ws$DeployableSecurityProtocol;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeployableSecurityProtocol(ApplicationServiceContext serviceContext, PolicyInfoManagerInterface policyInfoManager) {
        String method = "DeployableSecurityProtocol";
        try {
            try {
                LOCATION.entering("DeployableSecurityProtocol", new Object[]{serviceContext});
                this.serviceContext = serviceContext;
                if (wssImpl == null) {
                    wssImpl = (WSSecurity)serviceContext.getContainerContext().getObjectRegistry().getServiceInterface("tc~sec~wssec~service");
                }
                if (documentBuilder == null) {
                    documentBuilder = new DocumentBuilderFactoryImpl().newDocumentBuilder();
                }
                if (decryptionPolicy == null) {
                    WSMappingUtil util = WSMappingUtil.get(WSMappingUtil.POLICY_MAPPING);
                    Object o = util.unmarshall(this.getClass().getResourceAsStream(DECRYPTION_POLICY_RESOUCE));
                    decryptionPolicy = (WSPolicy)o;
                }
                this.lockingEnabled = "true".equals(serviceContext.getServiceState().getProperties().getProperty("locking.client.enabled", "true"));
                this.lockingTimeout = Integer.parseInt(serviceContext.getServiceState().getProperties().getProperty("locking.timeout", "30000"));
                this.invalidateAllSessions = "true".equals(serviceContext.getServiceState().getProperties().getProperty("invalidate.all.sessions", "true"));
            }
            catch (Throwable ex) {
                DeployableSecurityProtocolMessage.ID1000_ERROR_INSTANTIATING_PROTOCOL.create((Object)ex.getClass().getName(), (Object)ex.getMessage()).log(500, CATEGORY, LOCATION, "DeployableSecurityProtocol");
                Object var7_8 = null;
                LOCATION.exiting();
                return;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
    }

    public void init(PropertyContext ctx) {
        String method = "init";
        LOCATION.entering("init", new Object[]{ctx});
        if (ctx.isDefined()) {
            this.initialized = true;
            this.ctx = ctx.getSubContext("http://www.sap.com/webas/630/soap/features/authentication");
            DestinationService dstService = null;
            KeystoreManager keystoreManager = null;
            if (this.serviceContext != null) {
                dstService = (DestinationService)this.serviceContext.getContainerContext().getObjectRegistry().getServiceInterface("tc~sec~destinations~service");
                keystoreManager = (KeystoreManager)this.serviceContext.getContainerContext().getObjectRegistry().getServiceInterface("keystore");
            } else {
                try {
                    InitialContext context = new InitialContext();
                    dstService = (DestinationService)context.lookup("tc~sec~destinations~service");
                    keystoreManager = (KeystoreManager)context.lookup("keystore");
                }
                catch (Exception ex) {
                    DeployableSecurityProtocolMessage.ID0010_NO_KEYSTORE_DST_SERVICE_JNDI.create((Object)ex.getClass().getName(), (Object)ex.getMessage()).log(500, CATEGORY, LOCATION, "init");
                }
            }
            if (dstService != null && keystoreManager != null) {
                DeployableAuthenticationContext authenticationContext = new DeployableAuthenticationContext(dstService, keystoreManager, this.ctx, this.invalidateAllSessions);
                this.setAuthenticationContext(authenticationContext);
            } else {
                DeployableSecurityProtocolMessage.ID0000_NO_KEYSTORE_DST_SERVICE.create().log(500, CATEGORY, LOCATION, "init");
            }
        }
        LOCATION.exiting();
    }

    public boolean handleRequest(AbstractMessage message, PropertyContext context) throws ClientProtocolException {
        String method = "handleRequest";
        PropertyContext config = context.getSubContext("bindingConfig");
        this.operationName = (String)config.getSubContext("input").getProperty("operationName");
        boolean transportRequestResult = this.transportSecurityHandleRequest(context);
        try {
            if (message != null && message instanceof ClientMimeMessage) {
                this.handleOutboundMessage(message, context);
            }
        }
        catch (Throwable ex) {
            String traceID = DeployableSecurityProtocolMessage.ID0600_NO_TRACE.create((Object)this.getClass().getName()).format();
            LogRecord traceLogRecord = LOCATION.catching(CATEGORY, ex);
            if (traceLogRecord != null) {
                traceID = traceLogRecord.getId().toString();
            }
            IDMessage errorMessage = DeployableSecurityProtocolMessage.ID0800_OUTBOUND_POLICY_ERROR.create(ex.getClass(), (Object)ex.getMessage(), (Object)traceID);
            errorMessage.log(500, CATEGORY, LOCATION, "handleRequest");
            throw new ClientProtocolException(errorMessage.format());
        }
        return transportRequestResult;
    }

    public boolean handleResponse(AbstractMessage message, PropertyContext context) throws ClientProtocolException {
        String method = "handleResponse";
        try {
            if (message != null && message instanceof ClientMimeMessage) {
                this.handleInboundMessage(message, context);
            }
        }
        catch (Throwable ex) {
            String traceID = DeployableSecurityProtocolMessage.ID0600_NO_TRACE.create((Object)this.getClass().getName()).format();
            LogRecord traceLogRecord = LOCATION.catching(CATEGORY, ex);
            if (traceLogRecord != null) {
                traceID = traceLogRecord.getId().toString();
            }
            IDMessage errorMessage = DeployableSecurityProtocolMessage.ID0900_INBOUND_POLICY_ERROR.create(ex.getClass(), (Object)ex.getMessage(), (Object)traceID);
            errorMessage.log(500, CATEGORY, LOCATION, "handleResponse");
            throw new ClientProtocolException(errorMessage.format());
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WSPolicy getProxyRequestPolicy(PropertyContext context) throws ConfigurationLockedException, NameNotFoundException, ConfigurationException, XMLBindException, ParserConfigurationException, SAXException, IOException {
        WSPolicy wSPolicy;
        PolicyInfoManagerInterface policyInfoManager;
        block17: {
            WSPolicy wSPolicy2;
            block16: {
                Object cfgHandler = null;
                PropertyContext features = context.getSubContext("featureConfig");
                if (features == null) return null;
                if ("yes".equals(features.getProperty("DynamicClient"))) {
                    WSPolicy wSPolicy3;
                    PolicyInfoManagerInterface policyInfoManager2;
                    block15: {
                        WSPolicy wSPolicy4;
                        block14: {
                            String logicalTarget = (String)features.getProperty("LogicalTarget");
                            if (logicalTarget == null) {
                                throw new IOException("logical target for dynamic clients not specified");
                            }
                            policyInfoManager2 = wssImpl.getPolicyInfoManager();
                            try {
                                String name = "sap.com/DynamicWSProxies/" + logicalTarget + "/default";
                                WSPolicyConfigurationData proxyConfiguration = policyInfoManager2.getProxyConfiguration(name);
                                PolicyInfoManagerInterface policyInfoManagerInterface = policyInfoManager2;
                                synchronized (policyInfoManagerInterface) {
                                    if ("None".equals(proxyConfiguration.getOutboundPolicyTemplate())) {
                                        wSPolicy4 = emptyPolicy;
                                        // MONITOREXIT @DISABLED, blocks:[0, 4, 12, 13] lbl16 : MonitorExitStatement: MONITOREXIT : var8_12
                                        Object var12_17 = null;
                                        break block14;
                                    }
                                    wSPolicy3 = policyInfoManager2.getProxyRequestPolicy(name);
                                }
                                break block15;
                            }
                            catch (Throwable throwable) {
                                Object var12_19 = null;
                                policyInfoManager2.closeAllConfigurations();
                                throw throwable;
                            }
                        }
                        policyInfoManager2.closeAllConfigurations();
                        return wSPolicy4;
                    }
                    Object var12_18 = null;
                    policyInfoManager2.closeAllConfigurations();
                    return wSPolicy3;
                }
                if (features.getProperty("RuntimeInfo") == null) {
                    return null;
                }
                RuntimeInformation runtimInfo = (RuntimeInformation)context.getSubContext("featureConfig").getProperty("RuntimeInfo");
                PropertyContext config = context.getSubContext("bindingConfig");
                String operationName = (String)config.getSubContext("input").getProperty("operationName");
                String outboundPolicyTemplate = "None";
                LogicalPortType logicalPortType = runtimInfo.getLogicalPortType();
                LocalFeatures localFeatures = logicalPortType.getLocalFeatures();
                OperationType operationType = localFeatures.getOperation(operationName);
                FeatureType wssFeature = operationType.getFeature("http://www.sap.com/webas/630/soap/features/wss");
                if (wssFeature != null && wssFeature.getProperty("RequestPolicy") != null && "None".equals(outboundPolicyTemplate = wssFeature.getProperty("RequestPolicy").getValue())) {
                    return emptyPolicy;
                }
                String applicationName = runtimInfo.getApplicationName() + "/" + runtimInfo.getJndiName() + "*" + runtimInfo.getLogicalPortName() + "/" + operationName;
                policyInfoManager = wssImpl.getPolicyInfoManager();
                try {
                    PolicyInfoManagerInterface policyInfoManagerInterface = policyInfoManager;
                    synchronized (policyInfoManagerInterface) {
                        if ("None".equals(policyInfoManager.getProxyConfiguration(applicationName).getOutboundPolicyTemplate())) {
                            wSPolicy2 = emptyPolicy;
                            // MONITOREXIT @DISABLED, blocks:[2, 5, 11] lbl53 : MonitorExitStatement: MONITOREXIT : var14_25
                            Object var19_27 = null;
                            break block16;
                        }
                        wSPolicy = policyInfoManager.getProxyRequestPolicy(applicationName);
                    }
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var19_29 = null;
                    policyInfoManager.closeAllConfigurations();
                    throw throwable;
                }
            }
            policyInfoManager.closeAllConfigurations();
            return wSPolicy2;
        }
        Object var19_28 = null;
        policyInfoManager.closeAllConfigurations();
        return wSPolicy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WSPolicy getProxyResponsePolicy(PropertyContext context) throws ConfigurationLockedException, NameNotFoundException, ConfigurationException, XMLBindException, ParserConfigurationException, SAXException, IOException {
        WSPolicy wSPolicy;
        PolicyInfoManagerInterface policyInfoManager;
        block17: {
            WSPolicy wSPolicy2;
            block16: {
                Object cfgHandler = null;
                PropertyContext features = context.getSubContext("featureConfig");
                if (features == null) return null;
                if ("yes".equals(features.getProperty("DynamicClient"))) {
                    WSPolicy wSPolicy3;
                    PolicyInfoManagerInterface policyInfoManager2;
                    block15: {
                        WSPolicy wSPolicy4;
                        block14: {
                            String logicalTarget = (String)features.getProperty("LogicalTarget");
                            if (logicalTarget == null) {
                                throw new IOException("logical target for dynamic clients not specified");
                            }
                            policyInfoManager2 = wssImpl.getPolicyInfoManager();
                            try {
                                String name = "sap.com/DynamicWSProxies/" + logicalTarget + "/default";
                                WSPolicyConfigurationData proxyConfiguration = policyInfoManager2.getProxyConfiguration(name);
                                PolicyInfoManagerInterface policyInfoManagerInterface = policyInfoManager2;
                                synchronized (policyInfoManagerInterface) {
                                    if ("None".equals(proxyConfiguration.getOutboundPolicyTemplate())) {
                                        wSPolicy4 = emptyPolicy;
                                        // MONITOREXIT @DISABLED, blocks:[0, 4, 12, 13] lbl16 : MonitorExitStatement: MONITOREXIT : var8_12
                                        Object var12_17 = null;
                                        break block14;
                                    }
                                    wSPolicy3 = policyInfoManager2.getProxyRequestPolicy(name);
                                }
                                break block15;
                            }
                            catch (Throwable throwable) {
                                Object var12_19 = null;
                                policyInfoManager2.closeAllConfigurations();
                                throw throwable;
                            }
                        }
                        policyInfoManager2.closeAllConfigurations();
                        return wSPolicy4;
                    }
                    Object var12_18 = null;
                    policyInfoManager2.closeAllConfigurations();
                    return wSPolicy3;
                }
                if (features.getProperty("RuntimeInfo") == null) {
                    return null;
                }
                RuntimeInformation runtimInfo = (RuntimeInformation)context.getSubContext("featureConfig").getProperty("RuntimeInfo");
                String inboundPolicyTemplate = "None";
                LogicalPortType logicalPortType = runtimInfo.getLogicalPortType();
                LocalFeatures localFeatures = logicalPortType.getLocalFeatures();
                OperationType operationType = localFeatures.getOperation(this.operationName);
                FeatureType wssFeature = operationType.getFeature("http://www.sap.com/webas/630/soap/features/wss");
                if (wssFeature != null && wssFeature.getProperty("ResponsePolicy") != null && "None".equals(inboundPolicyTemplate = wssFeature.getProperty("ResponsePolicy").getValue())) {
                    return emptyPolicy;
                }
                String applicationName = runtimInfo.getApplicationName() + "/" + runtimInfo.getJndiName() + "*" + runtimInfo.getLogicalPortName() + "/" + this.operationName;
                policyInfoManager = wssImpl.getPolicyInfoManager();
                try {
                    PolicyInfoManagerInterface policyInfoManagerInterface = policyInfoManager;
                    synchronized (policyInfoManagerInterface) {
                        if ("None".equals(policyInfoManager.getProxyConfiguration(applicationName).getInboundPolicyTemplate())) {
                            wSPolicy2 = emptyPolicy;
                            // MONITOREXIT @DISABLED, blocks:[2, 5, 11] lbl51 : MonitorExitStatement: MONITOREXIT : var12_20
                            Object var17_25 = null;
                            break block16;
                        }
                        wSPolicy = policyInfoManager.getProxyResponsePolicy(applicationName);
                    }
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var17_27 = null;
                    policyInfoManager.closeAllConfigurations();
                    throw throwable;
                }
            }
            policyInfoManager.closeAllConfigurations();
            return wSPolicy2;
        }
        Object var17_26 = null;
        policyInfoManager.closeAllConfigurations();
        return wSPolicy;
    }

    /*
     * Unable to fully structure code
     */
    private boolean transportSecurityHandleRequest(PropertyContext context) throws ClientProtocolException {
        method = "transportSecurityHandleRequest";
        DeployableSecurityProtocol.LOCATION.entering("transportSecurityHandleRequest", new Object[]{context});
        if (!this.initialized) {
            this.init(context);
        }
        featureContext = context.getSubContext("featureConfig");
        authenticationContext = null;
        if (featureContext != null) {
            authenticationContext = featureContext.getSubContext("http://www.sap.com/webas/630/soap/features/authentication");
        }
        if ((authenticationMechanism = (String)authenticationContext.getProperty("AuthenticationMechanism")) == null) {
            authenticationMechanism = "HTTP";
        }
        if ("yes".equals(featureContext.getProperty("DynamicClient"))) {
            block27: {
                logicalTarget = (String)featureContext.getProperty("LogicalTarget");
                if (logicalTarget == null) {
                    throw new ClientProtocolException("logical target for dynamic clients not specified");
                }
                dplAuthenticationContext = (DeployableAuthenticationContext)this.getAuthenticationContext();
                name = "sap.com/DynamicWSProxies/" + logicalTarget;
                if (dplAuthenticationContext != null) {
                    try {
                        dplAuthenticationContext.setDestination(name, context);
                    }
                    catch (Throwable ex) {
                        exceptionMessage = DeployableSecurityProtocolMessage.ID0110_DST_LOOKUP_FAILED.create((Object)name, (Object)ex.getClass().getName(), (Object)ex.getMessage());
                        exceptionMessage.log(500, DeployableSecurityProtocol.CATEGORY, DeployableSecurityProtocol.LOCATION, "transportSecurityHandleRequest");
                        throw new ClientProtocolException(exceptionMessage.formatNonLocalized());
                    }
                }
                dstService = null;
                destinationUrl = null;
                if (this.serviceContext != null) {
                    dstService = (DestinationService)this.serviceContext.getContainerContext().getObjectRegistry().getServiceInterface("tc~sec~destinations~service");
                }
                if (dstService != null) {
                    try {
                        destination = (HTTPDestination)dstService.getDestination("WebService", name);
                        destinationUrl = destination.getUrl();
                        if (destinationUrl == null) {
                            throw new Exception("Destination URL is null.");
                        }
                        break block27;
                    }
                    catch (Exception e) {
                        msg = DeployableSecurityProtocolMessage.ID0110_DST_LOOKUP_FAILED.create((Object)name, null, null);
                        msg.log(500, DeployableSecurityProtocol.CATEGORY, DeployableSecurityProtocol.LOCATION, "transportSecurityHandleRequest");
                        throw new ClientProtocolException(msg.formatNonLocalized());
                    }
                }
                DeployableSecurityProtocolMessage.ID0000_NO_KEYSTORE_DST_SERVICE.create().log(500, DeployableSecurityProtocol.CATEGORY, DeployableSecurityProtocol.LOCATION, "transportSecurityHandleRequest");
            }
            http = (HTTPTransportInterface)context.getProperty("transportInterface");
            endpointUrl = http.getEndpoint();
            try {
                endpointUrlObject = new URL(endpointUrl);
                destinationUrlObject = new URL(destinationUrl);
                protocol = destinationUrlObject.getProtocol();
                host = destinationUrlObject.getHost();
                port = destinationUrlObject.getPort();
                file = endpointUrlObject.getFile();
                result = new URL(protocol, host, port, file);
                http.setEndpoint(result.toString());
            }
            catch (Exception e) {
                msg = DeployableSecurityProtocolMessage.ID0700_DYNAMIC_URL_ERROR.create((Object)name, (Object)e.getClass().getName(), (Object)e.getMessage());
                msg.log(500, DeployableSecurityProtocol.CATEGORY, DeployableSecurityProtocol.LOCATION, "transportSecurityHandleRequest");
                throw new ClientProtocolException(msg.formatNonLocalized());
            }
        }
        if (this.customDestinationName != null) {
            dstService = null;
            if (this.serviceContext != null) {
                dstService = (DestinationService)this.serviceContext.getContainerContext().getObjectRegistry().getServiceInterface("tc~sec~destinations~service");
            }
            if (dstService != null) {
                try {
                    destination = (HTTPDestination)dstService.getDestination("HTTP", this.customDestinationName);
                    dplAuthenticationContext = (DeployableAuthenticationContext)this.getAuthenticationContext();
                    dplAuthenticationContext.setDestination(this.customDestinationName, context);
                    http = (HTTPTransportInterface)context.getProperty("transportInterface");
                    if (this.customUrlPostfix == null && !"".equals(destination.getUrl().trim())) {
                        http.setEndpoint(destination.getUrl());
                    }
                    if (this.customUrlPostfix == null || "".equals(destination.getUrl().trim())) ** GOTO lbl99
                    http.setEndpoint(destination.getUrl() + this.customUrlPostfix);
                }
                catch (Throwable ex) {
                    exceptionMessage = DeployableSecurityProtocolMessage.ID0110_DST_LOOKUP_FAILED.create((Object)this.customDestinationName, (Object)ex.getClass().getName(), (Object)ex.getMessage());
                    exceptionMessage.log(500, DeployableSecurityProtocol.CATEGORY, DeployableSecurityProtocol.LOCATION, "transportSecurityHandleRequest");
                    throw new ClientProtocolException(exceptionMessage.formatNonLocalized());
                }
            }
        } else if (!this.ignoreDefaultDestination && featureContext != null && featureContext.getProperty("RuntimeInfo") != null) {
            runtimInfo = (RuntimeInformation)featureContext.getProperty("RuntimeInfo");
            name = runtimInfo.getApplicationName() + "/" + runtimInfo.getJndiName() + "/" + runtimInfo.getLogicalPortName();
            dplAuthenticationContext = (DeployableAuthenticationContext)this.getAuthenticationContext();
            DeployableSecurityProtocolMessage.ID0100_DST_FOUND.create((Object)name).log(200, DeployableSecurityProtocol.CATEGORY, DeployableSecurityProtocol.LOCATION, "transportSecurityHandleRequest");
            if (dplAuthenticationContext != null) {
                try {
                    dplAuthenticationContext.setDestination(name, context);
                }
                catch (Throwable ex) {
                    exceptionMessage = DeployableSecurityProtocolMessage.ID0110_DST_LOOKUP_FAILED.create((Object)name, (Object)ex.getClass().getName(), (Object)ex.getMessage());
                    exceptionMessage.log(500, DeployableSecurityProtocol.CATEGORY, DeployableSecurityProtocol.LOCATION, "transportSecurityHandleRequest");
                    throw new ClientProtocolException(exceptionMessage.formatNonLocalized());
                }
            }
        }
lbl99:
        // 9 sources

        authenticationHeadersHashtable = this.getAuthenticationContext().getHttpHeaderHashtable();
        headerNamesEnumeration = authenticationHeadersHashtable.keys();
        while (headerNamesEnumeration.hasMoreElements()) {
            name = (String)headerNamesEnumeration.nextElement();
            value = (String)authenticationHeadersHashtable.get(name);
            this.addHeader(name, value);
        }
        this.internalSetHTTPHeaders(context);
        DeployableSecurityProtocol.LOCATION.exiting((Object)"true");
        return true;
    }

    public void handleInboundMessage(AbstractMessage message, PropertyContext context) throws DOMException, ParserException, Exception {
        if (!(message instanceof ClientMimeMessage)) {
            return;
        }
        ClientMimeMessage mimeMessage = (ClientMimeMessage)message;
        ClientSOAPMessage soapMessage = mimeMessage.getSOAPMessage();
        if (soapMessage.isEmptyBody()) {
            return;
        }
        WSPolicy policy = null;
        policy = this.getProxyResponsePolicy(context);
        if (policy == emptyPolicy) {
            return;
        }
        ArrayList soapHeaderList = soapMessage.getHeaders();
        Document soapDocument = documentBuilder.newDocument();
        Element envelopeElement = soapDocument.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:Envelope");
        Element headerElement = soapDocument.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:Header");
        Element originalBodyElement = soapMessage.getSoapBody();
        Element bodyElement = (Element)soapDocument.importNode(originalBodyElement, true);
        int i = 0;
        while (i < soapHeaderList.size()) {
            headerElement.appendChild(soapDocument.importNode((Node)soapHeaderList.get(i), true));
            ++i;
        }
        envelopeElement.appendChild(headerElement);
        envelopeElement.appendChild(bodyElement);
        soapDocument.appendChild(envelopeElement);
        WSSecurityContext sctx = new WSSecurityContext();
        wssImpl.verifyPolicy(soapDocument, policy, sctx);
        Element oldBodyElement = soapMessage.getSoapBody();
        while (oldBodyElement.getChildNodes().getLength() > 0) {
            oldBodyElement.removeChild(oldBodyElement.getFirstChild());
        }
        NodeList bodyChildNodeList = bodyElement.getChildNodes();
        Document oldBodyDocument = oldBodyElement.getOwnerDocument();
        int i2 = 0;
        while (i2 < bodyChildNodeList.getLength()) {
            Node importedNode = oldBodyDocument.importNode(bodyChildNodeList.item(i2), true);
            oldBodyElement.appendChild(importedNode);
            ++i2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleOutboundMessage(AbstractMessage message, PropertyContext context) throws ParserException, Exception {
        block11: {
            block10: {
                block9: {
                    String method = "handleOutboundMessage";
                    LOCATION.entering("handleOutboundMessage", new Object[0]);
                    if (!(message instanceof ClientMimeMessage)) return;
                    try {
                        NodeList nl;
                        WSPolicy policy = null;
                        ClientMimeMessage mimeMessage = (ClientMimeMessage)message;
                        ClientSOAPMessage soapMessage = mimeMessage.getSOAPMessage();
                        if (soapMessage.isEmptyBody()) {
                            Object var21_7 = null;
                            break block9;
                        }
                        policy = this.getProxyRequestPolicy(context);
                        if (policy == emptyPolicy) {
                            break block10;
                        }
                        Element soapBody = soapMessage.getSoapBody();
                        Document soapDocument = soapBody.getOwnerDocument();
                        int nsCounter = 0;
                        Iterator nsIterator = SecurityPolicyConstants.getWSUNamespaces().iterator();
                        while (true) {
                            if (!nsIterator.hasNext()) {
                                WSSecurityContext sctx = new WSSecurityContext();
                                WSSecurityDocument wsDocument = wssImpl.applyPolicy(soapDocument, policy, sctx);
                                nl = soapDocument.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
                                if (nl.getLength() != 0) break;
                                throw new ClientProtocolException(this.getClass().getName() + ": No Envelope element found for namespace " + "http://schemas.xmlsoap.org/soap/envelope/");
                            }
                            String namespace = (String)nsIterator.next();
                            Attr idAttribute = soapDocument.createAttributeNS(namespace, "wsu" + nsCounter + ":Id");
                            idAttribute.setNodeValue("body");
                            soapBody.setAttributeNodeNS(idAttribute);
                            ++nsCounter;
                        }
                        Element envelopeElement = (Element)nl.item(0);
                        NodeList headerNodeList = envelopeElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
                        if (headerNodeList.getLength() == 0) {
                            throw new ClientProtocolException(this.getClass().getName() + ": No Header element found for namespace " + "http://schemas.xmlsoap.org/soap/envelope/");
                        }
                        Element headerElement = (Element)headerNodeList.item(0);
                        ArrayList soapHeadersList = soapMessage.getHeaders();
                        while (true) {
                            if (headerElement.getChildNodes().getLength() <= 0) {
                                break block11;
                            }
                            NodeList headerChildsNodeList = headerElement.getChildNodes();
                            Node node = headerChildsNodeList.item(0);
                            headerElement.removeChild(node);
                            soapHeadersList.add(node);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var21_10 = null;
                        LOCATION.exiting();
                        throw throwable;
                    }
                }
                LOCATION.exiting();
                return;
            }
            Object var21_8 = null;
            LOCATION.exiting();
            return;
        }
        Object var21_9 = null;
        LOCATION.exiting();
    }

    private void createDestination(PropertyContext propertyContext) {
        String method = "createDestination";
        LOCATION.entering("createDestination");
        String ideUsername = null;
        String ideClientCertificateKeystoreView = null;
        String ideClientCertificateAlias = null;
        String ideAuthenticationMethod = null;
        String authenticationMechanism = "HTTP";
        if (propertyContext.getSubContext("http://www.sap.com/webas/630/soap/features/authentication") != null) {
            ideUsername = (String)propertyContext.getSubContext("http://www.sap.com/webas/630/soap/features/authentication").getProperty("AuthenticationCredentialUser");
            ideClientCertificateKeystoreView = (String)propertyContext.getSubContext("http://www.sap.com/webas/630/soap/features/authentication").getProperty("clientKeystore");
            ideClientCertificateAlias = (String)propertyContext.getSubContext("http://www.sap.com/webas/630/soap/features/authentication").getProperty("certName");
            ideAuthenticationMethod = (String)propertyContext.getSubContext("http://www.sap.com/webas/630/soap/features/authentication").getProperty("AuthenticationMethod");
            authenticationMechanism = (String)propertyContext.getSubContext("http://www.sap.com/webas/630/soap/features/authentication").getProperty("AuthenticationMechanism");
        }
        if (ideUsername == null) {
            ideUsername = "";
        }
        if (ideClientCertificateKeystoreView == null) {
            ideClientCertificateKeystoreView = "";
        }
        if (ideClientCertificateAlias == null) {
            ideClientCertificateAlias = "";
        }
        if (authenticationMechanism == null) {
            authenticationMechanism = "HTTP";
        }
        if (propertyContext.getProperty("RuntimeInfo") != null) {
            RuntimeInformation runtimInfo = (RuntimeInformation)propertyContext.getProperty("RuntimeInfo");
            String name = runtimInfo.getApplicationName() + "/" + runtimInfo.getJndiName() + "/" + runtimInfo.getLogicalPortName();
            String url = runtimInfo.getEndpoint();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                DestinationService dstService = (DestinationService)this.serviceContext.getContainerContext().getObjectRegistry().getServiceInterface("tc~sec~destinations~service");
                if (dstService != null) {
                    HTTPDestinationImpl destination = null;
                    boolean dstExists = dstService.getDestinationNames("WebService").contains(name);
                    if (dstExists) {
                        destination = (HTTPDestinationImpl)dstService.getDestination("WebService", name);
                        destination.setDefaultUrl(url);
                        destination.setName(name);
                        dstService.updateDestination("WebService", (Destination)destination);
                        DeployableSecurityProtocolMessage.ID0210_UPDATE_DST.create((Object)name).log(200, CATEGORY, LOCATION, "createDestination");
                    } else {
                        destination = (HTTPDestinationImpl)dstService.createDestination("WebService");
                        destination.setDefaultUrl(url);
                        destination.setUrl(url);
                        destination.setName(name);
                        destination.setUrlChoice("Default");
                        if ("HTTP".equals(authenticationMechanism)) {
                            if ("BasicAuth".equals(ideAuthenticationMethod)) {
                                destination.setUsernamePassword(ideUsername, "");
                            }
                            if ("CertAuth".equals(ideAuthenticationMethod)) {
                                destination.setClientCertificateAuthentication(ideClientCertificateKeystoreView, ideClientCertificateAlias);
                            }
                            if ("SSO2Auth".equals(ideAuthenticationMethod)) {
                                destination.setSSO2Authentication();
                            }
                        }
                        dstService.storeDestination("WebService", (Destination)destination);
                        DeployableSecurityProtocolMessage.ID0220_CREATE_DST.create((Object)name).log(200, CATEGORY, LOCATION, "createDestination");
                    }
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                } else {
                    DeployableSecurityProtocolMessage.ID0105_DST_NOT_STARTED.create((Object)name).log(500, CATEGORY, LOCATION, "createDestination");
                    LOCATION.exiting((Object)"onStartApplication: Destination service not running");
                }
            }
            catch (Throwable ex) {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                DeployableSecurityProtocolMessage.ID0200_ERROR_CREATE_DST.create((Object)name, (Object)ex.getClass().getName(), (Object)ex).log(500, CATEGORY, LOCATION, "createDestination");
                LOCATION.exiting((Object)ex);
            }
        }
        LOCATION.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSLD(PropertyContext propertyContext) {
        block10: {
            block9: {
                String method = "updateSLD";
                LOCATION.entering("updateSLD");
                RuntimeInformation runtimInfo = (RuntimeInformation)propertyContext.getProperty("RuntimeInfo");
                String name = runtimInfo.getApplicationName() + "/" + runtimInfo.getJndiName() + "/" + runtimInfo.getLogicalPortName();
                DestinationService dstService = (DestinationService)this.serviceContext.getContainerContext().getObjectRegistry().getServiceInterface("tc~sec~destinations~service");
                HTTPDestinationImpl destination = null;
                try {
                    try {
                        destination = (HTTPDestinationImpl)dstService.getDestination("WebService", name);
                        if (!"SLD".equals(destination.getUrlChoice())) {
                            Object var15_7 = null;
                            break block9;
                        }
                        destination.setSldUrl("");
                        dstService.updateDestination("WebService", (Destination)destination);
                        String applicationName = runtimInfo.getApplicationName();
                        String jndiName = runtimInfo.getJndiName();
                        String logicalPortName = runtimInfo.getLogicalPortName();
                        String sysName = destination.getSLDSystemName();
                        if (sysName.trim().equals("")) {
                            sysName = null;
                        }
                        SLDLogicalPort lp = new SLDLogicalPort();
                        lp.setSystemName(sysName);
                        lp.setWSName(destination.getSLDWSName());
                        lp.setWSPortName(destination.getSLDWSPort());
                        DeployableSecurityProtocolMessage.ID0300_SLD_LOOKUP.create((Object)name, (Object)destination.getSLDSystemName(), (Object)destination.getSLDWSName(), (Object)destination.getSLDWSPort()).log(300, CATEGORY, LOCATION, "updateSLD");
                        WebServiceInterface wsi = (WebServiceInterface)this.serviceContext.getContainerContext().getObjectRegistry().getProvidedInterface("webservices");
                        LogicalPortType lpt = (LogicalPortType)wsi.updateWSClientFromSLD(applicationName, jndiName, logicalPortName, lp);
                        if (lpt != null) {
                            destination.setSldUrl(lpt.getEndpoint());
                            dstService.updateDestination("WebService", (Destination)destination);
                            DeployableSecurityProtocolMessage.ID0310_SLD_UPDATED.create((Object)name, (Object)lpt.getEndpoint()).log(300, CATEGORY, LOCATION, "updateSLD");
                            break block10;
                        } else {
                            DeployableSecurityProtocolMessage.ID0330_SLD_RETURNED_NULL.create((Object)name, (Object)destination.getSLDSystemName(), (Object)destination.getSLDWSName(), (Object)destination.getSLDWSPort()).log(500, CATEGORY, LOCATION, "updateSLD");
                        }
                        break block10;
                    }
                    catch (Throwable e) {
                        DeployableSecurityProtocolMessage.ID0320_SLD_FAILED.create((Object)name, (Object)e.getClass().getName(), (Object)e.getMessage()).log(500, CATEGORY, LOCATION, "updateSLD");
                        Object var15_9 = null;
                        LOCATION.exiting();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var15_10 = null;
                    LOCATION.exiting();
                    throw throwable;
                }
            }
            LOCATION.exiting();
            return;
        }
        Object var15_8 = null;
        LOCATION.exiting();
    }

    private ServerInternalLocking getLockingContext(ApplicationServiceContext serviceContext) throws TechnicalLockException, IllegalArgumentException {
        if (this._serverInternalLocking == null) {
            this.lockingContext = serviceContext.getCoreContext().getLockingContext();
            this._serverInternalLocking = this.lockingContext.createServerInternalLocking(this.lockNameSpace, this.lockDescription);
        }
        return this._serverInternalLocking;
    }

    /*
     * Loose catch block
     */
    public void onStartApplication(PropertyContext propertyContext) {
        block10: {
            String method = "onStartApplication";
            ServerInternalLocking serverInternalLocking = null;
            RuntimeInformation runtimInfo = (RuntimeInformation)propertyContext.getProperty("RuntimeInfo");
            String lockingArgument = "DeployableSecurityProtocol";
            String applicationName = runtimInfo.getApplicationName();
            if (this.lockingEnabled) {
                if (lockingArgument.length() > 150) {
                    lockingArgument = lockingArgument.substring(0, 149);
                }
                serverInternalLocking = this.getLockingContext(this.serviceContext);
                serverInternalLocking.lock(this.lockNameSpace, lockingArgument, 'X', this.lockingTimeout);
            }
            this.createDestination(propertyContext);
            this.updateSLD(propertyContext);
            this.updateURL(propertyContext);
            Object var9_7 = null;
            try {
                serverInternalLocking.unlock(this.lockNameSpace, lockingArgument, 'X');
            }
            catch (Exception e2) {
                DeployableSecurityProtocolMessage.ID0400_ERROR_RELEASING_LOCK.create((Object)applicationName, (Object)e2.getClass().getName(), (Object)e2.getMessage()).log(500, CATEGORY, LOCATION, method);
            }
            break block10;
            {
                catch (Exception e) {
                    DeployableSecurityProtocolMessage.ID0450_ERROR_LOCK_EXCEPTION.create((Object)applicationName).log(500, CATEGORY, LOCATION, method);
                    Object var9_8 = null;
                    try {
                        serverInternalLocking.unlock(this.lockNameSpace, lockingArgument, 'X');
                    }
                    catch (Exception e2) {
                        DeployableSecurityProtocolMessage.ID0400_ERROR_RELEASING_LOCK.create((Object)applicationName, (Object)e2.getClass().getName(), (Object)e2.getMessage()).log(500, CATEGORY, LOCATION, method);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    serverInternalLocking.unlock(this.lockNameSpace, lockingArgument, 'X');
                }
                catch (Exception e2) {
                    DeployableSecurityProtocolMessage.ID0400_ERROR_RELEASING_LOCK.create((Object)applicationName, (Object)e2.getClass().getName(), (Object)e2.getMessage()).log(500, CATEGORY, LOCATION, method);
                }
                throw throwable;
            }
        }
    }

    private void updateURL(PropertyContext propertyContext) {
        block10: {
            String method = "updateURL";
            LOCATION.entering("updateURL");
            Object ideAuthenticationMethod = null;
            String authenticationMechanism = "HTTP";
            if (authenticationMechanism == null) {
                authenticationMechanism = "HTTP";
            }
            if (propertyContext.getProperty("RuntimeInfo") != null) {
                RuntimeInformation runtimInfo = (RuntimeInformation)propertyContext.getProperty("RuntimeInfo");
                String name = runtimInfo.getApplicationName() + "/" + runtimInfo.getJndiName() + "/" + runtimInfo.getLogicalPortName();
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    DestinationService dstService = (DestinationService)this.serviceContext.getContainerContext().getObjectRegistry().getServiceInterface("tc~sec~destinations~service");
                    if (dstService != null) {
                        HTTPDestinationImpl destination = null;
                        boolean dstExists = dstService.getDestinationNames("WebService").contains(name);
                        if (dstExists) {
                            destination = (HTTPDestinationImpl)dstService.getDestination("WebService", name);
                            try {
                                if (!"Default".equals(destination.getUrlChoice())) {
                                    WebServiceInterface wsInterface = (WebServiceInterface)this.serviceContext.getContainerContext().getObjectRegistry().getProvidedInterface("webservices");
                                    String url = destination.getUrl();
                                    if ("SLD".equals(destination.getUrlChoice())) {
                                        url = destination.getSldUrl();
                                    }
                                    wsInterface.changeEndpointURL(runtimInfo.getApplicationName(), runtimInfo.getJndiName(), runtimInfo.getLogicalPortName(), url);
                                }
                            }
                            catch (Throwable ex) {
                                LOCATION.exiting((Object)ex);
                            }
                        }
                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                        break block10;
                    }
                    LOCATION.exiting((Object)"updateURL: Destination service not running");
                }
                catch (Throwable ex) {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                    LOCATION.exiting((Object)ex);
                }
            }
        }
        LOCATION.exiting();
    }

    public boolean isIgnoreDefaultDestination() {
        return this.ignoreDefaultDestination;
    }

    public void setIgnoreDefaultDestination(boolean b) {
        this.ignoreDefaultDestination = b;
    }

    public void onDeploy(String applicationName, String wsClientName, WSClientBaseContext wsClientContext, String dir, Configuration wsClientConfiguration) throws WSDeploymentException, WSWarningException {
    }

    /*
     * Loose catch block
     */
    public void onPostDeploy(String applicationName, String wsClientName, WSClientContext wsClientContext, String dir, Configuration wsClientConfiguration) throws WSDeploymentException, WSWarningException {
        block34: {
            String method = "onPostDeploy";
            ServerInternalLocking serverInternalLocking = null;
            String lockingArgument = "DeployableSecurityProtocol";
            Object logicalPortName = null;
            WSPolicyConfigurationData proxyConfiguration = null;
            if (this.lockingEnabled) {
                if (lockingArgument.length() > 150) {
                    lockingArgument = lockingArgument.substring(0, 149);
                }
                serverInternalLocking = this.getLockingContext(this.serviceContext);
                serverInternalLocking.lock(this.lockNameSpace, lockingArgument, 'X', this.lockingTimeout);
            }
            ConfigurationHandler cfgHandler = this.serviceContext.getCoreContext().getConfigurationHandlerFactory().getConfigurationHandler();
            PolicyInfoManagerImpl policyInfoManager = new PolicyInfoManagerImpl(cfgHandler);
            PropertyContext[] propCtx = (PropertyContext[])wsClientContext.getLPPropertyContexts();
            int propIndex = 0;
            while (propIndex < propCtx.length) {
                RuntimeInformation runtimeInfo = (RuntimeInformation)propCtx[propIndex].getProperty("RuntimeInfo");
                LogicalPortType logicalPortType = runtimeInfo.getLogicalPortType();
                LocalFeatures localFeatures = logicalPortType.getLocalFeatures();
                OperationType[] operations = localFeatures.getOperation();
                int opIndex = 0;
                while (opIndex < operations.length) {
                    String name = applicationName + "/" + runtimeInfo.getJndiName() + "*" + runtimeInfo.getLogicalPortName() + "/" + operations[opIndex].getName();
                    try {
                        String outboundPolicyTemplate;
                        String inboundPolicyTemplate;
                        int tries;
                        boolean saved;
                        block33: {
                            saved = false;
                            tries = 0;
                            inboundPolicyTemplate = "None";
                            outboundPolicyTemplate = "None";
                            String operationName = operations[opIndex].getName();
                            FeatureType wssFeature = operations[opIndex].getFeature("http://www.sap.com/webas/630/soap/features/wss");
                            if (wssFeature != null) {
                                if (wssFeature.getProperty("RequestPolicy") != null) {
                                    outboundPolicyTemplate = wssFeature.getProperty("RequestPolicy").getValue();
                                }
                                if (wssFeature.getProperty("ResponsePolicy") != null) {
                                    inboundPolicyTemplate = wssFeature.getProperty("ResponsePolicy").getValue();
                                }
                            }
                            String defaultInboundProfile = "None";
                            if (!"None".equals(inboundPolicyTemplate)) {
                                defaultInboundProfile = "default_" + inboundPolicyTemplate;
                            }
                            String defaultOutboundProfile = "None";
                            List inboundProfiles = policyInfoManager.getPolicyProfileNames("webservices/security/wss/policy-profiles/inbound", inboundPolicyTemplate);
                            List outboundProfiles = policyInfoManager.getPolicyProfileNames("webservices/security/wss/policy-profiles/outbound", outboundPolicyTemplate);
                            if (!inboundProfiles.isEmpty() && !outboundProfiles.isEmpty()) {
                                try {
                                    proxyConfiguration = policyInfoManager.getProxyRedeployConfiguration(name);
                                    String inProfileOld = proxyConfiguration.getInboundPolicyProfile();
                                    String outProfileOld = proxyConfiguration.getOutboundPolicyProfile();
                                    String inTemplateOld = proxyConfiguration.getInboundPolicyTemplate();
                                    String outTemplateOld = proxyConfiguration.getOutboundPolicyTemplate();
                                    if (inTemplateOld.equals(inboundPolicyTemplate) && outTemplateOld.equals(outboundPolicyTemplate) && inboundProfiles.contains(inProfileOld) && outboundProfiles.contains(outProfileOld)) break block33;
                                    if (inboundProfiles.contains(defaultInboundProfile) && outboundProfiles.contains(defaultOutboundProfile)) {
                                        proxyConfiguration = policyInfoManager.createPolicyConfiguration(defaultInboundProfile, defaultOutboundProfile);
                                        break block33;
                                    }
                                    proxyConfiguration = policyInfoManager.createPolicyConfiguration("None", "None");
                                }
                                catch (NameNotFoundException e) {
                                    if (inboundProfiles.contains(defaultInboundProfile) && outboundProfiles.contains(defaultOutboundProfile)) {
                                        proxyConfiguration = policyInfoManager.createPolicyConfiguration(defaultInboundProfile, defaultOutboundProfile);
                                        break block33;
                                    }
                                    proxyConfiguration = policyInfoManager.createPolicyConfiguration("None", "None");
                                }
                                catch (Exception ex) {
                                    DeployableSecurityProtocolMessage.ID0430_ERROR_DEPLOYING_APPLICATION.create((Object)name, (Object)ex.getClass().getName(), (Object)ex.getMessage()).log(500, CATEGORY, LOCATION, method);
                                }
                            } else {
                                proxyConfiguration = policyInfoManager.createPolicyConfiguration("None", "None");
                            }
                        }
                        proxyConfiguration.setInboundPolicyTemplate(inboundPolicyTemplate);
                        proxyConfiguration.setOutboundPolicyTemplate(outboundPolicyTemplate);
                        while (!saved && tries < 3) {
                            ++tries;
                            try {
                                policyInfoManager.updateProxyConfiguration(proxyConfiguration, name);
                                saved = true;
                            }
                            catch (ConfigurationLockedException lockedException) {
                                Thread.sleep(1000L);
                                cfgHandler.closeAllConfigurations();
                                if (tries != 3) continue;
                                throw lockedException;
                            }
                        }
                        cfgHandler.closeAllConfigurations();
                    }
                    catch (Throwable ex) {
                        try {
                            if (cfgHandler != null) {
                                cfgHandler.closeAllConfigurations();
                            }
                        }
                        catch (ConfigurationException e) {
                            DeployableSecurityProtocolMessage.ID0500_CREATE_POLICY_ERROR.create((Object)name, (Object)ex.getClass().getName(), (Object)ex.getMessage()).log(500, CATEGORY, LOCATION, method);
                        }
                        DeployableSecurityProtocolMessage.ID0500_CREATE_POLICY_ERROR.create((Object)name, (Object)ex.getClass().getName(), (Object)ex.getMessage()).log(500, CATEGORY, LOCATION, method);
                    }
                    ++opIndex;
                }
                ++propIndex;
            }
            Object var36_42 = null;
            try {
                serverInternalLocking.unlock(this.lockNameSpace, lockingArgument, 'X');
            }
            catch (Exception e) {
                DeployableSecurityProtocolMessage.ID0400_ERROR_RELEASING_LOCK.create((Object)applicationName, (Object)e.getClass().getName(), (Object)e.getMessage()).log(500, CATEGORY, LOCATION, method);
            }
            break block34;
            {
                catch (LockException le) {
                    DeployableSecurityProtocolMessage.ID0450_ERROR_LOCK_EXCEPTION.create((Object)applicationName).log(500, CATEGORY, LOCATION, method);
                    Object var36_43 = null;
                    try {
                        serverInternalLocking.unlock(this.lockNameSpace, lockingArgument, 'X');
                    }
                    catch (Exception e) {
                        DeployableSecurityProtocolMessage.ID0400_ERROR_RELEASING_LOCK.create((Object)applicationName, (Object)e.getClass().getName(), (Object)e.getMessage()).log(500, CATEGORY, LOCATION, method);
                    }
                    break block34;
                }
                catch (Throwable t) {
                    DeployableSecurityProtocolMessage.ID0430_ERROR_DEPLOYING_APPLICATION.create((Object)applicationName, (Object)t.getClass().getName(), (Object)t.getMessage()).log(500, CATEGORY, LOCATION, method);
                    Object var36_44 = null;
                    try {
                        serverInternalLocking.unlock(this.lockNameSpace, lockingArgument, 'X');
                    }
                    catch (Exception e) {
                        DeployableSecurityProtocolMessage.ID0400_ERROR_RELEASING_LOCK.create((Object)applicationName, (Object)e.getClass().getName(), (Object)e.getMessage()).log(500, CATEGORY, LOCATION, method);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var36_45 = null;
                try {
                    serverInternalLocking.unlock(this.lockNameSpace, lockingArgument, 'X');
                }
                catch (Exception e) {
                    DeployableSecurityProtocolMessage.ID0400_ERROR_RELEASING_LOCK.create((Object)applicationName, (Object)e.getClass().getName(), (Object)e.getMessage()).log(500, CATEGORY, LOCATION, method);
                }
                throw throwable;
            }
        }
    }

    public void onCommitDeploy(String arg0, String arg1) throws WSWarningException {
    }

    public void onRollbackDeploy(String arg0, String arg1) throws WSWarningException {
    }

    /*
     * Loose catch block
     */
    public void onRemove(String applicationName) throws WSWarningException {
        block10: {
            ServerInternalLocking serverInternalLocking = null;
            String lockingArgument = "DeployableSecurityProtocol";
            if (lockingArgument.length() > 150) {
                lockingArgument = lockingArgument.substring(0, 149);
            }
            if (this.lockingEnabled) {
                serverInternalLocking = this.getLockingContext(this.serviceContext);
                serverInternalLocking.lock(this.lockNameSpace, lockingArgument, 'X', this.lockingTimeout);
            }
            ConfigurationHandler cfgHandler = this.serviceContext.getCoreContext().getConfigurationHandlerFactory().getConfigurationHandler();
            PolicyInfoManagerImpl policyInfoManager = new PolicyInfoManagerImpl(cfgHandler);
            policyInfoManager.deleteProxyConfiguration(applicationName);
            Object var7_8 = null;
            try {
                serverInternalLocking.unlock(this.lockNameSpace, lockingArgument, 'X');
            }
            catch (Exception e2) {
                String method2 = "onRemove";
                DeployableSecurityProtocolMessage.ID0400_ERROR_RELEASING_LOCK.create((Object)applicationName, (Object)e2.getClass().getName(), (Object)e2.getMessage()).log(500, CATEGORY, LOCATION, method2);
            }
            break block10;
            {
                catch (Throwable e) {
                    String method = "onRemove";
                    DeployableSecurityProtocolMessage.ID0440_ERROR_UNDEPLOYING_APPLICATION.create((Object)applicationName, (Object)e.getClass().getName(), (Object)e.getMessage()).log(500, CATEGORY, LOCATION, method);
                    Object var7_9 = null;
                    try {
                        serverInternalLocking.unlock(this.lockNameSpace, lockingArgument, 'X');
                    }
                    catch (Exception e2) {
                        String method2 = "onRemove";
                        DeployableSecurityProtocolMessage.ID0400_ERROR_RELEASING_LOCK.create((Object)applicationName, (Object)e2.getClass().getName(), (Object)e2.getMessage()).log(500, CATEGORY, LOCATION, method2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    serverInternalLocking.unlock(this.lockNameSpace, lockingArgument, 'X');
                }
                catch (Exception e2) {
                    String method2 = "onRemove";
                    DeployableSecurityProtocolMessage.ID0400_ERROR_RELEASING_LOCK.create((Object)applicationName, (Object)e2.getClass().getName(), (Object)e2.getMessage()).log(500, CATEGORY, LOCATION, method2);
                }
                throw throwable;
            }
        }
    }

    public void setHTTPDestination(String destinationName, String urlPostfix) throws OperationNotSupportedException {
        throw new OperationNotSupportedException(OperationNotSupportedMessage.ID0100_DEPLOYABLE_PROXY_NOT_SUPPORTED.create(), null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        emptyPolicy = new WSPolicy();
    }
}

