/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.jarm.sat;

import com.sap.tc.logging.perf.ISatRecord;
import com.sap.tc.logging.perf.PerfTracing;
import com.sap.tc.logging.perf.SatRecord;
import com.sap.util.monitor.jarm.ActionOverview;
import com.sap.util.monitor.jarm.CompSingleOverviewExt;
import com.sap.util.monitor.jarm.IJarmDataRecipient;
import com.sap.util.monitor.jarm.RequestOverviewExt;
import com.sap.util.monitor.jarm.sat.ISatCheck;

public class LogJarmDataRecipient
implements IJarmDataRecipient {
    private static PerfTracing perfTrace;
    private static boolean perfTraceAvail;
    private ISatCheck iSatCheck;
    private String logPath = "testLogSat";

    private LogJarmDataRecipient() {
    }

    protected LogJarmDataRecipient(ISatCheck iSatCheckParam) {
        this.iSatCheck = iSatCheckParam;
    }

    public int getRecipientType() {
        return 0;
    }

    public void notifyAtRequestEnd(RequestOverviewExt reqOverview) {
        SatRecord record = new SatRecord();
        if (!perfTraceAvail) {
            this.getPerfTraceObject();
        }
        record.provider = 1;
        this.logRequest(record, reqOverview);
        CompSingleOverviewExt[] compOverview = reqOverview.taskOverviewExt[0].compOverviewExt;
        record.userName = "N/A";
        int i = 0;
        while (i < reqOverview.reqComp) {
            record.seqNumber = i;
            this.logComponent(record, compOverview[i]);
            ++i;
        }
    }

    public boolean isTraceOn(String userName, String reqName) {
        return this.iSatCheck.isTraceOn(userName, reqName);
    }

    public boolean isTraceOn(String userName, String reqName, long duration, int outData) {
        return this.iSatCheck.isTraceOn(userName, reqName, duration, outData);
    }

    private synchronized void getPerfTraceObject() {
        if (!perfTraceAvail) {
            perfTrace = new PerfTracing();
            perfTraceAvail = true;
        }
    }

    private void logRequest(SatRecord record, RequestOverviewExt reqOverview) {
        record.recType = 10;
        record.name = reqOverview.reqName;
        record.userName = reqOverview.userName;
        record.state = reqOverview.reqStatus == 0 ? 0 : (reqOverview.reqStatus == 1 ? 1 : 2);
        record.startTS = reqOverview.reqTS;
        record.grossTime = reqOverview.reqTime;
        record.grossCpuTime = reqOverview.reqCpuTime;
        record.outData = reqOverview.reqOutData;
        record.numberOfSubRecords = reqOverview.reqComp;
        record.descr = reqOverview.reqDescr != null ? reqOverview.reqDescr : " ";
        perfTrace.logWrite((ISatRecord)record);
    }

    private void logComponent(SatRecord record, CompSingleOverviewExt compOverview) {
        int actionCount;
        record.recType = 11;
        record.level = compOverview.level;
        record.name = compOverview.compName;
        record.state = compOverview.compGrossTime != -1L ? 0 : 1;
        record.startTS = compOverview.compStartTS;
        record.grossTime = compOverview.compGrossTime;
        record.netTime = compOverview.compNetTime;
        record.grossCpuTime = compOverview.compGrossCpuTime;
        record.netCpuTime = compOverview.compNetCpuTime;
        record.outData = (int)compOverview.compOutData;
        record.numberOfSubRecords = actionCount = compOverview.actionOverview != null ? compOverview.actionOverview.length : 0;
        record.descr = compOverview.compDescr != null ? compOverview.compDescr : " ";
        record.prop = compOverview.compProps;
        perfTrace.logWrite((ISatRecord)record);
        record.recType = 12;
        record.level = -1;
        record.userName = "N/A";
        record.name = "N/A";
        record.numberOfSubRecords = -1;
        record.outData = -1;
        record.state = -1;
        record.netTime = -1L;
        record.grossTime = -1L;
        record.netCpuTime = -1L;
        record.grossCpuTime = -1L;
        record.descr = "N/A";
        record.prop = null;
        int i = 0;
        while (i < actionCount) {
            record.seqNumber = i;
            this.logAction(record, compOverview.actionOverview[i]);
            ++i;
        }
    }

    private void logAction(SatRecord record, ActionOverview actionOverview) {
        record.startTS = actionOverview.actionTS;
        record.descr = actionOverview.actionText;
        perfTrace.logWrite((ISatRecord)record);
    }
}

