/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.interfaces.webservices.runtime;

import java.io.Serializable;
import java.util.StringTokenizer;

public class HTTPProxy
implements Serializable {
    private String proxyHost;
    private int proxyPort = 80;
    private String proxyUser;
    private String proxyPass;
    private String excludeList;
    private boolean bypassLocalAddresses = true;

    public String getExcludeList() {
        return this.excludeList;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setExcludeList(String excludeList) {
        this.excludeList = excludeList.toLowerCase();
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean useProxyForAddress(String address) {
        address = address.toLowerCase();
        if (this.bypassLocalAddresses && (address.indexOf(".") == -1 || "127.0.0.1".equals(address))) {
            return false;
        }
        return HTTPProxy.useProxyForSpecificAddress(address, this.excludeList);
    }

    private static boolean useProxyForSpecificAddress(String address, String excludeList) {
        if (excludeList == null || excludeList.trim().length() == 0) {
            return true;
        }
        StringTokenizer tokenizer = new StringTokenizer(excludeList, ";,| ", false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (!HTTPProxy.match(token, 0, address, 0)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean match(String pattern, int patternStart, String string, int stringStart) {
        int s = stringStart;
        int p = patternStart;
        while (true) {
            boolean pEnd;
            boolean sEnd = s >= string.length();
            boolean bl = pEnd = p >= pattern.length();
            if (sEnd && pEnd) {
                return true;
            }
            if (pEnd) {
                return false;
            }
            if (sEnd) {
                if (pattern.charAt(p) != '*') return false;
                --s;
            } else if (pattern.charAt(p) != '?') {
                if (pattern.charAt(p) == '*') {
                    if (++p >= pattern.length()) {
                        return true;
                    }
                    boolean bl2 = pEnd = false;
                    if (pEnd) {
                        return true;
                    }
                    int i = s;
                    while (i < string.length()) {
                        if (HTTPProxy.match(pattern, p, string, i)) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                if (pattern.charAt(p) != string.charAt(s)) {
                    return false;
                }
            }
            ++p;
            ++s;
        }
    }

    public boolean isBypassLocalAddresses() {
        return this.bypassLocalAddresses;
    }

    public void setBypassLocalAddresses(boolean b) {
        this.bypassLocalAddresses = b;
    }

    public String getProxyPass() {
        return this.proxyPass;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyPass(String proxyPass) {
        this.proxyPass = proxyPass;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }
}

