/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.smime;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.ContentInfoStream;
import iaik.pkcs.pkcs7.ContentStream;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.pkcs.pkcs7.SignedDataStream;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;

public class SMimeSigned
extends SignedDataStream {
    int a;
    AlgorithmID b = AlgorithmID.sha;

    public void writeTo(OutputStream outputStream, int n) throws IOException {
        this.block_size = n;
        try {
            DerCoder.encodeTo((ASN1Object)new ContentInfoStream((ContentStream)this).toASN1Object(), (OutputStream)outputStream);
            return;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.writeTo(outputStream, 2048);
    }

    public void verify(PublicKey publicKey) throws SignatureException {
        this.verify(publicKey, this.a);
    }

    public X509Certificate verify() throws SignatureException {
        return this.verify(this.a);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("mode: ");
        if (this.mode == 1) {
            stringBuffer.append("implicit\n");
        } else {
            stringBuffer.append("explicit\n");
        }
        stringBuffer.append(String.valueOf(super.toString()) + "\n\n");
        return stringBuffer.toString();
    }

    public byte[] toByteArray() throws PKCSException {
        return DerCoder.encode((ASN1Object)new ContentInfoStream((ContentStream)this).toASN1Object());
    }

    public ASN1Object toASN1Object() throws PKCSException {
        if (this.block_size < 0) {
            this.block_size = 2048;
        }
        return this.toASN1Object(this.block_size);
    }

    public int getMode() {
        return this.mode;
    }

    public void decode(InputStream inputStream) throws IOException {
        DerInputStream derInputStream;
        ObjectID objectID;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        if (!(objectID = (derInputStream = ((DerInputStream)inputStream).readSequence()).readObjectID()).equals((Object)ObjectID.pkcs7_signedData)) {
            throw new IOException("Content type not SignedData!");
        }
        DerInputStream derInputStream2 = derInputStream.readContextSpecific();
        try {
            super.decode((InputStream)derInputStream2);
            return;
        }
        catch (PKCSParsingException pKCSParsingException) {
            throw new IOException("Unable to parse SignedData!");
        }
    }

    public void addSigner(PrivateKey privateKey, IssuerAndSerialNumber issuerAndSerialNumber) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        Attribute[] attributeArray = new Attribute[3];
        attributeArray[0] = new Attribute(ObjectID.contentType, new ASN1Object[]{ObjectID.pkcs7_data});
        attributeArray[1] = new Attribute(ObjectID.signingTime, new ASN1Object[]{new ChoiceOfTime().toASN1Object()});
        SEQUENCE sEQUENCE = new SEQUENCE();
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        sEQUENCE2.addComponent((ASN1Object)AlgorithmID.des_EDE3_CBC.getAlgorithm());
        sEQUENCE.addComponent((ASN1Object)sEQUENCE2);
        sEQUENCE2 = new SEQUENCE();
        sEQUENCE2.addComponent((ASN1Object)AlgorithmID.rc2_CBC.getAlgorithm());
        sEQUENCE2.addComponent((ASN1Object)new INTEGER(128));
        sEQUENCE.addComponent((ASN1Object)sEQUENCE2);
        sEQUENCE2 = new SEQUENCE();
        sEQUENCE2.addComponent((ASN1Object)AlgorithmID.rc2_CBC.getAlgorithm());
        sEQUENCE2.addComponent((ASN1Object)new INTEGER(64));
        sEQUENCE.addComponent((ASN1Object)sEQUENCE2);
        sEQUENCE2 = new SEQUENCE();
        sEQUENCE2.addComponent((ASN1Object)AlgorithmID.rc2_CBC.getAlgorithm());
        sEQUENCE2.addComponent((ASN1Object)new INTEGER(40));
        sEQUENCE.addComponent((ASN1Object)sEQUENCE2);
        sEQUENCE2 = new SEQUENCE();
        sEQUENCE2.addComponent((ASN1Object)AlgorithmID.des_CBC.getAlgorithm());
        sEQUENCE.addComponent((ASN1Object)sEQUENCE2);
        attributeArray[2] = new Attribute(ObjectID.symmetricCapabilities, new ASN1Object[]{sEQUENCE});
        SignerInfo signerInfo = new SignerInfo(issuerAndSerialNumber, this.b, privateKey);
        signerInfo.setAuthenticatedAttributes(attributeArray);
        this.addSignerInfo(signerInfo);
    }

    public SMimeSigned(byte[] byArray, int n) throws IOException {
        this((InputStream)null, n);
        if (byArray != null) {
            this.setInputStream(new ByteArrayInputStream(byArray));
        }
    }

    public SMimeSigned(InputStream inputStream, AlgorithmID[] algorithmIDArray) throws IOException {
        super(inputStream, algorithmIDArray);
    }

    public SMimeSigned(InputStream inputStream, int n) throws IOException {
        super(inputStream, n);
    }

    public SMimeSigned(InputStream inputStream) throws IOException {
        this.decode(inputStream);
    }
}

