/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.smime;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs7.RecipientInfo;
import iaik.security.random.SecRandom;
import iaik.security.smime.SMimeEncrypted;
import iaik.security.smime.SMimeException;
import iaik.utils.SmtpException;
import iaik.utils.SmtpMailer;
import iaik.utils.Util;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class SMimeMailer
extends SmtpMailer {
    SecureRandom b;
    int c;
    int d;
    AlgorithmID e;
    Vector a;
    Vector f = new Vector();
    public static final int SIGNED_AND_ENCRYPTED = 3;
    public static final int SIGNED = 2;
    public static final int ENCRYPTED = 1;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("S/MIME EMail type: ");
        switch (this.c) {
            case 1: {
                stringBuffer.append("ENCRYPTED\n");
                break;
            }
            case 2: {
                stringBuffer.append("SIGNED\n");
                break;
            }
            case 3: {
                stringBuffer.append("SIGNED_AND_ENCRYPTED\n");
                break;
            }
            default: {
                stringBuffer.append("undefined\n");
            }
        }
        stringBuffer.append("Content encryption algorithm: ");
        stringBuffer.append(String.valueOf(this.e.getName()) + "\n");
        stringBuffer.append("Key length [bits]: " + this.d + "\n\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.b = secureRandom;
    }

    public void setFrom(String string, String string2, iaik.x509.X509Certificate x509Certificate, AlgorithmID algorithmID) {
        this.setFrom(string, string2);
        try {
            this.a.addElement(new RecipientInfo((X509Certificate)x509Certificate, algorithmID));
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return;
        }
    }

    public void setEncryption(AlgorithmID algorithmID, int n) {
        this.e = algorithmID;
        this.d = n;
    }

    public boolean sendMail() throws SmtpException {
        try {
            if (this.c == 1) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
                this.writeHeaders(printWriter);
                int n = 0;
                while (n < this.f.size()) {
                    printWriter.println(this.f.elementAt(n));
                    ++n;
                }
                this.writeBody(printWriter);
                SMimeEncrypted sMimeEncrypted = new SMimeEncrypted(byteArrayOutputStream.toByteArray(), this.e, this.d);
                Object[] objectArray = new RecipientInfo[this.a.size()];
                this.a.copyInto(objectArray);
                sMimeEncrypted.setRecipientInfos((RecipientInfo[])objectArray);
                if (this.b == null) {
                    this.b = SecRandom.getDefault();
                }
                byte[] byArray = Util.Base64Encode((byte[])sMimeEncrypted.toByteArray());
                this.setText(new String(byArray));
                byte[] byArray2 = new byte[10];
                this.b.nextBytes(byArray2);
                String string = Util.toString((byte[])byArray2);
                super.addAdditionalField("Message-ID: <" + string + ">");
                super.addAdditionalField("MIME-Version: 1.0");
                super.addAdditionalField("Content-Type: application/x-pkcs7-mime;");
                super.addAdditionalField("\tname=\"smime.p7m\"");
                super.addAdditionalField("Content-Transfer-Encoding: base64");
                super.addAdditionalField("Content-Disposition: attachment;");
                super.addAdditionalField("\tfilename=\"smime.p7m\"");
                return super.sendMail();
            }
            throw new SmtpException("At this time only SMIME_ENCRYPTED is implemented.");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SmtpException("Encryption Error: " + noSuchAlgorithmException.getMessage());
        }
        catch (SMimeException sMimeException) {
            throw new SmtpException("Encryption Error: " + ((Throwable)((Object)sMimeException)).getMessage());
        }
    }

    public void addTo(String string, String string2, iaik.x509.X509Certificate x509Certificate, AlgorithmID algorithmID) {
        this.addTo(string, string2);
        try {
            this.a.addElement(new RecipientInfo((X509Certificate)x509Certificate, algorithmID));
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return;
        }
    }

    public void addDate(Date date) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Date: ");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
        stringBuffer.append(simpleDateFormat.format(date));
        stringBuffer.append(" +");
        TimeZone timeZone = simpleDateFormat.getTimeZone();
        String string = String.valueOf(timeZone.getRawOffset() / 36000);
        int n = string.length();
        while (n++ < 4) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        this.addAdditionalField(stringBuffer.toString());
    }

    public void addDate() {
        this.addDate(new Date());
    }

    public void addCc(String string, String string2, iaik.x509.X509Certificate x509Certificate, AlgorithmID algorithmID) {
        this.addCc(string, string2);
        try {
            this.a.addElement(new RecipientInfo((X509Certificate)x509Certificate, algorithmID));
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return;
        }
    }

    public void addBcc(String string, String string2, iaik.x509.X509Certificate x509Certificate, AlgorithmID algorithmID) {
        this.addBcc(string, string2);
        try {
            this.a.addElement(new RecipientInfo((X509Certificate)x509Certificate, algorithmID));
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return;
        }
    }

    public void addAdditionalField(String string) {
        this.f.addElement(string);
    }

    public SMimeMailer(String string, int n) {
        super(string);
        this.c = n;
        this.a = new Vector();
    }
}

