/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.jarm;

import com.sap.util.monitor.jarm.ComponentOverviewExt;
import com.sap.util.monitor.jarm.OverviewMonitor;
import com.sap.util.monitor.jarm.RequestOverviewExt;
import com.sap.util.monitor.jarm.RequestSummaryExt;
import com.sap.util.monitor.jarm.UserOverview;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SerialValuesMonitor {
    static final String[] summaryHeaders = new String[]{"Name", "Value"};
    static final String[] summaryNames = new String[]{"Start of Monitoring", "Number of Requests", "Average Response Time (ms)", "Average CPU Time (ms)", "Requests per Second", "Average outbound Data (bytes)", "Accumulated Response Time (ms)", "Accumulated CPU Time (ms)", "Requests providing outbound Data", "Accumulated outbound Data (bytes)", "Number of Component Calls by all Requests", "Average Number of Component Calls per Request", "Requests providing correct Monitor Data", "Requests with not correctly closed Components", "Requests closed because of too many Components", "Requests running with level 0", "Requests running with level 1", "Requests running with level 2", "Number of users making requests (since first request)", "Number of users making requests (since last reset)", "Timestamp of last request reset", "Timestamp of last component reset", "Timestamp of last user reset"};
    static final String[] requestHeaders = new String[]{"Request Name", "Response Time", "CPU Time", "Outbound Data", "Components", "Comp (Max Time)", "Max Time", "Comp (Max CPU Time)", "Max CPU Time", "Comp (Max Data)", "Data", "Status", "Start Time", "User", "Description", "Level"};
    static final String[] componentHeaders = new String[]{"Component Name", "Avg Gross Time", "Avg Net Time", "Avg Gross CPU Time", "Avg Net CPU Time", "Avg outbound Data", "Calls", "Sum Gross Time", "Sum Net Time", "Sum Gross CPU Time", "Sum Net CPU Time", "Sum outbound Data", "Comp Gross Time provided", "Comp Net Time provided", "Comp Data provided", "Description"};
    static final String[] userHeaders = new String[]{"User Name", "Avg Time", "Total Time", "Num of Requests", "First Request", "Last Request"};
    static SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy kk:mm:ss.SSS");

    public static String[] getSummaryHeaders() {
        return summaryHeaders;
    }

    public static Serializable[][] getSummaryContent() {
        Serializable[][] content = new Serializable[summaryNames.length][2];
        int idx = 0;
        int i = 0;
        while (i < content.length) {
            content[i][0] = summaryNames[i];
            ++i;
        }
        RequestSummaryExt requestSummaryData = OverviewMonitor.getSummaryOfRequestsExt();
        if (requestSummaryData != null) {
            content[idx++][1] = SerialValuesMonitor.getFormatedDate(requestSummaryData.reqFirstTS);
            content[idx++][1] = new Long(requestSummaryData.reqAccNr);
            content[idx++][1] = new Long(requestSummaryData.reqAvgTime);
            content[idx++][1] = new Long(requestSummaryData.reqAvgCpuTime);
            content[idx++][1] = new Long(requestSummaryData.reqPerSec);
            content[idx++][1] = new Long(requestSummaryData.reqAvgOutData);
            content[idx++][1] = new Long(requestSummaryData.reqAccTime);
            content[idx++][1] = new Long(requestSummaryData.reqAccCpuTime);
            content[idx++][1] = new Long(requestSummaryData.reqAccOutDataFilled);
            content[idx++][1] = new Long(requestSummaryData.reqAccOutData);
            content[idx++][1] = new Long(requestSummaryData.reqAccComp);
            content[idx++][1] = new Long(requestSummaryData.reqAvgComp);
            content[idx++][1] = new Long(requestSummaryData.reqAccStatusOk);
            content[idx++][1] = new Long(requestSummaryData.reqAccStatusCompNotClosed);
            content[idx++][1] = new Long(requestSummaryData.reqAccStatusEndForced);
            content[idx++][1] = new Long(requestSummaryData.reqCompLevelBasic);
            content[idx++][1] = new Long(requestSummaryData.reqCompLevelMedium);
            content[idx++][1] = new Long(requestSummaryData.reqCompLevelDetail);
            content[idx++][1] = new Long(requestSummaryData.reqStartAccUserNr);
            content[idx++][1] = new Long(requestSummaryData.reqAccUserNr);
            content[idx++][1] = SerialValuesMonitor.getFormatedDate(requestSummaryData.resetReqTS);
            content[idx++][1] = SerialValuesMonitor.getFormatedDate(requestSummaryData.resetCompTS);
            content[idx++][1] = SerialValuesMonitor.getFormatedDate(requestSummaryData.resetUserTS);
        }
        return content;
    }

    public static String[] getRequestHeaders() {
        return requestHeaders;
    }

    public static Serializable[][] getRequestContent(int max_results) {
        Serializable[][] content;
        int idx = 0;
        RequestOverviewExt[] topRequests = OverviewMonitor.getTopRequestsExt(1, 0, "*", max_results);
        if (topRequests != null) {
            content = new Serializable[topRequests.length][requestHeaders.length];
            int i = 0;
            while (i < topRequests.length) {
                RequestOverviewExt request = topRequests[i];
                content[i][idx++] = SerialValuesMonitor.getStringNotNull(request.reqName);
                content[i][idx++] = new Long(request.reqTime);
                content[i][idx++] = new Long(request.reqCpuTime);
                content[i][idx++] = new Integer(request.reqOutData);
                content[i][idx++] = new Integer(request.reqComp);
                content[i][idx++] = SerialValuesMonitor.getStringNotNull(request.compNetTimeName);
                content[i][idx++] = new Long(request.compNetTime);
                content[i][idx++] = SerialValuesMonitor.getStringNotNull(request.compNetCpuTimeName);
                content[i][idx++] = new Long(request.compNetCpuTime);
                content[i][idx++] = SerialValuesMonitor.getStringNotNull(request.compOutDataName);
                content[i][idx++] = new Long(request.compOutData);
                content[i][idx++] = new Integer(request.reqStatus);
                content[i][idx++] = SerialValuesMonitor.getFormatedDate(request.reqTS);
                content[i][idx++] = SerialValuesMonitor.getStringNotNull(request.userName);
                content[i][idx++] = SerialValuesMonitor.getStringNotNull(request.reqDescr);
                content[i][idx++] = new Integer(request.reqCompLevel);
                idx = 0;
                ++i;
            }
        } else {
            content = new Serializable[0][0];
        }
        return content;
    }

    public static String[] getComponentHeaders() {
        return componentHeaders;
    }

    public static Serializable[][] getComponentContent(int max_results) {
        Serializable[][] content;
        int idx = 0;
        ComponentOverviewExt[] topComponents = OverviewMonitor.getTopComponentsExt(0, "*", max_results);
        if (topComponents != null) {
            content = new Serializable[topComponents.length][componentHeaders.length];
            int i = 0;
            while (i < topComponents.length) {
                ComponentOverviewExt component = topComponents[i];
                content[i][idx++] = SerialValuesMonitor.getStringNotNull(component.compName);
                content[i][idx++] = new Long(component.compAvgGrossTime);
                content[i][idx++] = new Long(component.compAvgNetTime);
                content[i][idx++] = new Long(component.compAvgGrossCpuTime);
                content[i][idx++] = new Long(component.compAvgNetCpuTime);
                content[i][idx++] = new Long(component.compAvgOutData);
                content[i][idx++] = new Long(component.compAccNr);
                content[i][idx++] = new Long(component.compAccGrossTime);
                content[i][idx++] = new Long(component.compAccNetTime);
                content[i][idx++] = new Long(component.compAccGrossCpuTime);
                content[i][idx++] = new Long(component.compAccNetCpuTime);
                content[i][idx++] = new Long(component.compAccOutData);
                content[i][idx++] = new Long(component.compAccGrossTimeFilled);
                content[i][idx++] = new Long(component.compAccNetTimeFilled);
                content[i][idx++] = new Long(component.compAccOutDataFilled);
                content[i][idx++] = SerialValuesMonitor.getStringNotNull(component.compDescr);
                idx = 0;
                ++i;
            }
        } else {
            content = new Serializable[0][0];
        }
        return content;
    }

    public static String[] getUserHeaders() {
        return userHeaders;
    }

    public static Serializable[][] getUserContent(int max_results) {
        Serializable[][] content;
        int idx = 0;
        UserOverview[] topUsers = OverviewMonitor.getTopUsers(0, "*", max_results);
        if (topUsers != null) {
            content = new Serializable[topUsers.length][userHeaders.length];
            int i = 0;
            while (i < topUsers.length) {
                UserOverview user = topUsers[i];
                content[i][idx++] = SerialValuesMonitor.getStringNotNull(user.userName);
                content[i][idx++] = new Long(user.userAvgTime);
                content[i][idx++] = new Long(user.userAccTime);
                content[i][idx++] = new Long(user.userAccNr);
                content[i][idx++] = SerialValuesMonitor.getFormatedDate(user.userFirstTS);
                content[i][idx++] = SerialValuesMonitor.getFormatedDate(user.userLastTS);
                idx = 0;
                ++i;
            }
        } else {
            content = new Serializable[0][0];
        }
        return content;
    }

    private static String getFormatedDate(long time) {
        if (time == 0L) {
            return "";
        }
        return formatter.format(new Date(time));
    }

    private static String getStringNotNull(String s) {
        return s == null ? "" : s;
    }
}

