/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.jarm;

import com.sap.bc.krn.perf.PerfTimes;
import com.sap.util.monitor.jarm.ConfMonitor;
import com.sap.util.monitor.jarm.IPerfMeasurement;

public class PerfMeasurementDefaultImpl
implements IPerfMeasurement {
    private PerfTimes perfTimes;
    private boolean availCpuTime;
    private boolean availElapsedTimeUs;

    protected PerfMeasurementDefaultImpl() {
        boolean error = false;
        try {
            this.perfTimes = new PerfTimes();
            this.availCpuTime = this.perfTimes.cpuTimePerThread();
            this.availElapsedTimeUs = true;
        }
        catch (UnsatisfiedLinkError exc) {
            error = true;
            ConfMonitor.logWriteInfo(0, "DLL for CPU measurement not found");
        }
        catch (NoClassDefFoundError exc) {
            error = true;
            ConfMonitor.logWriteInfo(0, "JAR file for CPU measurement not found");
        }
        catch (Exception exc) {
            error = true;
        }
        if (error) {
            this.availElapsedTimeUs = false;
            this.availCpuTime = false;
        }
        ConfMonitor.logWriteInfo(0, "Default Performance Measurement:");
        ConfMonitor.logWriteInfo(0, "  Elapsed time measurement: true");
        ConfMonitor.logWriteInfo(0, "  CPU time measurement: " + this.availCpuTime);
    }

    public boolean availElapsedTime() {
        return true;
    }

    public boolean availCpuTime() {
        return this.availCpuTime;
    }

    public long getElapsedTime() {
        if (this.availElapsedTimeUs) {
            return this.perfTimes.elapsed();
        }
        return System.currentTimeMillis();
    }

    public long getCpuTime() {
        if (this.availCpuTime) {
            return this.perfTimes.cpuTimeUs();
        }
        return -1L;
    }

    public long getDifferenceElapsedTime(long startVal, long endVal) {
        long result = this.availElapsedTimeUs ? this.perfTimes.getDelta2Us(startVal, endVal) / 1000L : endVal - startVal;
        return result;
    }

    public long getDifferenceCpuTime(long startVal, long endVal) {
        long result = this.availCpuTime ? this.perfTimes.getDelta2Us(startVal, endVal) / 1000L : -1L;
        return result;
    }
}

