/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.jarm;

import com.sap.util.monitor.jarm.ApplThreadOverview;
import com.sap.util.monitor.jarm.CompSingleMonitor;
import com.sap.util.monitor.jarm.ConfMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;
import java.util.Arrays;

class ApplThreadMonitor {
    protected Thread myThread;
    protected String threadName;
    protected TaskMonitor myMonitor;
    protected long firstTaskTS;
    protected ApplThreadMonitor nextAppl;
    private boolean active;
    private boolean foreignCompActive;
    private String userName;
    private String reqName;
    private String taskName;
    private String compName;
    private String action;
    private long sumTaskTime;
    private long reqTS;
    private long taskTS;
    private long compTS;
    private long callCount;
    private boolean callActive;
    private CompSingleMonitor headCompSingleList;
    private CompSingleMonitor tailCompSingleList;

    protected ApplThreadMonitor() {
    }

    protected static synchronized ApplThreadOverview[] getApplThreads(boolean clearOnly) {
        ApplThreadOverview hlpOverview;
        ApplThreadOverview headOverview = null;
        ApplThreadOverview tailOverview = null;
        int arrayCount = 0;
        ApplThreadMonitor hlpAppl = TaskMonitor.getApplThreadList();
        if (hlpAppl == null) {
            return null;
        }
        do {
            if (hlpAppl.myThread.isAlive()) {
                if (!clearOnly) {
                    hlpOverview = hlpAppl.getApplThread();
                    if (headOverview != null) {
                        tailOverview.nextOverview = hlpOverview;
                        tailOverview = hlpOverview;
                    } else {
                        headOverview = tailOverview = hlpOverview;
                    }
                    ++arrayCount;
                }
            } else {
                TaskMonitor.removeThread(hlpAppl.myThread);
                hlpAppl.myThread = null;
            }
            ApplThreadMonitor hlpAppl2 = hlpAppl;
            hlpAppl = hlpAppl.nextAppl;
            hlpAppl2.nextAppl = null;
        } while (hlpAppl != null);
        if (arrayCount != 0 && !clearOnly) {
            ApplThreadOverview[] resultOverviews = new ApplThreadOverview[arrayCount];
            hlpOverview = headOverview;
            int i = 0;
            while (i < arrayCount) {
                resultOverviews[i] = hlpOverview;
                hlpOverview = hlpOverview.nextOverview;
                ++i;
            }
            Arrays.sort((Object[])resultOverviews, headOverview);
            return resultOverviews;
        }
        return null;
    }

    protected void startRequest(TaskMonitor monitor, String userNameParam, String reqNameParam, long currentTS) {
        this.callActive = true;
        this.active = true;
        this.foreignCompActive = false;
        this.myMonitor = monitor;
        this.userName = userNameParam;
        this.reqName = reqNameParam;
        this.taskName = reqNameParam;
        this.compName = " ";
        this.action = " ";
        this.taskTS = this.compTS = currentTS;
        this.reqTS = this.compTS;
        ++this.callCount;
        this.callActive = false;
    }

    protected void endRequest(long currentTS) {
        this.callActive = true;
        this.active = false;
        this.foreignCompActive = false;
        this.action = null;
        this.compName = null;
        this.taskName = null;
        this.reqName = null;
        this.userName = null;
        this.sumTaskTime += this.myMonitor.perfMeasure.getDifferenceElapsedTime(this.taskTS, currentTS);
        this.myMonitor = null;
        this.compTS = 0L;
        this.taskTS = 0L;
        this.reqTS = 0L;
        ++this.callCount;
        this.callActive = false;
    }

    protected void startComponent(String compNameParam, boolean foreign, long currentTS) {
        this.callActive = true;
        this.compTS = currentTS;
        this.foreignCompActive = foreign;
        this.compName = compNameParam;
        this.action = " ";
        ++this.callCount;
        this.callActive = false;
    }

    protected void endComponent(String parentCompName, boolean parentForeignComp, long parentCompTS) {
        this.callActive = true;
        this.compTS = parentCompTS;
        this.compName = parentCompName;
        this.foreignCompActive = parentForeignComp;
        this.action = " ";
        ++this.callCount;
        this.callActive = false;
    }

    protected void compAction(String paramCompName, String paramAction) {
        this.callActive = true;
        this.compName = paramCompName;
        this.action = paramAction;
        ++this.callCount;
        this.callActive = false;
    }

    protected void setUser(String paramUserName) {
        this.callActive = true;
        this.userName = paramUserName;
        ++this.callCount;
        this.callActive = false;
    }

    protected CompSingleMonitor getCompElem() {
        CompSingleMonitor retComp = null;
        if (this.headCompSingleList != this.tailCompSingleList && this.headCompSingleList != null && this.tailCompSingleList != null) {
            retComp = this.headCompSingleList;
            this.headCompSingleList = this.headCompSingleList.succ;
        } else {
            ApplThreadMonitor applThreadMonitor = this;
            synchronized (applThreadMonitor) {
                if (this.headCompSingleList == this.tailCompSingleList) {
                    if (this.headCompSingleList != null) {
                        retComp = this.headCompSingleList;
                        this.tailCompSingleList = null;
                        this.headCompSingleList = null;
                    }
                    int i = 0;
                    while (i < ConfMonitor.initFreeCompNum) {
                        CompSingleMonitor hlpComp = new CompSingleMonitor(i);
                        if (i > 0) {
                            this.tailCompSingleList.succ = hlpComp;
                            this.tailCompSingleList = hlpComp;
                        } else {
                            this.headCompSingleList = this.tailCompSingleList = hlpComp;
                        }
                        ++i;
                    }
                    if (retComp == null) {
                        retComp = this.headCompSingleList;
                        this.headCompSingleList = this.headCompSingleList.succ;
                    }
                } else {
                    retComp = this.headCompSingleList;
                    this.headCompSingleList = this.headCompSingleList.succ;
                }
            }
        }
        return retComp;
    }

    protected synchronized void putCompElemList(CompSingleMonitor headOfList) {
        long lastSeqNumber;
        long firstSeqNumber;
        CompSingleMonitor tailOfList = headOfList;
        if (headOfList == null) {
            return;
        }
        if (this.headCompSingleList != null) {
            firstSeqNumber = this.headCompSingleList.sequenceNumber;
            lastSeqNumber = this.tailCompSingleList.sequenceNumber;
        } else {
            firstSeqNumber = 0L;
            lastSeqNumber = this.tailCompSingleList != null ? this.tailCompSingleList.sequenceNumber : 0L;
        }
        if (lastSeqNumber - firstSeqNumber >= (long)ConfMonitor.initMaxFreeCompNum) {
            do {
                if (tailOfList.pred != null) {
                    tailOfList.pred.succ = null;
                }
                tailOfList.nextMainComp = null;
                tailOfList.parentComp = null;
                tailOfList.pred = null;
                tailOfList.mon = null;
                tailOfList.compPropSingle = null;
                tailOfList.compMon = null;
                tailOfList.compName = null;
            } while ((tailOfList = tailOfList.succ) != null);
            return;
        }
        tailOfList.sequenceNumber = ++lastSeqNumber;
        tailOfList.compPropSingle = null;
        tailOfList.mon = null;
        tailOfList.compMon = null;
        tailOfList.nextMainComp = null;
        tailOfList.parentComp = null;
        tailOfList.compName = null;
        while (tailOfList.succ != null) {
            tailOfList = tailOfList.succ;
            tailOfList.sequenceNumber = ++lastSeqNumber;
            tailOfList.compPropSingle = null;
            tailOfList.mon = null;
            tailOfList.compMon = null;
            tailOfList.nextMainComp = null;
            tailOfList.parentComp = null;
            tailOfList.compName = null;
        }
        if (this.headCompSingleList == null) {
            this.headCompSingleList = headOfList;
        } else {
            this.tailCompSingleList.succ = headOfList;
        }
        this.tailCompSingleList = tailOfList;
    }

    protected ApplThreadOverview getApplThread() {
        ApplThreadOverview applOverview = new ApplThreadOverview();
        if (!this.active) {
            applOverview.myThread = this.myThread;
            applOverview.threadName = this.threadName;
            applOverview.firstTaskTS = this.firstTaskTS;
            applOverview.sumTaskTime = this.sumTaskTime;
            applOverview.active = false;
            applOverview.action = null;
            applOverview.compName = null;
            applOverview.taskName = null;
            applOverview.reqName = null;
            applOverview.userName = null;
            applOverview.compTime = 0L;
            applOverview.taskTime = 0L;
            applOverview.reqTime = 0L;
        } else {
            boolean ready = false;
            do {
                if (!this.callActive) {
                    long currentTS = this.myMonitor.perfMeasure.getElapsedTime();
                    long hlpCallCount = this.callCount;
                    applOverview.myThread = this.myThread;
                    applOverview.threadName = this.threadName;
                    applOverview.active = this.active;
                    applOverview.userName = this.userName != null ? this.userName : " ";
                    applOverview.reqName = this.reqName;
                    applOverview.taskName = this.taskName;
                    applOverview.compName = this.compName;
                    applOverview.action = this.action;
                    applOverview.firstTaskTS = this.firstTaskTS;
                    applOverview.reqTime = this.myMonitor.perfMeasure.getDifferenceElapsedTime(this.reqTS, currentTS);
                    applOverview.taskTime = this.myMonitor.perfMeasure.getDifferenceElapsedTime(this.taskTS, currentTS);
                    applOverview.compTime = this.myMonitor.perfMeasure.getDifferenceElapsedTime(this.compTS, currentTS);
                    applOverview.sumTaskTime = this.sumTaskTime + applOverview.reqTime;
                    if (!this.callActive && hlpCallCount == this.callCount) {
                        ready = true;
                    }
                }
                if (ready) continue;
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (!ready);
        }
        return applOverview;
    }
}

