/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.wsnavigator;

import com.sap.engine.services.webservices.tools.ExceptionManager;
import com.sap.engine.services.webservices.wsdl.WSDLDOMLoader;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsnavigator.Endpoint;
import com.sap.engine.services.webservices.wsnavigator.Operation;
import com.sap.engine.services.webservices.wsnavigator.OperationTree;
import com.sap.engine.services.webservices.wsnavigator.ParameterObject;
import com.sap.engine.services.webservices.wsnavigator.ProxyDefinition;
import com.sap.engine.services.webservices.wsnavigator.ProxyDirLoader;
import com.sap.engine.services.webservices.wsnavigator.TestTreeListener;
import com.sap.engine.services.webservices.wsnavigator.WSNavigatorException;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class Tester {
    private static void test(byte type, String mappings, String rootWSDL, String lportsXMLStr, String typesXMLStr, ClassLoader proxyLoader) throws WSNavigatorException {
        WSDLDefinitions def;
        System.out.println("---------------------------------------------------");
        WSDLDOMLoader loader = new WSDLDOMLoader();
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(mappings));
            def = loader.loadMirrorWSDLDocument(rootWSDL, props);
        }
        catch (Exception e) {
            throw new WSNavigatorException(e);
        }
        File lportsXML = new File(lportsXMLStr);
        File typesXML = new File(typesXMLStr);
        ProxyDefinition proxy = new ProxyDefinition(type, def, lportsXML, typesXML, proxyLoader);
        Endpoint[] endpoints = proxy.getEndpoints();
        int i = 0;
        while (i < endpoints.length) {
            Endpoint endpoint = endpoints[i];
            System.out.println("Endpoint: " + endpoint.getName());
            Operation[] ops = endpoint.getOperations();
            int j = 0;
            while (j < ops.length) {
                Operation op = ops[j];
                System.out.println("  Opertn: " + op.getName());
                ParameterObject[] params = op.getParameters();
                int k = 0;
                while (k < params.length) {
                    ParameterObject param = params[k];
                    System.out.println("    Parm: " + param.getDisplayName() + ", type = " + param.getType().getName());
                    ++k;
                }
                OperationTree.serializeOperation(op, new TestTreeListener());
                ++j;
            }
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            Tester.test((byte)1, "C:/test/rpc/wsdls/wsdlmapping.properties", "C:/test/rpc/wsdls/wsdlroot.wsdl", "C:/test/rpc/proxy/test/lports.xml", "C:/test/rpc/proxy/test/types.xml", new ProxyDirLoader("C:/test/rpc/proxy/"));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("MSG: " + ExceptionManager.getErrorMessage(e));
        }
    }
}

