/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.wsnavigator;

import com.sap.engine.lib.xml.util.QName;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl;
import com.sap.engine.services.webservices.jaxrpc.exceptions.LogicalPortException;
import com.sap.engine.services.webservices.jaxrpc.exceptions.TypeMappingException;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortFactory;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPorts;
import com.sap.engine.services.webservices.wsdl.WSDLBinding;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLPortType;
import com.sap.engine.services.webservices.wsnavigator.Endpoint;
import com.sap.engine.services.webservices.wsnavigator.WSNavigatorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProxyDefinition {
    public static final byte DEPLOYABLE = 0;
    public static final byte DEPLOYABLE_RPC = 2;
    public static final byte DEPLOYABLE_JAXRPC = 4;
    public static final byte DEPLOYABLE_RPC_JAXRPC = 6;
    public static final byte STANDALONE = 1;
    public static final byte STANDALONE_RPC = 3;
    public static final byte STANDALONE_JAXRPC = 5;
    public static final byte STANDALONE_RPC_JAXRPC = 7;
    private WSDLDefinitions def;
    private ClassLoader proxyLoader;
    private Endpoint[] endpoints = null;
    private File lportsXML;
    private File typesXML;
    private byte type;

    public ProxyDefinition(byte type, WSDLDefinitions def, File lportsXML, File typesXML, ClassLoader proxyLoader) {
        this.type = type;
        this.def = def;
        this.proxyLoader = proxyLoader;
        this.lportsXML = lportsXML;
        this.typesXML = typesXML;
    }

    private void initEndpoints() throws LogicalPortException, ClassNotFoundException, TypeMappingException, IOException, WSNavigatorException {
        LogicalPortFactory factory = new LogicalPortFactory();
        LogicalPorts lports = factory.loadLogicalPorts(this.lportsXML);
        String siName = lports.getInterfaceName();
        LogicalPortType[] ports = lports.getLogicalPort();
        Endpoint[] endpoints = new Endpoint[ports.length];
        int i = 0;
        while (i < ports.length) {
            LogicalPortType port = ports[i];
            String portName = port.getName();
            WSDLBinding binding = this.def.getBinding(port.getBindingName(), port.getBindingUri());
            QName portTypeName = binding.getType();
            WSDLPortType portType = this.def.getPortType(portTypeName.getLocalName(), portTypeName.getURI());
            String interfaceName = port.getInterfaceName();
            Class<?> interfaceClass = this.proxyLoader.loadClass(interfaceName);
            TypeMappingRegistryImpl typeRegistry = new TypeMappingRegistryImpl();
            if (this.typesXML != null && this.typesXML.exists()) {
                FileInputStream typesStream = new FileInputStream(this.typesXML);
                typeRegistry.fromXML(typesStream, this.proxyLoader);
                ((InputStream)typesStream).close();
            }
            Endpoint endpoint = new Endpoint(this, typeRegistry);
            endpoint.setLpName(port.getName());
            endpoint.setLpClassName(port.getInterfaceName());
            endpoint.setName(portName);
            endpoint.setServiceInterfaceName(siName);
            endpoint.setOperations(portType, this.def, interfaceClass);
            endpoints[i] = endpoint;
            ++i;
        }
        this.endpoints = endpoints;
    }

    WSDLDefinitions getWSDL() {
        return this.def;
    }

    public Endpoint[] getEndpoints() throws WSNavigatorException {
        if (this.endpoints == null) {
            try {
                this.initEndpoints();
            }
            catch (Throwable thr) {
                throw new WSNavigatorException(thr);
            }
        }
        return this.endpoints;
    }

    ClassLoader getLoader() {
        return this.proxyLoader;
    }

    public byte getType() {
        return this.type;
    }

    boolean isRPCMethodsOn() {
        return (this.type & 2) == 2;
    }
}

