/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.wsnavigator;

import com.sap.engine.lib.xml.util.QName;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingImpl;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl;
import com.sap.engine.services.webservices.wsdl.WSDLChannel;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLMessage;
import com.sap.engine.services.webservices.wsdl.WSDLOperation;
import com.sap.engine.services.webservices.wsdl.WSDLPart;
import com.sap.engine.services.webservices.wsnavigator.Endpoint;
import com.sap.engine.services.webservices.wsnavigator.ParameterObject;
import com.sap.engine.services.webservices.wsnavigator.WSNavigatorException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class Operation
implements Serializable {
    private String name;
    private String operationID;
    private ParameterObject[] parameters;
    private Endpoint endpoint;
    private Method javaMethod;
    private javax.xml.namespace.QName returnXMLType;

    public Operation(WSDLOperation wsdlOperation, WSDLDefinitions definitions, Method javaMethod, Endpoint endpoint) throws WSNavigatorException {
        ArrayList outParts;
        this.name = wsdlOperation.getName();
        this.operationID = javaMethod.toString();
        this.endpoint = endpoint;
        this.javaMethod = javaMethod;
        WSDLChannel inputChannel = wsdlOperation.getInput();
        QName inputMsgName = inputChannel.getMessage();
        WSDLMessage inputMsg = definitions.getMessage(inputMsgName);
        ArrayList parts = inputMsg.getParts();
        WSDLChannel outputChannel = wsdlOperation.getOutput();
        if (outputChannel != null) {
            QName outputMsgName = outputChannel.getMessage();
            WSDLMessage outputMsg = definitions.getMessage(outputMsgName);
            outParts = outputMsg.getParts();
        } else {
            outParts = new ArrayList();
        }
        Class<?>[] parameterTypes = javaMethod.getParameterTypes();
        int len = parameterTypes.length;
        this.parameters = new ParameterObject[len];
        int i = 0;
        while (i < len) {
            WSDLPart wsdlPart = i < parts.size() ? (WSDLPart)parts.get(i) : (WSDLPart)outParts.get(i - parts.size());
            Class<?> paramClass = parameterTypes[i];
            this.parameters[i] = new ParameterObject(wsdlPart, paramClass, this.getEndpoint().getTypeRegistry());
            ++i;
        }
        if (outParts.size() > 0) {
            WSDLPart part = (WSDLPart)outParts.get(0);
            QName partType = part.getType();
            TypeMappingRegistryImpl typeRegistry = endpoint.getTypeRegistry();
            TypeMappingImpl typeMapping = (TypeMappingImpl)typeRegistry.getDefaultTypeMapping();
            this.returnXMLType = typeMapping.getTypeForElement(new javax.xml.namespace.QName(partType.getURI(), partType.getLocalName()));
        }
    }

    public String getName() {
        return this.name;
    }

    public ParameterObject[] getParameters() {
        return this.parameters;
    }

    public String getOperationID() {
        return this.operationID;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Method getAsJavaMethod() {
        return this.javaMethod;
    }

    public javax.xml.namespace.QName getReturnXMLType() {
        return this.returnXMLType;
    }
}

