/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.wsdl;

import com.sap.engine.interfaces.webservices.runtime.HTTPProxyResolver;
import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.jaxp.TransformerFactoryImpl;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.parser.URLLoaderBase;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGenerator;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGeneratorConfig;
import com.sap.engine.services.webservices.tools.WSDLDownloadResolver;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WSDLImportTool {
    private String proxyHost = null;
    private String proxyPort = null;
    private HTTPProxyResolver proxyResolver;
    private String username;
    private String password;
    public static String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";
    public static String SCHEMA_NAMESPACE1 = "http://www.w3.org/2000/10/XMLSchema";
    public static String SCHEMA_NAMESPACE2 = "http://www.w3.org/2001/XMLSchema";
    public static String SCHEMA_NAMESPACE3 = "http://www.w3.org/1999/XMLSchema";
    public static String DEFINITIONS = "definitions";
    public static String TYPES = "types";
    public static String SCHEMA = "schema";
    public static String IMPORT = "import";
    public static final String INCLUDE = "include";
    public static final String PATH_SEPARATOR = "|";
    private int wsdlCounter = 1;
    private int schemaCounter = 1;
    private String localWSDLName = "wsdlfile";
    private String localWSDLRoot = "wsdlroot";
    private String localSchemaName = "wsdlschema";
    private String suffix = null;
    boolean fixImports = false;
    private Transformer transformer = null;
    private StandardDOMParser domparser = null;
    private Hashtable reachedFiles = new Hashtable();

    public void setImportFix(boolean flag) {
        this.fixImports = flag;
    }

    public void setSufix(String suffix) {
        if (suffix == null) {
            suffix = "";
        }
        this.suffix = suffix;
    }

    public void setHttpProxy(String proxyHost, String proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public void setHTTPProxyResolver(HTTPProxyResolver proxyResolver) {
        this.proxyResolver = proxyResolver;
    }

    public void setUser(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void clearHTTPProxy() {
        this.proxyHost = null;
        this.proxyHost = null;
    }

    private StandardDOMParser getDOMParser() throws SAXException {
        if (this.domparser != null) {
            return this.domparser;
        }
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.domparser = new StandardDOMParser();
        this.domparser.setValidation(false);
        this.domparser.setReadDTD(false);
        this.domparser.setNamespaces(true);
        return this.domparser;
    }

    private DOMSource loadDocument(String fileName) throws WSDLException {
        try {
            Document document;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                StandardDOMParser parser = this.getDOMParser();
                WSDLDownloadResolver resolver = new WSDLDownloadResolver();
                if (this.proxyHost != null && this.proxyHost.length() > 0 && this.proxyPort != null && this.proxyPort.length() > 0) {
                    resolver.setProxyHost(this.proxyHost);
                    resolver.setProxyPort(Integer.parseInt(this.proxyPort));
                } else if (this.proxyResolver != null) {
                    resolver.setHTTPProxyResolver(this.proxyResolver);
                }
                resolver.setUsername(this.username);
                resolver.setPassword(this.password);
                parser.setEntityResolver((EntityResolver)resolver);
                InputSource source = resolver.resolveEntity(null, fileName);
                if (source == null) {
                    source = new InputSource(fileName);
                }
                document = parser.parse(source);
                resolver.closeConnections();
                Object var8_10 = null;
                Thread.currentThread().setContextClassLoader(loader);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                Thread.currentThread().setContextClassLoader(loader);
                throw throwable;
            }
            Element root = document.getDocumentElement();
            DOMSource source = new DOMSource(root, fileName);
            return source;
        }
        catch (SAXException e) {
            throw new WSDLException("Parser exception occurred:" + e.getMessage(), e);
        }
        catch (FactoryConfigurationError e) {
            throw new WSDLException("Factory configuration error occurred:" + e.getMessage());
        }
        catch (IOException e) {
            throw new WSDLException("IO Exception occurred while parsing file:" + e.getMessage(), e);
        }
    }

    private DOMSource loadDocument(InputStream fileName, String systemId) throws WSDLException {
        try {
            DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(fileName);
            Element root = document.getDocumentElement();
            DOMSource source = new DOMSource(root, systemId);
            return source;
        }
        catch (SAXException e) {
            throw new WSDLException("Parser exception occurred:" + e.getMessage(), e);
        }
        catch (FactoryConfigurationError e) {
            throw new WSDLException("Factory configuration error occurred:" + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new WSDLException("Parser configuration exception occurred:" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new WSDLException("IO Exception occurred while parsing file:" + e.getMessage(), e);
        }
    }

    private ArrayList getDefinitionsImport(Element element) {
        Node node = element.getFirstChild();
        ArrayList<Element> result = new ArrayList<Element>();
        while (node != null) {
            Element child;
            if (node.getNodeType() == 1 && (child = (Element)node).getLocalName().equals(IMPORT) && WSDL_NAMESPACE.equals(child.getNamespaceURI())) {
                result.add(child);
            }
            node = node.getNextSibling();
        }
        return result;
    }

    private ArrayList getSchemaImport(Element element) {
        Node node = element.getFirstChild();
        ArrayList<Element> result = new ArrayList<Element>();
        while (node != null) {
            if (node.getNodeType() == 1) {
                Element child = (Element)node;
                if (child.getLocalName().equals(IMPORT) && SCHEMA_NAMESPACE1.equals(child.getNamespaceURI())) {
                    result.add(child);
                }
                if (child.getLocalName().equals(IMPORT) && SCHEMA_NAMESPACE2.equals(child.getNamespaceURI())) {
                    result.add(child);
                }
                if (child.getLocalName().equals(IMPORT) && SCHEMA_NAMESPACE3.equals(child.getNamespaceURI())) {
                    result.add(child);
                }
                if (child.getLocalName().equals(INCLUDE) && SCHEMA_NAMESPACE1.equals(child.getNamespaceURI())) {
                    result.add(child);
                }
                if (child.getLocalName().equals(INCLUDE) && SCHEMA_NAMESPACE2.equals(child.getNamespaceURI())) {
                    result.add(child);
                }
                if (child.getLocalName().equals(INCLUDE) && SCHEMA_NAMESPACE3.equals(child.getNamespaceURI())) {
                    result.add(child);
                }
            }
            node = node.getNextSibling();
        }
        return result;
    }

    private String getImportLocation(Element importElement) throws WSDLException {
        String location = importElement.getAttribute("location");
        if (location.length() == 0) {
            location = importElement.getAttribute("schemaLocation");
        }
        return location;
    }

    private DOMSource resolveImport(String rootId, String relativeLocation) throws WSDLException {
        DOMSource result = null;
        if (relativeLocation.length() != 0) {
            URL locationURL;
            try {
                URL rootURL = URLLoaderBase.fileOrURLToURL(null, (String)rootId);
                locationURL = URLLoaderBase.fileOrURLToURL((URL)rootURL, (String)relativeLocation);
            }
            catch (IOException e) {
                throw new WSDLException(" Unable to resolve location : {" + relativeLocation + "} from base location: {" + rootId + "}");
            }
            result = this.loadDocument(locationURL.toExternalForm());
        }
        return result;
    }

    private DOMSource resolveImport(String rootId, Element importElement) throws WSDLException {
        DOMSource result = null;
        String location = this.getImportLocation(importElement);
        if (location.length() != 0) {
            URL locationURL;
            try {
                URL rootURL = URLLoaderBase.fileOrURLToURL(null, (String)rootId);
                locationURL = URLLoaderBase.fileOrURLToURL((URL)rootURL, (String)location);
            }
            catch (IOException e) {
                throw new WSDLException(" Unable to resolve location : {" + location + "} from base location: {" + rootId + "}");
            }
            result = this.loadDocument(locationURL.toExternalForm());
        }
        return result;
    }

    private boolean isSchema(DOMSource source) {
        Element root = (Element)source.getNode();
        if (root.getLocalName().equals(SCHEMA) && SCHEMA_NAMESPACE1.equals(root.getNamespaceURI())) {
            return true;
        }
        if (root.getLocalName().equals(SCHEMA) && SCHEMA_NAMESPACE2.equals(root.getNamespaceURI())) {
            return true;
        }
        return root.getLocalName().equals(SCHEMA) && SCHEMA_NAMESPACE3.equals(root.getNamespaceURI());
    }

    private ArrayList getWSDLSchemas(DOMSource wsdlSource) {
        Element root = (Element)wsdlSource.getNode();
        Node node = root.getFirstChild();
        Node types = null;
        while (node != null) {
            Element element;
            if (node.getNodeType() == 1 && (element = (Element)node).getLocalName().equals(TYPES) && WSDL_NAMESPACE.equals(element.getNamespaceURI())) {
                types = element;
                break;
            }
            node = node.getNextSibling();
        }
        ArrayList<Element> result = new ArrayList<Element>();
        if (types != null) {
            node = types.getFirstChild();
            while (node != null) {
                Element element;
                DOMSource source;
                if (node.getNodeType() == 1 && this.isSchema(source = new DOMSource(element = (Element)node, wsdlSource.getSystemId()))) {
                    result.add(element);
                }
                node = node.getNextSibling();
            }
        }
        return result;
    }

    private boolean isWSDLDefinitions(DOMSource source) {
        Element root = (Element)source.getNode();
        return root.getLocalName().equals(DEFINITIONS) && WSDL_NAMESPACE.equals(root.getNamespaceURI());
    }

    private void fillReferences(String path, String destination, Hashtable idMapping) {
        String key;
        Enumeration en = idMapping.keys();
        String startPath = null;
        while (en.hasMoreElements()) {
            Object key2 = en.nextElement();
            if (!idMapping.get(key2).equals(destination)) continue;
            startPath = (String)key2;
            break;
        }
        en = idMapping.keys();
        int pLength = startPath.length();
        Hashtable temp = new Hashtable();
        while (en.hasMoreElements()) {
            key = (String)en.nextElement();
            if (!key.startsWith(startPath) || key.length() <= pLength) continue;
            String permKey = path + key.substring(pLength);
            temp.put(permKey, idMapping.get(key));
        }
        en = temp.keys();
        while (en.hasMoreElements()) {
            key = en.nextElement();
            idMapping.put(key, temp.get(key));
        }
        idMapping.put(path, destination);
    }

    private ArrayList saveSchemaSpecial(DOMSource source, String path, File outputDir, String preferedName, Hashtable idMapping) throws WSDLException {
        ArrayList<File> result = new ArrayList<File>();
        String temp = (String)this.reachedFiles.get(source.getSystemId());
        if (temp != null) {
            this.fillReferences(path, temp, idMapping);
            return result;
        }
        if (preferedName == null) {
            if (this.suffix == null) {
                this.suffix = "";
            }
            preferedName = this.localSchemaName + this.suffix + Integer.toString(this.schemaCounter) + ".xsd";
            ++this.schemaCounter;
        }
        File outputFile = new File(outputDir, preferedName);
        result.add(outputFile);
        ArrayList schemaImports = this.getSchemaImport((Element)source.getNode());
        int i = 0;
        while (i < schemaImports.size()) {
            Element importTag = (Element)schemaImports.get(i);
            String relativeLocation = this.getImportLocation(importTag);
            DOMSource domdocument = this.resolveImport(source.getSystemId(), relativeLocation);
            if (domdocument != null && this.isSchema(domdocument)) {
                if (this.isSchema(domdocument)) {
                    ArrayList resultFiles = this.saveSchemaSpecial(domdocument, this.extend(path, relativeLocation), outputDir, null, idMapping);
                    result.addAll(resultFiles);
                } else {
                    throw new WSDLException("In wsdl definitions only schema and wsdl's can be imported ! Bug in import statement of :" + source.getSystemId());
                }
            }
            if (this.fixImports && idMapping.get(this.extend(path, relativeLocation)) != null) {
                importTag.setAttribute("schemaLocation", (String)idMapping.get(this.extend(path, relativeLocation)));
            }
            ++i;
        }
        this.saveDOMSourceSpecial(source, path, outputFile, idMapping);
        return result;
    }

    private ArrayList saveSchema(DOMSource source, File outputDir, String preferedName, Hashtable idMapping) throws WSDLException {
        ArrayList<File> result = new ArrayList<File>();
        if (idMapping.containsKey(source.getSystemId())) {
            return result;
        }
        if (preferedName == null) {
            if (this.suffix == null) {
                this.suffix = "";
            }
            preferedName = this.localSchemaName + this.suffix + Integer.toString(this.schemaCounter) + ".xsd";
            ++this.schemaCounter;
        }
        File outputFile = new File(outputDir, preferedName);
        result.add(outputFile);
        ArrayList schemaImports = this.getSchemaImport((Element)source.getNode());
        int i = 0;
        while (i < schemaImports.size()) {
            Element importTag = (Element)schemaImports.get(i);
            DOMSource domdocument = this.resolveImport(source.getSystemId(), importTag);
            if (domdocument != null && this.isSchema(domdocument)) {
                if (this.isSchema(domdocument)) {
                    ArrayList resultFiles = this.saveSchema(domdocument, outputDir, null, idMapping);
                    result.addAll(resultFiles);
                } else {
                    throw new WSDLException("In wsdl definitions only schema and wsdl's can be imported ! Bug in import statement of :" + source.getSystemId());
                }
            }
            if (this.fixImports && idMapping.get(domdocument.getSystemId()) != null) {
                importTag.setAttribute("schemaLocation", (String)idMapping.get(domdocument.getSystemId()));
            }
            ++i;
        }
        this.saveDOMSource(source, outputFile, idMapping);
        return result;
    }

    private void saveDOMSource(DOMSource source, File outputFile, Hashtable idMapping) throws WSDLException {
        TransformerFactoryImpl factory = new TransformerFactoryImpl();
        Transformer transformer = null;
        try {
            transformer = factory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new WSDLException("Unable to write file from " + source.getSystemId() + " to " + outputFile.getAbsolutePath());
        }
        transformer.setOutputProperty("indent", "yes");
        try {
            FileOutputStream out = new FileOutputStream(outputFile);
            try {
                transformer.transform(source, new StreamResult(out));
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                ((OutputStream)out).close();
                throw throwable;
            }
            ((OutputStream)out).close();
            idMapping.put(source.getSystemId(), outputFile.getName());
        }
        catch (IOException ioe) {
            throw new WSDLException("Unable to write file :" + outputFile.getAbsolutePath(), ioe);
        }
        catch (TransformerException t) {
            throw new WSDLException("Tranformer Exception on file saving :" + outputFile.getAbsolutePath());
        }
    }

    private Transformer getTransformer() throws TransformerConfigurationException {
        if (this.transformer != null) {
            return this.transformer;
        }
        TransformerFactoryImpl factory = new TransformerFactoryImpl();
        this.transformer = factory.newTransformer();
        this.transformer.setOutputProperty("indent", "yes");
        return this.transformer;
    }

    private void saveDOMSourceSpecial(DOMSource source, String path, File outputFile, Hashtable idMapping) throws WSDLException {
        Transformer transformer = null;
        try {
            transformer = this.getTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new WSDLException("Unable to write file from " + source.getSystemId() + " to " + outputFile.getAbsolutePath());
        }
        try {
            FileOutputStream out = new FileOutputStream(outputFile);
            try {
                transformer.transform(source, new StreamResult(out));
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                ((OutputStream)out).close();
                throw throwable;
            }
            ((OutputStream)out).close();
            idMapping.put(path, outputFile.getName());
            this.reachedFiles.put(source.getSystemId(), outputFile.getName());
        }
        catch (IOException f) {
            throw new WSDLException("Unable to write file :" + outputFile.getAbsolutePath(), f);
        }
        catch (TransformerException t) {
            throw new WSDLException("Tranformer Exception on file saving :" + outputFile.getAbsolutePath());
        }
    }

    private String extend(String rootPath, String extensionPath) {
        return rootPath + PATH_SEPARATOR + extensionPath;
    }

    private ArrayList saveWSDLSpecial(DOMSource source, String path, File outputDir, String preferedName, Hashtable idMapping) throws WSDLException {
        if (!outputDir.exists()) {
            outputDir.mkdirs();
            if (!outputDir.isDirectory()) {
                outputDir.delete();
            }
        } else if (!outputDir.isDirectory()) {
            throw new WSDLException(outputDir.getAbsolutePath() + " is not a directory !");
        }
        ArrayList<File> result = new ArrayList<File>();
        String temp = (String)this.reachedFiles.get(source.getSystemId());
        if (temp != null) {
            this.fillReferences(path, temp, idMapping);
            return result;
        }
        if (preferedName == null) {
            if (this.suffix == null) {
                this.suffix = "";
            }
            preferedName = this.localWSDLName + this.suffix + Integer.toString(this.wsdlCounter) + ".wsdl";
            ++this.wsdlCounter;
        }
        File outputFile = new File(outputDir, preferedName);
        result.add(outputFile);
        ArrayList definitionImports = this.getDefinitionsImport((Element)source.getNode());
        int i = 0;
        while (i < definitionImports.size()) {
            Element importState = (Element)definitionImports.get(i);
            String relativeLocation = this.getImportLocation(importState);
            DOMSource domdocument = this.resolveImport(source.getSystemId(), relativeLocation);
            if (domdocument != null) {
                ArrayList resultFiles;
                if (this.isWSDLDefinitions(domdocument)) {
                    resultFiles = this.saveWSDLSpecial(domdocument, this.extend(path, relativeLocation), outputDir, null, idMapping);
                    result.addAll(resultFiles);
                } else if (this.isSchema(domdocument)) {
                    resultFiles = this.saveSchemaSpecial(domdocument, this.extend(path, relativeLocation), outputDir, null, idMapping);
                    result.addAll(resultFiles);
                } else {
                    throw new WSDLException("In wsdl definitions only schema and wsdl's can be imported ! Bug in import statement of :" + source.getSystemId());
                }
            }
            if (this.fixImports && idMapping.get(this.extend(path, relativeLocation)) != null) {
                importState.setAttribute("location", (String)idMapping.get(this.extend(path, relativeLocation)));
            }
            ++i;
        }
        ArrayList schemas = this.getWSDLSchemas(source);
        int i2 = 0;
        while (i2 < schemas.size()) {
            Element schema = (Element)schemas.get(i2);
            ArrayList schemaImports = this.getSchemaImport(schema);
            int j = 0;
            while (j < schemaImports.size()) {
                Element importTag = (Element)schemaImports.get(j);
                String relativeLocation = this.getImportLocation(importTag);
                DOMSource domdocument = this.resolveImport(source.getSystemId(), relativeLocation);
                if (domdocument != null) {
                    if (!this.isSchema(domdocument)) {
                        throw new WSDLException("In wsdl definitions only schema and wsdl's can be imported ! Bug in import statement of :" + source.getSystemId());
                    }
                    ArrayList resultFiles = this.saveSchemaSpecial(domdocument, this.extend(path, relativeLocation), outputDir, null, idMapping);
                    result.addAll(resultFiles);
                    if (this.fixImports && idMapping.get(this.extend(path, relativeLocation)) != null) {
                        importTag.setAttribute("schemaLocation", (String)idMapping.get(this.extend(path, relativeLocation)));
                    }
                }
                ++j;
            }
            ++i2;
        }
        this.saveDOMSourceSpecial(source, path, outputFile, idMapping);
        return result;
    }

    private ArrayList saveWSDL(DOMSource source, File outputDir, String preferedName, Hashtable idMapping) throws WSDLException {
        if (!outputDir.exists()) {
            outputDir.mkdirs();
            if (!outputDir.isDirectory()) {
                outputDir.delete();
            }
        } else if (!outputDir.isDirectory()) {
            throw new WSDLException(outputDir.getAbsolutePath() + " is not a directory !");
        }
        ArrayList<File> result = new ArrayList<File>();
        if (idMapping.containsKey(source.getSystemId())) {
            return result;
        }
        if (preferedName == null) {
            if (this.suffix == null) {
                this.suffix = "";
            }
            preferedName = this.localWSDLName + this.suffix + Integer.toString(this.wsdlCounter) + ".wsdl";
            ++this.wsdlCounter;
        }
        File outputFile = new File(outputDir, preferedName);
        result.add(outputFile);
        ArrayList definitionImports = this.getDefinitionsImport((Element)source.getNode());
        int i = 0;
        while (i < definitionImports.size()) {
            Element importState = (Element)definitionImports.get(i);
            DOMSource domdocument = this.resolveImport(source.getSystemId(), importState);
            if (domdocument != null) {
                ArrayList resultFiles;
                if (this.isWSDLDefinitions(domdocument)) {
                    resultFiles = this.saveWSDL(domdocument, outputDir, null, idMapping);
                    result.addAll(resultFiles);
                } else if (this.isSchema(domdocument)) {
                    resultFiles = this.saveSchema(domdocument, outputDir, null, idMapping);
                    result.addAll(resultFiles);
                } else {
                    throw new WSDLException("In wsdl definitions only schema and wsdl's can be imported ! Bug in import statement of :" + source.getSystemId());
                }
            }
            if (this.fixImports && idMapping.get(domdocument.getSystemId()) != null) {
                importState.setAttribute("location", (String)idMapping.get(domdocument.getSystemId()));
            }
            ++i;
        }
        ArrayList schemas = this.getWSDLSchemas(source);
        int i2 = 0;
        while (i2 < schemas.size()) {
            Element schema = (Element)schemas.get(i2);
            ArrayList schemaImports = this.getSchemaImport(schema);
            int j = 0;
            while (j < schemaImports.size()) {
                Element importTag = (Element)schemaImports.get(j);
                DOMSource domdocument = this.resolveImport(source.getSystemId(), importTag);
                if (domdocument != null) {
                    if (!this.isSchema(domdocument)) {
                        throw new WSDLException("In wsdl definitions only schema and wsdl's can be imported ! Bug in import statement of :" + source.getSystemId());
                    }
                    ArrayList resultFiles = this.saveSchema(domdocument, outputDir, null, idMapping);
                    result.addAll(resultFiles);
                    if (this.fixImports && idMapping.get(domdocument.getSystemId()) != null) {
                        importTag.setAttribute("schemaLocation", (String)idMapping.get(domdocument.getSystemId()));
                    }
                }
                ++j;
            }
            ++i2;
        }
        this.saveDOMSource(source, outputFile, idMapping);
        return result;
    }

    public File[] downloadWSDL(String wsdlLocation, File outputLocation, Hashtable idMapping) throws WSDLException {
        DOMSource source = this.loadDocument(wsdlLocation);
        idMapping.clear();
        this.reachedFiles.clear();
        idMapping.put("", wsdlLocation);
        idMapping.put("Version", "2.0");
        if (this.isWSDLDefinitions(source)) {
            if (this.suffix == null) {
                this.suffix = "";
            }
            ArrayList perm = this.saveWSDLSpecial(source, source.getSystemId(), outputLocation, this.localWSDLRoot + this.suffix + ".wsdl", idMapping);
            File[] result = new File[perm.size()];
            int i = 0;
            while (i < perm.size()) {
                result[i] = (File)perm.get(i);
                ++i;
            }
            this.transformer = null;
            this.domparser = null;
            return result;
        }
        this.transformer = null;
        this.domparser = null;
        throw new WSDLException("Given " + wsdlLocation + " is not WSDL definitions file !");
    }

    public File[] downloadWSDL(InputStream wsdlStream, File outputLocation, Hashtable idMapping) throws WSDLException {
        DOMSource source = this.loadDocument(wsdlStream, "root.wsdl");
        idMapping.clear();
        this.reachedFiles.clear();
        idMapping.put("", "root.wsdl");
        idMapping.put("Version", "2.0");
        if (this.isWSDLDefinitions(source)) {
            if (this.suffix == null) {
                this.suffix = "";
            }
            ArrayList perm = this.saveWSDLSpecial(source, source.getSystemId(), outputLocation, this.localWSDLRoot + this.suffix + ".wsdl", idMapping);
            File[] result = new File[perm.size()];
            int i = 0;
            while (i < perm.size()) {
                result[i] = (File)perm.get(i);
                ++i;
            }
            this.transformer = null;
            this.domparser = null;
            return result;
        }
        this.transformer = null;
        this.domparser = null;
        throw new WSDLException("Given WSDL is not WSDL definitions file !");
    }

    private static void printFileList(File[] fileList, String label) {
        System.out.println("File List : " + label);
        System.out.println("----------");
        int i = 0;
        while (i < fileList.length) {
            System.out.println(fileList[i].getAbsolutePath());
            ++i;
        }
        System.out.println("----------");
    }

    private static void printHashtableContents(Hashtable contents, String label) {
        System.out.println("Hash Map contents: " + label);
        System.out.println("-------------------");
        Enumeration enumeration = contents.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = (String)contents.get(key);
            System.out.println("[" + key + "] = [" + value + "]");
        }
        System.out.println("-------------------");
    }

    public static void testIt(String wsdlLocation, String outputLocation) throws WSDLException {
        Hashtable idMapping = new Hashtable();
        WSDLImportTool importTool = new WSDLImportTool();
        importTool.setImportFix(true);
        File[] files = importTool.downloadWSDL(wsdlLocation, new File(outputLocation), idMapping);
        WSDLImportTool.printFileList(files, "Files downloaded.");
        WSDLImportTool.printHashtableContents(idMapping, "Mapping recieved.");
        System.out.println("Generating proxy from mirror location");
        ProxyGenerator generator = new ProxyGenerator();
        ProxyGeneratorConfig config = new ProxyGeneratorConfig(files[0].getAbsolutePath(), files[0].getParent(), "proxy");
        config.setLogicalPortName("lports.xml");
        config.setCompile(true);
        config.setLocationMap(idMapping);
        try {
            generator.generateProxy(config);
            files = config.getAllGeneratedFiles();
        }
        catch (Exception e) {
            throw new WSDLException(e);
        }
        WSDLImportTool.printFileList(files, "Proxy Files generated.");
    }

    public static void main(String[] args) throws Exception {
        WSDLImportTool.testIt("http://Chavdar-B:50000/contextRoot/wsdl1/wsdlroot.wsdl", "d:/downloaded/webservicesnew7/");
    }
}

